#include "stdafx.h"

extern "C" __declspec(dllexport)
FxU32 grTexTextureMemRequired(FxU32 evenOdd, GrTexInfo *info)
{
	int height, width;
	int memNeeded = 0;

	if(info->largeLod > info->smallLod)
	{
		MessageBox(NULL, "wrong way", "Notice", MB_APPLMODAL);
		return 0;
	}

	for(int i = info->largeLod; i <= info->smallLod; i++)
	{
		if(evenOdd == GR_MIPMAPLEVELMASK_EVEN && (i & 1) == 1) continue;
		if(evenOdd == GR_MIPMAPLEVELMASK_ODD  && (i & 1) == 0) continue;

		height = 1 << (8 - i);
		width = 1 << (8 - i);

		switch(info->aspectRatio)
		{
			case GR_ASPECT_8x1:
				height >>= 3;
				break;
			case GR_ASPECT_4x1:
				height >>= 2;
				break;
			case GR_ASPECT_2x1:
				height >>= 1;
				break;
			case GR_ASPECT_1x1:
				break;
			case GR_ASPECT_1x2:
				width >>= 1;
				break;
			case GR_ASPECT_1x4:
				width >>= 2;
				break;
			case GR_ASPECT_1x8:
				width >>= 3;
				break;
		}

      if(height == 0) height = 1;
      if(width == 0) width = 1;

		switch(info->format)
		{
		case GR_TEXFMT_8BIT:
		case GR_TEXFMT_YIQ_422:
		case GR_TEXFMT_ALPHA_8:
		case GR_TEXFMT_INTENSITY_8:
		case GR_TEXFMT_ALPHA_INTENSITY_44:
		case GR_TEXFMT_P_8:
			memNeeded += height * width;
			break;
		case GR_TEXFMT_16BIT:
		case GR_TEXFMT_AYIQ_8422:
		case GR_TEXFMT_RGB_565:
		case GR_TEXFMT_ARGB_1555:
		case GR_TEXFMT_ARGB_4444:
		case GR_TEXFMT_ALPHA_INTENSITY_88:
		case GR_TEXFMT_AP_88:
			memNeeded += (height * width) << 1;
			break;
		}
	}
   
   if(memNeeded & 7) memNeeded += 8 - (memNeeded & 7);

	return memNeeded;

   //MessageBox(NULL, "grTexTextureMemRequired", "Notice", MB_APPLMODAL);
}