/* 2004.03.05, 2004.8.18
****************************************
**  Copyright  (C)  W.ch  1999-2004   **
**  Web:  http://www.winchiphead.com  **
****************************************
**  USB 1.1 Host Examples for CH375   **
**  KC7.0@MCS-51                      **
****************************************
*/
/* CH375ΪUSBӿڵĳʾ */

/* MCS-51ƬCԵʾ, жϷʽ */

#include <reg51.h>
#include <string.h>
#include <stdio.h>

/* CH375뼰״̬ */
#include "CH375INC.H"

/* ¶MCS-51Ƭ,Ƭ޸,ΪṩCԵٶҪԱŻ */
unsigned char volatile xdata	CH375_CMD_PORT _at_ 0xBDF1;	/* CH375˿ڵI/Oַ */
unsigned char volatile xdata	CH375_DAT_PORT _at_ 0xBCF0;	/* CH375ݶ˿ڵI/Oַ */
unsigned char xdata				DATA_BUFFER[ 0x8000 ] _at_ 0x0000;	/* ⲿRAMݻʼַ */

#define CH375_INT_NO			0		/* CH375жϺ */
#define CH375_INT_FLAG			IE0		/* IE0,CH375жϱ־ */
#define CH375_INT_EN			EX0		/* EX0,CH375ж */

/* P1.4һLEDڼʾĽ,͵ƽLED,U̲ */
sbit P1_4  = P1^4;
#define LED_OUT_ACT( )		{ P1_4 = 0; }	/* P1.4 ͵ƽLEDʾ */
#define LED_OUT_INACT( )	{ P1_4 = 1; }	/* P1.4 ͵ƽLEDʾ */

bit		mDeviceOnline = 0;				/* CH375ĿUSB豸״̬: 0Ͽ,1 */
unsigned char mIntStatus;				/* CH375ж״̬ */

/* ʱ2΢,ȷ */
void	delay2us( )
{
	unsigned char i;
	for ( i = 2; i != 0; i -- );
}

/* ʱ1΢,ȷ */
void	delay1us( )
{
	unsigned char i;
	for ( i = 1; i != 0; i -- );
}

/* ʱ100,ȷ */
void	mDelay100mS( )
{
	unsigned char	i, j, c;
	for ( i = 200; i != 0; i -- ) for ( j = 200; j != 0; j -- ) c+=3;
}

/*  */

void CH375_WR_CMD_PORT( unsigned char cmd ) {  /* CH375˿д,ڲС4uS,ƬϿʱ */
	delay2us();
	CH375_CMD_PORT=cmd;
	delay2us();
}

void CH375_WR_DAT_PORT( unsigned char dat ) {  /* CH375ݶ˿д,ڲС1.5uS,ƬϿʱ */
	CH375_DAT_PORT=dat;
	delay1us();  /* ΪMCS51Ƭʵʱ */
}

unsigned char CH375_RD_DAT_PORT() {  /* CH375ݶ˿ڶ,ڲС1.5uS,ƬϿʱ */
	delay1us();  /* ΪMCS51Ƭʵʱ */
	return( CH375_DAT_PORT );
}

/* CH375жϷ,ʹüĴ1 */
void	CH375Interrupt( ) interrupt CH375_INT_NO using 1
{
	CH375_WR_CMD_PORT( CMD_GET_STATUS );  /* ȡж״̬ȡж */
	mIntStatus = CH375_RD_DAT_PORT( );  /* ȡж״̬ */
	CH375_INT_FLAG = 0;  /* жϱ־ */
	if ( mIntStatus == USB_INT_DISCONNECT ) mDeviceOnline = 0;  /* ⵽USB豸Ͽ¼ */
	else if ( mIntStatus == USB_INT_CONNECT ) mDeviceOnline = 1;  /* ⵽USB豸¼ */
}

/* ʱ10,ȷ */
void	mDelay10mS( )
{
	unsigned char i, j;
	for ( i = 50; i != 0; i -- ) for ( j = 200; j != 0; j -- );
}

/* CH375ΪUSBʽ */
unsigned char	mCH375Init( )
{
	unsigned char	c, i;
	CH375_WR_CMD_PORT( CMD_SET_USB_MODE );  /* USBģʽ */
	CH375_WR_DAT_PORT( 6 );  /* ģʽ,ԶUSB豸 */
	for ( i = 0xff; i != 0; i -- ) {  /* ȴɹ,ͨҪȴ10uS-20uS */
		c = CH375_RD_DAT_PORT( );
		if ( c == CMD_RET_SUCCESS ) break;  /* ɹ */
	}
	if ( i != 0 ) return( USB_INT_SUCCESS );  /* ɹ */
	else return( 0xff );  /* CH375,оƬͺŴߴڴڷʽ߲֧ */
}

/* CH375Ķ˵㻺ȡյ */
unsigned char	mReadCH375Data( unsigned char *buf )
{
	unsigned char len, i;
	unsigned char *p;
	CH375_WR_CMD_PORT( CMD_RD_USB_DATA );  /* CH375Ķ˵㻺ȡݿ */
	p = buf;
	len = CH375_RD_DAT_PORT( );  /* ݳ */
	for ( i=0; i<len; i++ ) *p++ = CH375_RD_DAT_PORT( );  /* ȡ */
	return( len );
}

/* CH375Ķ˵㻺д׼͵ */
void	mWriteCH375Data( unsigned char *buf, unsigned char len )
{
	unsigned char i;
	unsigned char *p;
	CH375_WR_CMD_PORT( CMD_WR_USB_DATA7 );  /* CH375Ķ˵㻺дݿ */
	p = buf;
	CH375_WR_DAT_PORT( len );  /* ݳ */
	for ( i=0; i<len; i++ ) CH375_WR_DAT_PORT( *p++ );  /* д */
}

/* ĿUSB豸ִпƴ: ȡUSB */
void	mCtrlGetDescr( unsigned char type )
{
	mIntStatus = 0;  /* ж״̬ */
	CH375_WR_CMD_PORT( CMD_GET_DESCR );  /* ƴ-ȡ */
	CH375_WR_DAT_PORT( type );  /* 0:豸, 1: */
	while ( mIntStatus == 0 );  /* ȴ */
}

/* ĿUSB豸ִпƴ: USBַ */
void	mCtrlSetAddress( unsigned char addr )
{
	mIntStatus = 0;  /* ж״̬ */
	CH375_WR_CMD_PORT( CMD_SET_ADDRESS );  /* ƴ-USBַ */
	CH375_WR_DAT_PORT( addr );  /* 1 - 7eh */
	while ( mIntStatus == 0 );  /* ȴ */
	if ( mIntStatus != USB_INT_SUCCESS ) return;  /* ʧ */
/* ĿUSB豸ĵַɹ޸ĺ,Ӧͬ޸CH375USBַ,CH375޷Ŀ豸ͨѶ */
	CH375_WR_CMD_PORT( CMD_SET_USB_ADDR );  /* CH375USBַ */
	CH375_WR_DAT_PORT( addr );  /* ޸CH375USB豸ܹ,ж֪ͨ */
}

/* ĿUSB豸ִпƴ: ֵ */
void	mCtrlSetConfig( unsigned char value )
{
	mIntStatus = 0;  /* ж״̬ */
	CH375_WR_CMD_PORT( CMD_SET_CONFIG );  /* ƴ-USB */
	CH375_WR_DAT_PORT( value );
	while ( mIntStatus == 0 );  /* ȴ */
}

/* ýյͬλ DATA0/DATA1 */
void	mSetRecvDataTog( unsigned char tog )
/* togֵ: 0:0, 1:1 */
{
	CH375_WR_CMD_PORT( CMD_SET_ENDP6 );  /* ˵Ľ */
	CH375_WR_DAT_PORT( tog ? 0xC0 : 0x80 );
	delay2us( );
}

/* ÷͵ͬλ DATA0/DATA1 */
void	mSetSendDataTog( unsigned char tog )
/* togֵ: 0:0, 1:1 */
{
	CH375_WR_CMD_PORT( CMD_SET_ENDP7 );  /* ˵ķ */
	CH375_WR_DAT_PORT( tog ? 0xC0 : 0x80 );
	delay2us( );
}

/* ,ִUSB */
void	mIssueToken( unsigned char endp, unsigned char token )
{
	mIntStatus = 0;  /* ж״̬ */
	CH375_WR_CMD_PORT( CMD_ISSUE_TOKEN );  /* ,ִ */
	CH375_WR_DAT_PORT( endp << 4 | token );  /* 4λǶ˵,4λPID */
	while ( mIntStatus == 0 );  /* ȴ */
}

/* ״̬,ʾ벢ͣ */
void	mStopIfError( )
{
	if ( mIntStatus == USB_INT_SUCCESS ) return;  /* ɹ */
	printf( "Error: %02X, %d\n", (unsigned int)mIntStatus, (unsigned int)mDeviceOnline );  /* ʾ */
	while ( 1 ) {
		LED_OUT_ACT( );  /* LED˸ */
		mDelay100mS( );
		LED_OUT_INACT( );
		mDelay100mS( );
	}
}

/* Ϊprintfgetkeyʼ */
void	mInitSTDIO( )
{
	SCON = 0x50;
	PCON = 0x80;
	TMOD = 0x20;
	TH1 = 0xf3;  /* 24MHz, 9600bps */
	TR1 = 1;
	TI = 1;
}

main( ) {
	unsigned char	i, len;
	unsigned char	mBulkInEndp, mBulkOutEndp, mBulkOutLen;
	LED_OUT_ACT( );  /* LEDһʾ */
	mDelay100mS( );  /* ʱ100 */
	LED_OUT_INACT( );
	mInitSTDIO( );
	printf( "Start\n" );
	CH375_INT_EN = 0;  /* ֹCH375ж */
	IT0=0;  /* CH375жźΪ͵ƽ */
	CH375_INT_FLAG = 0;  /* жϱ־ */
	i = mCH375Init( );  /* ʼCH375 */
	mIntStatus = i;
	mStopIfError( );
	CH375_INT_EN = 1;  /* CH375ж */
/* ·ʼ */
	EA = 1;  /* ʼ,ж */
	printf( "Insert USB device\n" );
	while ( mDeviceOnline == 0 );  /* ȴUSB豸 */

#if 1
/* ʵϲûбҪUSB豸λ豸,ǼWINDOWS,ҲԲ */
/* ˵, ЩUSB豸Ҫڲ븴λUSB߲ܹ, ⲿֳȥ */
	printf( "Begin: reset USB device\n" );
	while ( mDeviceOnline == 0 );  /* ȴUSB豸 */
	CH375_INT_EN = 0;  /* λUSBڼӦýֹCH375ж */
	CH375_WR_CMD_PORT( CMD_SET_USB_MODE );  /* USBģʽ */
	CH375_WR_DAT_PORT( 7 );  /* ģʽ,λUSB豸 */
	mDelay10mS( );  /* λʱӦ10mS */
	mDeviceOnline = 0;
	CH375_INT_FLAG = 0;  /* жϱ־ */
	CH375_INT_EN = 1;  /* CH375ж */
/*	printf( "End: reset USB device\n" ); */
	i = mCH375Init( );  /* ֹͣλ,³ʼCH375 */
	mIntStatus = i;
	mStopIfError( );
	while ( mDeviceOnline == 0 );  /* ȴUSB豸 */
#endif

	mDelay10mS( );  /* ʵʱ,ѡĲ */
	mCtrlGetDescr( 1 );  /* ȡ豸 */
	mStopIfError( );
	len = mReadCH375Data( DATA_BUFFER );  /* ȡ豸 */
	printf( "Device descr data len: %d, data: ", len );
	for ( i = 0; i < len; i ++ ) printf( "%02X,", (unsigned int)DATA_BUFFER[i] );
	printf( "\n" );
	mCtrlSetAddress( 5 );  /* USBַ,ֵַΪ17EH,ΪûHUBֻһUSB豸,ѡ */
	mStopIfError( );
	mCtrlGetDescr( 2 );  /* ȡ */
	mStopIfError( );
	len = mReadCH375Data( DATA_BUFFER );  /* ȡ */
	printf( "Config descr data len: %d, data: ", len );
	for ( i = 0; i < len; i ++ ) printf( "%02X,", (unsigned int)DATA_BUFFER[i] );
	printf( "\n" );
/* ڴ˲жUSBĿ豸Ĵ,Ƿȷ,˵, */
	printf( "Set config value\n" );
	i = DATA_BUFFER[5];  /* USB豸ֻһ,ֵĵ6ֽ */
	mCtrlSetConfig( i );  /* USBֵ */
	mStopIfError( );
/* USB豸óɹ,ݴ,ٶǰͨõĿUSB豸˵źݰ */
	mBulkInEndp = 1; mBulkOutEndp = 2; mBulkOutLen = 64;  /* ٶIN˵1,OUT˵2,ݰ64 */
	printf( "Out data to bulk out endpoint\n" );
	for ( i = 0; i < mBulkOutLen; i ++ ) DATA_BUFFER[i] = i;  /* ģ */
	mSetSendDataTog( 0 );  /* ÷͵ͬλ DATA0 */
	mWriteCH375Data( DATA_BUFFER, mBulkOutLen );
	mIssueToken( mBulkOutEndp, DEF_USB_PID_OUT );  /* һOUT,DATA0 */
	mStopIfError( );
#if 0
	mSetSendDataTog( 1 );  /* ÷͵ͬλ DATA1 */
	mWriteCH375Data( DATA_BUFFER+mBulkOutLen, mBulkOutLen );
	mIssueToken( mBulkOutEndp, DEF_USB_PID_OUT );  /* һOUT,DATA1 */
#endif
	printf( "In data to bulk in endpoint\n" );
	mSetRecvDataTog( 0 );  /* ýյͬλ DATA0 */
	mIssueToken( mBulkInEndp, DEF_USB_PID_IN );  /* һIN,ϣDATA0 */
	mStopIfError( );

	printf( "Stop\n" );
	LED_OUT_ACT( );  /* LED */
	while ( 1 );  /* ͣ */
}
