// 2003.09.08, 2003.12.28, 2004.10.15, 2004.12.05, 2004.12.10, 2005.01.20, 2005.02.23, 2005.07.15, 2005.08.17
//****************************************
//**  Copyright  (C)  W.ch  1999-2005   **
//**  Web:  http://www.winchiphead.com  **
//****************************************
//**  DLL for USB interface chip CH375  **
//**  C, VC5.0                          **
//****************************************
//
// USB߽ӿоƬCH375Ӧòӿڿ  V2.2
// Ͼߺ޹˾  : W.ch 2005.08
// CH375-DLL  V2.2 , Support: Ctrl/Bulk/Int
// л: Windows 98/ME, Windows 2000/XP
// support USB chip: CH372/CH375
//

#ifndef		_CH375_DLL_H
#define		_CH375_DLL_H

#ifdef __cplusplus
extern "C" {
#endif

#define		mOFFSET( s, m )			( (ULONG) & ( ( ( s * ) 0 ) -> m ) )	// ȡṹԱƫƵַĺ

#ifndef		max
#define		max( a, b )				( ( ( a ) > ( b ) ) ? ( a ) : ( b ) )	// ϴֵ
#endif

#ifndef		min
#define		min( a, b )				( ( ( a ) < ( b ) ) ? ( a ) : ( b ) )	// Сֵ
#endif

#ifdef		ExAllocatePool
#undef		ExAllocatePool						// ɾTAGڴ
#endif

#ifndef		NTSTATUS
typedef		LONG	NTSTATUS;					// ״̬
#endif


typedef	struct	_USB_SETUP_PKT {				// USBƴĽ׶εṹ
	UCHAR			mUspReqType;				// 00H 
	UCHAR			mUspRequest;				// 01H 
	union	{
		struct	{
			UCHAR	mUspValueLow;				// 02H ֵֽ
			UCHAR	mUspValueHigh;				// 03H ֵֽ
		};
		USHORT		mUspValue;					// 02H-03H ֵ
	};
	union	{
		struct	{
			UCHAR	mUspIndexLow;				// 04H ֽ
			UCHAR	mUspIndexHigh;				// 05H ֽ
		};
		USHORT		mUspIndex;					// 04H-05H 
	};
	USHORT			mLength;					// 06H-07H ݽ׶εݳ
} mUSB_SETUP_PKT, *mPUSB_SETUP_PKT;


#define		mCH375_PACKET_LENGTH	64			// CH375ֵ֧ݰĳ
#define		mCH375_PKT_LEN_SHORT	8			// CH375ֵ֧Ķݰĳ


typedef	struct	_WIN32_COMMAND {				// WIN32ӿڽṹ
	union	{
		ULONG		mFunction;					// ʱָܴ߹ܵ
		NTSTATUS	mStatus;					// ʱز״̬
	};
	ULONG			mLength;					// ȡ,غݵĳ
	union	{
		mUSB_SETUP_PKT	mSetupPkt;				// USBƴĽ׶ε
		UCHAR			mBuffer[ mCH375_PACKET_LENGTH ];	// ݻ,Ϊ0255B
	};
} mWIN32_COMMAND, *mPWIN32_COMMAND;


// WIN32Ӧòӿ
#define		IOCTL_CH375_COMMAND		( FILE_DEVICE_UNKNOWN << 16 | FILE_ANY_ACCESS << 14 | 0x0f37 << 2 | METHOD_BUFFERED )	// רýӿ

#define		mWIN32_COMMAND_HEAD		mOFFSET( mWIN32_COMMAND, mBuffer )	// WIN32ӿڵͷ

#define		mCH375_MAX_NUMBER		16			// ͬʱӵCH375

#define		mMAX_BUFFER_LENGTH		0x1000		// ݻ󳤶4096

#define		mMAX_COMMAND_LENGTH		( mWIN32_COMMAND_HEAD + mMAX_BUFFER_LENGTH )	// ݳȼṹͷĳ

#define		mDEFAULT_BUFFER_LEN		0x0400		// ݻĬϳ1024

#define		mDEFAULT_COMMAND_LEN	( mWIN32_COMMAND_HEAD + mDEFAULT_BUFFER_LEN )	// Ĭݳȼṹͷĳ


// CH375˵ַ
#define		mCH375_ENDP_INTER_UP	0x81		// CH375жϴ˵ĵַ
#define		mCH375_ENDP_AUX_DOWN	0x01		// CH375ĸ´˵ĵַ
#define		mCH375_ENDP_DATA_UP		0x82		// CH375ݿϴ˵ĵַ
#define		mCH375_ENDP_DATA_DOWN	0x02		// CH375ݿ´˵ĵַ


// 豸ӿṩĹܵ
#define		mPipeDeviceCtrl			0x00000004	// CH375ۺϿƹܵ
#define		mPipeInterUp			0x00000005	// CH375жϴܵ
#define		mPipeDataUp				0x00000006	// CH375ݿϴܵ
#define		mPipeDataDown			0x00000007	// CH375ݿ´ܵ
#define		mPipeAuxDown			0x00000008	// CH375ĸ´ܵ

// ӦòӿڵĹܴ
#define		mFuncNoOperation		0x00000000	// ޲
#define		mFuncGetVersion			0x00000001	// ȡ汾
#define		mFuncGetConfig			0x00000002	// ȡUSB豸
#define		mFuncSetExclusive		0x0000000b	// öռʹ
#define		mFuncResetDevice		0x0000000c	// λUSB豸
#define		mFuncResetPipe			0x0000000d	// λUSBܵ
#define		mFuncAbortPipe			0x0000000e	// ȡUSBܵ
#define		mFuncSetTimeout			0x0000000f	// USBͨѶʱ
#define		mFuncBufferMode			0x00000010	// 趨ϴģʽѯеݳ
#define		mFuncBufferModeDn		0x00000011	// 趨´ģʽѯеݳ


// USB豸׼
#define		mUSB_CLR_FEATURE		0x01
#define		mUSB_SET_FEATURE		0x03
#define		mUSB_GET_STATUS			0x00
#define		mUSB_SET_ADDRESS		0x05
#define		mUSB_GET_DESCR			0x06
#define		mUSB_SET_DESCR			0x07
#define		mUSB_GET_CONFIG			0x08
#define		mUSB_SET_CONFIG			0x09
#define		mUSB_GET_INTERF			0x0a
#define		mUSB_SET_INTERF			0x0b
#define		mUSB_SYNC_FRAME			0x0c

// CH375ƴĳר
#define		mCH375_VENDOR_READ		0xc0		// ͨƴʵֵCH375רö
#define		mCH375_VENDOR_WRITE		0x40		// ͨƴʵֵCH375רд

// CH375ƴĳר
#define		mCH375_SET_CONTROL		0x51		// ź
#define		mCH375_GET_STATUS		0x52		// ״̬ź

// Ĵλ
#define		mBitInputRxd			0x02		// ֻ,RXD#״̬,1:ߵƽ,0:͵ƽ
#define		mBitInputReq			0x04		// ֻ,REQ#״̬,1:ߵƽ,0:͵ƽ


// ֱ״̬źŵλ
#define		mStateRXD				0x00000200	// RXD#״̬,1:ߵƽ,0:͵ƽ
#define		mStateREQ				0x00000400	// REQ#״̬,1:ߵƽ,0:͵ƽ

#define		MAX_DEVICE_PATH_SIZE	128			// 豸Ƶַ
#define		MAX_DEVICE_ID_SIZE		64			// 豸IDַ


typedef		VOID	( CALLBACK	* mPCH375_INT_ROUTINE ) (  // жϷص
	PUCHAR			iBuffer );  // ָһ,ṩǰж


HANDLE	WINAPI	CH375OpenDevice(  // CH375豸,ؾ,Ч
	ULONG			iIndex );  // ָCH375豸,0Ӧһ豸,-1ԶһԱ򿪵豸


VOID	WINAPI	CH375CloseDevice(  // رCH375豸
	ULONG			iIndex );  // ָCH375豸


ULONG	WINAPI	CH375GetVersion( );  // DLL汾,ذ汾


ULONG	WINAPI	CH375DriverCommand(  // ֱӴ,򷵻0,򷵻ݳ
	ULONG			iIndex,  // ָCH375豸,V1.6DLLҲ豸򿪺ľ
	mPWIN32_COMMAND	ioCommand );  // ṹָ
// óڵú󷵻ݳ,Ȼṹ,Ƕ,ݷṹ,
// صݳڲʧʱΪ0,ɹʱΪṹĳ,һֽ,򷵻mWIN32_COMMAND_HEAD+1,
// ṹڵǰ,ֱṩ:ܵŻܴ,ȡݵĳ(ѡ),(ѡ)
// ṹڵú,ֱ𷵻:״̬,ݵĳ(ѡ),
//   ״̬WINDOWSĴ,ԲοNTSTATUS.H,
//   ݵĳָصݳ,ݴĻ,дһΪ0


ULONG	WINAPI	CH375GetDrvVersion( );  // 汾,ذ汾,򷵻0


BOOL	WINAPI	CH375ResetDevice(  // λUSB豸
	ULONG			iIndex );  // ָCH375豸


BOOL	WINAPI	CH375GetDeviceDescr(  // ȡ豸
	ULONG			iIndex,  // ָCH375豸
	PVOID			oBuffer,  // ָһ㹻Ļ,ڱ
	PULONG			ioLength );  // ָ򳤶ȵԪ,ʱΪ׼ȡĳ,غΪʵʶȡĳ


BOOL	WINAPI	CH375GetConfigDescr(  // ȡ
	ULONG			iIndex,  // ָCH375豸
	PVOID			oBuffer,  // ָһ㹻Ļ,ڱ
	PULONG			ioLength );  // ָ򳤶ȵԪ,ʱΪ׼ȡĳ,غΪʵʶȡĳ


BOOL	WINAPI	CH375SetIntRoutine(  // 趨жϷ
	ULONG			iIndex,  // ָCH375豸
	mPCH375_INT_ROUTINE	iIntRoutine );  // ָжϷص,ΪNULLȡжϷ,жʱøó


BOOL	WINAPI	CH375ReadInter(  // ȡж
	ULONG			iIndex,  // ָCH375豸
	PVOID			oBuffer,  // ָһ㹻Ļ,ڱȡж
	PULONG			ioLength );  // ָ򳤶ȵԪ,ʱΪ׼ȡĳ,غΪʵʶȡĳ


BOOL	WINAPI	CH375AbortInter(  // жݶ
	ULONG			iIndex );  // ָCH375豸


BOOL	WINAPI	CH375ReadData(  // ȡݿ
	ULONG			iIndex,  // ָCH375豸
	PVOID			oBuffer,  // ָһ㹻Ļ,ڱȡ
	PULONG			ioLength );  // ָ򳤶ȵԪ,ʱΪ׼ȡĳ,غΪʵʶȡĳ


BOOL	WINAPI	CH375AbortRead(  // ݿ
	ULONG			iIndex );  // ָCH375豸


BOOL	WINAPI	CH375WriteData(  // дݿ
	ULONG			iIndex,  // ָCH375豸
	PVOID			iBuffer,  // ָһ,׼д
	PULONG			ioLength );  // ָ򳤶ȵԪ,ʱΪ׼дĳ,غΪʵдĳ


BOOL	WINAPI	CH375AbortWrite(  // ݿд
	ULONG			iIndex );  // ָCH375豸


BOOL	WINAPI	CH375WriteRead(  // д׼ݿ(),ٶȡ׼ݿ(Ӧ)
	ULONG			iIndex,  // ָCH375豸
	PVOID			iBuffer,  // ָһ,׼д,ȲmCH375_PACKET_LENGTH
	PVOID			oBuffer,  // ָһ㹻Ļ,ȲСmCH375_PACKET_LENGTH,ڱȡ
	PULONG			ioLength );  // ָ򳤶ȵԪ,mCH375_PACKET_LENGTH,ʱΪ׼дĳ,غΪʵʶȡĳ


BOOL	WINAPI	CH375GetStatus(  // ͨCH375ֱݺ״̬
	ULONG			iIndex,  // ָCH375豸
	PULONG			iStatus );  // ָһ˫ֵԪ,ڱ״̬
// λ7-λ0ӦCH375D7-D0,λ9ӦCH375RXD#,λ10ӦCH375REQ#


BOOL	WINAPI	CH375SetTimeout(  // USBݶдĳʱ
	ULONG			iIndex,  // ָCH375豸
	ULONG			iWriteTimeout,  // ָUSBдݿĳʱʱ,ԺmSΪλ,0xFFFFFFFFָʱ(Ĭֵ)
	ULONG			iReadTimeout );  // ָUSBȡݿĳʱʱ,ԺmSΪλ,0xFFFFFFFFָʱ(Ĭֵ)


BOOL	WINAPI	CH375WriteAuxData(  // д
	ULONG			iIndex,  // ָCH375豸
	PVOID			iBuffer,  // ָһ,׼д
	PULONG			ioLength );  // ָ򳤶ȵԪ,ʱΪ׼дĳ,غΪʵдĳ


BOOL	WINAPI	CH375SetExclusive(  // öռʹõǰCH375豸
	ULONG			iIndex,  // ָCH375豸
	ULONG			iExclusive );  // Ϊ0豸Թʹ,0ռʹ


ULONG	WINAPI	CH375GetUsbID(  // ȡUSB豸ID,,16λΪID,16λΪƷID,ʱȫ0(ЧID)
	ULONG			iIndex );  // ָCH375豸


PVOID	WINAPI	CH375GetDeviceName(  // ָCH375豸ƵĻ,򷵻NULL
	ULONG			iIndex );  // ָCH375豸,0Ӧһ豸


BOOL	WINAPI	CH375SetBufUpload(  // 趨ڲϴģʽ
	ULONG			iIndex,  // ָCH375豸,0Ӧһ豸
	ULONG			iEnableOrClear );  // Ϊ0ֹڲϴģʽ,ʹֱϴ,0ڲϴģʽе
// ڲϴģʽ,ôCH375򴴽߳ԶUSBϴݵڲ,ͬʱе,ӦóCH375ReadDataػе


LONG	WINAPI	CH375QueryBufUpload(  // ѯڲϴеݰ,ɹݰ,-1
	ULONG			iIndex );  // ָCH375豸,0Ӧһ豸


BOOL	WINAPI	CH375SetBufDownload(  // 趨ڲ´ģʽ
	ULONG			iIndex,  // ָCH375豸,0Ӧһ豸
	ULONG			iEnableOrClear );  // Ϊ0ֹڲ´ģʽ,ʹֱ´,0ڲ´ģʽе
// ڲ´ģʽ,ôӦóCH375WriteData󽫽ǽUSB´ݷŵڲ,CH375򴴽߳Զֱ


LONG	WINAPI	CH375QueryBufDownload(  // ѯڲ´еʣݰ(δ),ɹݰ,-1
	ULONG			iIndex );  // ָCH375豸,0Ӧһ豸


BOOL	WINAPI	CH375ResetInter(  // λжݶ
	ULONG			iIndex );  // ָCH375豸


BOOL	WINAPI	CH375ResetAux(  // λд
	ULONG			iIndex );  // ָCH375豸


BOOL	WINAPI	CH375ResetRead(  // λݿ
	ULONG			iIndex );  // ָCH375豸


BOOL	WINAPI	CH375ResetWrite(  // λݿд
	ULONG			iIndex );  // ָCH375豸


typedef		VOID	( CALLBACK	* mPCH375_NOTIFY_ROUTINE ) (  // 豸¼֪ͨص
	ULONG			iEventStatus );  // 豸¼͵ǰ״̬(ж): 0=豸γ¼, 3=豸¼

#define		CH375_DEVICE_ARRIVAL		3		// 豸¼,Ѿ
#define		CH375_DEVICE_REMOVE_PEND	1		// 豸Ҫγ
#define		CH375_DEVICE_REMOVE			0		// 豸γ¼,Ѿγ


BOOL	WINAPI	CH375SetDeviceNotify(  // 趨豸¼֪ͨ
	ULONG					iIndex,  // ָCH375豸,0Ӧһ豸
	PCHAR					iDeviceID,  // ѡ,ַָ,ָص豸ID,ַ\0ֹ
	mPCH375_NOTIFY_ROUTINE	iNotifyRoutine );  // ָ豸¼ص,ΪNULLȡ¼֪ͨ,ڼ⵽¼ʱøó


BOOL	WINAPI	CH375SetTimeoutEx(  // USBݶдĳʱ
	ULONG			iIndex,  // ָCH375豸
	ULONG			iWriteTimeout,  // ָUSBдݿĳʱʱ,ԺmSΪλ,0xFFFFFFFFָʱ(Ĭֵ)
	ULONG			iReadTimeout,  // ָUSBȡݿĳʱʱ,ԺmSΪλ,0xFFFFFFFFָʱ(Ĭֵ)
	ULONG			iAuxTimeout,  // ָUSB´ݵĳʱʱ,ԺmSΪλ,0xFFFFFFFFָʱ(Ĭֵ)
	ULONG			iInterTimeout );  // ָUSBжϴݵĳʱʱ,ԺmSΪλ,0xFFFFFFFFָʱ(Ĭֵ)


#ifdef __cplusplus
}
#endif

#endif		// _CH375_DLL_H
