/* 2004.03.05, 2004.8.18
****************************************
**  Copyright  (C)  W.ch  1999-2004   **
**  Web:  http://www.winchiphead.com  **
****************************************
**  USB 1.1 Host Examples for CH375   **
**  KC7.0@MCS-51                      **
****************************************
*/
/* CH375+CH372Ƭϵͳ,豸˲CH37X,ôԲοCH375PRT.C */
/* ˵ĳʾ,C,CH375жΪѯʽ */

/* ¶MCS-51Ƭ,Ƭ޸,ΪṩCԵٶҪԱŻ */
#include <reg51.h>
unsigned char volatile xdata	CH375_CMD_PORT _at_ 0xBDF1;	/* CH375˿ڵI/Oַ */
unsigned char volatile xdata	CH375_DAT_PORT _at_ 0xBCF0;	/* CH375ݶ˿ڵI/Oַ */
sbit	CH375_INT_WIRE	=		0xB0^2;	/* P3.2, INT0, CH375INT#,ڲѯж״̬ */

/* ΪͨõĵƬC */
#include <string.h>
#include <stdio.h>

/* CH375뼰״̬ */
#include "CH375INC.H"

/* ʱ2΢,ȷ */
void	delay2us( )
{
	unsigned char i;
	for ( i = 2; i != 0; i -- );
}

/* ʱ1΢,ȷ */
void	delay1us( )
{
	unsigned char i;
	for ( i = 1; i != 0; i -- );
}

/*  */

void ERROR() {
	while(1);
}

void CH375_WR_CMD_PORT( unsigned char cmd ) {  /* CH375˿д,ڲС4uS,ƬϿʱ */
	delay2us();
	CH375_CMD_PORT=cmd;
	delay2us();
}

void CH375_WR_DAT_PORT( unsigned char dat ) {  /* CH375ݶ˿д,ڲС1.5uS,ƬϿʱ */
	CH375_DAT_PORT=dat;
	delay1us();  /* ΪMCS51Ƭʵʱ */
}

unsigned char CH375_RD_DAT_PORT() {  /* CH375ݶ˿ڶ,ڲС1.5uS,ƬϿʱ */
	delay1us();  /* ΪMCS51Ƭʵʱ */
	return( CH375_DAT_PORT );
}

unsigned char wait_interrupt() {  /* ˵ȴ, ز״̬ */
	while( CH375_INT_WIRE );  /* ѯȴCH375ж(INT#͵ƽ) */
	CH375_WR_CMD_PORT( CMD_GET_STATUS );  /* ж, ȡж״̬ */
	return( CH375_RD_DAT_PORT() );
}

unsigned char endp6_mode, endp7_mode;

#define	TRUE	1
#define	FALSE	0
unsigned char set_usb_mode( unsigned char mode ) {  /* CH37XĹģʽ */
	unsigned char i;
	CH375_WR_CMD_PORT( CMD_SET_USB_MODE );
	CH375_WR_DAT_PORT( mode );
	endp6_mode=endp7_mode=0x80;  /* ˸λUSBͬ־ */
	for( i=0; i!=100; i++ ) {  /* ȴģʽ,30uS */
		if ( CH375_RD_DAT_PORT()==CMD_RET_SUCCESS ) return( TRUE );  /* ɹ */
	}
	return( FALSE );  /* CH375,оƬͺŴߴڴڷʽ߲֧ */
}

/* ͬ */
/* USBͬͨлDATA0DATA1ʵ: 豸, CH372/CH375Զл;
   , SET_ENDP6SET_ENDP7CH375лDATA0DATA1.
   ˵ĳΪSET_ENDP6SET_ENDP7ֱṩһȫֱ,
   ʼֵΪ80H, ÿִһγɹλ6ȡ, ÿִһʧ临λΪ80H. */

void toggle_recv() {  /* ճɹ,лDATA0DATA1ʵͬ */
	CH375_WR_CMD_PORT( CMD_SET_ENDP6 );
	CH375_WR_DAT_PORT( endp6_mode );
	endp6_mode^=0x40;
	delay2us();
}

void toggle_send() {  /* ͳɹ,лDATA0DATA1ʵͬ */
	CH375_WR_CMD_PORT( CMD_SET_ENDP7 );
	CH375_WR_DAT_PORT( endp7_mode );
	endp7_mode^=0x40;
	delay2us();
}

unsigned char clr_stall6() {  /* ʧܺ,λ豸˵ͬDATA0 */
	CH375_WR_CMD_PORT( CMD_CLR_STALL );
	CH375_WR_DAT_PORT( 2 | 0x80 );  /* 豸˲CH37XоƬ,ôҪ޸Ķ˵ */
	endp6_mode=0x80;
	return( wait_interrupt() );
}

unsigned char clr_stall7() {  /* ʧܺ,λ豸˵ͬDATA0 */
	CH375_WR_CMD_PORT( CMD_CLR_STALL );
	CH375_WR_DAT_PORT( 2 );  /* 豸˲CH37XоƬ,ôҪ޸Ķ˵ */
	endp7_mode=0x80;
	return( wait_interrupt() );
}

/* ݶд, ƬдCH372CH375оƬеݻ */

unsigned char rd_usb_data( unsigned char *buf ) {  /* CH37Xݿ */
	unsigned char i, len;
	CH375_WR_CMD_PORT( CMD_RD_USB_DATA );  /* CH375Ķ˵㻺ȡյ */
	len=CH375_RD_DAT_PORT();  /* ݳ */
	for ( i=0; i!=len; i++ ) *buf++=CH375_RD_DAT_PORT();
	return( len );
}

void wr_usb_data( unsigned char len, unsigned char *buf ) {  /* CH37Xдݿ */
	CH375_WR_CMD_PORT( CMD_WR_USB_DATA7 );  /* CH375Ķ˵㻺д׼͵ */
	CH375_WR_DAT_PORT( len );  /* ݳ, lenܴ64 */
	while( len-- ) CH375_WR_DAT_PORT( *buf++ );
}

/*  */

unsigned char issue_token( unsigned char endp_and_pid ) {  /* ִUSB */
/* ִɺ, ж֪ͨƬ, USB_INT_SUCCESS˵ɹ */
	unsigned char status;
	CH375_WR_CMD_PORT( CMD_ISSUE_TOKEN );
	CH375_WR_DAT_PORT( endp_and_pid );  /* 4λĿĶ˵, 4λPID */
	status=wait_interrupt();  /* ȴCH375 */
	if ( status!=USB_INT_SUCCESS && (endp_and_pid&0xF0)==0x20 ) {  /* ʧ,豸˲CH37XоƬ,ôҪ޸Ķ˵ */
		if ( (endp_and_pid&0x0F)==DEF_USB_PID_OUT ) clr_stall7();  /* λ豸˽ */
		else if ( (endp_and_pid&0x0F)==DEF_USB_PID_IN ) clr_stall6();  /* λ豸˷ */
	}
	return( status );
}

void host_send( unsigned char len, unsigned char *buf ) {  /*  */
	wr_usb_data( len, buf );
	toggle_send();
	if ( issue_token( ( 2 << 4 ) | DEF_USB_PID_OUT )!=USB_INT_SUCCESS ) ERROR();  /* 豸˲CH37XоƬ,ôҪ޸Ķ˵ */
}

unsigned char host_recv( unsigned char *buf ) {  /* , س */
	toggle_recv();
	if ( issue_token( ( 2 << 4 ) | DEF_USB_PID_IN )!=USB_INT_SUCCESS ) ERROR();  /* 豸˲CH37XоƬ,ôҪ޸Ķ˵ */
	return( rd_usb_data( buf ) );
}

unsigned char get_descr( unsigned char type ) {  /* 豸˻ȡ */
	unsigned char status;
	CH375_WR_CMD_PORT( CMD_GET_DESCR );
	CH375_WR_DAT_PORT( type );  /* , ֻ֧1(豸)2() */
	status=wait_interrupt();  /* ȴCH375 */
	if ( status==USB_INT_SUCCESS ) {  /* ɹ */
		unsigned char buffer[64];
		unsigned char i, len;
		len=rd_usb_data( buffer );
		printf( "%s:", type==1?"豸":"" );
		for ( i=0; i!=len; i++ ) printf( "%02X ", buffer[i] );
		printf( "\n" );
	}
	return( status );
}

unsigned char set_addr( unsigned char addr ) {  /* 豸˵USBַ */
	unsigned char status;
	CH375_WR_CMD_PORT( CMD_SET_ADDRESS );  /* USB豸˵USBַ */
	CH375_WR_DAT_PORT( addr );  /* ַ, 1127ֵ֮, 220 */
	status=wait_interrupt();  /* ȴCH375 */
	if ( status==USB_INT_SUCCESS ) {  /* ɹ */
		CH375_WR_CMD_PORT( CMD_SET_USB_ADDR );  /* USB˵USBַ */
		CH375_WR_DAT_PORT( addr );  /* ĿUSB豸ĵַɹ޸ĺ,Ӧͬ޸˵USBַ */
	}
	return( status );
}

unsigned char set_config( unsigned char cfg ) {  /* 豸˵USB */
	endp6_mode=endp7_mode=0x80;  /* λUSBͬ־ */
	CH375_WR_CMD_PORT( CMD_SET_CONFIG );  /* USB豸˵ֵ */
	CH375_WR_DAT_PORT( cfg );  /* ֵȡUSB豸 */
	return( wait_interrupt() );  /* ȴCH375 */
}

/* ˵ʾ */
main() {
	unsigned char xdata data_to_send[250], data_by_recv[250];  /* շ */
	unsigned char i, len;
	set_usb_mode( 6 );  /* USBģʽ, 豸CH37X, ô56 */
	while ( wait_interrupt()!=USB_INT_CONNECT );  /* ȴ豸 */

#ifdef DEVICE_NOT_CH37X
/* 豸CH37X,ô²ǿѡ,
   USBоƬ,ôҪִ²,ҪݻֵԼ˵,޸ıеĶ˵,
   ηοCH375PRT.Cļ */
#define USB_RESET_FIRST	1  /* USB淶δҪUSB豸븴λ豸,ǼWINDOWS,ЩUSB豸ҲҪڲȸλܹ */
#ifdef USB_RESET_FIRST
	set_usb_mode( 7 );  /* λUSB豸,CH375USBźߵD+D-͵ƽ */
/* ƬCH375INT#ŲжϷʽǲѯʽ,ôӦڸUSB豸ڼֹCH375ж,USB豸λɺCH375жϱ־ж */
	for ( i=0; i<250; i++ ) { delay2us(); delay2us(); delay2us(); delay2us(); }  /* λʱ䲻1mS,Ϊ10mS */
	set_usb_mode( 6 );  /* λ */
	while ( wait_interrupt()!=USB_INT_CONNECT );  /* ȴλ֮豸ٴ */
	for ( i=0; i<250; i++ ) delay2us();  /* ЩUSB豸Ҫʱٺܹ */
#endif
	get_descr(1);  /* ȡUSB豸豸 */
	set_addr(5);  /* USB豸ĵַ,ΪֻһUSB豸,ԿԷ1126ֵ֮ */
	get_descr(2);  /* ȡUSB豸 */
	set_config(1);  /* USBֵ,ֵUSB豸 */
#endif

	for ( i=0; i<250; i+=64 ) host_send( 64, &data_to_send[i] );  /* 256ֽڵݸ豸 */
	host_send( 0, NULL );  /* ٶ, Ϳݸ豸˾֪ͨ豸˷ */
	for ( i=0; i<250; i+=len ) len=host_recv( &data_by_recv[i] );  /* 豸˽256ֽڵ */
	/* ٴμݻ߽ */
	while(1);
}
