/* 2003.10.20
****************************************
**  Copyright  (C)  W.ch  1999-2003   **
**  Web:  http://www.winchiphead.com  **
****************************************
**  DOS for PCI interface chip CH365  **
**  C, TC2.0                          **
****************************************

 CH365Ĵ洢ռõ1MBڴ,ԱDOSȡ
 Set PCI memory base address of CH365 under 1MB memory
 Ͼߺ޹˾  : W.ch 2003.10
 CH365-MEM  V1.0
 л: DOS, Windows 95/98/Me
*/

#include	<dos.h>
#include	<stddef.h>

unsigned short	dosCH365PciAddr;	/* CH365 PCI slot address, bus/device/function */

unsigned short	CH365CheckDevice( )  /* search&check CH365, return PCI slot address */
{
	union	REGS	mReg;
	mReg.x.ax = 0xb102;
	mReg.x.cx = 0x5049;  /* Vendor ID */
	mReg.x.dx = 0x4348;  /* Device ID */
	mReg.x.si = 0;  /* search start */
	int86 ( 0x1a, &mReg, &mReg );  /* call PCI BIOS */
	if ( mReg.h.ah == 0 ) {  /* success */
		dosCH365PciAddr = mReg.x.bx;  /* found CH365 */
		return( mReg.x.bx );  /* return PCI slot address */
	}
	else return( 0xffff );  /* not found */
}

unsigned short	CH365ReadCfgWord(  /* read a word from config space of CH365 */
	unsigned short	iOffset )  /* offset address */
{
	union	REGS	mReg;
	mReg.x.bx = dosCH365PciAddr;
	mReg.x.ax = 0xb109;
	mReg.x.di = iOffset;
	int86 ( 0x1a, &mReg, &mReg );  /* call PCI BIOS */
	return( mReg.x.cx );  /* return word data */
}

void			CH365WriteCfgWord(  /* write a word to config space of CH365 */
	unsigned short	iOffset,  /* offset address */
	unsigned short	iWord )  /* word data to be write */
{
	union	REGS	mReg;
	mReg.x.bx = dosCH365PciAddr;
	mReg.x.ax = 0xb10c;
	mReg.x.di = iOffset;
	mReg.x.cx = iWord;
	int86 ( 0x1a, &mReg, &mReg );  /* call PCI BIOS */
}

main ( int argc, char *argv[] )
{
  unsigned short MemAddrHigh=0x000d;  /* for line address D8000H or D0000H, high of memory base address always is 0x000d */
  unsigned short MemAddrLow;
  unsigned short OldCommand;
  if ( argc > 1 && ( argv[1][0]=='d' || argv[1][0]=='D' ) && ( argv[1][1]=='0' || argv[1][1]=='8' ) && argv[1][2]=='0' && argv[1][3]=='0' )
  	MemAddrLow = argv[1][1]=='0' ? 0x0000 : 0x8000;  /* get low of memory base address */
  else {  /* parameter error */
  	printf("\n Command parameter:  D800 or D000\n");
  	printf("\n    D800 set memory address to 000D8000H, DOS segment address is D800H\n");
  	printf("\n    D000 set memory address to 000D0000H, DOS segment address is D000H\n");
  	exit(5);
  }
  for ( dosCH365PciAddr=0; dosCH365PciAddr<0x4000; dosCH365PciAddr+=8 ) {  /* search CH365 */
/* you can call CH365CheckDevice directly if use default PCI ID of CH365 */
  	if ( CH365ReadCfgWord( 0x06 ) == 0x0400
  	  && CH365ReadCfgWord( 0x40 ) == CH365ReadCfgWord( 0x44 )
  	  && CH365ReadCfgWord( 0x42 ) == CH365ReadCfgWord( 0x46 ) ) break;  /* found */
  }
  if ( dosCH365PciAddr >= 0x4000 ) {  /* not found CH365 */
  	printf("\n CH365 not found\n");
  	exit(6);
  }
  OldCommand = CH365ReadCfgWord( 0x04 );  /* save old command register */
  CH365WriteCfgWord( 0x04, OldCommand & 0xfd );  /* disable memory space */
  CH365WriteCfgWord( 0x16, MemAddrHigh );  /* set high of memory base address */
  CH365WriteCfgWord( 0x14, MemAddrLow );  /* set low of memory base address */
  CH365WriteCfgWord( 0x04, OldCommand | 0x02 );  /* enable memory space */
  if ( MemAddrLow == 0x0000 ) CH365WriteCfgWord( 0x40, 0x0000 );  /* set A15 of CH365 to 0 or low */
  else CH365WriteCfgWord( 0x40, 0x0001 );  /* set A15 of CH365 to 1 or high */
  printf("\n the memory base address of CH365 has been set to 000D%04XH\n", MemAddrLow);
}
