unit CH341DLL;
interface
// 2004.05.28, 2004.10.20, 2005.01.08, 2005.03.25
//****************************************
//**  Copyright  (C)  W.ch  1999-2005   **
//**  Web:  http://www.winchiphead.com  **
//****************************************
//**  DLL for USB interface chip CH341  **
//**  C, VC5.0                          **
//****************************************
//
// USB߽ӿоƬCH341Ӧòӿڿ V1.5
// Ͼߺ޹˾  : W.ch 2005.03
// CH341-DLL  V1.5
// л: Windows 98/ME, Windows 2000/XP
// support USB chip: CH341, CH341A
// USB => Parallel, I2C, SPI, JTAG ...
//
uses SysUtils;
const
     FILE_DEVICE_UNKNOWN = $H22;
     FILE_ANY_ACCESS = 0;
     METHOD_BUFFERED = 0;
     mCH341_PACKET_LENGTH = 32;			// CH341ֵ֧ݰĳ
     mCH341_PKT_LEN_SHORT = 8 ;			// CH341ֵ֧Ķݰĳ



// WIN32Ӧòӿ
//     IOCTL_CH341_COMMAND		( FILE_DEVICE_UNKNOWN << 16 | FILE_ANY_ACCESS << 14 | 0x0f34 << 2 | METHOD_BUFFERED )	// רýӿ
//     mWIN32_COMMAND_HEAD		mOFFSET( mWIN32_COMMAND, mBuffer )	// WIN32ӿڵͷ
     mCH341_MAX_NUMBER =	16;			// ͬʱӵCH341
     mMAX_BUFFER_LENGTH	=$1000;		// ݻ󳤶4096
//     mMAX_COMMAND_LENGTH		( mWIN32_COMMAND_HEAD + mMAX_BUFFER_LENGTH )	// ݳȼṹͷĳ
     mDEFAULT_BUFFER_LEN=$0400;		// ݻĬϳ1024
//     mDEFAULT_COMMAND_LEN	( mWIN32_COMMAND_HEAD + mDEFAULT_BUFFER_LEN )	// Ĭݳȼṹͷĳ

// CH341˵ַ
     mCH341_ENDP_INTER_UP=$81 ;		// CH341жϴ˵ĵַ
     mCH341_ENDP_INTER_DOWN=$01;		// CH341ж´˵ĵַ
     mCH341_ENDP_DATA_UP=$82  ;		// CH341ݿϴ˵ĵַ
     mCH341_ENDP_DATA_DOWN=$02 ;		// CH341ݿ´˵ĵַ

// 豸ӿṩĹܵ
     mPipeDeviceCtrl=$00000004;	// CH341ۺϿƹܵ
     mPipeInterUp=$00000005  ;	// CH341жϴܵ
     mPipeDataUp =$00000006  ;	// CH341ݿϴܵ
     mPipeDataDown=$00000007 ;	// CH341ݿ´ܵ

// ӦòӿڵĹܴ
     mFuncNoOperation=$00000000;	// ޲
     mFuncGetVersion =$00000001;	// ȡ汾
     mFuncGetConfig  =$00000002	;// ȡUSB豸
     mFuncSetTimeout =$00000009	;// USBͨѶʱ
     mFuncSetExclusive=$0000000b;	// öռʹ
     mFuncResetDevice =$0000000c ;	// λUSB豸
     mFuncResetPipe  	=$0000000d ;	// λUSBܵ
     mFuncAbortPipe			=$0000000e;	// ȡUSBܵ

// CH341רõĹܴ
     mFuncSetParaMode		=$0000000f  ;	// òģʽ
     mFuncReadData0			=$00000010 ;	// Ӳڶȡݿ0
     mFuncReadData1			=$00000011 ;	// Ӳڶȡݿ1
     mFuncWriteData0			=$00000012 ;	// 򲢿дݿ0
     mFuncWriteData1			=$00000013  ;	// 򲢿дݿ1
     mFuncWriteRead			=$00000014  ;	// 


// USB豸׼
     mUSB_CLR_FEATURE		=$01;
     mUSB_SET_FEATURE		=$03 ;
     mUSB_GET_STATUS			=$00 ;
     mUSB_SET_ADDRESS		=$05      ;
     mUSB_GET_DESCR			=$06   ;
     mUSB_SET_DESCR			=$07   ;
     mUSB_GET_CONFIG			=$08   ;
     mUSB_SET_CONFIG			=$09    ;
     mUSB_GET_INTERF			=$0a    ;
     mUSB_SET_INTERF			=$0b    ;
     mUSB_SYNC_FRAME			=$0c    ;

// CH341ƴĳר
     mCH341_VENDOR_READ		=$C0	 ;	// ͨƴʵֵCH341רö
     mCH341_VENDOR_WRITE		=$40 ;		// ͨƴʵֵCH341רд

// CH341ƴĳר
     mCH341_PARA_INIT		=$B1	;	// ʼ
     mCH341_I2C_STATUS		=$52	;	// ȡI2Cӿڵ״̬
     mCH341_I2C_COMMAND		=$53	 ;	// I2Cӿڵ

// CH341ڲ
     mCH341_PARA_CMD_R0		=$AC ;		// Ӳڶ0
     mCH341_PARA_CMD_R1		=$AD  ;		// Ӳڶ1
     mCH341_PARA_CMD_W0		=$A6  ;		// 򲢿д0
     mCH341_PARA_CMD_W1		=$A7  ;		// 򲢿д1
     mCH341_PARA_CMD_STS		=$A0  ;		// ȡ״̬

// CH341Aڲ
     mCH341A_CMD_SET_OUTPUT	=$A1;		// ò
     mCH341A_CMD_IO_ADDR		=$A2 ;		// MEMַд/,ӴֽڿʼΪ
     mCH341A_CMD_SPI_STREAM	=$A8  ;		// SPIӿڵ,ӴֽڿʼΪ
     mCH341A_CMD_SIO_STREAM	=$A9  ;		// SIOӿڵ,ӴֽڿʼΪ
     mCH341A_CMD_I2C_STREAM	=$AA  ;		// I2Cӿڵ,ӴֽڿʼΪI2C
     mCH341A_CMD_UIO_STREAM	=$AB  ;		// UIOӿڵ,ӴֽڿʼΪ

// CH341Aƴĳר
     mCH341A_BUF_CLEAR		=$B2 ;		// δɵ
     mCH341A_I2C_CMD_X		=$54  ;		// I2Cӿڵ,ִ
     mCH341A_DELAY_MS		=$5E  ;		// Ϊλʱָʱ
     mCH341A_GET_VER			=$5F   ;		// ȡоƬ汾

     mCH341_EPP_IO_MAX	 =	( mCH341_PACKET_LENGTH - 1 )  ;	// CH341EPP/MEMʽµζдݿ󳤶
     mCH341A_EPP_IO_MAX		=$FF  ;		// CH341AEPP/MEMʽµζдݿ󳤶

     mCH341A_CMD_IO_ADDR_W	=$00   ;		// MEMַд/:д,λ6-λ0Ϊַ,һֽΪд
     mCH341A_CMD_IO_ADDR_R	=$80   ;		// MEMַд/:,λ6-λ0Ϊַ,һ𷵻

     mCH341A_CMD_I2C_STM_STA	=$74	;	// I2Cӿڵ:ʼλ
     mCH341A_CMD_I2C_STM_STO	=$75   ;		// I2Cӿڵ:ֹͣλ
     mCH341A_CMD_I2C_STM_OUT	=$80	;	// I2Cӿڵ:,λ5-λ0Ϊ,ֽΪ,0ֻһֽڲӦ
     mCH341A_CMD_I2C_STM_IN	=$C0	;	// I2Cӿڵ:,λ5-λ0Ϊ,0ֻһֽڲӦ
//     mCH341A_CMD_I2C_STM_MAX   =	( min( =$3F, mCH341_PACKET_LENGTH ) );	// I2Cӿڵݵ󳤶
     mCH341A_CMD_I2C_STM_SET	=$60  ;		// I2Cӿڵ:ò,λ2=SPII/O(0=뵥,1=˫˫),λ1λ0=I2Cٶ(00=,01=׼,10=,11=)
     mCH341A_CMD_I2C_STM_US	=$40	;	// I2Cӿڵ:΢Ϊλʱ,λ3-λ0Ϊʱֵ
     mCH341A_CMD_I2C_STM_MS	=$50 ;		// I2Cӿڵ:Ϊλʱ,λ3-λ0Ϊʱֵ
     mCH341A_CMD_I2C_STM_DLY	=$0F  ;		// I2Cӿڵʱֵ
     mCH341A_CMD_I2C_STM_END	=$00  ;		// I2Cӿڵ:ǰ

     mCH341A_CMD_UIO_STM_IN	=$00  ;		// UIOӿڵ:D7-D0
     mCH341A_CMD_UIO_STM_DIR	=$40  ;		// UIOӿڵ:趨I/OD5-D0,λ5-λ0Ϊ
     mCH341A_CMD_UIO_STM_OUT	=$80 ;		// UIOӿڵ:D5-D0,λ5-λ0Ϊ
     mCH341A_CMD_UIO_STM_US	=$C0   ;		// UIOӿڵ:΢Ϊλʱ,λ5-λ0Ϊʱֵ
     mCH341A_CMD_UIO_STM_END	=$20	;	// UIOӿڵ:ǰ


// CH341ڹģʽ
     mCH341_PARA_MODE_EPP	=$00 ;		// CH341ڹģʽΪEPPʽ
     mCH341_PARA_MODE_EPP17	=$00 ;		// CH341AڹģʽΪEPPʽV1.7
     mCH341_PARA_MODE_EPP19	=$01 ;		// CH341AڹģʽΪEPPʽV1.9
     mCH341_PARA_MODE_MEM	=$02 ;		// CH341ڹģʽΪMEMʽ


// ֱ״̬źŵλ
     mStateBitERR			=$00000100 ;	// ֻ,ERR#״̬,1:ߵƽ,0:͵ƽ
     mStateBitPEMP			=$00000200 ;	// ֻ,PEMP״̬,1:ߵƽ,0:͵ƽ
     mStateBitINT			=$00000400 ;	// ֻ,INT#״̬,1:ߵƽ,0:͵ƽ
     mStateBitSLCT			=$00000800 ;	// ֻ,SLCT״̬,1:ߵƽ,0:͵ƽ
     mStateBitSDA			=$00800000 ;	// ֻ,SDA״̬,1:ߵƽ,0:͵ƽ

type
  PVOID = Pointer;
  PULONG=pcardinal;

Type
        mUspValue=record
        mUspValueLow : Byte;
        mUspValueHigh : Byte;
End;
Type
        mUspIndex=record
        mUspIndexLow : Byte;
        mUspIndexHigh  : Byte;
End ;
Type
    USB_SETUP_PKT=record
    mUspReqType : Byte;
    mUspRequest : Byte;
    mUspValue : mUspValue;
    mUspIndex : mUspIndex;
    mLength : Integer;
End ;
Type
   WIN32_COMMAND=record               //WIN32ӿڽṹ
   mFunction : cardinal;              //ʱָܴ߹ܵ
                                      //ʱز״̬
   mLength : cardinal;                //ȡ,غݵĳ
   mBuffer:array[0..(mCH341_PACKET_LENGTH-1)] of Byte;         //ݻ,Ϊ0255B                                           'ݻ,Ϊ0255B
End ;

Type mPWIN32_COMMAND=^WIN32_COMMAND;

var
   mUSB_SETUP_PKT :USB_SETUP_PKT;
   mWIN32_COMMAND : WIN32_COMMAND;

type  mPCH341_INT_ROUTINE=Procedure (  // жϷ
      iStatus:cardinal );stdcall;      // ж״̬,
      // λ7-λ0ӦCH341D7-D0
      // λ8ӦCH341ERR#, λ9ӦCH341PEMP, λ10ӦCH341INT#, λ11ӦCH341SLCT

Function CH341OpenDevice(    // CH341豸,ؾ,Ч
    iIndex :cardinal):integer ;Stdcall; external 'CH341DLL.DLL' ;// ָCH341豸,0Ӧһ豸

procedure CH341CloseDevice(    // رCH341豸
                   iIndex :cardinal) ;Stdcall; external 'CH341DLL.DLL';// ָCH341豸


Function CH341GetVersion( ):cardinal;Stdcall; external 'CH341DLL.DLL';  // DLL汾,ذ汾


Function CH341DriverCommand(  // ֱӴ,򷵻0,򷵻ݳ
	iIndex:cardinal;  // ָCH341豸,V1.6DLLҲ豸򿪺ľ
	ioCommand:mPWIN32_COMMAND):cardinal;Stdcall; external 'CH341DLL.DLL';  // ṹָ
// óڵú󷵻ݳ,Ȼṹ,Ƕ,ݷṹ,
// صݳڲʧʱΪ0,ɹʱΪṹĳ,һֽ,򷵻mWIN32_COMMAND_HEAD+1,
// ṹڵǰ,ֱṩ:ܵŻܴ,ȡݵĳ(ѡ),(ѡ)
// ṹڵú,ֱ𷵻:״̬,ݵĳ(ѡ),
//   ״̬WINDOWSĴ,ԲοNTSTATUS.H,
//   ݵĳָصݳ,ݴĻ,дһΪ0


Function CH341GetDrvVersion( ):cardinal;Stdcall; external 'CH341DLL.DLL';  // 汾,ذ汾,򷵻0


Function CH341ResetDevice(  // λUSB豸
	iIndex:cardinal ):boolean;Stdcall; external 'CH341DLL.DLL';  // ָCH341豸


Function CH341GetDeviceDescr(  // ȡ豸
	iIndex:cardinal;  // ָCH341豸
	oBuffer:PVOID;  // ָһ㹻Ļ,ڱ
	ioLength:PULONG ):boolean;Stdcall; external 'CH341DLL.DLL';  // ָ򳤶ȵԪ,ʱΪ׼ȡĳ,غΪʵʶȡĳ


Function CH341GetConfigDescr(  // ȡ
	iIndex:cardinal;  // ָCH341豸
	oBuffer:PVOID;  // ָһ㹻Ļ,ڱ
	ioLength:PULONG ):boolean;Stdcall; external 'CH341DLL.DLL';  // ָ򳤶ȵԪ,ʱΪ׼ȡĳ,غΪʵʶȡĳ


Function CH341SetIntRoutine(  // 趨жϷ
	iIndex:cardinal;  // ָCH341豸
	iIntRoutine:mPCH341_INT_ROUTINE ):boolean;Stdcall; external 'CH341DLL.DLL';  // ָжϷ,ΪNULLȡжϷ,жʱøó


Function CH341ReadInter(  // ȡж
	iIndex:cardinal;  // ָCH341豸
	iStatus:PULONG ):boolean;Stdcall; external 'CH341DLL.DLL';  // ָһ˫ֵԪ,ڱȡж״̬,
// λ7-λ0ӦCH341D7-D0
// λ8ӦCH341ERR#, λ9ӦCH341PEMP, λ10ӦCH341INT#, λ11ӦCH341SLCT


Function CH341AbortInter(  // жݶ
	iIndex:cardinal ):boolean;Stdcall; external 'CH341DLL.DLL';  // ָCH341豸


Function CH341SetParaMode(  // òģʽ
	iIndex:cardinal;  // ָCH341豸
	iMode:cardinal ):boolean;Stdcall; external 'CH341DLL.DLL';  // ָģʽ: 0ΪEPPģʽ/EPPģʽV1.7, 1ΪEPPģʽV1.9, 2ΪMEMģʽ

Function CH341InitParallel(  // λʼ,RST#͵ƽ
	iIndex:cardinal;  // ָCH341豸
	iMode:cardinal ):boolean;Stdcall; external 'CH341DLL.DLL';  // ָģʽ: 0ΪEPPģʽ/EPPģʽV1.7, 1ΪEPPģʽV1.9, 2ΪMEMģʽ, >= 0x00000100 ֵǰģʽ


Function CH341ReadData0(  // 0#˿ڶȡݿ
	iIndex:cardinal;  // ָCH341豸
	oBuffer:PVOID;  // ָһ㹻Ļ,ڱȡ
	ioLength:PULONG ):boolean;Stdcall; external 'CH341DLL.DLL';  // ָ򳤶ȵԪ,ʱΪ׼ȡĳ,غΪʵʶȡĳ

Function CH341ReadData1(  // 1#˿ڶȡݿ
	iIndex:cardinal;  // ָCH341豸
	oBuffer:PVOID;  // ָһ㹻Ļ,ڱȡ
	ioLength:PULONG ):boolean;Stdcall; external 'CH341DLL.DLL';  // ָ򳤶ȵԪ,ʱΪ׼ȡĳ,غΪʵʶȡĳ

Function CH341AbortRead(  // ݿ
	iIndex:cardinal ):boolean;Stdcall; external 'CH341DLL.DLL';  // ָCH341豸


Function CH341WriteData0(  // 0#˿дݿ
	iIndex:cardinal;  // ָCH341豸
	iBuffer:PVOID;  // ָһ,׼д
	ioLength:PULONG ):boolean;Stdcall; external 'CH341DLL.DLL';  // ָ򳤶ȵԪ,ʱΪ׼дĳ,غΪʵдĳ


Function CH341WriteData1(  // 1#˿дݿ
	iIndex:cardinal;  // ָCH341豸
	iBuffer:PVOID;  // ָһ,׼д
	ioLength:PULONG ):boolean;Stdcall; external 'CH341DLL.DLL';  // ָ򳤶ȵԪ,ʱΪ׼дĳ,غΪʵдĳ


Function CH341AbortWrite(  // ݿд
	iIndex:cardinal ):boolean;Stdcall; external 'CH341DLL.DLL';  // ָCH341豸


Function CH341GetStatus(  // ͨCH341ֱݺ״̬
	iIndex:cardinal;  // ָCH341豸
	iStatus:PULONG ):boolean;Stdcall; external 'CH341DLL.DLL';  // ָһ˫ֵԪ,ڱ״̬,ολ˵
// λ7-λ0ӦCH341D7-D0
// λ8ӦCH341ERR#, λ9ӦCH341PEMP, λ10ӦCH341INT#, λ11ӦCH341SLCT, λ23ӦCH341SDA
// λ13ӦCH341BUSY/WAIT#, λ14ӦCH341AUTOFD#/DATAS#,λ15ӦCH341SLCTIN#/ADDRS#


Function CH341ReadI2C(  // I2Cӿڶȡһֽ
	iIndex:cardinal;  // ָCH341豸
	iDevice:byte;  // 7λָI2C豸ַ
	iAddr:byte;  // ָݵԪĵַ
	oByte:Pbytearray ):boolean;Stdcall; external 'CH341DLL.DLL';  // ָһֽڵԪ,ڱȡֽ


Function CH341WriteI2C(  // I2Cӿдһֽ
	iIndex:cardinal;  // ָCH341豸
	iDevice:byte;  // 7λָI2C豸ַ
	iAddr:byte;  // ָݵԪĵַ
	iByte:byte ):boolean;Stdcall; external 'CH341DLL.DLL';  // дֽ


Function CH341EppReadData(  // EPPʽ: WR#=1, DS#=0, AS#=1, D0-D7=input
	iIndex:cardinal;  // ָCH341豸
	oBuffer:PVOID;  // ָһ㹻Ļ,ڱȡ
	ioLength:PULONG ):boolean;Stdcall; external 'CH341DLL.DLL';  // ָ򳤶ȵԪ,ʱΪ׼ȡĳ,غΪʵʶȡĳ


Function CH341EppReadAddr(  // EPPʽַ: WR#=1, DS#=1, AS#=0, D0-D7=input
	iIndex:cardinal;  // ָCH341豸
	oBuffer:pvoid;  // ָһ㹻Ļ,ڱȡĵַ
	ioLength:PULONG ):boolean;Stdcall; external 'CH341DLL.DLL';  // ָ򳤶ȵԪ,ʱΪ׼ȡĳ,غΪʵʶȡĳ


Function CH341EppWriteData(  // EPPʽд: WR#=0, DS#=0, AS#=1, D0-D7=output
	iIndex:cardinal;  // ָCH341豸
	iBuffer:pvoid;  // ָһ,׼д
	ioLength:PULONG ):boolean;Stdcall; external 'CH341DLL.DLL';  // ָ򳤶ȵԪ,ʱΪ׼дĳ,غΪʵдĳ


Function CH341EppWriteAddr(  // EPPʽдַ: WR#=0, DS#=1, AS#=0, D0-D7=output
	iIndex:cardinal;  // ָCH341豸
	iBuffer:PVOID;  // ָһ,׼дĵַ
	ioLength:PULONG ):boolean;Stdcall; external 'CH341DLL.DLL';  // ָ򳤶ȵԪ,ʱΪ׼дĳ,غΪʵдĳ


Function CH341EppSetAddr(  // EPPʽõַ: WR#=0, DS#=1, AS#=0, D0-D7=output
	iIndex:cardinal;  // ָCH341豸
	iAddr:byte ):boolean;Stdcall; external 'CH341DLL.DLL';  // ָEPPַ



Function CH341MemReadAddr0(  // MEMʽַ0: WR#=1, DS#/RD#=0, AS#/ADDR=0, D0-D7=input
	iIndex:cardinal;  // ָCH341豸
	oBuffer:pvoid;  // ָһ㹻Ļ,ڱӵַ0ȡ
	ioLength:PULONG ):boolean;Stdcall; external 'CH341DLL.DLL' ; // ָ򳤶ȵԪ,ʱΪ׼ȡĳ,غΪʵʶȡĳ


Function CH341MemReadAddr1(  // MEMʽַ1: WR#=1, DS#/RD#=0, AS#/ADDR=1, D0-D7=input
	iIndex:cardinal;  // ָCH341豸
	oBuffer:pvoid;  // ָһ㹻Ļ,ڱӵַ1ȡ
	ioLength:PULONG ):boolean;Stdcall; external 'CH341DLL.DLL' ;  // ָ򳤶ȵԪ,ʱΪ׼ȡĳ,غΪʵʶȡĳ


function CH341MemWriteAddr0(  // MEMʽдַ0: WR#=0, DS#/RD#=1, AS#/ADDR=0, D0-D7=output
	iIndex:cardinal;  // ָCH341豸
	iBuffer:pvoid;  // ָһ,׼ַ0д
	ioLength:PULONG ):boolean;Stdcall; external 'CH341DLL.DLL' ; // ָ򳤶ȵԪ,ʱΪ׼дĳ,غΪʵдĳ


Function CH341MemWriteAddr1(  // MEMʽдַ1: WR#=0, DS#/RD#=1, AS#/ADDR=1, D0-D7=output
	iIndex:cardinal;  // ָCH341豸
	iBuffer:pvoid;  // ָһ,׼ַ1д
	ioLength:PULONG  ):boolean;Stdcall; external 'CH341DLL.DLL' ;  // ָ򳤶ȵԪ,ʱΪ׼дĳ,غΪʵдĳ

Function CH341SetExclusive(  // öռʹõǰCH341豸
	iIndex:cardinal;  // ָCH341豸
	iExclusive:cardinal ):boolean;Stdcall; external 'CH341DLL.DLL' ;  // Ϊ0豸Թʹ,0ռʹ

Function CH341SetTimeout(  // USBݶдĳʱ
	iIndex:cardinal;  // ָCH341豸
	iWriteTimeout:cardinal;  // ָUSBдݿĳʱʱ,ԺmSΪλ,0xFFFFFFFFָʱ(Ĭֵ)
	iReadTimeout:cardinal ):boolean;Stdcall; external 'CH341DLL.DLL' ;  // ָUSBȡݿĳʱʱ,ԺmSΪλ,0xFFFFFFFFָʱ(Ĭֵ)


Function CH341ReadData(  // ȡݿ
	iIndex:cardinal;  // ָCH341豸
	oBuffer:PVOID;  // ָһ㹻Ļ,ڱȡ
	ioLength:PULONG ):boolean;Stdcall; external 'CH341DLL.DLL' ;  // ָ򳤶ȵԪ,ʱΪ׼ȡĳ,غΪʵʶȡĳ

Function CH341WriteData(  // дݿ
	iIndex:cardinal;// ָCH341豸
	iBuffer:PVOID;  // ָһ,׼д
	ioLength:PULONG ):boolean;Stdcall; external 'CH341DLL.DLL' ;  // ָ򳤶ȵԪ,ʱΪ׼дĳ,غΪʵдĳ

Function CH341GetDeviceName(  // ָCH341豸ƵĻ,򷵻NULL
	iIndex:cardinal ):PVOID;Stdcall; external 'CH341DLL.DLL' ;  // ָCH341豸,0Ӧһ豸

Function CH341GetVerIC(  // ȡCH341оƬİ汾,:0=豸Ч,0x10=CH341,0x20=CH341A
	iIndex:cardinal ):cardinal;Stdcall; external 'CH341DLL.DLL' ;  // ָCH341豸


Function CH341FlushBuffer(  // CH341Ļ
	iIndex:cardinal ):boolean;Stdcall; external 'CH341DLL.DLL' ;  // ָCH341豸

Function CH341WriteRead(  // ִ,
	iIndex:cardinal;  // ָCH341豸
	iWriteLength:cardinal;  // д,׼дĳ
	iWriteBuffer:PVOID;  // ָһ,׼д
	iReadStep:cardinal;  // ׼ȡĵĳ, ׼ȡܳΪ(iReadStep*iReadTimes)
	iReadTimes:cardinal;  // ׼ȡĴ
	oReadLength:PULONG;  // ָ򳤶ȵԪ,غΪʵʶȡĳ
	oReadBuffer:PVOID ):boolean;Stdcall; external 'CH341DLL.DLL' ;  // ָһ㹻Ļ,ڱȡ

Function CH341SetStream(  // ôģʽ
	iIndex:cardinal;  // ָCH341豸
	iMode:cardinal ):boolean;Stdcall; external 'CH341DLL.DLL' ;  // ָģʽ,
// λ1-λ0: I2Cӿٶ/SCLƵ, 00=/20KHz,01=׼/100KHz(Ĭֵ),10=/400KHz,11=/750KHz
// λ2:     SPII/O/IO, 0=뵥(D3ʱ/D5/D7)(Ĭֵ),1=˫˫(D3ʱ/D5D4/D7D6)
// λ7:     SPIֽеλ˳, 0=λǰ, 1=λǰ
// ,Ϊ0

Function CH341SetDelaymS(  // Ӳ첽ʱ,úܿ췵,һ֮ǰʱָ
	iIndex:cardinal;  // ָCH341豸
	iDelay:cardinal ):boolean;Stdcall; external 'CH341DLL.DLL' ;  // ָʱĺ

Function CH341StreamI2C(  // I2C
	iIndex:cardinal;  // ָCH341豸
	iWriteLength:cardinal;  // ׼дֽ
	iWriteBuffer:pvoid;  // ָһ,׼д,ֽͨI2C豸ַдλ
	iReadLength:cardinal;  // ׼ȡֽ
	oReadBuffer:pvoid ):boolean;stdcall; external 'CH341DLL.DLL' ;  // ָһ,غǶ

// EEPROMͺ
type
   EEPROM_TYPE =(ID_24C01,ID_24C02,ID_24C04,ID_24C08,ID_24C16,ID_24C32,ID_24C64,ID_24C128,ID_24C256,ID_24C512,ID_24C1024,ID_24C2048,ID_24C4096);

Function CH341ReadEEPROM(  // EEPROMжȡݿ
	iIndex:cardinal;  // ָCH341豸
        iEepromID:EEPROM_TYPE;  // ָEEPROMͺ
	iAddr:cardinal;  // ָݵԪĵַ
	iLength:cardinal;  // ׼ȡֽ
	oBuffer:Pbytearray ):boolean;stdcall; external 'CH341DLL.DLL' ;  // ָһ,غǶ


Function CH341WriteEEPROM(  // EEPROMдݿ
	iIndex:cardinal;  // ָCH341豸
	iEepromID:EEPROM_TYPE;  // ָEEPROMͺ
	iAddr:cardinal;  // ָݵԪĵַ
	iLength:cardinal;  // ׼дֽ
	iBuffer:pbytearray ):boolean;stdcall; external 'CH341DLL.DLL' ;  // ָһ,׼д

Function CH341GetInput(  // ͨCH341ֱݺ״̬,ЧʱCH341GetStatus
	iIndex:cardinal;  // ָCH341豸
	iStatus:PULONG ):boolean;Stdcall; external 'CH341DLL.DLL' ;  // ָһ˫ֵԪ,ڱ״̬,ολ˵
// λ7-λ0ӦCH341D7-D0
// λ8ӦCH341ERR#, λ9ӦCH341PEMP, λ10ӦCH341INT#, λ11ӦCH341SLCT, λ23ӦCH341SDA
// λ13ӦCH341BUSY/WAIT#, λ14ӦCH341AUTOFD#/DATAS#,λ15ӦCH341SLCTIN#/ADDRS#

Function CH341SetOutput(  // CH341I/O,ͨCH341ֱ
// ***** ʹøAPI, ֹ޸I/OʹűΪŵ֮·оƬ *****
	iIndex:cardinal;  // ָCH341豸
	iEnable:cardinal;  // Ч־,ολ˵
// λ0Ϊ1˵iSetDataOutλ15-λ8Ч,
// λ1Ϊ1˵iSetDirOutλ15-λ8Ч,
// λ2Ϊ1˵iSetDataOut7-λ0Ч,
// λ3Ϊ1˵iSetDirOutλ7-λ0Ч,
// λ4Ϊ1˵iSetDataOutλ23-λ16Ч,
	iSetDirOut:cardinal;  // I/O,ĳλ0ӦΪ,ĳλ1ӦΪ,ڷʽĬֵΪ0x000FC000,ολ˵
	iSetDataOut:cardinal ):boolean;Stdcall; external 'CH341DLL.DLL' ;  // ,I/OΪ,ôĳλ0ʱӦ͵ƽ,ĳλ1ʱӦߵƽ,ολ˵
// λ7-λ0ӦCH341D7-D0
// λ8ӦCH341ERR#, λ9ӦCH341PEMP, λ10ӦCH341INT#, λ11ӦCH341SLCT
// λ13ӦCH341WAIT#, λ14ӦCH341DATAS#/READ#,λ15ӦCH341ADDRS#/ADDR/ALE
// ֻ,I/O: λ16ӦCH341RESET#, λ17ӦCH341WRITE#, λ18ӦCH341SCL, λ29ӦCH341SDA

Function CH341Set_D5_D0(  // CH341D5-D0ŵI/O,ͨCH341D5-D0ֱ,ЧʱCH341SetOutput
// ***** ʹøAPI, ֹ޸I/OʹűΪŵ֮·оƬ *****
	iIndex:cardinal;  // ָCH341豸
	iSetDirOut:cardinal;  // D5-D0ŵI/O,ĳλ0ӦΪ,ĳλ1ӦΪ,ڷʽĬֵΪ0x00ȫ
	iSetDataOut:cardinal ):boolean;Stdcall; external 'CH341DLL.DLL' ;  // D5-D0ŵ,I/OΪ,ôĳλ0ʱӦ͵ƽ,ĳλ1ʱӦߵƽ
// ݵλ5-λ0ֱӦCH341D5-D0

Function CH341StreamSPI3(  // SPI,3߽ӿ,ʱΪDCK2/SCL,ΪDIO/SDA(׼˫I/O),ƬѡΪD0/D1/D2,ٶԼ51Kֽ
//* SPIʱ: DCK2/SCLΪʱ, ĬΪ͵ƽ, DIO/SDAʱ֮ǰ, DIO/SDAʱ½֮ */
	iIndex:cardinal;  // ָCH341豸
	iChipSelect:cardinal;  // Ƭѡ, λ7Ϊ0Ƭѡ, λ7Ϊ1Ч: λ1λ0Ϊ00/01/10ֱѡD0/D1/D2Ϊ͵ƽЧƬѡ
	iLength:cardinal;  // ׼ֽ
	ioBuffer:PVOID):boolean;Stdcall; external 'CH341DLL.DLL' ;  // ָһ,׼DIOд,غǴDIO


Function CH341StreamSPI4(  // SPI,4߽ӿ,ʱΪDCK/D3,ΪDOUT/D5,ΪDIN/D7,ƬѡΪD0/D1/D2,ٶԼ68Kֽ
//* SPIʱ: DCK/D3Ϊʱ, ĬΪ͵ƽ, DOUT/D5ʱ֮ǰ, DIN/D7ʱ½֮ */
	iIndex:cardinal;  // ָCH341豸
	iChipSelect:cardinal;  // Ƭѡ, λ7Ϊ0Ƭѡ, λ7Ϊ1Ч: λ1λ0Ϊ00/01/10ֱѡD0/D1/D2Ϊ͵ƽЧƬѡ
	iLength:cardinal;  // ׼ֽ
	ioBuffer:PVOID ):boolean;Stdcall; external 'CH341DLL.DLL' ;  // ָһ,׼DOUTд,غǴDIN


Function CH341StreamSPI5(  // SPI,5߽ӿ,ʱΪDCK/D3,ΪDOUT/D5DOUT2/D4,ΪDIN/D7DIN2/D6,ƬѡΪD0/D1/D2,ٶԼ30Kֽ*2
//* SPIʱ: DCK/D3Ϊʱ, ĬΪ͵ƽ, DOUT/D5DOUT2/D4ʱ֮ǰ, DIN/D7DIN2/D6ʱ½֮ */
	iIndex:cardinal;  // ָCH341豸
	iChipSelect:cardinal;  // Ƭѡ, λ7Ϊ0Ƭѡ, λ7Ϊ1Ч: λ1λ0Ϊ00/01/10ֱѡD0/D1/D2Ϊ͵ƽЧƬѡ
	iLength:cardinal;  // ׼ֽ
	ioBuffer:PVOID;  // ָһ,׼DOUTд,غǴDIN
	ioBuffer2:PVOID ):boolean;Stdcall; external 'CH341DLL.DLL' ;  // ָڶ,׼DOUT2д,غǴDIN2

Function CH341BitStreamSPI(  // SPIλ,4/5߽ӿ,ʱΪDCK/D3,ΪDOUT/DOUT2,ΪDIN/DIN2,ƬѡΪD0/D1/D2,ٶԼ8Kλ*2
		iIndex:cardinal;  // ָCH341豸
	        iLength:cardinal;  // ׼λ,һ896,鲻256
	        ioBuffer:PVOID ):boolean;Stdcall; external 'CH341DLL.DLL' ;  // ָһ,׼DOUT/DOUT2/D2-D0д,غǴDIN/DIN2
//* SPIʱ: DCK/D3Ϊʱ, ĬΪ͵ƽ, DOUT/D5DOUT2/D4ʱ֮ǰ, DIN/D7DIN2/D6ʱ½֮ */
//* ioBufferеһֽڹ8λֱӦD7-D0, λ5DOUT, λ4DOUT2, λ2-λ0D2-D0, λ7DIN, λ6DIN2, λ3ݺ */
//* ڵøAPI֮ǰ,ӦȵCH341Set_D5_D0CH341D5-D0ŵI/O,ŵĬϵƽ */


Function CH341SetBufUpload(  // 趨ڲϴģʽ
	iIndex:cardinal;  // ָCH341豸,0Ӧһ豸
	iEnableOrClear:cardinal ):boolean;Stdcall; external 'CH341DLL.DLL' ;  // Ϊ0ֹڲϴģʽ,ʹֱϴ,0ڲϴģʽе
// ڲϴģʽ,ôCH341򴴽߳ԶUSBϴݵڲ,ͬʱе,ӦóCH341ReadDataػе


Function CH341QueryBufUpload(  // ѯڲϴеݰ,ɹݰ,-1
	iIndex:cardinal ):integer;Stdcall; external 'CH341DLL.DLL' ;  // ָCH341豸,0Ӧһ豸


Function CH341SetBufDownload(  // 趨ڲ´ģʽ
	iIndex:cardinal;  // ָCH341豸,0Ӧһ豸
	iEnableOrClear:cardinal ):boolean;Stdcall; external 'CH341DLL.DLL' ;  // Ϊ0ֹڲ´ģʽ,ʹֱ´,0ڲ´ģʽе
// ڲ´ģʽ,ôӦóCH341WriteData󽫽ǽUSB´ݷŵڲ,CH341򴴽߳Զֱ


Function CH341QueryBufDownload(  // ѯڲ´еʣݰ(δ),ɹݰ,-1
	iIndex:cardinal ):integer;Stdcall; external 'CH341DLL.DLL' ;  // ָCH341豸,0Ӧһ豸


Function CH341ResetInter(  // λжݶ
	iIndex:cardinal ):boolean;Stdcall; external 'CH341DLL.DLL' ;  // ָCH341豸


Function CH341ResetRead(  // λݿ
	iIndex:cardinal ):boolean;Stdcall; external 'CH341DLL.DLL' ;  // ָCH341豸


Function 	CH341ResetWrite(  // λݿд
	iIndex:cardinal ):boolean;Stdcall; external 'CH341DLL.DLL' ;  // ָCH341豸


type	 mPCH341_NOTIFY_ROUTINE =ProceDure (  // 豸¼֪ͨص
	 iEventStatus:cardinal);stdcall;  // 豸¼͵ǰ״̬(ж): 0=豸γ¼, 3=豸¼

const	CH341_DEVICE_ARRIVAL =		3 ;		// 豸¼,Ѿ
	CH341_DEVICE_REMOVE_PEND =	1 ;		// 豸Ҫγ
	CH341_DEVICE_REMOVE    =	0 ;		// 豸γ¼,Ѿγ


Function CH341SetDeviceNotify(  // 趨豸¼֪ͨ
	iIndex:cardinal;  // ָCH341豸,0Ӧһ豸
	iDeviceID:PCHAR;  // ѡ,ַָ,ָص豸ID,ַ\0ֹ
	iNotifyRoutine:mPCH341_NOTIFY_ROUTINE):boolean;Stdcall; external 'CH341DLL.DLL' ;  // ָ豸¼ص,ΪNULLȡ¼֪ͨ,ڼ⵽¼ʱøó


Function CH341SetupSerial(  // 趨CH341Ĵ,APIֻڹڴڷʽCH341оƬ
	iIndex:cardinal;  // ָCH341豸,0Ӧһ豸
	iParityMode:cardinal;  // ָCH341ڵУģʽ: NOPARITY/ODDPARITY/EVENPARITY/MARKPARITY/SPACEPARITY
	iBaudRate:cardinal ):boolean;Stdcall; external 'CH341DLL.DLL' ;  // ָCH341ڵͨѶֵ,503000000ֵ֮


{ APIڹڴڷʽCH341оƬ,֮APIһֻڲڷʽCH341оƬ
	CH341OpenDevice
	CH341CloseDevice
	CH341SetupSerial
	CH341ReadData
	CH341WriteData
	CH341SetBufUpload
	CH341QueryBufUpload
	CH341SetBufDownload
	CH341QueryBufDownload
	CH341SetDeviceNotify
	CH341GetStatus
//  ҪAPI,ǴҪAPI
	CH341GetVersion
	CH341DriverCommand
	CH341GetDrvVersion
	CH341ResetDevice
	CH341GetDeviceDescr
	CH341GetConfigDescr
	CH341SetIntRoutine
	CH341ReadInter
	CH341AbortInter
	CH341AbortRead
	CH341AbortWrite
	CH341ReadI2C
	CH341WriteI2C
	CH341SetExclusive
	CH341SetTimeout
	CH341GetDeviceName
	CH341GetVerIC
	CH341FlushBuffer
	CH341WriteRead
	CH341ResetInter
	CH341ResetRead
	CH341ResetWrite
}
implementation


end.
