// TSRSTART.C
// This program checks to see if TSRPLAY has been installed.
// If TSRPLAY is not resident, the size and number of each DMA
// buffer, the file list and file count in _tsrPlayInfo are 
// initialized.

#include <stdio.h>
#include <string.h>
#include "cvxdigi.h"

#define _FILE_COUNT               2 
#define _FILE_1                  "TEST1.V8"
#define _FILE_2                  "TEST2.V8"
#define _BUFFER_SIZE_DEFAULT      32
#define _BUFFER_COUNT_DEFAULT     3

VOID main( VOID )
{
   WORD errorCode;

   // Check to see if TSRPLAY is resident.
   if( !tsrResident() )
   {
      printf( "Installing %s\n", tsrGetProgramID() );

      // Setup 2 files in _tsrPlayInfo structure.
      _tsrPlayInfo.fileCount = _FILE_COUNT;

      // Put new file names into structure.
      strcpy(_tsrPlayInfo.fileName[ 0 ], _FILE_1);
      strcpy(_tsrPlayInfo.fileName[ 1 ], _FILE_2);
      
      // Set up memory for TSRPLAY
      _tsrPlayInfo.bufferSize  = _BUFFER_SIZE_DEFAULT;
      _tsrPlayInfo.bufferCount = _BUFFER_COUNT_DEFAULT;
      
      errorCode = tsrStart();

      // Make call to install TSRPLAY system.
      if( errorCode )
         printf( "ERROR : tsrStart() failed : errorCode = %d \n", errorCode );
   }
   else
      printf( "ERROR : %s has already been installed\n", tsrGetProgramID() );
}


