// File        : recfile.c
//
// Description : Function to record a file Covox ADPCM and PCM using any Covox hardware
//
// Written by  : Ryan Hanlon
// Description :
// Date        : Feb 8, 1992
//
//----------------------------------------------------------------------------
//             Copyright (c) 1992, Covox, Inc. All Rights Reserved                   
//----------------------------------------------------------------------------

#include "cvxdigi.h"
#include "cvxutil.h"


// Flag used to determine when i/o is complete.
//
extern BYTE _ioStopFlag;


WORD recordFile( HANDLE fileHandle,   BYTE fileFormat, BYTE recordRate,  
                 WORD   silenceRange, BOOL hookKBFlag,
                 WORD   portIn,       LONG bufferSize )
{
   LPSTR  buffer;
   LONG   length;
   LONG   bytesAvailable;
   LONG   bytesWritten;
   LONG   bytesRecorded;
   WORD   returnValue = _ERROR_NONE;
   WORD   i;

   // Allocated buffer for non-DMA recording.
   //
   if( bufferSize )
   {
      buffer = cvxBufferAlloc( bufferSize, &bytesAvailable );

      if( buffer == _NULL )
         returnValue = _ERROR_MEMORY_ALLOC;

      length = bufferSize;
   }
   else
   {
      // Find largest amount of memory that can be allocated.
      //
      cvxBufferAlloc( 0xFFFFFFFF, &bytesAvailable );

      buffer = cvxBufferAlloc( bytesAvailable, &length );

      if( buffer == _NULL )
         returnValue = _ERROR_MEMORY_ALLOC;

      length = bytesAvailable;
   }   

   if( !returnValue )
   {
      // If rate not given then set rate to the default.
      //
      if( !recordRate )
         recordRate = _CVX_RATE_DEFAULT;
   
      // Hook int 9h (keyboard interrupt).  This hook will set the flag
      // _ioStopFlag when a key has been struck.
      //
      if( hookKBFlag )
         hookKeyboard();
   
      // Call function to record file of specified format.
      //
      switch( fileFormat )
      {
         case _FORMAT_V8S:
            returnValue = record8s( buffer, length,       recordRate, 
                                    portIn, silenceRange, &bytesRecorded );
            break;

         case _FORMAT_V4S:
            returnValue = record4s( buffer, length,       recordRate,
                                    portIn, silenceRange, &bytesRecorded );
            break;

         case _FORMAT_V3S:
            returnValue = record3s( buffer, length,       recordRate, 
                                    portIn, silenceRange, &bytesRecorded );
            break;

         case _FORMAT_V2S:
            returnValue = record2s( buffer, length,       recordRate, 
                                    portIn, silenceRange, &bytesRecorded );
            break;

         case _FORMAT_V8:
            returnValue = record8 ( buffer, length, recordRate,
                                    portIn, &bytesRecorded );
            break;

         default:
            returnValue = _ERROR_INVALID_FORMAT;

            break;
      }
   
      // Reset keyboard ISR vector.
      //
      if( hookKBFlag )
         unhookKeyboard();
   
      if( !returnValue )
      {
         returnValue = cvxFileWrite( fileHandle,    buffer, 
                                     bytesRecorded, &bytesWritten );
      }

      cvxBufferFree( buffer );
   }

   return( returnValue );
}
