/****************************************************************************

  File                  : fmsetins.c	
  Date                  : 3-18-91	
  Description           : Setup the selected voice with the passed instrument data
				

  Progammer(s)          : Don Fowler, Lance Williams	
  Last Modifications    : 	

  Additional Notes      : 

****************************************************************************
               Copyright (c) 1991,  Covox, Inc.  All Rights Reserved      
****************************************************************************/

#include "cvxfmsy.h"

/****************************************************************************

	Function	 : BYTE fmSetInstrument(  FM_INSTRUMENT far *Instrument, BYTE Voice )

	Parameters: FM_INSTRUMENT, Voice
					1.) Voice - The voice to set the instrument on

	Actions	 :	 1.) Check for system initialized
					 2.) Check for vaid instrument for voice
					 3.) Set the am-vib-egtype-ksr-multi register
					 4.) Set the ksl-tl register
					 5.) Set the attack-decay register
					 6.) Set the sustain-release register
					 7.) Set the feedback-connection register
					 8.) Set the wave select register
					 9.) Set the instrument set for voice flag

*****************************************************************************/

WORD fmSetInstrument( _BNK_INSTRUMENT far *Instrument, BYTE Voice )
{
	// Temporary variable
	WORD			Temp;

	// Check to see if the system is initialized
	if( !_fmGlobalParameters.systemInitialized )
		return( _ERROR_SYSTEM_NOT_INITIALIZED );
	  
	// Check for voice out of range
	if( Voice > _TOT_VOICES )
		return( _ERROR_VOICE_OUT_OF_RANGE );

	// Check for valid parameters for melodic voice and setup the melodic instrument
	if( ( _fmGlobalParameters.mode == _MELODIC ) || ( _fmGlobalParameters.mode == _PERCUSSIVE && Voice < 6 ) )
	{
		// Check for voice out of range
		if( Voice > 8 )
			return( _ERROR_INVALID_VOICE_FOR_MODE );

		// Check for illegal instrument
		if( Instrument -> mode )
			return( _ERROR_INVALID_INSTRUMENT );
		
		// Or together the bit values for the am-multi register 
		Temp = ( Instrument -> modAmplitudeVibrato << 0x07 ) |
				 ( Instrument -> modFrequencyVibrato	<< 0x06 ) |
				 ( Instrument -> modSustainStatus    << 0x05 ) |
				 ( Instrument -> modKSR					<< 0x04 ) |
				 ( Instrument -> modFreqMultiplier 			  );

		// Set the am-vib-egtype-ksr-multi register
		fmSetRegister( ( _AM_MULTI + _fmMelodicSlots[ Voice ][ _MODULATOR ] ), Temp );

		// Or together the bits for the ksl-tl
		Temp = ( Instrument -> modKSL << 0x06 ) |
				 ( Instrument -> modOutputLevel );

		// Set the ksl-tl register
		fmSetRegister( ( _KSL_TL + _fmMelodicSlots[ Voice ][ _MODULATOR ] ), Temp );

		// Store the value in the global register
		_fmKSLTLReg[ _fmMelodicSlots[ Voice ][ _MODULATOR ] ] = Temp;

		// Or together the bits for the ar-dr register
		Temp = ( Instrument -> modAttack << 0x04 ) |
				 ( Instrument -> modDecay			 );

		// Set the ar-dr register
		fmSetRegister( ( _AR_DR + _fmMelodicSlots[ Voice ][ _MODULATOR ] ), Temp );

		// Or together the bits	for the sl-rr register
		Temp = ( Instrument -> modSustain	<< 0x04 ) |
				 ( Instrument -> modRelease 		  );

		// Set the sl-rr register
		fmSetRegister( ( _SL_RR + _fmMelodicSlots[ Voice ][ _MODULATOR ] ), Temp );

		// Or together the bits for the fb-c register
		Temp = ( Instrument -> modFeedbackLevel << 0x01 ) |
				 ( Instrument -> modConnection       );

		// Set the fb-c register
		fmSetRegister( ( _FB_C + Voice ), Temp );

		// Set the wave select register
		fmSetRegister( ( _WS + _fmMelodicSlots[ Voice ][ _MODULATOR ] ), Instrument -> modWaveform ); 

		// Set the carrier parameters
		// Or together the bit values for the am-multi register 
		Temp = ( Instrument -> carAmplitudeVibrato << 0x07 ) |
				 ( Instrument -> carFrequencyVibrato	<< 0x06 ) |
				 ( Instrument -> carSustainStatus    << 0x05 ) |
				 ( Instrument -> carKSR					<< 0x04 ) |
				 ( Instrument -> carFreqMultiplier 			  );

		// Set the am-vib-egtype-ksr-multi register
		fmSetRegister( ( _AM_MULTI + _fmMelodicSlots[ Voice ][ _CARRIER ] ), Temp );

		// Or together the bits for the ksl-tl
		Temp = ( Instrument -> carKSL << 0x06 ) |
				 ( Instrument -> carOutputLevel );

		// Set the ksl-tl register
		fmSetRegister( ( _KSL_TL + _fmMelodicSlots[ Voice ][ _CARRIER ] ), Temp );

		// Store the value in the global register
		_fmKSLTLReg[ _fmMelodicSlots[ Voice ][ _CARRIER ] ] = Temp;

		// Or together the bits for the ar-dr register
		Temp = ( Instrument -> carAttack << 0x04 ) |
				 ( Instrument -> carDecay			 );

		// Set the ar-dr register
		fmSetRegister( ( _AR_DR + _fmMelodicSlots[ Voice ][ _CARRIER ] ), Temp );

		// Or together the bits	for the sl-rr register
		Temp = ( Instrument -> carSustain	<< 0x04 ) |
				 ( Instrument -> carRelease 		  );

		// Set the sl-rr register
		fmSetRegister( ( _SL_RR + _fmMelodicSlots[ Voice ][ _CARRIER ] ), Temp );

		// Set the wave select register
		fmSetRegister( ( _WS + _fmMelodicSlots[ Voice ][ _CARRIER ] ), Instrument -> carWaveform ); 

		// Set the instrument set for voice flag
		_fmInstrumentSet[ Voice ] = _TRUE;

		return( _ERROR_NONE );
	}

	// Check for valid parameters for percussive mode and setup instrument 
	else
	{
		// Check	for bass drum
		if( Voice == _BASS_DRUM && Instrument -> voiceNumber == _BASS_DRUM )
		{
			// Setup the bass drum parameters
			// Or together the bit values for the am-multi register 
			Temp = ( Instrument -> modAmplitudeVibrato << 0x07 ) |
					 ( Instrument -> modFrequencyVibrato	<< 0x06 ) |
					 ( Instrument -> modSustainStatus    << 0x05 ) |
					 ( Instrument -> modKSR					<< 0x04 ) |
					 ( Instrument -> modFreqMultiplier 			  );

			// Set the am-vib-egtype-ksr-multi register
			fmSetRegister( ( _AM_MULTI + _fmPercussiveSlots[ Voice ][ _MODULATOR ] ), Temp );

			// Or together the bits for the ksl-tl
			Temp = ( Instrument -> modKSL << 0x06 ) |
					 ( Instrument -> modOutputLevel );

			// Set the ksl-tl register
			fmSetRegister( ( _KSL_TL + _fmPercussiveSlots[ Voice ][ _MODULATOR ] ), Temp );

			// Or together the bits for the ar-dr register
			Temp = ( Instrument -> modAttack << 0x04 ) |
					 ( Instrument -> modDecay			 );

			// Set the ar-dr register
			fmSetRegister( ( _AR_DR + _fmPercussiveSlots[ Voice ][ _MODULATOR ] ), Temp );

			// Or together the bits	for the sl-rr register
			Temp = ( Instrument -> modSustain	<< 0x04 ) |
					 ( Instrument -> modRelease 		  );

			// Set the sl-rr register
			fmSetRegister( ( _SL_RR + _fmPercussiveSlots[ Voice ][ _MODULATOR ] ), Temp );

			// Or together the bits for the fb-c register
			Temp = ( Instrument -> modFeedbackLevel << 0x01 ) |
					 ( Instrument -> modConnection       );

			// Set the fb-c register
			fmSetRegister( ( _FB_C + Voice ), Temp );
	
			// Set the wave select register
			fmSetRegister( ( _WS + _fmPercussiveSlots[ Voice ][ _MODULATOR ] ), Instrument -> modWaveform ); 

			// Set the carrier parameters
			// Or together the bit values for the am-multi register 
			Temp = ( Instrument -> carAmplitudeVibrato << 0x07 ) |
					 ( Instrument -> carFrequencyVibrato	<< 0x06 ) |
					 ( Instrument -> carSustainStatus    << 0x05 ) |
					 ( Instrument -> carKSR					<< 0x04 ) |
					 ( Instrument -> carFreqMultiplier 			  );

			// Set the am-vib-egtype-ksr-multi register
			fmSetRegister( ( _AM_MULTI + _fmPercussiveSlots[ Voice ][ _CARRIER ] ), Temp );

			// Or together the bits for the ksl-tl
			Temp = ( Instrument -> carKSL << 0x06 ) |
					 ( Instrument -> carOutputLevel );

			// Set the ksl-tl register
			fmSetRegister( ( _KSL_TL + _fmPercussiveSlots[ Voice ][ _CARRIER ] ), Temp );

			// Or together the bits for the ar-dr register
			Temp = ( Instrument -> carAttack << 0x04 ) |
					 ( Instrument -> carDecay			 );

			// Set the ar-dr register
			fmSetRegister( ( _AR_DR + _fmPercussiveSlots[ Voice ][ _CARRIER ] ), Temp );

			// Or together the bits	for the sl-rr register
			Temp = ( Instrument -> carSustain	<< 0x04 ) |
					 ( Instrument -> carRelease 		  );

			// Set the sl-rr register
			fmSetRegister( ( _SL_RR + _fmPercussiveSlots[ Voice ][ _CARRIER ] ), Temp );

			// Set the wave select register
			fmSetRegister( ( _WS + _fmPercussiveSlots[ Voice ][ _CARRIER ] ), Instrument -> carWaveform ); 

			// Set the instrument set for voice flag
			_fmInstrumentSet[ _BASS_DRUM ] = _TRUE;

			return( _ERROR_NONE );
		}

		// Check for any of the other percussion instruments
		else if( ( Voice == _SNARE_DRUM && Instrument -> voiceNumber == _SNARE_DRUM ) ||
			      ( Voice == _TOM && Instrument -> voiceNumber == _TOM ) ||
			      ( Voice == _CYMBAL && Instrument -> voiceNumber == _CYMBAL ) ||
			      ( Voice == _HIGH_HAT && Instrument -> voiceNumber == _HIGH_HAT ) )
	 	{
			// Setup the carrier parameters for the percussion instrument
			// Or together the bit values for the am-multi register 
			Temp = ( Instrument -> modAmplitudeVibrato << 0x07 ) |
					 ( Instrument -> modFrequencyVibrato	<< 0x06 ) |
					 ( Instrument -> modSustainStatus    << 0x05 ) |
					 ( Instrument -> modKSR					<< 0x04 ) |
					 ( Instrument -> modFreqMultiplier 			  );

			// Set the am-vib-egtype-ksr-multi register
			fmSetRegister( ( _AM_MULTI + _fmPercussiveSlots[ Voice ][ _MODULATOR ] ), Temp );

			// Or together the bits for the ksl-tl
			Temp = ( Instrument -> modKSL << 0x06 ) |
					 ( Instrument -> modOutputLevel );

			// Set the ksl-tl register
			fmSetRegister( ( _KSL_TL + _fmPercussiveSlots[ Voice ][ _MODULATOR ] ), Temp );

			// Or together the bits for the ar-dr register
			Temp = ( Instrument -> modAttack << 0x04 ) |
					 ( Instrument -> modDecay			 );

			// Set the ar-dr register
			fmSetRegister( ( _AR_DR + _fmPercussiveSlots[ Voice ][ _MODULATOR ] ), Temp );

			// Or together the bits	for the sl-rr register
			Temp = ( Instrument -> modSustain	<< 0x04 ) |
					 ( Instrument -> modRelease 		  );

			// Set the sl-rr register
			fmSetRegister( ( _SL_RR + _fmPercussiveSlots[ Voice ][ _MODULATOR ] ), Temp );

			// Or together the bits for the fb-c register
			Temp = ( Instrument -> modFeedbackLevel << 0x01 ) |
					 ( Instrument -> modConnection       );

			// Set the wave select register
			fmSetRegister( ( _WS + _fmPercussiveSlots[ Voice ][ _MODULATOR ] ), Instrument -> modWaveform ); 

			// Set the instrument set for voice	for flag
			_fmInstrumentSet[ Voice ] = _TRUE;

			return( _ERROR_NONE );
		}
		else
			return( _ERROR_INVALID_INSTRUMENT );
  	}
}

