;****************************************************************************
;**                                                                        **
;**                                RECPLAY.INC                             **
;**                                                                        **
;**                     Copyright, 1988, 1992 Covox Inc.                   **
;**                           All rights reserved.                         **
;**                                                                        **
;****************************************************************************

; Purpose       File of overspecialized macros For use with 
;               record and play library functions.
; Date written  5 Apr 90
;
; Last updated  February 12, 1992


VM_COUNTER0_OFFSET          EQU   8     ; 8254 Counter 0 registor offset from base
VM_COUNTER1_OFFSET          EQU   09h   ; 8254 Counter 1 registor offset from base
VM_COUNTER2_OFFSET          EQU   0Ah   ; 8254 Counter 2 registor offset from base
VM_CONTROL_OFFSET           EQU   0bh   ; 8254 Control registor offset from base
VM_CLEAR_IRQ_OFFSET         EQU   0Ch   ; VM Pro Clear IRQ Flip Flop
VM_ENABLE_DMA_OFFSET        EQU   0Eh   ; VM Pro Enable DMA Flip Flop
VM_DISABLE_DMA_OFFSET       EQU   0Dh   ; VM Pro Disable DMA Flip Flop
VM_DAC_OFFSET               EQU   0Fh   ; Offset from base to DAC and A to D

_ERROR_NONE                 EQU   0
_ERROR_PORT_INIT_FAILED     EQU   1000                                          
_ERROR_INVALID_BUFFER_SIZE  EQU   1001
_ERROR_INVALID_FORMAT       EQU   1002
_ERROR_PLAY8_BUSY           EQU   1003

convert_date   STRUC  ; Structure used by pack and unpack
      source_pointer      DD   ?   ; Far pointer to source buffer
      source_length       DD   ?   ; length of source buffer (min 100)
      source_used         DD   ?   ; number of bytes of the source used
                                   ; in packing or unpacking
      destination_pointer DD   ?   ; Far pointer to destination buffer
      destination_length  DD   ?   ; Length of destination buffer (min 16)
      destination_filled  DD   ?   ; number of bytes of the destination buffer
                                   ; filed in packing of unpacking
      off_format          DW   ?   ; compression format of 
                                   ;   source when unpacking
                                   ;   destination when packing

      off_rate            DB   ?   ; sample rate placed in destination
                                   ; header if rate not zero

      off_silence         DW   ?   ; silence range (0 to 5) when
                                   ; packing silence encoded sounds

      off_treble          DW   ?   ; A switch if not zero
                                   ; then differeciate unpacking stream

      off_play_noise      DW   ?   ; A switch if not zero then unpack
                                   ; silence coding to random noise
                             
      off_no_more_source  DW   ?   ; Flag passed by calling routine for
                                   ; If not zero then there is no more
                                   ; source data beyound what is presently
                                   ; in the source buffer.

      off_done            DW   ?   ; Flag, if no more source data and
                                   ; conversion complete then this value
                                   ; is 1, else value zero. This is returned
                                   ; by the pack and unpack routines.

      off_first_pass      DW   ?   ; Flag passed by calling routine,
                                   ; If not zero then it is the first time
                                   ; time through the partial source data (or whole
                                   ; thing at once). If zero then the call is
                                   ; a continuation of a previous pack
                                   ; or unpack call.
convert_date   ENDS


        IF1
;;
;;   For Covox Play rountines, setup pointers and get the
;;   stack ready.
;;
;;   When Done:
;;      es:di   far pointer to buffer
;;      ssize_msw:ssize_lsw  DWORD of count
;;
setup_play   MACRO   format_code
             LOCAL   L00,L01,L02,L03,L04,got_header,no_header,j_ret_uninit
            .ERRB   <format_code>

      cld                              ; set direction to upperward
      les    ax, stk_size              ; save DWORD size in RAM
      mov    ssize_lsw, ax
      mov    ssize_msw, es
      sub    ssize_lsw, 1              ; subtract one from source length, because zero adjust
      sbb    ssize_msw, 0
      jnc    L00

      mov    ax, _ERROR_INVALID_BUFFER_SIZE
      jmp    ret_error_no_uninit       ; jump if length was zero
L00:
      les    di, stk_start
      cmp    di, 08000h                ; adjust offset so always less then 8000h
      jb     L01
      add    di, 08000h
      mov    dx, es
      add    dx, 0800h
      mov    es, dx

L01:
   IFDIFI <format_code>,<08h>
      mov    ax, stk_play_noise        ; set noise flag to 1 or 0
      cmp    ax, 00
      je     L04
      mov    ax, 01

L04:
      mov   noiseflag, al
   ENDIF

      mov    dx, di                    ; save source pointer for restoring if no header                
      mov    si, OFFSET _sr_header     ;Check to see if this file
      mov    cx, 8
      rep    cmpsb
      jcxz   got_header
      jmp    SHORT no_header

got_header:
      mov    ax, stk_rate
      cmp    ax, 0
      jne    L02                       ; uses rate value passed
      mov    al, es:[di+1]             ; get rate
      or     al, al                    ; if header rate zero, set to default
      jnz    L02
      mov    al, 132

L02:
      mov    stk_rate, ax
      cmp    BYTE PTR es:[di+0], format_code  ; make sure same format
      je     CHECK_HEADER

      mov    ax, _ERROR_INVALID_FORMAT
      jmp    j_ret_uninit              ; jump if not the same format

CHECK_HEADER:
      add    di,8                      ; move pass header
      sub    ssize_lsw,16              ; adjust for header
      sbb    ssize_msw,0
      jnc    play_init
      mov    ax, _ERROR_INVALID_BUFFER_SIZE

j_ret_uninit:   
      jmp     ret_error_no_uninit

no_header:
      mov    di, dx                    ; restore source pointer
      mov    ax, stk_rate              ; get rate from pass value
      cmp    ax, 0
      jne    L03
      mov    ax, 132                   ; if no rate given then uses default

L03:
      mov    stk_rate, ax

play_init:

        ENDM
;;
;;   For Covox Record rountines, setup pointers and get the
;;   stack ready.
;;
;;   When Done:
;;      es:di   far pointer to buffer
;;      ssize_msw:ssize_lsw  DWORD of count
;;
setup_record   MACRO   format_code
                LOCAL   L00,L01,L02,L03,L04,rate_done
                .ERRB   <format_code>

      cld                              ; set direction to upperward
      les    ax, stk_size              ; save DWORD size in RAM
      mov    dsize_lsw, ax
      mov    dsize_msw, es
      sub    dsize_lsw, 1              ; subtract one from source length, because zero adjust
      sbb    dsize_msw, 0
      jnc    L00

      mov    ax, _ERROR_INVALID_BUFFER_SIZE
      jmp    ret_error_no_uninit       ; jump if length was zero

L00:
      les    di, stk_start
      cmp    di, 08000h                ; adjust offset so always less then 8000h
      jb     L01
      add    di, 08000h
      mov    dx, es
      add    dx, 0800h
      mov    es, dx

L01:
   IFDIFI <format_code>,<08h>
      mov    bx, stk_silence
      cmp    bx, 05
      jbe    L02
      mov    bx, 03

L02:
      shl    bx, 01
      mov    cx, [_sr_codetbl + bx]    ; into codetbl
      mov    macode, cx                ; to get code values
   ENDIF

load_new_header:
      mov    si, OFFSET _sr_header     ; move the header to the destination
      mov    cx, 8
      rep    movsb                     ; first move header
      mov    al, format_code
      mov    BYTE PTR es:[di], al
      inc    di

      mov    ax, stk_rate              ; calculate rate value for header
      cmp    ax, 0
      jne    L03
      xor    ah, ah
      mov    al, 132                   ; default rate
      jmp    SHORT rate_done
L03:
      cmp    al, 255
      jbe    rate_done
      mov    al, 255

rate_done:
      mov    BYTE PTR es:[di], al
      inc    di
      mov    al, 0                     ; zero out rest of header
      mov    cx, 6
      rep    stosb

      sub    dsize_lsw, 16             ; adjust for header
      sbb    dsize_msw, 0
      jnc    L04

      mov    ax, _ERROR_INVALID_BUFFER_SIZE
      jmp    ret_error_no_uninit

L04:
        ENDM
;;
;;   Macro to test keyboaard buffer pointers to see if keypressed
;;   Sets Zero Flag if key pressed, else zero flag cleared
;;
key_pressed   MACRO
      call   _sr_stop_io               ;; call routine that only effects the
                                       ;; flags to test for stop conditions
                                       ;; zero flag set if we are to stop
      ENDM

;;
;;   Macro to make random noise 
;;   seed_registor
;;
make_noise   MACRO   seed_reg
      LOCAL   L00
      mov    ax, seed_reg              ; generate low-level noise if required
      and    al, 1
      add    al, 80h
      xor    ah, ah
      rcr    seed_reg, 1               ; randomize by shifting
      jnc    L00
      xor    seed_reg, 50111           ; and sometimes adding
      add    seed_reg, 8000h           ; and xoring

L00:
      ENDM

differentiate   MACRO
      LOCAL   differ1,differ2,differx
      cmp    diffflag, 1
      jnz    differx
      mov    diffbyte1, al
      sub    al, diffbyte2
      push   ax
      mov    al, diffbyte1
      mov    diffbyte2, al
      pop    ax
      neg    al
      add    al, 80h
      cmp    al, 40h
      ja     differ1
      mov    al, 0
      jmp    SHORT differx

differ1:
      cmp    al, 0C0h
      jb     differ2
      mov    al, 0FFh
      jmp    SHORT differx

differ2:
      shl    al, 1
      xor    al, 80h

differx:
      ENDM



put_one_byte   MACRO   out_value, out_port
      LOCAL   wait_loop

wait_loop:
      in     al, 042h                  ; read lsb from counter register.
      cmp    al, 132                   ; compare timer value to sampling/playback rate.
      ja     wait_loop                 ; keep waiting if not.
      mov    al, 0                     ; set timer again
      out    042h, al                 
      mov    dx, out_port
      mov    al, out_value
      out    dx, al
      ENDM      


   ENDIF ;For the IF1 at the top.
