;----------------------------------------
;	8088 INTERRUPT LOCATIONS	:
;	REFERENCED BY POST & BIOS	:
;----------------------------------------

ABS0		SEGMENT AT 0		; ADDRESS= 0000:0000

@STG_LOC0	DB	?		; START OF INTERRUPT VECTOR TABLE

		ORG	4*002H
@NMI_PTR	DD	?		; NON-MASKABLE INTERRUPT VECTOR

		ORG	4*005H
@INT5_PTR	DD	?		; PRINT SCREEN INTERRUPT VECTOR

		ORG	4*008H
@INT_PTR	DD	?		; HARDWARE INTERRUPT POINTER (8-F)

		ORG	4*010H
@VIDEO_INT	DD	?		; VIDEO I/O INTERRUPT VECTOR

		ORG	4*013H
@ORG_VECTOR	DD	?		; DISKETTE/DISK INTERRUPT VECTOR

		ORG	4*018H
@BASIC_PTR	DD	?		; POINTER TO CASSETTE BASIC

		ORG	4*01DH
@PARM_PTR	DD	?		; POINTER TO VIDEO PARAMETERS

		ORG	4*01EH
@DISK_POINTER	DD	?		; POINTER TO DISKETTE PARAMETER TABLE

		ORG	4*01FH
@EXT_PTR	DD	?		; POINTER TO GRAPHIC CHARACTERS 128-255

		ORG	4*040H
@DISK_VECTOR	DD	?		; POINTER TO DISKETTE INTERRUPT CODE

		ORG	4*041H
@HF_TBL_VEC	DD	?		; POINTER TO FIRST DISK PARAMETER TABLE

		ORG	4*046H
@HF1_TBL_VEC	DD	?		; POINTER TO SECOND DISK PARAMETER TABLE

		ORG	4*070H
@SLAVE_INT_PTR	DD	?		; POINTER TO SLAVE INTERRUPT HANDLER

		ORG	4*076H
@HDISK_INT	DD	?		; POINTER TO FIXED DISK INTERRUPT CODE

	ORG	0400H
DATA_AREA	LABEL BYTE		; ABSOLUTE LOCATION OF DATA SEGMENT
DATA_WORD	LABEL WORD

		ORG	0500H
@MFG_TEST_RTN	LABEL	FAR		; LOAD LOCATION FOR MANUFACTURING TESTS

		ORG	7C00H
@BOOT_LOCN	LABEL	FAR		; BOOT STRAP CODE LOAD LOCATION

ABS0		ENDS
PAGE
;----------------------------------------
;	ROM BIOS DATA AREAS		:
;----------------------------------------

DATA		SEGMENT AT 40H		; ADDRESS= 0040:0000
DATA40		LABEL	BYTE
@RS232_BASE	DW	?		; BASE ADDRESSES OF RS232 ADAPTERS
		DW	?		;  SECOND LOGICAL RS232 ADAPTER
		DW	?		;   RESERVED
		DW	?		;   RESERVED
@PRINTER_BASE	DW	?		; BASE ADDRESSES OF PRINTER ADAPTERS
		DW	?		;  SECOND LOGICAL PRINTER ADAPTER
		DW	?		;  THIRD LOGICAL PRINTER ADAPTER
		DW	?		;   RESERVED
@EQUIP_FLAG	DW	?		; INSTALLED HARDWARE FLAGS
@MFG_TST	DB	?		; INITIALIZATION FLAGS
@MEMORY_SIZE	DW	?		; BASE MEMORY SIZE IN K BYTES  (X 1024)
@MFG_ERR_FLAG	DB	?		; SCRATCHPAD FOR MANUFACTURING
		DB	?		;  ERROR CODES

;----------------------------------------
;	KEYBOARD DATA AREAS		:
;----------------------------------------

@KB_FLAG	DB	?		; KEYBOARD SHIFT STATE AND STATUS FLAGS
@KB_FLAG_1	DB	?		; SECOND BYTE OF KEYBOARD STATUS
@ALT_INPUT	DB	?		; STORAGE FOR ALTERNATE KEY PAD ENTRY
@BUFFER_HEAD	DW	?		; POINTER TO HEAD OF KEYBOARD BUFFER
@BUFFER_TAIL	DW	?		; POINTER TO TAIL OF KEYBOARD BUFFER

;------     HEAD = TAIL    INDICATES THAT THE BUFFER IS EMPTY

@KB_BUFFER	DW	16 DUP (?)	; ROOM FOR 15 SCAN CODE ENTRIES

;----------------------------------------
;	DISKETTE DATA AREAS		:
;----------------------------------------

@SEEK_STATUS	DB	?		; DRIVE RECALIBRATION STATUS
					; BIT 3-0 = DRIVE 3-0 RECALIBRATION
					; BEFORE NEXT SEEK IF BIT IS = 0
@MOTOR_STATUS	DB	?		; MOTOR STATUS
					; BIT 3-0 = DRIVE 3-0 CURRENTLY RUNNING
					; BIT 7 = CURRENT OPERATION IS A WRITE
@MOTOR_COUNT	DB	?		; TIME OUT COUNTER FOR MOTOR(S) TURN OFF
@DSKETTE_STATUS DB	?		; RETURN CODE STATUS BYTE
					; CMD_BLOCK  IN STACK FOR DISK OPERATION
@NEC_STATUS	DB	7 DUP(?)	; STATUS BYTES FROM DISKETTE OPERATION


;----------------------------------------
;	VIDEO DISPLAY DATA AREA 	:
;----------------------------------------

@CRT_MODE	DB	?		; CURRENT DISPLAY MODE (TYPE)
@CRT_COLS	DW	?		; NUMBER OF COLUMNS ON SCREEN
@CRT_LEN	DW	?		; LENGTH OF REGEN BUFFER IN BYTES
@CRT_START	DW	?		; STARTING ADDRESS IN REGEN BUFFER
@CURSOR_POSN	DW	8 DUP(?)	; CURSOR FOR EACH OF UP TO 8 PAGES

@CURSOR_MODE	DW	?		; CURRENT CURSOR MODE SETTING
@ACTIVE_PAGE	DB	?		; CURRENT PAGE BEING DISPLAYED
@ADDR_6845	DW	?		; BASE ADDRESS FOR ACTIVE DISPLAY CARD
@CRT_MODE_SET	DB	?		; CURRENT SETTING OF THE 3X8 REGISTER
@CRT_PALETTE	DB	?		; CURRENT PALETTE SETTING - COLOR CARD

;----------------------------------------
;	POST AND BIOS WORK DATA AREA	:
;----------------------------------------

					; STACK SAVE, ETC.
@IO_ROM_INIT	DW	?		; POINTER TO ROM INITIALIZATION ROUTINE
@IO_ROM_SEG	DW	?		; POINTER TO I/O ROM SEGMENT
@INTR_FLAG	DB	?		; FLAG INDICATING AN INTERRUPT HAPPENED

;----------------------------------------
;	TIMER DATA AREA 		:
;----------------------------------------

@TIMER_LOW	DW	?		; LOW WORD OF TIMER COUNT
@TIMER_HIGH	DW	?		; HIGH WORD OF TIMER COUNT
@TIMER_OFL	DB	?		; TIMER HAS ROLLED OVER SINCE LAST READ

;----------------------------------------
;	SYSTEM DATA AREA		:
;----------------------------------------

@BIOS_BREAK	DB	?		; BIT 7=1 IF BREAK KEY HAS BEEN PRESSED
@RESET_FLAG	DW	?		; WORD=1234H IF KEYBOARD RESET UNDERWAY

;----------------------------------------
;	FIXED DISK DATA AREAS		:
;----------------------------------------

@DISK_STATUS1	DB	?		; FIXED DISK STATUS
@HF_NUM 	DB	?		; COUNT OF FIXED DISK DRIVES
@CONTROL_BYTE	DB	?		; HEAD CONTROL BYTE
@PORT_OFF	DB	?		;  RESERVED (PORT OFFSET)
PAGE
;----------------------------------------
;	TIME-OUT VARIABLES		:
;----------------------------------------

@PRINT_TIM_OUT	DB	?		; TIME OUT COUNTERS FOR PRINTER RESPONSE
		DB	?		;  SECOND LOGICAL PRINTER ADAPTER
		DB	?		;  THIRD LOGICAL PRINTER ADAPTER
		DB	?		;   RESERVED
@RS232_TIM_OUT	DB	?		; TIME OUT COUNTERS FOR RS232 RESPONSE
		DB	?		;  SECOND LOGICAL RS232 ADAPTER
		DB	?		;   RESERVED
		DB	?		;   RESERVED

;----------------------------------------
;	ADDITIONAL KEYBOARD DATA AREA	:
;----------------------------------------

					; BUFFER LOCATION WITHIN SEGMENT 40H
@BUFFER_START	DW	?		; OFFSET OF KEYBOARD BUFFER START
@BUFFER_END	DW	?		; OFFSET OF END OF BUFFER

;----------------------------------------
;	EGA/PGA DISPLAY WORK AREA	:
;----------------------------------------

@ROWS		DB	?		; ROWS ON THE ACTIVE SCREEN (LESS 1)
@POINTS 	DW	?		; BYTES PER CHARACTER
@INFO		DB	?		; MODE OPTIONS
@INFO_3 	DB	?		; FEATURE BIT SWITCHES
		DB	?		; RESERVED FOR DISPLAY ADAPTERS
		DB	?		; RESERVED FOR DISPLAY ADAPTERS

;----------------------------------------
;	ADDITIONAL MEDIA DATA		:
;----------------------------------------

@LASTRATE	DB	?		; LAST DISKETTE DATA RATE SELECTED
@HF_STATUS	DB	?		; STATUS REGISTER
@HF_ERROR	DB	?		; ERROR REGISTER
@HF_INT_FLAG	DB	?		; FIXED DISK INTERRUPT FLAG
@HF_CNTRL	DB	?		; COMBO FIXED DISK/DISKETTE CARD BIT 0=1
@DSK_STATE	DB	?		; DRIVE 0 MEDIA STATE
		DB	?		; DRIVE 1 MEDIA STATE
		DB	?		; DRIVE 0 OPERATION START STATE
		DB	?		; DRIVE 1 OPERATION START STATE
@DSK_TRK	DB	?		; DRIVE 0 PRESENT CYLINDER
		DB	?		; DRIVE 1 PRESENT CYLINDER

;----------------------------------------
;	ADDITIONAL KEYBOARD FLAGS	:
;----------------------------------------

@KB_FLAG_3	DB	?		; KEYBOARD MODE STATE AND TYPE FLAGS
@KB_FLAG_2	DB	?		; KEYBOARD LED FLAGS

IFE SYSTEM
;----------------------------------------
;	REAL TIME CLOCK DATA AREA	:
;----------------------------------------

@USER_FLAG	DW	?		; OFFSET ADDRESS OF USERS WAIT FLAG
@USER_FLAG_SEG	DW	?		; SEGMENT ADDRESS OF USER WAIT FLAG
@RTC_LOW	DW	?		; LOW WORD OF USER WAIT FLAG
@RTC_HIGH	DW	?		; HIGH WORD OF USER WAIT FLAG
@RTC_WAIT_FLAG	DB	?		; WAIT ACTIVE FLAG (01=BUSY, 80=POSTED)
ENDIF
					;		  (00=POST ACKNOWLEDGED)

;----------------------------------------
;	AREA FOR NETWORK ADAPTER	:
;----------------------------------------

@NET		DB	7 DUP(?)	; RESERVED FOR NETWORK ADAPTERS

;----------------------------------------
;	EGA/PGA PALETTE POINTER 	:
;----------------------------------------

@SAVE_PTR	DD	?		; POINTER TO EGA PARAMETER CONTROL BLOCK

;----------------------------------------
;	TIMER DATA			:
;----------------------------------------
		ORG	0CEH
@DAY_COUNT	DW	?		; COUNT OF DAYS FROM 1-1-80

					; RESERVED
;----------------------------------------
;	DATA AREA - PRINT SCREEN	:
;----------------------------------------

		ORG	100H		; ADDRESS= 0040:0100   (REF 0050:0000)

@STATUS_BYTE	DB	?		; PRINT SCREEN STATUS BYTE
					;  00=READY/OK,  01=BUSY,  FF=ERROR

DATA		ENDS			; END OF BIOS DATA SEGMENT
