/*/
* grabcld.c -- Image-1280 Windows 3.0 demo
*
* (c) Matrox Electronic Systems    March 1992
*
* This demo opens a transparent window and starts a colour grab process in
* FB012. The grab ROI is set up to be at the same location as the window's
* client area.  As the window is moved, commands are sent to the board to
* change the ROI.
*/

#include <windows.h>
#include <string.h>
#include "imseries.h"
#include "i_head.h"
#include "proto.h"
#include "grabcld.h"

HANDLE hInst;
static char string[100];
static old_x = 0;
static old_y = 39;
short dcmasks[6];

#define VideoWndROI		I_ROI3

BOOL FirstTime = TRUE;
HWND hGrabWnd;

int PASCAL WinMain(hInstance, hPrevInstance, lpCmdLine, nCmdShow)
HANDLE hInstance;
HANDLE hPrevInstance;
LPSTR lpCmdLine;
int nCmdShow;
	{
   MSG msg;
   int imhdl;

   imhdl = ioopdevice(I_LIN_AIN_LOW,0);
   iosldevice(imhdl);
   ioslmemdevice(imhdl);

   // Inquire for masks on FBs and overlay
   // im1280 win driver set overlay masks and they do not need to be changed!
   //  dcmask[0] for FB red         dcmask[3] for overlay red      
   //  dcmask[1] for FB green       dcmask[4] for overlay green    
   //  dcmask[2] for FB blue        dcmask[5] for overlay blue     
   pciqsys(I_IQ_DCMASKS,dcmasks);

   if (!hPrevInstance)
	   if (!InitApplication(hInstance))
	      return (FALSE);

	lsdcstopal(1);

	// set up the FBs properly
	ShowCursor(FALSE);
   krgcdi();
	pcstfborg(I_FB1X1KX1KX32);
   lsdcstrgb888( I_FB0_1K_1K_8, I_FB1_1K_1K_8, I_FB2_1K_1K_8);
	krhwslcsurf(I_FB_SURF0);
	krhwdolfclr(0L);
	krhwslcsurf(I_OVL_SURF);
	krgcen();
   ShowCursor(TRUE);
	pchlprocess();
	pcstcond(0, I_FOR, 1);

	// set up the FBs properly. Keep overlay masks untoutched!
	lsdcstrdmask(-1, -1, -1, dcmasks[3], dcmasks[4], dcmasks[5]);

   if (!InitInstance(hInstance, nCmdShow))
      return (FALSE);

   while (GetMessage(&msg, NULL, NULL, NULL))
	   {
		TranslateMessage(&msg);
		DispatchMessage(&msg);
    	}

   return (msg.wParam);
	} // WiMain


BOOL InitApplication(hInstance)
HANDLE hInstance;
	{
   WNDCLASS  wc;

   wc.style          = NULL;
   wc.lpfnWndProc    = MainWndProc;
   wc.cbClsExtra     = 0;
   wc.cbWndExtra     = 0;
   wc.hInstance      = hInstance;
   wc.hIcon          = LoadIcon(hInstance, "grabIcon");
   wc.hCursor        = LoadCursor(NULL, IDC_ARROW);

   // Check if transparent color is black or dark green
   //  im1280 win driver sets masks on r,g and b for overlay to 0x1d
   //  when it is a driver used with WinSel strap
   if (dcmasks[3]==0x1d) /* Is green transparent? */
      wc.hbrBackground  = CreateSolidBrush(RGB(0,128,0));
   else
      wc.hbrBackground  = GetStockObject(BLACK_BRUSH);
   

   wc.lpszMenuName   = "IconMenu";
   wc.lpszClassName  = "VideowinWClass";

   return (RegisterClass(&wc));
	}


BOOL InitInstance(hInstance, nCmdShow)
HANDLE hInstance;
int nCmdShow;
	{
   hInst = hInstance;

   hGrabWnd = CreateWindow(   "VideowinWClass",
                              "Image-1280 Windows 3.0 Colour Grab",
                              WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU,
                              0,
                              0,
                              512 + 2 * GetSystemMetrics(SM_CXBORDER),
                              480 + GetSystemMetrics(SM_CYCAPTION)
                                  + GetSystemMetrics(SM_CYMENU)
                                  + 2 * GetSystemMetrics(SM_CYBORDER),
                              NULL,
                              NULL,
                              hInstance,
                              NULL
   	                    );
   
   if (!hGrabWnd)
      return (FALSE);

	// set ROI size and pos of hidden FB image
	pcstroisiz(512, 480);
	pcstroipos(I_ROI0, 0, 0);
	pcstroipos(VideoWndROI, 0, 0);

   ShowWindow(hGrabWnd, nCmdShow);
   UpdateWindow(hGrabWnd);

   return (TRUE);
	} // InitInstance


long FAR PASCAL MainWndProc(hWnd, message, wParam, lParam)
HWND hWnd;
UINT message;
WPARAM wParam;
LPARAM lParam;
	{
   FARPROC lpProcAbout;
	HDC hDC;
	PAINTSTRUCT ps;
	POINT cur_point;

	cur_point.x = 0;
	cur_point.y = 39;

   switch (message)
		{
		case WM_COMMAND:
		    if (wParam == IDM_ABOUT)
				{
				lpProcAbout = MakeProcInstance(About, hInst);

				DialogBox(  hInst,
				            "AboutBox",
				            hWnd,
				            lpProcAbout);

				FreeProcInstance(lpProcAbout);
				break;
		    	}
		    else
				return (DefWindowProc(hWnd, message, wParam, lParam));

		case WM_CREATE:
			pchlprocess();

			// set ROI for destination
			// 1st time through, set upper-left corner to be in client-area
			pcstroipos(VideoWndROI,
						  GetSystemMetrics(SM_CXBORDER),
						  GetSystemMetrics(SM_CYCAPTION) +
						  GetSystemMetrics(SM_CYMENU));

         dislboard( I_CLD, 0L);         
			pcstcond(0, I_FOREVER, 2);
			pcsllogcam(I_CLDNTSC);
         dislchannel( 0L);
			pcslsync( I_PROC_CAMERA);

			// do the grab
			didograb(I_DIG_24, I_FB0123 | VideoWndROI);

			break;

		case WM_DESTROY:
			// halt the grab
			pchlprocess();
			pcslsync(I_PROC_ALONE);		// remove sync from camera
			pcstcond(0, 1, 1);

			lsdcstrdmask(0, 0, 0, dcmasks[3], dcmasks[4], dcmasks[5]);
			ShowCursor(FALSE);
			krgcdi();
			krhwslcsurf(I_FB_SURF0);
			krhwdolfclr(0L);
			krhwslcsurf(I_OVL_SURF);
			krgcen();
			ShowCursor(TRUE);

         PostQuitMessage(0);
		   break;

		case WM_MOVE:
			if (FirstTime)
				{
				FirstTime = FALSE;
				}
			else
				{
				// get current (x, y) of client's top left corner
				cur_point = MAKEPOINT(lParam);

				// send code to 1280 to update FB contents beneath client area
				// set ROI for destination
				pcstroipos(VideoWndROI,((cur_point.x + 2) & 0xfffc), cur_point.y);
				// restart the grab
				didograb(I_DIG_24, I_FB0123 | VideoWndROI);
				}
			break;

		case WM_PAINT:
			// invalidate the entire client area, which also erases background
			InvalidateRect(hWnd, NULL, TRUE);
			BeginPaint(hWnd, &ps);
			EndPaint(hWnd, &ps);
			break;

		default:
		    return (DefWindowProc(hWnd, message, wParam, lParam));
    	}

   return (NULL);
	} // MainWndProc


BOOL FAR PASCAL About(hDlg, message, wParam, lParam)
HWND hDlg;
UINT message;
WPARAM wParam;
LPARAM lParam;
	{
    switch (message)
		{
		case WM_INITDIALOG:
		    return (TRUE);

		case WM_COMMAND:
		    if (wParam == IDOK || wParam == IDCANCEL)
				{
				EndDialog(hDlg, TRUE);
				return (TRUE);
		    	}
		    break;
    	}

   return (FALSE);
	} // About

