/*
    filename :  ioputtxt.c

COPYRIGHT (c) 1989, 1990, 1991  Matrox Electronic Systems Ltd.
All Rights Reserved

*/

#ifdef ANSI
#include <stdlib.h>
#endif

#include <stdio.h>
#include "imseries.h"
#include "imbind.h"
#include "proto.h"

/*/     Function:   ioputtxt()
*       Synopsis:   This routine writes a buffer of char to the FIFO.
*       Date:       January 23rd 1990
*       param:      --- none ---
*                                               
*       returns:    word
**/

#ifdef ANSI
void FTYPE ioputtxt(char _I_PTYPE *buffer, unsigned short nchar)
#else
FTYPE ioputtxt( buffer, nchar )
char _I_PTYPE *buffer;
unsigned short nchar;
#endif
{
    short   _I_PTYPE *ptr;
    unsigned short  i;

    if (( ptr = (short _I_PTYPE *)calloc(nchar, sizeof(short))) == NULL ) {
#ifndef  I_NOPRINTF
# ifdef I_INTEL		/* fprintf buggy under INTEL Vr4 */
        printf( "ioputtxt: Out of memory for malloc.\n");
# else
        fprintf( stderr, "ioputtxt: Out of memory for malloc.\n");
# endif /* I_INTEL    */
#else	  /* !I_NOPRINTF */
		  ;
#endif  /* I_NOPRINTF */
        exit(1);
        }

    for (i = 0; i < nchar; i++)
        ptr[i] = buffer[i];

    ioputbuf(ptr,nchar);

    free(ptr);

}  /* ioputtxt() */
