/*/  Function name:   sctxstring
*
*    Note:  Values returned in the read fifo depend on the selected string
*           drawing mode.
*
*    Author:   Jean Dupre
*    Date:     March 17, 1988
*
*    Modification history:  
*
*    Calls:  ioputmbuf:  send multiple buffers of words to the board.
*
*    Uses:  None
*
*    Return value:   None
*/

#include "imseries.h"
#include "imbind.h"
#include "proto.h"

IMPORT  short  buff[];
IMPORT  short  *ptrbuff;
IMPORT  unsigned short _I_PTYPE *i_buffers[];
IMPORT  unsigned short i_ns[];

#define BUFFER_SIZE 4    /* parameters buffer size in words */

#ifdef ANSI
void FTYPE sctxstring(short x, short y, short _I_PTYPE *strptr)
#else
FTYPE sctxstring(x, y, strptr)
short  x, y;
short  _I_PTYPE *strptr;
#endif

	{
	unsigned short _I_PTYPE * _I_PTYPE *buffers, _I_PTYPE *ns;
	unsigned short  length = 0;
    short  _I_PTYPE *ptrtxt;

    ptrtxt = strptr;

    while (*ptrtxt++)
        length++;

    /* set buffer for parameters */
    ptrbuff = buff;

	*ptrbuff++ = 0x0072;
    *ptrbuff++ = x;
    *ptrbuff++ = y;
    *ptrbuff = length;

    /* set buffer for buffers */
    buffers = i_buffers;
    /* first send  parameters */
    *buffers++ = (unsigned short _I_PTYPE *)buff;
    /* then the structure values */
    *buffers = (unsigned short _I_PTYPE *)strptr;

    /* set buffer for buffer sizes */
    ns = i_ns;
    /* parameter buffer size ( in words ) */
    *ns++ = (unsigned short) BUFFER_SIZE;
    /* structure size ( in words ) */
    *ns = length;

    /* send buffers */
    ioputmbuf(i_buffers, i_ns, 2);

    }


