/*
    filename :  close.c

COPYRIGHT (c) 1989, 1990, 1991  Matrox Electronic Systems Ltd.
All Rights Reserved

*/

/* all conditionnal compilations switches in imseries.h */

#include <stdio.h>
#include "imseries.h"
#include "imbind.h"
#include "proto.h"

extern  I_IMGLOB    i_glob;

#ifdef WIN_NT
int unmapmem( void **ptr,unsigned long device);
#endif



/*/     Function:   iocldevice()
*       Synopsis:   Close IM-1280 driver.
*
*       Date:       February 12, 1990
*
*       Parameter:  int     handle;         identification of the device to
*                                           close
*
*       Return value:   0 on succes, -1 on error.
**/

#ifdef  ANSI
short   FTYPE iocldevice(int handle)
#else
short   FTYPE iocldevice(handle)
int     handle;
#endif
{
#ifdef  I_UNIX

#ifdef  I_PHYSMAP

    short device;

    /* find device index */
    for (device = 0; device < I_N_OF_DEVICES; device++)
        {
        if ( i_glob.fd[device] == handle)
            break;
        }

    if ( device == I_N_OF_DEVICES )
        return( -1 );

#ifndef I_SCO
    /* free allocated memory */
    free ( i_glob.mem[device] );
#endif 	/* I_SCO */

#endif

    /* disable communication if closing current selected board */
    if (i_glob.board == handle) i_glob.board = -1;

    /* close and return */
    return ( close ( handle ));

#endif

#ifdef  I_MS_DOS
    short device = handle;

    if ( i_glob.img_addr[device] )  /* Check if new device was opened. */
        {

        /* if device is currently selected */
        if (i_glob.img_dev == device)
            {
            /* restore host control register */
            IOselect(device) = (char) i_glob.keep_hctrl[device];

            /* disable communication */
            i_glob.img_dev = -1;
            i_glob.imgmap = (IMGMAP *)NULL;
            }

/* dpet 94/05/08 close communication with the board under Windows NT */
#ifdef WIN_NT
        /*   unmap the memory mapped before to access the 1280 under
        *    Windows NT (We mapped the physical address space of the
        *    1280 into a user-mode process's address space) and we release
        *    the associated handler.
        */
        if (-1 == unmapmem( (i_glob.img_addr + ( unsigned short ) device) , device) )
           return( -1 );
#endif


        /* undefine */
        i_glob.img_addr[device] = (IMGMAP *)NULL;
        i_glob.img_fd[device]   = 0;

        }
    else
        return( -1 );

    return( 0 );

#endif


#ifdef I_OS2

   USHORT retval;

   /* disable communication if closing current selected board */
   if (i_glob.board == handle) i_glob.board = -1;

   retval = DosClose( handle );
   if ( retval != 0 ) {
#ifndef  I_NOPRINTF
# ifdef I_INTEL		/* fprintf buggy under INTEL Vr4 */
      printf( "\nIM-Series: error closing device.\n" );
# else
      fprintf( stderr, "\nIM-Series: error closing device.\n" );
# endif /* I_INTEL      */
#else	  /* ! I_NOPRINTF */
		;
#endif  /* I_NOPRINTF   */
      return(-1);
   }
   else
      return(0);

#endif

}
