		PAGE	80,132
		NAME	SEMS4
;************************************************************************
;*									*
;*									*
;*	EMM/EMS driver program for SUNTAC-62 chip set version B1	*
;*									*
;*			ONLY EVALUATION					*
;*			SAMPLE PROGRAM					*
;*									*
;*				Version 4.0/Release 1.0  11/14/1988	*
;*									*
;************************************************************************

;
;	physical pages struct
;
phys_page_struct		STRUC
    emm_handle2			DW	?	;EMM handle
    phys_page_port		DW	?	;physical page i/o port address
    phys_seg_addr		DW	?	;physical page segment address
    log_page_data		DB	?	;logical page no. data
phys_page_struct		ENDS

handle_page_struct		STRUC
    emm_handle3			DW	?
    page_alloc_to_handle	DW	?
handle_page_struct		ENDS

partial_page_map_struct		STRUC
    mappable_segment_count	DW	?
    mappable_segment		DW	4 DUP (?)
partial_page_map_struct		ENDS

log_to_phys_map_struct		STRUC
    log_page_number1		DW	?
    phys_page_number1		DW	?
log_to_phys_map_struct		ENDS

log_to_seg_map_struct		STRUC
    log_page_number2		DW	?
    mappable_seg_addr		DW	?
log_to_seg_map_struct		ENDS

handle_dir_struct		STRUC
    handle_value		DW	?
    handle_name1		DB	8 DUP (?)
handle_dir_struct		ENDS

map_and_jump_struct		STRUC
    target_address1		DD	?
    log_phys_map_len		DB	?
    log_phys_map_ptr		DD	?
map_and_jump_struct		ENDS

map_and_call_struct		STRUC
    target_address2		DD	?
    new_page_map_len		DB	?
    new_page_map_ptr		DD	?
    old_page_map_len		DB	?
    old_page_map_ptr		DD	?
    reserved			DW	4 DUP (?)
map_and_call_struct		ENDS

move_source_dest_struct		STRUC
    region_length1		DD	?
    source_memory_type1		DB	?
    source_handle1		DW	?
    source_initial_offset1	DW	?
    source_initial_seg_page1	DW	?
    dest_memory_type1		DB	?
    dest_handle1		DW	?
    dest_initial_offset1	DW	?
    dest_initial_seg_page1	DW	?
move_source_dest_struct		ENDS

xchg_source_dest_struct		STRUC
    region_length2		DD	?
    source_memory_type2		DB	?
    source_handle2		DW	?
    source_initial_offset2	DW	?
    source_initial_seg_page2	DW	?
    dest_memory_type2		DB	?
    dest_handle2		DW	?
    dest_initial_offset2	DW	?
    dest_initial_seg_page2	DW	?
xchg_source_dest_struct		ENDS

mappable_phys_page_struct	STRUC
    phys_page_segment		DW	?
    phys_page_number2		DW	?
mappable_phys_page_struct	ENDS

hardware_info_struct		STRUC
    raw_page_size		DW	?
    alternate_register_sets	DW	?
    context_save_area_size	DW	?
    DMA_register_sets		DW	?
    DMA_channel_operation	DW	?
hardware_info_struct		ENDS

HANDLE_CNT		EQU	255	;max handle count
PAGE_MAX		EQU	216	;max logical page count
BACK_MAX		EQU	40	;max mapping data backup count
EMSIOA			EQU	0E8H	;EMS i/o port address A
EMSIOB			EQU	98H	;EMS i/o port address B
CHKIOA			EQU	9DH	;EMS i/o port A check data
CHKIOB			EQU	93H	;EMS i/o port B check data
I8042			EQU	60H	;i8042 i/o port address
TIME_OUT		EQU	1000	;
STATSEG			EQU	0C000H	;defult start page frame address
ROMSEG			EQU	0E000H	;option ROM area segment address
ENDSEG			EQU	0F000H	;BIOS ROM area segment address
NOT_USE			EQU	0AA55H	;not used logical page code
NON			EQU	0FFFFH	;non or bad logical page code
CR			EQU	0DH	;Carriage Return code
LF			EQU	0AH	;Line Feed code
TAB			EQU	09H	;TAB code
MEMSIZE			EQU	413H	;system memory size data area address
DIS_EMS			EQU	0	;physical page disable data
EMSVER			EQU	40H	;EMS version 4.0
HANDLE_NAME_SIZE	EQU	8	;EMM handle name byte size
UNMAP			EQU	0FFFFH	;unmap code
UNALLOC			EQU	0FFFFH	;unallocate code
PUSH_REG		EQU	8 * 2	;push register size
EMMWORK			EQU	50	;EMM driver work area size
RET_SP			EQU	EMMWORK+PUSH_REG+6+10	;int67 stack size
PHYS_PAGES		EQU	4	;physical page count
RAW_PAGES		EQU	400H	;raw page size (16KB)
CONTEXT_SIZE		EQU	SIZE phys_page_struct * PHYS_PAGES
ALTER_REGS		EQU	0	;alter map register set count
DMA_REGS		EQU	0	;alter DMA register set count
DMA_CHANNEL		EQU	0	;DMA channel number
VOLATILE		EQU	0	;volatile
NON_VOLATILE		EQU	1	;non volatile
F23_RETSP		EQU	10	;
LOG_SIZE		EQU	2	;logical page flag data size
FLAG_SIZE		EQU	2	;handle flag size

;
;	function 15 struct
;
f15_struct			STRUC
				DW	8 DUP (?)
    f15_map_data		DB	CONTEXT_SIZE DUP (?)
f15_struct			ENDS

;
;	function 16 struct
;
f16_struct			STRUC
				DW	8 DUP (?)
    f16_map_len			DW	?
    f16_map_data		DB	CONTEXT_SIZE DUP (?)
f16_struct			ENDS

;
;	function 17 struct
;
f17_struct			STRUC
				DW	8 DUP (?)
    f17_ax_save			DW	?
    f17_map_len			DW	?
    f17_map_data		DB	PHYS_PAGES * 4 DUP (?)
f17_struct			ENDS

;
;	function 22 struct
;
f22_struct			STRUC
				DW	8 DUP (?)
    f22_ax_save			DW	?
    f22_target_off		DW	?
    f22_target_seg		DW	?
    f22_map_len			DW	?
    f22_map_data		DB	PHYS_PAGES * 4 DUP (?)
f22_struct			ENDS

;
;	function 23 struct
;
f23_struct			STRUC
				DW	8 DUP (?)
    f23_target_off		DW	?
    f23_target_seg		DW	?
    f23_flag			DW	?
    f23_retoff			DW	?
    f23_retseg			DW	?
    f23_ax_save			DW	?
    f23_new_map_len		DW	?
    f23_new_map_data		DB	PHYS_PAGES * 4 DUP (?)
    f23_old_map_len		DW	?
    f23_old_map_data		DB	PHYS_PAGES * 4 DUP (?)
f23_struct			ENDS

;
;	function 24 struct
;
f24_struct			STRUC
				DW	8 DUP (?)
    source_off			DW	?
    source_seg			DW	?
    dest_off			DW	?
    dest_seg			DW	?
    source_pno			DW	?
    dest_pno			DW	?
    region_low			DW	?
    region_high			DW	?
    source_handle		DW	?
    dest_handle			DW	?
    source_type			DW	?
    dest_type			DW	?
    f24_ax_save			DW	?
    overlap_flag		DW	?
    get_source_f		DW	?
    get_dest_f			DW	?
f24_struct			ENDS

;
;	function 28 struct
;
f28_struct			STRUC
				DW	8 DUP (?)
    f28_map_data		DB	CONTEXT_SIZE DUP (?)
f28_struct			ENDS

;
;	register back area struct
;
retreg		STRUC
    bx_save	DW	?			;BX save area
    cx_save	DW	?			;CX save area
    dx_save	DW	?			;DX save area
    si_save	DW	?			;SI save area
    di_save	DW	?			;DI save area
    bp_save	DW	?			;BP save area
    es_save	DW	?			;ES save area
    ds_save	DW	?			;DS save area
retreg		ENDS

;
;	return address struct
;
ret_struct	STRUC
		DW	8 DUP (?)
		DB	EMMWORK DUP (?)
    ret_offset	DW	?			;return offset address
    ret_segment	DW	?			;return segment address
    ret_flag	DW	?			;return flags
ret_struct	ENDS

;-- EMS REGISTERS -----------------------------------------------------------:
;									     :
; EMS_R0 : 76543210 (Read/Write)					     :
;          |+-----+--- EMS i/o port address A9 - A3 (defult 13H or 1DH)	     :
;          |                                        * 13H(98H),1DH(E8H)      :
;          +-(Write)-- [98H/E8H] port read flag (0:not read, 1:read)	     :
;          +-(Read)--- Register data transmit flag (0:end, 1:not end)	     :
;									     :
; EMS_R1 : 76543210 (Reserved)						     :
;									     :
; EMS_R2 : 76543210 (Write only)					     :
;          |    |++--- EMS flag (00:EMS enable , 11:EMS disable)	     :
;          +----+----- System memory size A19 - A14 (A0H = 640KB)	     : 
;									     :
; EMS_R3 : 76543210 (Write only)					     :
;          |    |++--- Bank size (00:16KB)				     :
;          +----+----- EMS page frame segment address A19 - A14 (C0H = C000H):
;									     :
; EMS_R4 : 76543210 (Write only)					     :
;          +------+--- Bank 0 page number data (1 - 255)		     :
;		       * Data 0 = bank 0 disable			     :
;									     :
; EMS_R5 : 76543210 (Write only)					     :
;          +------+--- Bank 1 page number data (1 - 255)		     :
;		       * Data 0 = bank 1 disable			     :
;									     :
; EMS_R6 : 76543210 (Write only)					     :
;          +------+--- Bank 2 page number data (1 - 255)		     :
;		       * Data 0 = bank 2 disable			     :
;									     :
; EMS_R7 : 76543210 (Write only)					     :
;          +------+--- Bank 3 page number data (1 - 255)		     :
;		       * Data 0 = bank 3 disable			     :
;									     :
;----------------------------------------------------------------------------:


code		SEGMENT
		ASSUME	CS:code

		ORG	0000H

		; DEVICE header block
emmdrv		DW	-1,-1		;Link to next device
		DW	8000H		;
		DW	OFFSET emmstat	;
		DW	OFFSET emmint	;
		DB	'EMMXXXX0'	;

ptrsav		LABEL	DWORD
parofs		DW	0		;
parseg		DW	0		;

page_frame_seg	DW	0C000H		;physical page frame address
total_pages	DW	PAGE_MAX	;total logical page count
un_alloc_pages	DW	PAGE_MAX	;unallocate logical page count
handle_count	DW	0		;EMM handle used count
jump_addr	DW	0		;EMM function jump address data area
emm_flag	DB	0		;EMM driver install status

;
;	Define offsets for io data packet
;
iodat		STRUC	
	cmdlen	DB	?	;LENGTH OF THIS COMMAND
	unit	DB	?	;SUB UNIT SPECIFIER
	cmd	DB	?	;COMMAND CODE
	status	DW	?	;STATUS
		DB	8 DUP (?)
	media	DB	?	;MEDIA DESCRIPTOR
	trans	DD	?	;TRANSFER ADDRESS
	count	DW	?	;COUNT OF BLOCKS OR CHARACTERS
	start	DW	?	;FIRST BLOCK TO TRANSFER
iodat		ENDS

;
;	Define offsets for io data packet 2
;
iodat2		STRUC
		DB	13 DUP (?)
		DB	?
	brkoff	DW	?	;BREAK ADDRESS (OFFSET)
	brkseg	DW	?	;BREAK ADDRESS (SEGMENT)
iodat2		ENDS

;
; Simplistic Strategy routine for non-multi-Tasking system.
;
;	Currently just saves I/O packet pointers in PTRSAV for
;	later processing by the individual interrupt routines.
;
emmstat		PROC	FAR
		MOV	CS:parofs,BX	;
		MOV	CS:parseg,ES	;
		RET			;
emmstat		ENDP

;
; Common program for handling the simplistic I/O packet
;	processing scheme in MSDOS
;
emmint		PROC	FAR
		PUSH	AX		;Save all nessacary registers.
		PUSH	BX		;
		PUSH	DI		;
		PUSH	DS		;
		LDS	BX,CS:ptrsav	;Retrieve pointer to I/O Packet.
		MOV	AL,[BX].cmd	;Retrieve Command type. (1 => 11)
		CMP	AL,11		;Verify that not more than 11 commands.
		JA	cmderr		;Ah, well, error out.
		CMP	AL,3		;
		JA	exit		;
		CMP	AL,0		;init. command?
		JNZ	emmchk		;check EMS flag.
		JMP	emminit		;EMS Driver initial.
cmderr:					;
		MOV	AL,3		;Set unknown command error #.
err_exit:				;
		MOV	AH,10000001B	;Set error and done bits.
		STC			;Set carry bit also.
		JMP	exit1		;Quick way out.
;
;	EMM driver install check routine
;
emmchk:					;
		CMP	CS:emm_flag,1	;EMM install flag on?
		JNZ	err_exit	;no
exit:					;
		MOV	AH,00000001B	;Set done bit for MSDOS.
exit1:					;
		LDS	BX,CS:ptrsav	;Retrieve pointer to I/O Packet.
		MOV	[BX].status,AX	;Save operation compete and status.
		POP	DS		;Restore registers.
		POP	DI		;
		POP	BX		;
		POP	AX		;
		RET			;
emmint		ENDP

;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

;--------------------------------------------------------------------
;	int 67H EMM driver main routine
;--------------------------------------------------------------------
int67		PROC	FAR
		CLI				;
		SUB	SP,EMMWORK		;
		PUSH	DS			;Save registers...
		PUSH	ES			;
		PUSH	BP			;
		PUSH	DI			;
		PUSH	SI			;
		PUSH	DX			;
		PUSH	CX			;
		PUSH	BX			;
		MOV	BP,SP			;
		CLD				;
		PUSH	CS			;
		POP	DS			;

		ASSUME	DS:code

		CMP	AH,40H			;--- function code check ---
		JB	err84			; FUNCTION 1 - 30 ?
		CMP	AH,5EH			;
		JNB	err84			;---------------------------
		PUSH	BX			;
		MOV	jump_addr,AX		;
		XCHG	AH,AL			;
		XOR	AH,AH			;
		SUB	AX,40H			;
		SHL	AX,1			;
		MOV	BX,OFFSET func_table	;
		ADD	BX,AX			;
		MOV	AX,[BX]			;
		XCHG	AX,jump_addr		;
		POP	BX			;
		JMP	jump_addr		;---- jump to functions -----
noerr:						;normal return point.
		XOR	AH,AH			;
err_ret:					;error return point.
		POP	BX			;Restore registers...
		POP	CX			;
		POP	DX			;
		POP	SI			;
		POP	DI			;
		POP	BP			;
		POP	ES			;
		POP	DS			;
		ADD	SP,EMMWORK		;
		IRET				;
int67		ENDP

;--------------------------------------------------------------------
;	EMM driver function jump table
;		(40H - 5DH)
;--------------------------------------------------------------------
func_table	LABEL	WORD
		DW	OFFSET func1		;function 1
		DW	OFFSET func2		;function 2
		DW	OFFSET func3		;function 3
		DW	OFFSET func4		;function 4
		DW	OFFSET func5		;function 5
		DW	OFFSET func6		;function 6
		DW	OFFSET func7		;function 7
		DW	OFFSET func8		;function 8
		DW	OFFSET func9		;function 9
		DW	OFFSET func10		;function 10
		DW	OFFSET func11		;function 11
		DW	OFFSET func12		;function 12
		DW	OFFSET func13		;function 13
		DW	OFFSET func14		;function 14
		DW	OFFSET func15		;function 15
		DW	OFFSET func16		;function 16
		DW	OFFSET func17		;function 17
		DW	OFFSET func18		;function 18
		DW	OFFSET func19		;function 19
		DW	OFFSET func20		;function 20
		DW	OFFSET func21		;function 21
		DW	OFFSET func22		;function 22
		DW	OFFSET func23		;function 23
		DW	OFFSET func24		;function 24
		DW	OFFSET func25		;function 25
		DW	OFFSET func26		;function 26
		DW	OFFSET func27		;function 27
		DW	OFFSET func28		;function 28
		DW	OFFSET func29		;function 29
		DW	OFFSET func30		;function 30

;--------------------------------------------------------------------
;	error status set routine
;--------------------------------------------------------------------

;The manager detected a malfunction in the EMM software.
err80:
		MOV	AH,80H
		JMP	err_ret

;The manager detected a malfunction in the expanded memory hardware.
err81:
		MOV	AH,81H
		JMP	err_ret

;The EMM couldn't find the EMM handle your program specified.
err83:
		MOV	AH,83H
		JMP	err_ret

;The function code passed to the EMM is not defined.
err84:
		MOV	AH,84H
		JMP	err_ret

;All EMM handles are being used.
err85:
		MOV	AH,85H
		JMP	err_ret

;The EMM detected a "save" or "restore" page mapping context error.
err86:
		MOV	AH,86H
		JMP	err_ret

;There aren't enough expanded memory pages to satisfy your program's request.
err87:
		MOV	AH,87H
		JMP	err_ret

;There aren't enough unallocated pages to satisfy your program's request.
err88:
		MOV	AH,88H
		JMP	err_ret

;Can't allocate zero (0) pages.
err89:
		MOV	AH,89H
		JMP	err_ret

;The logical page is out of the range of logical pages which are allocated to
;the EMM handle.
err8a:
		MOV	AH,8AH
		JMP	err_ret

;The physical page to which the logical page is mapped is out of the range of
;physical pages.
err8b:
		MOV	AH,8BH
		JMP	err_ret

;The page mapping hardware state save area is full.
err8c:
		MOV	AH,8CH
		JMP	err_ret

;The page mapping hardware state save area already has a state associated with
;the EMM handle.
err8d:
		MOV	AH,8DH
		JMP	err_ret

;The page mapping hardware state save area doesn't have a state associated with
;the EMM handle.
err8e:
		MOV	AH,8EH
		JMP	err_ret

;The subfunction parameter passed to the function isn't defined.
err8f:
		MOV	AH,8FH
		JMP	err_ret

;The attrbute type is undefined.
err90:
		MOV	AH,90H
		JMP	err_ret

;The system configuration does not support non_volatility.
err91:
		MOV	AH,91H
		JMP	err_ret

;The source and destination expanded memory region have the same handle and
;overlap. (move)
err92:
		MOV	AH,92H
		JMP	err_ret

;The length of the specified source or destination expanded memory region
;exceeds the length of the expanded memory region allocated to the specified
;source or destination handle.
err93:
		MOV	AH,93H
		JMP	err_ret

;The conventional memory region and expanded memory region overlap.
err94:
		MOV	AH,94H
		JMP	err_ret

;The offset within the logical page exceeds the length of the logical page.
err95:
		MOV	AH,95H
		JMP	err_ret

;Region length exceeds 1M_byte limit.
err96:
		MOV	AH,96H
		JMP	err_ret

;The source and destination expanded memory region have the same handle and
;overlap. (exchanged)
err97:
		MOV	AH,97H
		JMP	err_ret

;The memory source and destination type are undefined/not supported.
err98:
		MOV	AH,98H
		JMP	err_ret

;Alternate map register serts are supported, but the alternate map register set
;specified is not support.
err9a:
		MOV	AH,9AH
		JMP	err_ret

;Alternate map/DMA register sets are supported. However, all alternate map/DMA
;register sets are currently allocated.
err9b:
		MOV	AH,9BH
		JMP	err_ret

;Alternate map/DMA register sets are not supported, and the alternate map/DMA
;register set specified is not zero.
err9c:
		MOV	AH,9CH
		JMP	err_ret

;Alternate map register serts are supported, but the alternate map register set
;specified is not defined, not allocated, or is the currently allocated map
;register set.
err9d:
		MOV	AH,9DH
		JMP	err_ret

;Dedicated DMA channels are not supported.
err9e:
		MOV	AH,9EH
		JMP	err_ret

;Dedicated DMA channels are not supported. But the DMA channel specified is not
;supported.
err9f:
		MOV	AH,9FH
		JMP	err_ret

;No corresponding handle value could be found for the handle name specified.
erra0:
		MOV	AH,0A0H
		JMP	err_ret

;A handle with this name already exists.
erra1:
		MOV	AH,0A1H
		JMP	err_ret

;An attempt was made to "wrap around" the 1M_byte address space during the
;move/exchange.
erra2:
		MOV	AH,0A2H
		JMP	err_ret

;The contents of the data structure passed to the function have either been
;corrupted or are meaningless.
erra3:
		MOV	AH,0A3H
		JMP	err_ret

;The operating system has denied access to the this function.
erra4:
		MOV	AH,0A4H
		JMP	err_ret

;------ function 1 --------------------------------------------------
; Get status
; output
;	AH	: status
;--------------------------------------------------------------------
func1:
		STI				;
		CMP	emm_flag,1		;EMM install flag on?
		JNZ	f11			;no
		JMP	noerr			;exit
f11:						;
		JMP	err80			;error exit

;------ function 2 --------------------------------------------------
; Get page frame address
; output
;	AH	: status
;	BX	: page segment address
;--------------------------------------------------------------------
func2:
		STI				;
		MOV	BX,page_frame_seg	;get EMM physical page segment
f21:						; address.
		MOV	[BP].bx_save,BX		;
		JMP	noerr			;exit

;------ function 3 --------------------------------------------------
; Get unallocated page count
; output
;	AH	: status
;	BX	: unallocate page
;	DX	: all page
;--------------------------------------------------------------------
func3:						;v0.5....
		MOV	DX,total_pages		;Get total page count
		MOV	BX,un_alloc_pages	;Get unallocated page count
		MOV	[BP].dx_save,DX		;Save all page count
		JMP	f21			;

;------ function 4 --------------------------------------------------
; Allocate pages
; input
;	BX	: request allocate page
; output
;	AH	: status
;	DX	: EMM handle
;--------------------------------------------------------------------
func4:						;v0.6....
		OR	BX,BX			;request page size 0 ?
		JZ	f49			;yes
f41:						;
		CMP	total_pages,BX		;request total size over ?
		JB	f42			;yes
		CMP	un_alloc_pages,BX	;request unallocate size over ?
		JB	f43			;yes
		XOR	DX,DX			;
		XOR	SI,SI			;
		MOV	CX,HANDLE_CNT		;
f45:						;
		CMP	[SI].handle_flag,0	;not used EMM handle ?
		JZ	f44			;
		INC	DX			;
		ADD	SI,FLAG_SIZE		;add handle flag size
		LOOP	f45			;
		JMP	err85			;error exit
f44:						;
		MOV	[SI].handle_flag,1	;handle active flag set
		INC	handle_count		;used EMM handle count up
		SUB	un_alloc_pages,BX	;unallocated page - BX
		MOV	[SI].alloc_page_count,BX;EMM handle used page count set
		MOV	[SI].back_address,0	;backup address clear
		MOV	DI,page_ptr		;
		MOV	[SI].page_address,DI	;set page buffer pointer
		PUSH	CS			;
		POP	ES			;
		MOV	SI,OFFSET log_page	;
		XOR	AX,AX			;
		MOV	CX,BX			;
		JCXZ	f48			;CX = 0?
f47:						;
		CMP	WORD PTR [SI],NOT_USE	;unallocated page ?
		JZ	f46			;
f4a:						;
		ADD	SI,LOG_SIZE		;
		INC	AX			;
		JMP	f47			;
f46:						;
		MOV	[SI],DX			;EMM handle set
		STOSW				;logical page no. set
		LOOP	f4a			;
f48:						;
		MOV	[BP].dx_save,DX		;return EMM handle
		MOV	[BP].bx_save,BX		;allocated pages count set
		MOV	page_ptr,DI		;
		JMP	noerr			;exit
f49:						;
		JMP	err89			;error exit
f42:						;
		JMP	err87			;error exit
f43:						;
		JMP	err88			;error exit

;------ function 5 --------------------------------------------------
; Map handle pages
; input
;	AL	: physical page no.
;	BX	: logical page no. (if BX=FFFFH then unmap)
;	DX	: EMM handle
; output
;	AH	: status
;--------------------------------------------------------------------
func5:						;v0.6....
		CMP	AL,PHYS_PAGES		;physical page no. ok ?
		JNB	f51			;no
		MOV	DI,OFFSET map_table	;get phys_page_struct pointer..
		XCHG	AL,CL			;
		MOV	AX,SIZE phys_page_struct;
		MUL	CL			;
		ADD	DI,AX			;
		CMP	DX,HANDLE_CNT		;check handle data...
		JNB	f5a			;
		MOV	SI,DX			;
		SHL	SI,1			;
		CMP	[SI].handle_flag,0	;active handle ?
		JZ	f5a			;
		CMP	BX,UNMAP		;unmap ?
		JZ	f57			;
		CMP	BX,[SI].alloc_page_count;logical page no. OK ?
		JNB	f53			;
		SHL	BX,1			;
		ADD	BX,[SI].page_address	;
		MOV	AX,[BX]			;
		ADD	AL,pageofs		;
		CMP	DX,[DI]			;same handle ?
		JNZ	f54			;
		CMP	AL,[DI].log_page_data	;same page no. ?
		JZ	f56			;
f54:						;
		PUSH	DX			;
		MOV	DX,[DI].phys_page_port	;
		CALL	emsout			;
		POP	DX			;
		JB	f59			;error?
f58:						;
		MOV	[DI],DX			;set handle
		MOV	[DI].log_page_data,AL	;set logical page no. data
f56:						;
		JMP	noerr			;exit
f57:						;
		XOR	AL,AL			;
		CMP	WORD PTR [DI],UNMAP	;
		JNZ	f55			;
		CMP	AL,[DI].log_page_data	;
		JZ	f56			;
f55:						;
		MOV	DX,[DI].phys_page_port	;unmapping...
		CALL	emsout			;
		JB	f59			;error?
		MOV	DX,UNMAP		;
		JMP	f58			;
f51:						;
		JMP	err8b			;error exit
f53:						;
		JMP	err8a			;error exit
f59:						;
		JMP	err81			;error exit
f5a:						;
		JMP	err83			;error exit 

;------ function 6 --------------------------------------------------
; Deallocate pages
; input
;	DX	: EMM handle
; output
;	AH	: status
;--------------------------------------------------------------------
f61:						;v0.6....
		JMP	err83			;error exit 
f63:						;
		JMP	err86			;error exit 
func6:						;
		PUSH	CS			;
		POP	ES			;
		CMP	DX,HANDLE_CNT		;check handle data...
		JNB	f61			;
		MOV	BX,DX			;
		SHL	BX,1			;
		CMP	[BX].handle_flag,0	;handle OK ?
		JZ	f61			;
		CMP	[BX].back_address,0	;backup used?
		JNZ	f63			;
		MOV	CX,[BX].alloc_page_count;
		JCXZ	f6c			;page = 0 ?
		MOV	DI,[BX].page_address	;deallocate logical page...
		PUSH	BX			;
f65:						;
		MOV	BX,[DI]			;
		SHL	BX,1			;
		MOV	[BX].log_page,NOT_USE	;
		INC	un_alloc_pages		;add unallocated pages
		INC	DI			;
		INC	DI			;
		LOOP	f65			;
		POP	BX			;
		MOV	SI,DI			;clear & sort page buffer...
		MOV	DI,[BX].page_address	;
		MOV	CX,page_ptr		;
		SUB	CX,SI			;
		SHR	CX,1			;
		JCXZ	f62			;
		REPZ	MOVSW			;
f62:						;
		MOV	CX,[BX].alloc_page_count;
		JCXZ	f68			;
		MOV	AX,UNALLOC		;
		REPZ	STOSW			;
f68:						;
		XOR	DI,DI			;change page address....
		MOV	SI,[BX].page_address	;get page address.
		MOV	AX,[BX].alloc_page_count;get allocated page count.
		SHL	AX,1			;
		MOV	CX,handle_count		;
f66:						;
		CMP	[DI].handle_flag,0	;active handle ?
		JZ	f6b			;
		CMP	[DI].page_address,SI	;page_address > SI ?
		JNG	f64			;
		SUB	[DI].page_address,AX	;page address - AX
f64:						;
		LOOP	f6b			;
		SUB	page_ptr,AX		;SUB page pointer
		MOV	CX,PHYS_PAGES		;deallocate physical page...
		XOR	AL,AL			;
		MOV	SI,OFFSET map_table	;
f6a:						;
		CMP	[SI],DX			;same handle no.?
		JNZ	f67			;
		CALL	reset_phys_page		;reset physical page.
		JNB	f67			;error?
		JMP	err81			;error exit.
f6b:						;
		ADD	DI,FLAG_SIZE		;
		JMP	f66			;
f67:						;
		INC	AL			;
		ADD	SI,SIZE phys_page_struct;
		LOOP	f6a			;
f6c:						;
		MOV	[BX].handle_flag,0	;clear handle use flag
		MOV	[BX].alloc_page_count,0	;clear allocate page count
		MOV	[BX].page_address,0	;clear handle page pointer
		MOV	[BX].back_address,0	;clear handle back pointer
		MOV	DI,OFFSET handle_name	;clear handle name data...
		MOV	AX,DX			;
		MOV	CL,3			;
		SHL	AX,CL			;
		ADD	DI,AX			;
		XOR	AL,AL			;
		MOV	CX,HANDLE_NAME_SIZE	;
		REPZ	STOSB			;
		CMP	DX,0			;system handle?
		JZ	f6d			;
		DEC	handle_count		;not use handle count up
		JMP	noerr			;exit
f6d:						;
		MOV	[BX].handle_flag,1	;
		JMP	noerr			;exit

;------ function 7 --------------------------------------------------
; Get EMS version
; output
;	AH	: status
;	AL	: EMS version number
;--------------------------------------------------------------------
func7:
		STI				;
		MOV	AL,EMSVER		;get version no.
		JMP	noerr			;

;------ function 8 --------------------------------------------------
; Save page map
; input
;	DX	: EMM handle
; output
;	AH	: status
;--------------------------------------------------------------------
func8:						;v0.6....
		PUSH	CS			;
		POP	ES			;
		CMP	DX,HANDLE_CNT		;check handle data
		JNB	f81			;
		MOV	SI,DX			;
		SHL	SI,1			;
		CMP	[SI].handle_flag,1	;handle OK ?
		JNZ	f81			;
		CMP	[SI].back_address,0	;backup ?
		JNZ	f82			;
		MOV	AL,backup_count		;
		CMP	AL,BACK_MAX		;
		JB	f83			;
		JMP	err8c			;error exit 
f83:						;
		MOV	DI,back_ptr		;copy mapping data -> [DI]
		MOV	[SI].back_address,DI	;
		MOV	SI,OFFSET map_table	;
		MOV	CX,CONTEXT_SIZE		;
		REPZ	MOVSB			;
		INC	backup_count		;
		MOV	back_ptr,DI		;
		JMP	noerr			;exit
f81:						;
		JMP	err83			;error exit 
f82:						;
		JMP	err8d			;error exit 

;------ function 9 --------------------------------------------------
; Restore page map
; input
;	DX	: EMM handle
; output
;	AH	: status
;--------------------------------------------------------------------
f91:						;v0.6....
		JMP	err83			;error exit 
func9:						;
		PUSH	CS			;
		POP	ES			;
		CMP	DX,HANDLE_CNT		;check handle data
		JNB	f91			;
		MOV	BX,DX			;
		SHL	BX,1			;
		CMP	[BX].handle_flag,1	;handle OK ?
		JNZ	f91			;
		CMP	[BX].back_address,0	;backup ?
		JZ	f92			;
		MOV	DI,OFFSET map_table	;disable physical pages...
		MOV	CX,PHYS_PAGES		;
f93:						;
		MOV	DX,[DI].phys_page_port	;
		MOV	AL,DIS_EMS		;
		CALL	emsout			;
		JB	f97			;
		ADD	DI,SIZE phys_page_struct;
		LOOP	f93			;
		MOV	CX,CONTEXT_SIZE		;move mapping data...
		MOV	SI,[BX].back_address	;
		MOV	DI,OFFSET map_table	;
		PUSH	DI			;
		REPZ	MOVSB			;
		POP	DI			;
		CALL	set_pages_map		;enable physical pages...
		JB	f97			;
		DEC	backup_count		;backup mapping count DEC
		MOV	DI,[BX].back_address	;clear & sort backup buffer...
		MOV	SI,CONTEXT_SIZE		;
		ADD	SI,DI			;
		MOV	CX,back_ptr		;
		SUB	CX,SI			;
		JCXZ	f96			;
		REPZ	MOVSB			;
f96:						;
		MOV	CX,CONTEXT_SIZE		;
		MOV	AL,0FFH			;
		REPZ	STOSB			;
		MOV	SI,[BX].back_address	;change backup address....
		MOV	[BX].back_address,0	;
		XOR	DI,DI			;
		MOV	AX,CONTEXT_SIZE		;
		MOV	CX,HANDLE_CNT		;
f95:						;
		CMP	[DI].handle_flag,0	;
		JZ	f94			;
		CMP	[DI].back_address,SI	;
		JB	f94			;
		SUB	[DI].back_address,AX	;
f94:						;
		ADD	DI,FLAG_SIZE		;
		LOOP	f95			;
		SUB	back_ptr,AX		;SUB backup pointer
		JMP	noerr			;exit
f92:						;
		JMP	err8e			;error exit 
f97:						;
		JMP	err81			;error exit

;------ function 10 -------------------------------------------------
; Get page mapping register I/O port array
; input
;	ES:DI	: buffer address point
; output
;	AH	: status
;	AL	: board count
;--------------------------------------------------------------------
func10:
		STI				;
		MOV	SI,OFFSET port_addr	;
		MOV	CX,PHYS_PAGES		;
		REPZ	MOVSW			;
		MOV	AL,1			;
		JMP	noerr			;

;------ function 11 -------------------------------------------------
; Get logical-to-physical page translation array
; input
;	DX	: EMM handle
;	ES:DI	: buffer address point
; output
;	AH	: status code
;	BX	: number of pages allocated EMM handle.
;--------------------------------------------------------------------
func11:
		STI				;
		CMP	DX,HANDLE_CNT		;check handle data
		JNB	f112			;
		MOV	SI,DX			;
		SHL	SI,1			;
		CMP	[SI].handle_flag,1	;
		JNZ	f112			;
		MOV	CX,[SI].alloc_page_count;
		JCXZ	f112			;
		MOV	BX,[SI].page_address	;
f111:						;
		MOV	AX,[BX]			;
		ADD	AL,pageofs		;
		XCHG	AH,AL			;
		STOSW				;
		INC	BX			;
		INC	BX			;
		LOOP	f111			;
		MOV	BX,[SI].alloc_page_count;
		MOV	[BP].bx_save,BX		;
		JMP	noerr			;exit
f112:						;
		JMP	err83			;error exit 

;------ function 12 -------------------------------------------------
; Get EMM handle count
; output
;	AH	: status
;	BX	: active EMM handles
;--------------------------------------------------------------------
func12:
		STI				;
		MOV	BX,handle_count		;
f121:						;
		MOV	[BP].bx_save,BX		;
		JMP	noerr			;exit

;------ function 13 -------------------------------------------------
; Get EMM handle pages
; input
;	DX	: EMM handle
; output
;	AH	: status
;	BX	: pages EMM handle
;--------------------------------------------------------------------
func13:						;v0.6....
		STI				;
		CMP	DX,HANDLE_CNT		;check handle data
		JNB	f131			;
		MOV	SI,DX			;
		SHL	SI,1			;
		CMP	[SI].handle_flag,1	;handle OK ?
		JNZ	f131			;
		MOV	BX,[SI].alloc_page_count;
		JMP	f121			;exit
f131:						;
		JMP	err83			;error exit 

;------ function 14 -------------------------------------------------
; Get all EMM handle pages
; input
;	ES:DI	: buffer address point
; output
;	AH	: status
;	BX	: number of active EMM handles
;--------------------------------------------------------------------
func14:
		STI				;
		XOR	SI,SI			;
		MOV	CX,HANDLE_CNT		;
		XOR	BX,BX			;
		XOR	DX,DX			;
f142:						;
		CMP	[SI].handle_flag,0	;
		JZ	f141			;
		MOV	AX,DX			;
		STOSW				;
		MOV	AX,[SI].alloc_page_count;v0.5
		STOSW				;
		INC	BX			;
f141:						;
		INC	DX			;
		ADD	SI,FLAG_SIZE		;
		LOOP	f142			;
		JMP	f121			;

;------ function 15 -------------------------------------------------
; Get/set page map
; input
;	AL	: request subfunction no.
;	ES:DI	: mapping registers buffer address point
; output
;	AH	: status
;--------------------------------------------------------------------
func15:
		CMP	AL,0			;
		JZ	get_page_map		;
		CMP	AL,1			;
		JZ	set_page_map		;
		CMP	AL,2			;
		JZ	get_set_page_map	;
		CMP	AL,3			;
		JZ	get_size_page_map	;
		JMP	err84			;error exit 

;--------------------------------------------------------------------
; Get page map.
; input
;	ES:DI	: dest_page_map
; output
;	AH	: status
;--------------------------------------------------------------------
get_page_map:
		MOV	SI,OFFSET map_table	;
		MOV	CX,CONTEXT_SIZE		;
		REPZ	MOVSB			;
		JMP	noerr			;exit

;--------------------------------------------------------------------
; Set page map.
; input
;	DS:SI	: source_page_map
; output
;	AH	: status
;--------------------------------------------------------------------
set_page_map:
		MOV	AX,[BP].ds_save		;
		MOV	DS,AX			;
		MOV	CX,CONTEXT_SIZE		;
		MOV	AX,SS			;
		MOV	ES,AX			;
		LEA	DI,[BP].f15_map_data	;save map data.
		REPZ	MOVSB			;
set_page_map3:					;
		LEA	DI,[BP].f15_map_data	;
		CALL	check_map_data		;check map data (ES:DI)
		JNB	set_page_map2		;
		JMP	erra3			;error exit
set_page_map2:					;
		MOV	AX,ES			;
		MOV	DS,AX			;
		MOV	SI,DI			;
		PUSH	CS			;
		POP	ES			;
		MOV	DI,OFFSET map_table	;
		MOV	CX,CONTEXT_SIZE		;
		REPZ	MOVSB			;
		CALL	set_pages_map		;mapping physical pages.
		JB	set_page_map1		;
		JMP	noerr			;exit
set_page_map1:					;
		JMP	err81			;error exit

;--------------------------------------------------------------------
; Get & set page map.
; input
;	DS:SI	: source_page_map
;	ES:DI	: dest_page_map
; output
;	AH	: status
;--------------------------------------------------------------------
get_set_page_map:
		PUSH	DI			;save map data...
		PUSH	DS			;
		PUSH	ES			;
		MOV	AX,[BP].ds_save		;
		MOV	DS,AX			;
		MOV	CX,CONTEXT_SIZE		;
		MOV	AX,SS			;
		MOV	ES,AX			;
		LEA	DI,[BP].f15_map_data	;
		REPZ	MOVSB			;
		POP	ES			;
		POP	DS			;
		POP	DI			;
		MOV	SI,OFFSET map_table	;move current map data...
		MOV	CX,CONTEXT_SIZE		;
		REPZ	MOVSB			;
		MOV	AX,SS			;
		MOV	ES,AX			;
		JMP	set_page_map3		;

;--------------------------------------------------------------------
; Get size of page map save array.
; output
;	AH	: status
;	AL	: size_of_array
;--------------------------------------------------------------------
get_size_page_map:
		MOV	AL,CONTEXT_SIZE		;map data size set.
		JMP	noerr			;

;------ function 16 -------------------------------------------------
; Get/set partial page map
;--------------------------------------------------------------------
func16:
		CMP	AL,0			;
		JZ	get_partial_map		;
		CMP	AL,1			;
		JZ	set_partial_map		;
		CMP	AL,2			;
		JZ	get_size_partial_map	;
		JMP	err84			;error exit 

;--------------------------------------------------------------------
; Get size of partial page map save array
; input
;	BX	: number of pages in the partial array
; output
;	AH	: status
;	AL	: size_of_partial_save_array
;--------------------------------------------------------------------
get_size_partial_map:
		OR	BX,BX			;BX = 0?
		JZ	get_size_partial_map1	;
		CMP	BX,PHYS_PAGES		;BX > physical page count?
		JG	get_size_partial_map2	;
		MOV	AX,SIZE phys_page_struct;get size of partial map array.
		MUL	BL			;
		ADD	AX,2			;
		JMP	noerr			;exit
get_size_partial_map1:
		JMP	err8f			;error exit
get_size_partial_map2:
		JMP	err8b			;error exit

;--------------------------------------------------------------------
; Get partial page map
; input
;	DS:SI	: partial_page_map
;	ES:DI	: dest_array
; output
;	AH	: status
;--------------------------------------------------------------------
get_partial_map:
		MOV	AX,[BP].ds_save		;
		MOV	DS,AX			;
		LODSW				;
		CMP	AX,PHYS_PAGES		;
		JG	get_partial_map1	;rel. 0.2
		MOV	CX,AX			;
		JCXZ	get_partial_map5	;page count = 0?
		STOSW				;
get_partial_map4:
		LODSW				;
		PUSH	CX			;
		MOV	BX,OFFSET map_table	;
		MOV	CX,PHYS_PAGES		;
get_partial_map3:
		CMP	AX,CS:[BX].phys_seg_addr;
		JZ	get_partial_map2	;
		ADD	BX,SIZE phys_page_struct;
		LOOP	get_partial_map3	;
		POP	CX			;
		JMP	err8b			;error exit
get_partial_map2:
		PUSH	SI			;move map data...
		PUSH	DS			;
		PUSH	CS			;
		POP	DS			;
		MOV	SI,BX			;
		MOV	CX,SIZE phys_page_struct;
		REPZ	MOVSB			;
		POP	DS			;
		POP	SI			;
		POP	CX			;
		LOOP	get_partial_map4	;
get_partial_map5:
		JMP	noerr			;exit
get_partial_map1:
		JMP	erra4			;error exit

;--------------------------------------------------------------------
; Set partial page map
; input
;	DS:SI	: source_array
; output
;	AH	: status
;--------------------------------------------------------------------
set_partial_map:
		MOV	AX,[BP].ds_save		;
		MOV	DS,AX			;
		LODSW				;
		MOV	[BP].f16_map_len,AX	;save page map data length.
		MOV	CX,SIZE phys_page_struct;
		MUL	CL			;
		MOV	CX,AX			;
		JCXZ	set_partial_map1	;
		MOV	AX,SS			;save page map data...
		MOV	ES,AX			;
		LEA	DI,[BP].f16_map_data	;
		REPZ	MOVSB			;
		LEA	SI,[BP].f16_map_data	;set page map data...
		MOV	AX,ES			;
		MOV	DS,AX			;
		MOV	AX,CS			;
		MOV	ES,AX			;
		MOV	CX,[BP].f16_map_len	;get page map data length.
set_partial_map4:
		MOV	AX,[SI].phys_seg_addr	;
		CALL	change_seg_page		;change segment -> phys_page_no
		JB	set_partial_map3	;
		MOV	DI,OFFSET map_table	;
		PUSH	CX			;
		MOV	CX,SIZE phys_page_struct;
		MUL	CL			;
		ADD	DI,AX			;
		REPZ	MOVSB			;
		POP	CX			;
		LOOP	set_partial_map4	;
		CALL	set_pages_map		;mapping physical pages.
		JB	set_partial_map2	;
set_partial_map1:
		JMP	noerr			;exit
set_partial_map2:
		JMP	err81			;error exit
set_partial_map3:
		JMP	err8b			;error exit 

;------ function 17 -------------------------------------------------
; Map/unmap multiple handle pages
;--------------------------------------------------------------------
func17:
		STI				;
		CMP	AL,0			;
		JZ	log_phys_map		;
		CMP	AL,1			;
		JZ	log_phys_map		;
		JMP	err84			;error exit 

;--------------------------------------------------------------------
; Logical page/physical page/segment method
; input
;	AL	: physical page/segment selector
;	DX	: EMM handle
;	CX	: logical to physical map length
;	DS:SI	: pointer to logical to physical/segment map array
; output
;	AH	: status
;--------------------------------------------------------------------
log_phys_map:
		MOV	[BP].f17_ax_save,AX	;
		MOV	AX,[BP].ds_save		;
		MOV	DS,AX			;
		CALL	check_handle		;check handle data.
		JNB	log_phys_map2		;
		JMP	err83			;error exit
log_phys_map2:
		CMP	CX,PHYS_PAGES		;
		JNA	log_phys_map1		;
		JMP	err8b			;error exit
log_phys_map1:
		JCXZ	log_phys_map9		;
		MOV	[BP].f17_map_len,CX	;save page map data length.
		MOV	AX,SS			;
		MOV	ES,AX			;
		LEA	DI,[BP].f17_map_data	;save page map data.
		SHL	CX,1			;
		REPZ	MOVSW			;
		MOV	AX,SS			;
		MOV	DS,AX			;
		LEA	SI,[BP].f17_map_data	;set page map data pointer.
		MOV	CX,[BP].f17_map_len	;get page map data length.
log_phys_map7:
		MOV	BX,[SI].log_page_number1;get logical page no.
		CMP	BX,UNMAP		;unmapping?
		JZ	log_phys_map6		;
		CALL	check_log_page		;check logical page no.
		JNB	log_phys_map3		;error?
		JMP	err8a			;error exit
log_phys_map3:
		MOV	BX,AX			;set EMM logical page no.
log_phys_map6:
		MOV	AX,[BP].f17_ax_save	;
		CMP	AL,0			;subfunction 0?
		JNZ	log_phys_map8		;
		MOV	AX,[SI].phys_page_number1;get physical page no.
		CMP	AX,PHYS_PAGES		;check physical page no.
		JB	log_phys_map4		;
		JMP	err8b			;error exit
log_phys_map8:
		MOV	AX,[SI].mappable_seg_addr;get mappable seg_address.
		CALL	change_seg_page		;change segment -> phys_page_no
		JNB	log_phys_map4		;
		JMP	err8b			;error exit 
log_phys_map4:
		CMP	BX,UNMAP		;unmapping?
		JZ	log_phys_mapa		;
		CALL	set_phys_page		;set physical page
		JNB	log_phys_map5		;
		JMP	err81			;error exit
log_phys_mapa:
		CALL	reset_phys_page		;reset physical page
		JNB	log_phys_map5		;
		JMP	err81			;error exit
log_phys_map5:
		ADD	SI,SIZE log_to_phys_map_struct;
		LOOP	log_phys_map7		;
log_phys_map9:
		JMP	noerr			;exit

;------ function 18 ------------------------------------------------------
; Reallocate pages
; input
;	DX	: EMM handle
;	BX	: reallocation count
; output
;	AH	: status
;	BX	: number of pages allocated to handle after reallocation
;-------------------------------------------------------------------------
func18:
		PUSH	CS			;
		POP	ES			;
		CMP	DX,HANDLE_CNT		;check handle data...
		JNB	f181			;
		MOV	SI,DX			;
		SHL	SI,1			;
		CMP	[SI].handle_flag,0	;
		JNZ	f181			;
		XOR	BX,BX			;
		MOV	[BP].bx_save,BX		;
		JMP	err83			;error exit 
f182:						;
		JMP	err87			;error exit
f18a:						;
		JMP	noerr			;exit
f181:						;
		CMP	total_pages,BX		;request total size over ?
		JB	f182			;yes
		MOV	AX,[SI].alloc_page_count;get page size to handle
		OR	BX,BX			;reallocate count = 0?
		JNZ	f184			;
		MOV	CX,AX			;
		JCXZ	f18a			;CX = 0 case?
		MOV	DI,[SI].page_address	;BX = 0 case...
		PUSH	BX			;
f185:						;
		MOV	BX,[DI]			;
		SHL	BX,1			;
		MOV	[BX].log_page,NOT_USE	;unallocate logical page
		INC	un_alloc_pages		;add unallocated pages
		INC	DI			;
		INC	DI			;
		LOOP	f185			;
		POP	BX			;
		JMP	f18l			;
f184:						;
		CMP	AX,BX			;check reallocation/allocated
		JNZ	f18c			;pages.
		JMP	noerr			;same size case.
f18c:						;
		JNB	f183			;BX < allocated count?
		JMP	f186			;
f183:						;
		MOV	CX,AX			;BX < allocated pages case...
		SUB	CX,BX			;
		MOV	DI,[SI].page_address	;BX = 0 case...
		MOV	AX,BX			;
		SHL	AX,1			;
		ADD	DI,AX			;
		PUSH	BX			;
f18b:						;
		MOV	BX,[DI]			;
		SHL	BX,1			;
		MOV	[BX].log_page,NOT_USE	;unallocate logical page
		INC	un_alloc_pages		;add unallocated pages
		INC	DI			;
		INC	DI			;
		LOOP	f18b			;
		POP	BX			;
f18l:						;
		MOV	CX,page_ptr		;clear & sort page buffer...
		MOV	AX,BX			;
		SHL	AX,1			;
		ADD	AX,[SI].page_address	;
		SUB	CX,AX			;
		PUSH	SI			;
		MOV	DI,[SI].page_address	;
		MOV	AX,BX			;
		SHL	AX,1			;
		ADD	DI,AX			;
		MOV	AX,[SI].alloc_page_count;
		MOV	SI,[SI].page_address	;
		SHL	AX,1			;
		ADD	SI,AX			;
		SHR	CX,1			;
		JCXZ	f18e			;
		REPZ	MOVSW			;
f18e:						;
		MOV	CX,page_ptr		;
		SUB	CX,DI			;
		SHR	CX,1			;
		JCXZ	f18f			;
		MOV	AX,UNALLOC		;
		REPZ	STOSW			;
f18f:						;
		POP	SI			;
		MOV	AX,[SI].alloc_page_count;
		MOV	[SI].alloc_page_count,BX;set EMM handle used page count
		XOR	DI,DI			;change other handle page add-
		SUB	AX,BX			;ress....
		SHL	AX,1			;
		MOV	BX,[SI].page_address	;
		MOV	CX,handle_count		;
f18j:						;
		CMP	[DI].handle_flag,0	;active handle ?
		JZ	f18k			;
		CMP	[DI].page_address,BX	;page_address > BX ?
		JNG	f18m			;
		SUB	[DI].page_address,AX	;page_address - AX
f18m:						;
		LOOP	f18k			;
		SUB	page_ptr,AX		;page_ptr - AX
		CMP	[SI].alloc_page_count,0	;allocate page count = 0 ?
		JNZ	f18o			;
		MOV	[SI].page_address,0	;clear page buffer pointer
f18o:						;
		JMP	noerr			;exit.
f18k:						;
		ADD	DI,FLAG_SIZE		;
		JMP	f18j			;
f186:						;
		MOV	CX,BX			;BX > allocated pages case...
		SUB	CX,AX			;
		CMP	un_alloc_pages,CX	;request unallocate size over ?
		JNB	f187			;no
		MOV	AX,[SI].alloc_page_count;
		MOV	[BP].bx_save,AX		;
		JMP	err88			;error exit
f187:						;
		PUSH	SI			;move page buffer...
		MOV	DI,page_ptr		;
		CMP	[SI].page_address,0	;not poniter address?
		JNZ	f18p			;
		MOV	[SI].page_address,DI	;set page pointer
		JMP	f18q			;
f18p:						;
		DEC	DI			;
		MOV	AX,CX			;
		SHL	AX,1			;
		ADD	DI,AX			;
		MOV	AX,[SI].alloc_page_count;
		SHL	AX,1			;
		ADD	AX,[SI].page_address	;
		PUSH	CX			;
		MOV	CX,page_ptr		;
		SUB	CX,AX			;
		MOV	SI,page_ptr		;
		DEC	SI			;
		STD				;
		JCXZ	f18g			;
		REPZ	MOVSB			;
f18g:						;
		POP	CX			;
f18q:						;
		SHL	CX,1			;
		ADD	page_ptr,CX		;pointer add
		POP	SI			;
		CLD				;
		MOV	DI,[SI].page_address	;allocate add pages...
		MOV	AX,[SI].alloc_page_count;
		MOV	CX,BX			;
		SUB	CX,AX			;
		SHL	AX,1			;
		ADD	DI,AX			;
		PUSH	SI			;
		MOV	SI,OFFSET log_page	;
		XOR	AX,AX			;
f188:						;
		CMP	WORD PTR [SI],UNMAP	;logical page end?
		JZ	f18d			;
		CMP	WORD PTR [SI],NOT_USE	;unallocated page ?
		JNZ	f189			;
		MOV	WORD PTR [SI],DX	;
		STOSW				;
		DEC	un_alloc_pages		;unallocated page - 1
		LOOP	f189			;
		POP	SI			;
		MOV	AX,[SI].alloc_page_count;
		MOV	[SI].alloc_page_count,BX;set EMM handle used page count
		XOR	DI,DI			;change other handle page add-
		XCHG	AX,BX			;ress....
		SUB	AX,BX			;
		SHL	AX,1			;
		MOV	BX,[SI].page_address	;
		MOV	CX,handle_count		;
f18h:						;
		CMP	[DI].handle_flag,0	;
		JZ	f18i			;
		CMP	[DI].page_address,BX	;
		JNG	f18n			;
		ADD	[DI].page_address,AX	;
f18n:						;
		LOOP	f18i			;
		JMP	noerr			;exit
f18i:						;
		ADD	DI,FLAG_SIZE		;
		JMP	f18h			;
f189:						;
		ADD	SI,LOG_SIZE		;
		INC	AX			;
		JMP	f188			;
f18d:						;
		POP	SI			;
		JMP	err80			;error exit

;------ function 19 -------------------------------------------------
; Get/set handle attribute
;--------------------------------------------------------------------
func19:
		STI				;
		CMP	AL,0			;
		JZ	get_handle_attr		;
		CMP	AL,1			;
		JZ	set_handle_attr		;
		CMP	AL,2			;
		JZ	get_attr_cap		;
		JMP	err84			;error exit 

;--------------------------------------------------------------------
; Get handle attribute
; input
;	DX	: EMM handle
; output
;	AH	: status
;	AL	: handle attribute
;--------------------------------------------------------------------
get_handle_attr:
		CALL	check_handle		;check handle data
		JNB	get_handle_attr1	;
		JMP	err83			;error exit 
get_handle_attr1:
		MOV	AL,VOLATILE		;handle attribute set
		JMP	noerr			;exit

;--------------------------------------------------------------------
; Set handle attribute
; input
;	DX	: EMM handle
;	BL	: new handle attribute
; output
;	AH	: status
;--------------------------------------------------------------------
set_handle_attr:
		CALL	check_handle		;check handle data
		JNB	set_handle_attr2	;
		JMP	err83			;error exit
set_handle_attr2:
		CMP	BL,VOLATILE		;
		JNZ	set_handle_attr1	;
		JMP	noerr			;exit
set_handle_attr1:
		CMP	BL,NON_VOLATILE		;handle attribute check
		JZ	set_handle_attr3	;
		JMP	err90			;error exit
set_handle_attr3:
		JMP	err91			;error exit

;--------------------------------------------------------------------
; Get attribute capability
; output
;	AH	: status
;	AL	: attribute capability
;--------------------------------------------------------------------
get_attr_cap:
		CALL	check_handle		;check handle data
		JNB	get_attr_cap1		;
		JMP	err83			;error exit
get_attr_cap1:
		MOV	AL,VOLATILE		;set attribute capability
		JMP	noerr			;exit

;------ function 20 -------------------------------------------------
; Get/set handle name
;--------------------------------------------------------------------
func20:
		CMP	AL,0			;
		JZ	get_handle_name		;
		CMP	AL,1			;
		JZ	set_handle_name		;
		JMP	err84			;error exit 

;--------------------------------------------------------------------
; Get handle name
; input
;	DX	: EMM handle
;	ES:DI	: pointer to handle name array
; output
;	AH	: status
;--------------------------------------------------------------------
get_handle_name:
		CALL	check_handle		;check handle data
		JNB	get_handle_name1	;
		JMP	err83			;error exit
get_handle_name1:				;
		MOV	SI,OFFSET handle_name	;
		MOV	AX,DX			;
		MOV	CL,3			;
		SHL	AX,CL			;
		ADD	SI,AX			;
		MOV	DI,[BP].di_save		;
		MOV	CX,HANDLE_NAME_SIZE	;
		REPZ	MOVSB			;
		JMP	noerr			;exit

;--------------------------------------------------------------------
; Set handle name
; input
;	DX	: EMM handle
;	DS:SI	: pointer to handle name
; output
;	AH	: status
;--------------------------------------------------------------------
set_handle_name:
		CALL	check_handle		;check handle data
		JNB	set_handle_name1	;
		JMP	err83			;error exit
set_handle_name1:				;
		PUSH	CS			;
		POP	ES			;
		MOV	AX,[BP].ds_save		;
		MOV	DS,AX			;
		MOV	BX,DX			;
		MOV	CX,HANDLE_CNT		;check handle name...
		MOV	DI,OFFSET handle_name	;
		XOR	DX,DX			;
set_handle_name2:				;
		CALL	check_handle		;check handle data
		JB	set_handle_name3	;
		PUSH	CX			;compare handle name...
		PUSH	SI			;
		PUSH	DI			;
		MOV	CX,HANDLE_NAME_SIZE	;
		REPZ	CMPSB			;
		POP	DI			;
		POP	SI			;
		POP	CX			;
		JZ	set_handle_name4	;found same handle name ?
set_handle_name3:				;
		ADD	DI,HANDLE_NAME_SIZE	;
		INC	DX			;
		LOOP	set_handle_name2	;
		MOV	DI,OFFSET handle_name	;set handle name...
		MOV	AX,BX			;
		MOV	CL,3			;
		SHL	AX,CL			;
		ADD	DI,AX			;
		MOV	CX,HANDLE_NAME_SIZE	;
		REPZ	MOVSB			;
		JMP	noerr			;exit
set_handle_name4:
		JMP	erra1			;error exit

;------ function 21 -------------------------------------------------
; Get handle directory
;--------------------------------------------------------------------
func21:
		CMP	AL,0			;
		JZ	get_handle_dir		;
		CMP	AL,1			;
		JZ	search_for_name		;
		CMP	AL,2			;
		JZ	get_total_handle	;
		JMP	err84			;error exit 

;--------------------------------------------------------------------
; Get handle directory
; input
;	ES:DI	: pointer to handle_dir
; output
;	AH	: status
;	AL	: number of entries in the handle_dir array
;--------------------------------------------------------------------
get_handle_dir:
		MOV	CX,HANDLE_CNT		;
		MOV	SI,OFFSET handle_name	;
		XOR	DX,DX			;
		XOR	BL,BL			;
get_handle_dir1:				;
		CALL	check_handle		;check handle data
		JB	get_handle_dir2		;
		MOV	AX,DX			;set EMM handle.
		STOSW				;
		PUSH	CX			;set handle name...
		PUSH	SI			;
		MOV	CX,HANDLE_NAME_SIZE	;
		REPZ	MOVSB			;
		POP	SI			;
		POP	CX			;
		INC	BL			;inc handle count.
get_handle_dir2:				;
		ADD	SI,HANDLE_NAME_SIZE	;
		INC	DX			;
		LOOP	get_handle_dir1		;
		MOV	AL,BL			;
		JMP	noerr			;exit

;--------------------------------------------------------------------
; Search for named handle
; input
;	DS:SI	: search handle_name pointer
; output
;	AH	: status
;	DX	: EMM handle
;--------------------------------------------------------------------
search_for_name:
		PUSH	CS			;
		POP	ES			;
		MOV	CX,HANDLE_CNT		;
		MOV	DI,OFFSET handle_name	;
		MOV	AX,[BP].ds_save		;
		MOV	DS,AX			;
		XOR	DX,DX			;
search_for_name1:				;
		PUSH	CX			;
		PUSH	SI			;
		PUSH	DI			;
		MOV	CX,HANDLE_NAME_SIZE	;
		REPZ	CMPSB			;
		POP	DI			;
		POP	SI			;
		POP	CX			;
		JZ	search_for_name2	;
		ADD	DI,HANDLE_NAME_SIZE	;
		INC	DX			;
		LOOP	search_for_name1	;
		JMP	erra0			;error exit
search_for_name2:				;
		MOV	CX,HANDLE_NAME_SIZE	;
		XOR	AL,AL			;
		REPZ	SCASB			;
		JNZ	search_for_name3	;
		JMP	erra1			;error exit
search_for_name3:				;
		PUSH	CS			;
		POP	DS			;
		MOV	[BP].dx_save,DX		;
		JMP	noerr			;exit

;--------------------------------------------------------------------
; Get total handle
; output
;	AH	: status
;	BX	: total_handles
;--------------------------------------------------------------------
get_total_handle:
		MOV	BX,HANDLE_CNT		;set max handle count.
		MOV	[BP].bx_save,BX		;
		JMP	noerr			;exit

;------ function 22 -------------------------------------------------
; Alter page map & jump.
; input
;	AL	: physical page number/segment selector
;	DX	: EMM handle
;	DS:SI	: pointer to map_and_jump structure
; output
;	AH	: status
;--------------------------------------------------------------------
func22:
		STI				;
		CMP	AL,0			;
		JZ	f220			;
		CMP	AL,1			;
		JZ	f220			;
		JMP	err8f			;error exit
f220:
		MOV	[BP].f22_ax_save,AX	;
		CALL	check_handle		;check handle data.
		JNB	f221			;
		JMP	err83			;error exit
f221:
		MOV	AX,[BP].ds_save		;copy calling parameters...
		MOV	DS,AX			;
		LES	BX,[SI].target_address1	;
		MOV	AX,ES			;
		MOV	[BP].f22_target_off,BX	;offset
		MOV	[BP].f22_target_seg,AX	;segment
		MOV	CL,[SI].log_phys_map_len;get mapping data length.
		XOR	CH,CH			;
		MOV	[BP].f22_map_len,CX	;length
		JCXZ	f22a			;
		LES	BX,[SI].log_phys_map_ptr;get log_phys_map_ptr.
		LEA	DI,[BP].f22_map_data	;copy log_phys_map data...
		SHL	CX,1			;
f228:
		MOV	AX,ES:[BX]		;
		MOV	SS:[DI],AX		;
		INC	DI			;
		INC	DI			;
		INC	BX			;
		INC	BX			;
		LOOP	f228			;
f22a:
		MOV	AX,SS			;
		MOV	DS,AX			;
		MOV	CX,[BP].f22_map_len	;length
		JCXZ	f222			;
		LEA	DI,[BP].f22_map_data	;get mapping data pointer.
f223:
		MOV	BX,[DI].log_page_number1;get logical page no.
		CMP	BX,UNMAP		;unmapping?
		JZ	f22b			;
		CALL	check_log_page		;check logical page no.
		JNB	f224			;
		JMP	err8a			;error exit
f224:
		MOV	BX,AX			;set EMM logical page no.
f22b:
		MOV	AX,[BP].f22_ax_save	;get phys_page_no/seg_selector.
		CMP	AL,0			;sub_function 0?
		JNZ	f229			;
		MOV	AX,[DI].phys_page_number1;get physical page no.
		CMP	AX,PHYS_PAGES		;
		JB	f225			;
		JMP	err8b			;error exit
f229:
		MOV	AX,[DI].mappable_seg_addr;get mappable segment.
		CALL	change_seg_page		;change segment -> phys_page_no.
		JNB	f225			;
		JMP	err8b			;error exit
f225:
		CMP	BX,UNMAP		;unmapping?
		JZ	f227			;
		CALL	set_phys_page		;set physical page
		JNB	f226			;
		JMP	err81			;error exit
f227:
		CALL	reset_phys_page		;reset physical page
		JNB	f226			;
		JMP	err81			;error exit
f226:
		ADD	DI,SIZE log_to_phys_map_struct;
		LOOP	f223			;
f222:
		MOV	AX,[BP].f22_target_seg	;get target address.
		MOV	[BP].ret_segment,AX	;set FAR:JUMP segment.
		MOV	AX,[BP].f22_target_off	;get target address.
		MOV	[BP].ret_offset,AX	;set FAR:JUMP offset.
		JMP	noerr			;exit

;------ function 23 -------------------------------------------------
; Alter page map & call
;--------------------------------------------------------------------
func23:
		STI				;
		CMP	AL,0			;
		JZ	f2300			;
		CMP	AL,1			;
		JZ	f2300			;
		CMP	AL,2			;
		JZ	get_page_map_stack	;
		JMP	err84			;error exit 

;--------------------------------------------------------------------
; Get page map stack space size
; output
;	AH	: status
;	BX	: stack space required
;--------------------------------------------------------------------
get_page_map_stack:
		MOV	BX,RET_SP		;set stack space...
		MOV	[BP].bx_save,BX		;
		JMP	noerr			;exit

;--------------------------------------------------------------------
; Alter page map & call
; input
;	AL	: physical page number/segment selector
;	DX	: EMM handle
;	DS:SI	: pointer to map_and_call structure
; output
;	AH	: status
;	AL	: number of entries in the handle_dir array
;--------------------------------------------------------------------
f2300:
		MOV	[BP].f23_ax_save,AX	;
		CALL	check_handle		;check handle data
		JNB	f2301			;
		JMP	err83			;error exit
f2301:
		MOV	AX,[BP].ds_save		;
		MOV	DS,AX			;
		LES	BX,[SI].target_address2	;get FAR:CALL target_addr.
		MOV	[BP].f23_target_off,BX	;set offset.
		MOV	AX,ES			;get segment
		MOV	[BP].f23_target_seg,AX	;set segment.
		MOV	CL,[SI].new_page_map_len;get new_page_map_len.
		XOR	CH,CH			;
		MOV	[BP].f23_new_map_len,CX	;
		LES	BX,[SI].new_page_map_ptr;get new_page_map_ptr.
		JCXZ	f2303			;
		LEA	DI,[BP].f23_new_map_data;
		SHL	CX,1			;
f2302:
		MOV	AX,ES:[BX]		;
		MOV	SS:[DI],AX		;
		INC	DI			;
		INC	DI			;
		INC	BX			;
		INC	BX			;
		LOOP	f2302			;
f2303:
		MOV	CL,[SI].old_page_map_len;get old_page_map_len.
		XOR	CH,CH			;
		MOV	[BP].f23_old_map_len,CX	;
		LES	BX,[SI].old_page_map_ptr;get old_page_map_ptr.
		JCXZ	f2305			;
		LEA	DI,[BP].f23_old_map_data;
		SHL	CX,1			;
f2304:
		MOV	AX,ES:[BX]		;
		MOV	SS:[DI],AX		;
		INC	DI			;
		INC	DI			;
		INC	BX			;
		INC	BX			;
		LOOP	f2304			;
f2305:
		MOV	CX,[BP].f23_new_map_len	;get new_page_map_len.
		JCXZ	f2307			;mapping page length = 0?
		MOV	AX,SS			;
		MOV	DS,AX			;
		LEA	SI,[BP].f23_new_map_data;get new_page_map_ptr.
f2306:
		MOV	BX,[SI].log_page_number2;get logical page no.
		CMP	BX,UNMAP		;unmapping?
		JZ	f2313			;
		CALL	check_log_page		;
		JNB	f2309			;
		JMP	err8a			;error exit
f2309:
		MOV	BX,AX			;
f2313:
		MOV	AX,[BP].f23_ax_save	;
		CMP	AL,0			;sub_function 0?
		JZ	f2310			;
		MOV	AX,[SI].mappable_seg_addr;
		CALL	change_seg_page		;change segment -> phys_page_no.
		JNB	f2311			;
		JMP	err8b			;error exit
f2310:
		MOV	AX,[SI].phys_page_number1;get physical page no.
		CMP	AX,PHYS_PAGES		;
		JB	f2311			;
		JMP	err8b			;error exit
f2311:
		CMP	BX,UNMAP		;unmapping?
		JZ	f2312			;
		CALL	set_phys_page		;set physical page
		JNB	f2308			;error ?
		JMP	err81			;error exit
f2312:
		CALL	reset_phys_page		;reset physical page
		JNB	f2308			;error ?
		JMP	err81			;error exit
f2308:
		ADD	SI,SIZE log_to_seg_map_struct;
		LOOP	f2306			;
f2307:
		MOV	BX,OFFSET f2350		;get FAR:CALL return_addr
		MOV	[BP].f23_retoff,BX	;set offset.
		MOV	AX,CS			;
		MOV	[BP].f23_retseg,AX	;set segment.
		MOV	AX,[BP].ret_flag	;get flags.
		MOV	[BP].f23_flag,AX	;set flags.
		MOV	AH,0			;
		POP	BX			;
		POP	CX			;
		POP	DX			;
		POP	SI			;
		POP	DI			;
		POP	BP			;
		POP	ES			;
		POP	DS			;
		IRET				;FAR:CALL to target

;
; far call return point
;
f2350:
		PUSHF				;push flags.
		POP	AX			;pop flags.
		CLI				;
		SUB	SP,F23_RETSP		;
		PUSH	DS			;PUSH registers...
		PUSH	ES			;
		PUSH	BP			;
		PUSH	DI			;
		PUSH	SI			;
		PUSH	DX			;
		PUSH	CX			;
		PUSH	BX			;
		MOV	BP,SP			;
		MOV	[BP].ret_flag,AX	;set return_flags.
		MOV	CX,[BP].f23_old_map_len	;get old_page_map_len.
		JCXZ	f2351			;mapping page length = 0?
		MOV	AX,SS			;
		MOV	DS,AX			;
		LEA	SI,[BP].f23_old_map_data;get old_page_map_ptr.
f2352:
		MOV	BX,[SI].log_page_number2;get logical page no.
		CMP	BX,UNMAP		;unmapping?
		JZ	f2359			;
		CALL	check_log_page		;
		JNB	f2358			;
		JMP	err8a			;error exit
f2358:
		MOV	BX,AX			;
f2359:
		MOV	AX,[BP].f23_ax_save	;
		CMP	AL,0			;
		JZ	f2354			;
		MOV	AX,[SI].mappable_seg_addr;
		CALL	change_seg_page		;change segment -> phys_page_no.
		JNB	f2355			;
		JMP	err8b			;error exit
f2354:
		MOV	AX,[SI].phys_page_number1;get physical page no.
		CMP	AX,PHYS_PAGES		;
		JB	f2355			;
		JMP	err8b			;error exit
f2355:
		CMP	BX,UNMAP		;unmapping?
		JZ	f2357			;
		CALL	set_phys_page		;set physical page
		JNB	f2353			;error ?
		JMP	err81			;error exit
f2357:
		CALL	reset_phys_page		;reset physical page
		JNB	f2353			;error ?
		JMP	err81			;error exit
f2353:
		ADD	SI,SIZE log_to_seg_map_struct;
		LOOP	f2352			;
f2351:
		JMP	noerr			;exit 

;------ function 24 -------------------------------------------------
; Move/exchange memory region
; input
;	AL	: move/xchg select data (00 = move,01 = xchg)
;	DS:SI	: pointer to move/xchg_source_dest structure
; output
;	AH	: status
;--------------------------------------------------------------------
func24:
		CMP	AL,0			;
		JZ	f2400			;
		CMP	AL,1			;
		JZ	f2400			;
		JMP	err84			;error exit
f2400:
		MOV	[BP].f24_ax_save,AX	;
		MOV	AX,[BP].ds_save		;get calling parameters...
		MOV	DS,AX			;
		MOV	AX,[SI].source_initial_offset1;get source offset.
		MOV	[BP].source_off,AX	;
		XOR	AH,AH			;
		MOV	AL,[SI].source_memory_type1;get source memory type.
		MOV	[BP].source_type,AX	;
		CMP	AX,0			;conventional?
		JZ	f2401			;
		MOV	AX,[SI].source_handle1	;get source handle.
		MOV	[BP].source_handle,AX	;
		MOV	AX,[SI].source_initial_seg_page1;get source page no.
		MOV	[BP].source_pno,AX	;
		MOV	AX,CS:page_frame_seg	;
		MOV	[BP].source_seg,AX	;
		JMP	f2402			;
f2401:
		MOV	AX,[SI].source_initial_seg_page1;get source segment.
		MOV	[BP].source_seg,AX	;
f2402:
		MOV	AX,[SI].dest_initial_offset1;get dest offset.
		MOV	[BP].dest_off,AX	;
		XOR	AH,AH			;
		MOV	AL,[SI].dest_memory_type1;get dest memory type.
		MOV	[BP].dest_type,AX	;
		CMP	AX,0			;conventional?
		JZ	f2403			;
		MOV	AX,[SI].dest_handle1	;get dest handle.
		MOV	[BP].dest_handle,AX	;
		MOV	AX,[SI].dest_initial_seg_page1;get dest page no.
		MOV	[BP].dest_pno,AX	;
		MOV	AX,CS:page_frame_seg	;
		ADD	AX,400H			;
		MOV	[BP].dest_seg,AX	;
		JMP	f2404			;
f2403:
		MOV	AX,[SI].dest_initial_seg_page1;get dest segment.
		MOV	[BP].dest_seg,AX	;
f2404:
		LES	DI,[SI].region_length1	;get region length...
		MOV	[BP].region_low,DI	;
		MOV	AX,ES			;
		MOV	[BP].region_high,AX	;
		CMP	AX,10H			;check region size...
		JB	f2405			;
		JZ	f2406			;
f2407:
		JMP	err96			;error exit
f2406:
		MOV	AX,ES			;
		OR	AX,AX			;
		JNZ	f2407			;
f2405:
		CMP	[BP].source_type,0	;check source data...
		JNZ	f2408			;
		XOR	DX,DX			;
		MOV	AX,[BP].source_seg	;conventional case...
		MOV	BX,10H			;
		MUL	BX			;
		ADD	AX,[BP].source_off	;
		ADC	DX,0			;
		CMP	DX,10H			;check source address...
		JB	f2409			;
f2411:
		JMP	erra2			;error exit
f2409:
		ADD	DX,[BP].region_high	;add region length...
		ADD	AX,[BP].region_low	;
		ADC	DX,0			;
		CMP	DX,10H			;check address...
		JB	f2412			;
		OR	AX,AX			;
		JNZ	f2411			;
		JMP	f2412			;
f2408:
		MOV	DX,[BP].source_handle	;
		CALL	check_handle		;check handle data.
		JNB	f2413			;
		JMP	err83			;error exit
f2413:
		MOV	BX,[BP].source_pno	;
		CALL	check_log_page		;
		JNB	f2414			;
		JMP	err8a			;error exit
f2414:
		MOV	DI,DX			;
		MOV	AX,[BP].source_off	;
		CMP	AX,4000H		;
		JB	f2415			;
		JMP	err95			;error exit
f2415:
		MOV	DX,[BP].region_high	;
		ADD	AX,[BP].region_low	;
		ADC	DX,0			;
		MOV	CX,4000H		;
		DIV	CX			;
		CMP	AX,0			;
		JZ	f2416			;
		INC	DX			;
f2416:
		ADD	BX,DX			;
		MOV	DX,DI			;
		CALL	check_log_page		;
		JNB	f2412			;
		JMP	err93			;error exit
f2412:
		MOV	AX,[BP].dest_type	;check dest data...
		CMP	AL,0			;conventional?
		JNZ	f2417			;
		XOR	DX,DX			;conventional memory case...
		MOV	AX,[BP].dest_seg	;
		MOV	BX,10H			;
		MUL	BX			;
		ADD	AX,[BP].dest_off	;
		ADC	DX,0			;
		CMP	DX,10H			;check dest address...
		JB	f2418			;
f2420:
		JMP	erra2			;error exit
f2418:
		ADD	DX,[BP].region_high	;add region length...
		ADD	AX,[BP].region_low	;
		ADC	DX,0			;
		CMP	DX,10H			;check address...
		JB	f2421			;
		OR	AX,AX			;
		JNZ	f2420			;
		JMP	f2421			;
f2417:
		MOV	DX,[BP].dest_handle	;expanded memory case...
		CALL	check_handle		;check handle data.
		JNB	f2422			;
		JMP	err83			;error exit
f2422:
		MOV	BX,[BP].dest_pno	;
		CALL	check_log_page		;check logical page no.
		JNB	f2423			;
		JMP	err8a			;error exit
f2423:
		MOV	DI,DX			;
		MOV	AX,[BP].dest_off	;
		CMP	AX,4000H		;
		JB	f2424			;
		JMP	err95			;error exit
f2424:
		MOV	DX,[BP].region_high	;
		ADD	AX,[BP].region_low	;
		ADC	DX,0			;
		MOV	CX,4000H		;
		DIV	CX			;
		CMP	AX,0			;
		JZ	f2425			;
		INC	DX			;
f2425:
		ADD	BX,DX			;
		MOV	DX,DI			;
		CALL	check_log_page		;
		JNB	f2421			;
		JMP	err93			;error exit
f2421:
		MOV	[BP].overlap_flag,0	;
		MOV	[BP].get_source_f,0	;
		MOV	[BP].get_dest_f,0	;
		MOV	AX,[BP].source_type	;check data overlap...
		CMP	AX,[BP].dest_type	;source and dest same type?
		JZ	f2435			;
		CMP	AX,0			;conventional memory?
		JZ	f2436			;
		MOV	[BP].get_source_f,1	;
		JMP	f2426			;
f2436:
		MOV	[BP].get_dest_f,1	;
		JMP	f2426			;
f2435:
		CMP	AX,0			;conventional memory?
		JZ	f2427			;
		MOV	AX,[BP].source_handle	;expanded memory case...
		CMP	AX,[BP].dest_handle	;
		JNZ	f2426			;
		MOV	AX,[BP].source_pno	;
		MOV	BX,4000H		;
		MUL	BX			;
		ADD	AX,[BP].source_off	;
		ADC	DX,0			;
		MOV	SI,AX			;
		MOV	CX,DX			;
		MOV	AX,[BP].dest_pno	;
		MOV	BX,4000H		;
		MUL	BX			;
		ADD	AX,[BP].dest_off	;
		ADC	DX,0			;
		MOV	DI,AX			;
		MOV	[BP].get_source_f,1	;
		MOV	[BP].get_dest_f,1	;
		JMP	f2428			;
f2427:
		MOV	SI,[BP].source_off	;conventional memory case...
		MOV	CX,[BP].source_seg	;
		MOV	DI,[BP].dest_off	;
		MOV	DX,[BP].dest_seg	;
f2428:
		CMP	DX,CX			;CX:SI = source
		JB	f2429			;DX:DI = dest
		JNZ	f2430			;
		CMP	DI,SI			;
		JB	f2430			;
f2429:
		XCHG	SI,DI			;
		XCHG	CX,DX			;
f2430:
		SUB	DI,SI			;DX:DI - CX:SI...
		SBB	DX,CX			;
		SUB	DI,[BP].region_low	;
		SBB	DX,[BP].region_high	;
		JNB	f2426			;ok
f2431:
		MOV	AX,[BP].f24_ax_save	;get AX
		CMP	AL,0			;
		JZ	f2432			;
		JMP	err97			;error exit
f2434:
		JMP	err80			;error exit
f2432:
		MOV	[BP].overlap_flag,1	;set overlap flag.
f2426:
		CLI				;move/xchg memory...
f2449:
		CMP	[BP].get_source_f,1	;
		JNZ	f2433			;
		MOV	AX,[BP].source_type	;
		CMP	AL,0			;
		JZ	f2451			;
		MOV	DX,[BP].source_handle	;
		MOV	BX,[BP].source_pno	;
		CALL	check_log_page		;
		JB	f2434			;
		MOV	BX,AX			;
		MOV	AL,0			;set physical page no.
		CALL	set_phys_page		;
		JB	f2434			;
f2451:
		MOV	SI,[BP].source_off	;set offset address.
		MOV	AX,[BP].source_seg	;set segment address..
		MOV	DS,AX			;
f2433:
		CMP	[BP].get_dest_f,1	;
		JNZ	f2445			;
		MOV	AX,[BP].dest_type	;
		CMP	AL,0			;
		JZ	f2452			;
		MOV	DX,[BP].dest_handle	;
		MOV	BX,[BP].dest_pno	;
		CALL	check_log_page		;
		JB	f2434			;
		MOV	BX,AX			;
		MOV	AL,1			;set physical page no.
		CALL	set_phys_page		;
		JB	f2434			;
f2452:
		MOV	DI,[BP].dest_off	;set offset address.
		MOV	AX,[BP].dest_seg	;set segment address..
		MOV	ES,AX			;
f2445:
		MOV	AX,[BP].source_type	;
		CMP	AX,[BP].dest_type	;
		JNZ	f2437			;
		CMP	AL,0			;
		JNZ	f2438			;
		MOV	DX,[BP].region_high	;conventional...
		MOV	CX,[BP].region_low	;
		JMP	f2440			;
f2437:
		XOR	DX,DX			;expanded/conventional...
		MOV	CX,4000H		;
		CMP	AL,0			;
		JNZ	f2439			;
		MOV	[BP].get_dest_f,1	;
		SUB	CX,DI			;
		JMP	f2440			;
f2439:
		MOV	[BP].get_source_f,1	;
		SUB	CX,SI			;
		JMP	f2440			;
f2438:
		MOV	DX,4000H		;expanded
		MOV	AX,DX			;
		SUB	DX,DI			;
		SUB	AX,SI			;
		MOV	CX,DX			;
		MOV	[BP].get_dest_f,1	;
		CMP	AX,DX			;
		JNB	f2440			;
		MOV	CX,AX			;
		MOV	[BP].get_source_f,1	;
		MOV	[BP].get_dest_f,0	;
f2440:
		CMP	DX,0			;
		JNZ	f2441			;
		JCXZ	f2448			;
f2441:
		MOV	AX,[BP].f24_ax_save	;
		CMP	AL,0			;
		JNZ	f2443			;
		MOV	AL,[SI]			;
		MOV	ES:[DI],AL		;
		JMP	f2444			;
f2443:
		MOV	AL,[SI]			;
		XCHG	AL,ES:[DI]		;
		MOV	[SI],AL			;
f2444:
		MOV	AX,DS			;DS:SI + 1...
		ADD	SI,1			;
		ADC	AX,0			;
		MOV	DS,AX			;
		MOV	AX,ES			;ES:DI + 1...
		ADD	DI,1			;
		ADC	AX,0			;
		MOV	ES,AX			;
		MOV	AX,[BP].region_low	;region_low - 1...
		SUB	AX,1			;
		MOV	[BP].region_low,AX	;
		MOV	AX,[BP].region_high	;region_high - 1...
		SBB	AX,0			;
		MOV	[BP].region_high,AX	;
		OR	AX,[BP].region_low	;
		JZ	f2448			;
		SUB	CX,1			;DX:CX - 1...
		SBB	DX,0			;
		MOV	AX,CX			;
		OR	AX,DX			;
		JNZ	f2441			;
		CMP	[BP].get_source_f,1	;
		JNZ	f2446			;
		INC	[BP].source_pno		;
		MOV	[BP].source_off,0	;
		MOV	[BP].get_source_f,0	;
f2446:
		CMP	[BP].get_dest_f,1	;
		JNZ	f2447			;
		INC	[BP].dest_pno		;
		MOV	[BP].dest_off,0		;
		MOV	[BP].get_dest_f,0	;
f2447:
		JMP	f2449			;
f2448:
		CMP	[BP].overlap_flag,1	;overlap flag on?
		JNZ	f2450			;
		JMP	err92			;error exit
f2450:
		JMP	noerr			;exit

;------ function 25 -------------------------------------------------
; Get mappable physical address array
;--------------------------------------------------------------------
func25:
		STI				;
		CMP	AL,0			;
		JZ	get_map_phys_addr	;
		CMP	AL,1			;
		JZ	get_map_phys_ent	;
		JMP	err84			;error exit 

;--------------------------------------------------------------------
; Get mappable physical address array
; input
;	ES:DI	: mappable_phys_page
; output
;	AH	: status
;	CX	: number of entries in the mappable_phys_page
;--------------------------------------------------------------------
get_map_phys_addr:
		MOV	AX,[BP].es_save		;
		MOV	ES,AX			;
		MOV	CX,PHYS_PAGES		;
		MOV	SI,OFFSET map_table	;
		XOR	DX,DX			;
get_map_phys_addr1:
		MOV	AX,[SI].phys_seg_addr	;
		STOSW				;
		MOV	AX,DX			;
		STOSW				;
		INC	DX			;
		ADD	SI,SIZE phys_page_struct;
		LOOP	get_map_phys_addr1	;
get_map_phys_addr2:
		MOV	CX,PHYS_PAGES		;
		MOV	[BP].cx_save,CX		;set segment addr entrie
		JMP	noerr			;exit

;--------------------------------------------------------------------
; Get mappable physcal address array entries
; output
;	AH	: status
;	CX	: number of entries in the mappable_phys_page
;--------------------------------------------------------------------
get_map_phys_ent:
		JMP	get_map_phys_addr2	;

;------ function 26 -------------------------------------------------
; Get expanded memory hardware infomation
;--------------------------------------------------------------------
func26:
		STI				;
		CMP	AL,0			;
		JZ	get_hardware_config	;
		CMP	AL,1			;
		JZ	get_unalloc_raw_page	;
		JMP	err84			;error exit 

;--------------------------------------------------------------------
; Get hardware configration array
; input
;	ES:DI	: hardware_info
; output
;	AH	: status
;--------------------------------------------------------------------
get_hardware_config:
		CMP	OSE_flag,0		;OS/E flag enable?
		JZ	get_hardware_config1	;
		JMP	erra4			;error exit
get_hardware_config1:
		MOV	AX,[BP].es_save		;
		MOV	ES,AX			;
		MOV	AX,RAW_PAGES		;
		STOSW				;
		MOV	AX,ALTER_REGS		;
		STOSW				;
		MOV	AX,CONTEXT_SIZE		;
		STOSW				;
		MOV	AX,DMA_REGS		;
		STOSW				;
		MOV	AX,DMA_CHANNEL		;
		STOSW				;
		JMP	noerr			;exit

;--------------------------------------------------------------------
; Get unallocated raw page count
; output
;	AH	: status
;	BX	: unallocated raw pages
;	DX	: total raw pages
;--------------------------------------------------------------------
get_unalloc_raw_page:
		JMP	func3			;goto function 3

;------ function 27 -------------------------------------------------
; Allocate raw pages
; input
;	BX	: num_of_raw_pages_to_alloc
; output
;	AH	: status
;	DX	: raw handle
;--------------------------------------------------------------------
func27:
		JMP	f41			;goto function 4

;------ function 28 -------------------------------------------------
; Alternate map register set
;--------------------------------------------------------------------
func28:
		STI				;
		CMP	OSE_flag,0		;OS/E flag enable?
		JZ	f280			;
		JMP	erra4			;error exit
f280:
		CMP	AL,0			;
		JNZ	f281			;
		JMP	get_alter_map_reg	;
f281:
		CMP	AL,1			;
		JNZ	f282			;
		JMP	set_alter_map_reg	;
f282:
		CMP	AL,2			;
		JNZ	f283			;
		JMP	get_alter_map_size	;
f283:
		CMP	AL,3			;
		JNZ	f284			;
		JMP	alloc_alter_map_reg	;
f284:
		CMP	AL,4			;
		JNZ	f285			;
		JMP	dealloc_alter_map_reg	;
f285:
		CMP	AL,5			;
		JNZ	f286			;
		JMP	alloc_DMA_reg		;
f286:
		CMP	AL,6			;
		JNZ	f287			;
		JMP	enable_DMA_alter_reg	;
f287:
		CMP	AL,7			;
		JNZ	f288			;
		JMP	disable_DMA_alter_reg	;
f288:
		CMP	AL,8			;
		JNZ	f289			;
		JMP	dealloc_DMA_reg		;
f289:
		JMP	err84			;error exit

;--------------------------------------------------------------------
; Get alternate map register set
; output
;	AH	: status
;	BL	: current active alternate map register set number
;	ES:DI	: pointer to a map register context save area
;--------------------------------------------------------------------
get_alter_map_reg:
		MOV	DI,CS:alter_map_off	;
		MOV	AX,CS:alter_map_seg	;
		MOV	ES,AX			;
		OR	AX,DI			;
		JNZ	get_alter_map_reg1	;
		JMP	get_alter_map_reg2	;
get_alter_map_reg1:
		MOV	SI,OFFSET map_table	;
		PUSH	CS			;
		POP	DS			;
		MOV	CX,CONTEXT_SIZE		;
		REPZ	MOVSB			;
get_alter_map_reg2:
		MOV	DI,CS:alter_map_off	;
		MOV	AX,CS:alter_map_seg	;
		MOV	[BP].di_save,DI		;
		MOV	[BP].es_save,AX		;
		MOV	BX,[BP].bx_save		;
		MOV	BL,0			;
		MOV	[BP].bx_save,BX		;
		JMP	noerr			;exit

;--------------------------------------------------------------------
; Set alternate map register set
; input
;	BL	: new alternate map register set number
;	ES:DI	: pointer to a map register context restore area
; output
;	AH	: status
;--------------------------------------------------------------------
set_alter_map_reg:
		CLI				;
		CMP	BL,0			;
		JZ	set_alter_map_reg1	;
		JMP	err9c			;error exit
set_alter_map_reg1:
		MOV	CS:alter_map_off,DI	;
		MOV	AX,ES			;
		MOV	CS:alter_map_seg,AX	;
		OR	AX,DI			;
		JNZ	set_alter_map_reg2	;
		JMP	noerr			;exit
set_alter_map_reg2:
		MOV	AX,ES			;
		MOV	DS,AX			;
		MOV	SI,DI			;
		MOV	CX,CONTEXT_SIZE		;
		MOV	AX,SS			;
		MOV	ES,AX			;
		LEA	DI,[BP].f28_map_data	;
		REPZ	MOVSB			;
		LEA	DI,[BP].f28_map_data	;
		CALL	check_map_data		;
		JNB	set_alter_map_reg3	;
		JMP	erra3			;error exit
set_alter_map_reg3:
		MOV	SI,DI			;
		MOV	AX,ES			;
		MOV	DS,AX			;
		MOV	CX,CONTEXT_SIZE		;
		MOV	DI,OFFSET map_table	;
		PUSH	CS			;
		POP	ES			;
		PUSH	DI			;
		REPZ	MOVSB			;
		POP	DI			;
		MOV	CX,PHYS_PAGES		;
set_alter_map_reg5:
		MOV	DX,CS:[DI].phys_page_port;mapping physical pages...
		MOV	AL,CS:[DI].log_page_data;
		CALL	emsout			;
		JNB	set_alter_map_reg4	;
		JMP	err81			;error exit
set_alter_map_reg4:
		ADD	DI,SIZE phys_page_struct;
		LOOP	set_alter_map_reg5	;
		JMP	noerr			;exit

;--------------------------------------------------------------------
; Get alternate map save array size
; output
;	AH	: status
;	DX	: size_of_array
;--------------------------------------------------------------------
get_alter_map_size:
		MOV	DX,CONTEXT_SIZE		;
		MOV	[BP].dx_save,DX		;
		JMP	noerr			;exit

;--------------------------------------------------------------------
; Allocate alternate map register set
; output
;	AH	: status
;	BL	: alternate map register set number
;--------------------------------------------------------------------
alloc_alter_map_reg:
		MOV	BL,0			;
		MOV	[BP].bx_save,BX		;
		JMP	noerr			;exit

;--------------------------------------------------------------------
; Deallocate alternate map register set
; input
;	BL	: alternate map register set number
; output
;	AH	: status
;--------------------------------------------------------------------
dealloc_alter_map_reg:
		CMP	BL,0			;
		JZ	dealloc_alter_map_reg1	;
		JMP	err9c			;error exit 
dealloc_alter_map_reg1:
		JMP	noerr			;exit

;--------------------------------------------------------------------
; Allocate DMA register set
; output
;	AH	: status
;	BL	: DMA register set number
;--------------------------------------------------------------------
alloc_DMA_reg:
		MOV	BL,0			;
		MOV	[BP].bx_save,BX		;
		JMP	noerr			;exit

;--------------------------------------------------------------------
; Enable DMA on alternate map register set
; input
;	BL	: DMA register set number
;	DL	: DMA channel number
; output
;	AH	: status
;--------------------------------------------------------------------
enable_DMA_alter_reg:
		CMP	BL,0			;
		JZ	enable_DMA_alter_reg1	;
		JMP	err9c			;error exit 
enable_DMA_alter_reg1:
		JMP	noerr			;exit

;--------------------------------------------------------------------
; Disable DMA on alternate map register set
; input
;	BL	: alternate register set number
; output
;	AH	: status
;--------------------------------------------------------------------
disable_DMA_alter_reg:
		CMP	BL,0			;
		JZ	disable_DMA_alter_reg1	;
		JMP	err9c			;error exit 
disable_DMA_alter_reg1:
		JMP	noerr			;exit

;--------------------------------------------------------------------
; Deallocate DMA register set
; input
;	BL	: DMA register set number
; output
;	AH	: status
;--------------------------------------------------------------------
dealloc_DMA_reg:
		CMP	BL,0			;
		JZ	dealloc_DMA_reg1	;
		JMP	err9c			;error exit 
dealloc_DMA_reg1:
		JMP	noerr			;exit

;------ function 29 -------------------------------------------------
; Prepare expanded memory hardware for warm boot
;--------------------------------------------------------------------
func29:
		MOV	AX,CS			;
		MOV	ES,AX			;
		MOV	DS,AX			;
		MOV	DI,OFFSET map_table	;disable physical pages...
		MOV	CX,PHYS_PAGES		;
f291:						;
		MOV	[DI].emm_handle2,UNMAP	;
		MOV	[DI].log_page_data,0	;
		ADD	DI,SIZE phys_page_struct;
		LOOP	f291			;
		CALL	set_pages_map		;
		JNB	f292			;
		JMP	err81			;error exit
f292:						;
		MOV	DI,OFFSET handle_flag	;clear handles...
		MOV	CX,HANDLE_CNT		;
		XOR	AX,AX			;
		REPZ	STOSW			;
		MOV	DI,OFFSET alloc_page_count;clear handles...
		MOV	CX,HANDLE_CNT		;
		REPZ	STOSW			;
		MOV	DI,OFFSET page_address	;clear handles...
		MOV	CX,HANDLE_CNT		;
		REPZ	STOSW			;
		MOV	DI,OFFSET back_address	;clear handles...
		MOV	CX,HANDLE_CNT		;
		REPZ	STOSW			;
		MOV	DI,OFFSET handle_name	;clear handles...
		MOV	CX,HANDLE_CNT		;
		SHL	CX,1			;
		SHL	CX,1			;
		REPZ	STOSW			;
		MOV	DI,OFFSET alloc_page	;clear logical page buffer...
		MOV	CX,PAGE_MAX		;
		MOV	AX,0FFFFH		;
		REPZ	STOSW			;
		XOR	DI,DI			;set system handle flag...
		MOV	[DI].handle_flag,1	;
		MOV	DI,OFFSET log_page	;unallocate all logical pages..
		MOV	AX,NOT_USE		;
		MOV	CX,PAGE_MAX		;
		REPZ	STOSW			;
		XOR	AX,AX			;
		MOV	handle_count,1		;set active handle count
		MOV	backup_count,AL		;set backup map count
		MOV	AX,total_pages		;
		MOV	un_alloc_pages,AX	;set unallocate page count
		MOV	AX,OFFSET alloc_page	;set page buffer pointer
		MOV	page_ptr,AX		;
		MOV	AX,OFFSET backup_map	;set backup map buffer pointer
		MOV	back_ptr,AX		;
		JMP	noerr			;exit
		
;------ function 30 -------------------------------------------------
; Enable/disable OS/E function set functions
; input
;	BX,CX	: alternate register set number
; output
;	AH	: status
;	BX,CX	: alternate register set number
;--------------------------------------------------------------------
func30:
		STI				;
		CMP	AL,0			;
		JZ	enable_OSE_func		;
		CMP	AL,1			;
		JZ	disable_OSE_func	;
		CMP	AL,2			;
		JZ	return_access_key	;
		JMP	err84			;error exit 

;--------------------------------------------------------------------
; Enable OS/E function set
; input
;	BX,CX	: access_key
; output
;	AH	: status
;	BX,CX	: access_key
;--------------------------------------------------------------------
enable_OSE_func:
		CMP	OSE_fast,0		;OS/E fast access flag enable?
		JZ	enable_OSE_func1	;
		CMP	access_key_h,BX		;compare access key high
		JNZ	enable_OSE_func2	;
		CMP	access_key_l,CX		;compare access key low
		JZ	enable_OSE_func1	;
enable_OSE_func2:
		JMP	erra4			;error exit
enable_OSE_func1:
		MOV	OSE_flag,0		;enable OS/E function
		MOV	OSE_fast,0FFFFH		;set OS/E fast access flag
		MOV	BX,access_key_h		;
		MOV	[BP].bx_save,BX		;
		MOV	CX,access_key_l		;
		MOV	[BP].cx_save,CX		;
		JMP	noerr			;exit

;--------------------------------------------------------------------
; Disable OS/E function set
; input
;	BX,CX	: access_key
; output
;	AH	: status
;	BX,CX	: access_key
;--------------------------------------------------------------------
disable_OSE_func:
		CMP	OSE_fast,0		;OS/E fast access flag enable?
		JZ	disable_OSE_func1	;
		CMP	access_key_h,BX		;compare access key high
		JNZ	disable_OSE_func2	;
		CMP	access_key_l,CX		;compare access key low
		JZ	disable_OSE_func1	;
disable_OSE_func2:
		JMP	erra4			;error exit
disable_OSE_func1:
		MOV	OSE_flag,0FFFFH		;disable OS/E function
		MOV	OSE_fast,0FFFFH		;set OS/E fast access flag
		MOV	BX,access_key_h		;
		MOV	[BP].bx_save,BX		;
		MOV	CX,access_key_l		;
		MOV	[BP].cx_save,CX		;
		JMP	noerr			;exit

;--------------------------------------------------------------------
; Return access key
; input
;	BX,CX	: access_key
; output
;	AH	: status
;--------------------------------------------------------------------
return_access_key:
		CMP	OSE_flag,0		;OS/E flag enable?
		JNZ	return_access_key2	;
		CMP	access_key_h,BX		;compare access key high
		JNZ	return_access_key2	;
		CMP	access_key_l,CX		;compare access key low
		JZ	return_access_key1	;
return_access_key2:
		JMP	erra4			;error exit
return_access_key1:
		MOV	OSE_flag,0		;enable OS/E function
		MOV	OSE_fast,0		;reset OS/E fast access flag
		XOR	AX,AX			;
		MOV	ES,AX			;
		MOV	SI,46CH			;
		MOV	AX,ES:[SI]		;
		ADD	BX,AX			;make access key...
		MOV	access_key_h,BX		;
		MOV	SI,46EH			;
		ADC	AX,ES:[SI]		;
		ADD	CX,AX			;
		MOV	access_key_l,CX		;
		JMP	noerr			;exit

;========================================================================

;--------------------------------------------------------------------
; Check mapping data.
; input
;	ES:DI	: pointer to mapping data
; output
;	CF = 0	: OK
;	CF = 1	: NG
;--------------------------------------------------------------------
check_map_data	PROC	NEAR
		PUSH	AX			;
		PUSH	CX			;
		PUSH	SI			;
		PUSH	DI			;
		MOV	SI,OFFSET map_table	;
		MOV	CX,PHYS_PAGES		;
check_map_data3:
		MOV	AX,ES:[DI].phys_page_port;
		CMP	AX,CS:[SI].phys_page_port;
		JNZ	check_map_data1		;
		MOV	AX,ES:[DI].phys_seg_addr;
		CMP	AX,CS:[SI].phys_seg_addr;
		JNZ	check_map_data1		;
		ADD	SI,SIZE phys_page_struct;
		ADD	DI,SIZE phys_page_struct;
		LOOP	check_map_data3		;
		CLC				;
		JMP	check_map_data2		;
check_map_data1:
		STC				;
check_map_data2:
		POP	DI			;
		POP	SI			;
		POP	CX			;
		POP	AX			;
		RET				;
check_map_data	ENDP

;--------------------------------------------------------------------
; Check logical page no.
; input
;	BX	: logical page number in handle
;	DX	: EMM handle
; output
;	AX	: logical page number in EMM
;	CF = 0	: OK
;	CF = 1	: NG
;--------------------------------------------------------------------
check_log_page 	PROC	NEAR
		PUSH	CX			;v0.6....
		PUSH	SI			;
		MOV	SI,DX			;
		SHL	SI,1			;
		CMP	BX,CS:[SI].alloc_page_count;
		JB	check_log_page1		;
		STC				;
		JMP	check_log_page2		;
check_log_page1:				;
		MOV	SI,CS:[SI].page_address	;
		MOV	AX,BX			;
		SHL	AX,1			;
		ADD	SI,AX			;
		MOV	AX,CS:[SI]		;get logical no. in EMM
		CLC				;
check_log_page2:				;
		POP	SI			;
		POP	CX			;
		RET				;
check_log_page 	ENDP

;--------------------------------------------------------------------
; Check EMM handle no.
; input
;	DX	: EMM handle
; output
;	CF = 0	: OK
;	CF = 1	: NG
;--------------------------------------------------------------------
check_handle 	PROC	NEAR
		PUSH	AX			;
		PUSH	DI			;
		CMP	DX,HANDLE_CNT		;
		JNB	check_handle1		;
		CLC				;reset CF
		MOV	DI,DX			;
		SHL	DI,1			;
		MOV	AX,CS:[DI].handle_flag	;active handle ?
		OR	AX,AX			;
		JNZ	check_handle2		;
check_handle1:					;
		STC				;set CF
check_handle2:					;
		POP	DI			;
		POP	AX			;
		RET				;
check_handle 	ENDP

;--------------------------------------------------------------------
; Set physical page map.
; output
;	CF = 0	: OK
;	CF = 1	: NG
;--------------------------------------------------------------------
set_pages_map	PROC	NEAR
		PUSH	AX			;
		PUSH	CX			;
		PUSH	DX			;
		PUSH	DI			;
		MOV	DI,OFFSET map_table	;
		MOV	CX,PHYS_PAGES		;
set_pages_map2:					;
		MOV	DX,CS:[DI].phys_page_port;mapping physical pages...
		MOV	AL,CS:[DI].log_page_data;
		CALL	emsout			;
		JB	set_pages_map1		;
		ADD	DI,SIZE phys_page_struct;
		LOOP	set_pages_map2		;
		CLC				;
set_pages_map1:					;
		POP	DI			;
		POP	DX			;
		POP	CX			;
		POP	AX			;
		RET				;
set_pages_map	ENDP

;--------------------------------------------------------------------
; Reset physical page.
; input
;	AL	: physical page no.
;--------------------------------------------------------------------
reset_phys_page	PROC	NEAR
		PUSH	AX			;
		PUSH	CX			;
		PUSH	DX			;
		PUSH	DI			;
		XOR	AH,AH			;
		MOV	DI,OFFSET map_table	;
		MOV	CL,SIZE phys_page_struct;
		MUL	CL			;
		ADD	DI,AX			;
		MOV	DX,CS:[DI].phys_page_port;
		MOV	AL,DIS_EMS		;
		CALL	emsout			;
		JB	reset_phys_page1	;error ?
		MOV	CS:[DI].emm_handle2,UNMAP;
		MOV	CS:[DI].log_page_data,AL;logical page no.
reset_phys_page1:				;
		POP	DI			;
		POP	DX			;
		POP	CX			;
		POP	AX			;
		RET
reset_phys_page	ENDP

;--------------------------------------------------------------------
; Set physical page.
; input
;	AL	: physical page no.
;	BX	: logical page no. in EMM (if BX=FFFFH then unmap)
;	DX	: EMM handle
;--------------------------------------------------------------------
set_phys_page	PROC	NEAR
		PUSH	AX			;
		PUSH	CX			;
		PUSH	DX			;
		PUSH	DI			;
		XOR	AH,AH			;
		MOV	DI,OFFSET map_table	;
		MOV	CL,SIZE phys_page_struct;
		MUL	CL			;
		ADD	DI,AX			;
		PUSH	DX			;
		MOV	DX,CS:[DI].phys_page_port;
		MOV	AX,BX			;
		ADD	AL,CS:pageofs		;
		CALL	emsout			;
		POP	DX			;
		JB	set_phys_page1		;error ?
		MOV	CS:[DI].emm_handle2,DX	;handle
		MOV	CS:[DI].log_page_data,AL;logical page no.
set_phys_page1:
		POP	DI			;
		POP	DX			;
		POP	CX			;
		POP	AX			;
		RET				;
set_phys_page	ENDP

;--------------------------------------------------------------------
; Change mappable segment address to physical page number.
; input
;	AX	: mappable segment address
; output
;	AX	: physical page number
;--------------------------------------------------------------------
change_seg_page	PROC	NEAR
		PUSH	BX			;
		PUSH	CX			;
		PUSH	DI			;
		CLC				;reset CF
		XOR	BX,BX			;
		MOV	DI,OFFSET map_table	;
		MOV	CX,PHYS_PAGES		;
change_seg_page2:
		CMP	AX,CS:[DI].phys_seg_addr;
		JZ	change_seg_page1	;
		ADD	DI,SIZE phys_page_struct;
		INC	BX			;
		LOOP	change_seg_page2	;
		STC				;set CF
change_seg_page1:
		MOV	AX,BX			;
		POP	DI			;
		POP	CX			;
		POP	BX			;
		RET				;
change_seg_page	ENDP

;--------------------------------------------------------------------
; Output EMS i/o port.
; input
;	DX	: i/o port address
;	AL	: output data
; output
;	CF = 0	: OK
;	CF = 1	: NG
;--------------------------------------------------------------------
emsout		PROC	NEAR
		PUSH	AX			;
		PUSH	CX			;
		PUSH	DX			;
		OUT	DX,AL			;
		MOV	CX,1000			;
		MOV	DX,CS:emsio		;get EMS status port address.
emsout2:					;
		IN	AL,DX			;
		TEST	AL,80H			;check TRS flag
		JZ	emsout1			;
		LOOP	emsout2			;
		INC	DX			; 00 -> EMS REGISTER R1...
		XOR	AL,AL			;
		OUT	DX,AL			;
		STC				;set CF
		JMP	emsout3			;
emsout1:					;
		INC	DX			; 00 -> EMS REGISTER R1...
		XOR	AL,AL			;
		OUT	DX,AL			;
		CLC				;reset CF
emsout3:					;
		POP	DX			;
		POP	CX			;
		POP	AX			;
		RET				;
emsout		ENDP

;.........................................................................

;--------------------------------------------------------------------
;	EMM driver work data area
;--------------------------------------------------------------------
emsio		LABEL	WORD
ems_io		DW	98H		;EMS i/o port address
pageofs		DB	?		;logical page no. offset data
backup_count	DB	0		;mapping data backup count
OSE_flag	DW	0		;OS/E function enable flag
OSE_fast	DW	0		;OS/E fast access flag
access_key_h	DW	0		;OS/E access key high
access_key_l	DW	0		;OS/E access key low
alter_map	LABEL	DWORD
alter_map_off	DW	0		;
alter_map_seg	DW	0		;
page_ptr	DW	alloc_page	;allocate page buffer pointer.
back_ptr	DW	backup_map	;backup map buffer pointer.

;
;	i/o port address buffer
;
port_addr	LABEL	WORD
		DW	PHYS_PAGES DUP (-1)

;
;	physical page status data area
;
map_table	LABEL	phys_page_struct
		DB	SIZE phys_page_struct * PHYS_PAGES DUP (-1)

;
;	handle name buffer
;
handle_name	LABEL	BYTE
		DB	HANDLE_NAME_SIZE * HANDLE_CNT DUP (0)

;
;	handle status flag buffer pointers (handle)
;
handle_flag	LABEL	WORD
		DW	HANDLE_CNT DUP(0)

;
;	allocate page count buffer pointers (handle)
;
alloc_page_count LABEL	WORD
		DW	HANDLE_CNT DUP(0)

;
;	mapping data backup buffer pointers (handle)
;
back_address	LABEL	WORD
		DW	HANDLE_CNT DUP(0)

;
;	mapping data backup area
;
backup_map	LABEL	WORD
		DB	SIZE phys_page_struct * PHYS_PAGES * BACK_MAX DUP(-1)

;
;	allocate pages buffer pointers (handle)
;
page_address	LABEL	WORD
		DW	HANDLE_CNT DUP(0)

;
;	allocate data area
;
alloc_page	LABEL	WORD
		DW	PAGE_MAX DUP(-1)

;
;	logical page kanri data
;	55AAH:not used , 0 - 254:used , FFFFH:bad or non
;
log_page	LABEL	WORD
		DB	LOG_SIZE * PAGE_MAX DUP (-1)

;********************************************************************

;--------------------------------------------------------------------
; EMM driver initilize program
;--------------------------------------------------------------------
emminit:
		PUSH	CX			;Store registers...
		PUSH	DX			;
		PUSH	SI			;
		PUSH	ES			;
		PUSH	BP			;
		PUSH	CS			;
		POP	DS			;
		XOR	AX,AX			;
		MOV	ES,AX			;
		MOV	SI,19CH			;
		MOV	WORD PTR ES:[SI],OFFSET int67;set int67 offset.
		MOV	ES:[SI+2],CS		;set int67 segment.
		MOV	SI,OFFSET start_msg	;display start messege.
		CALL	strdsp			;
		CALL	getprm			;get parameters
		CALL	ckemsio			;check EMS i/o port
		JB	errems			;error ?
		CALL	ramchk			;check EMS memory
		JB	errems			;error ?
		CALL	instmsg			;display install message.
		XOR	AX,AX			;
		MOV	ES,AX			;
		MOV	SI,46CH			;
		MOV	AX,ES:[SI]		;
		ADD	BX,AX			;make access key...
		MOV	access_key_h,BX		;
		MOV	SI,46EH			;
		ADC	AX,ES:[SI]		;
		ADD	BX,AX			;
		MOV	access_key_l,BX		;
		XOR	DI,DI			;set system handle...
		PUSH	CS			;
		POP	ES			;
		MOV	ES:[DI].handle_flag,1	;set system handle active.
		INC	CS:handle_count		;handle count up
		MOV	AX,OFFSET emminit	;make break address...
		ADD	AX,0FH			;
		MOV	CL,4			;
		SHR	AX,CL			;
		MOV	CX,AX			;
		MOV	AX,CS			;
		ADD	AX,CX			;
		MOV	emm_flag,1		;set EMM install flag.
		LDS	BX,ptrsav		;
		MOV	[BX].brkoff,0		;break address offset set.
		MOV	[BX].brkseg,AX		;break address segment set.
		JMP	emmint1			;
errems:						;
		MOV	SI,OFFSET notinst	;display error message
		CALL	strdsp			;
		MOV	emm_flag,0		;reset EMM install flag.
		PUSH	CS			;
		POP	ES			;
		MOV	DI,OFFSET func_table	;
		MOV	AX,OFFSET err80		;
		MOV	CX,30			;
		REPZ	STOSW			;
		LDS	BX,ptrsav		;
		MOV	AX,OFFSET func2		;set break address offset.
		MOV	[BX].brkoff,AX		;set break address offset.
		MOV	[BX].brkseg,CS		;set break address segment.
emmint1:					;
		POP	BP			;Restore registers...
		POP	ES			;
		POP	SI			;
		POP	DX			;
		POP	CX			;
		JMP	exit			;exit initial program.

;--------------------------------------------------------------------
; Get CONFIG.SYS parameters.
;--------------------------------------------------------------------
getprm		PROC	NEAR
		PUSH	DS		;
		INT	12H		;get system memory size.
		MOV	sysmem,AX	;
		LES	BX,ptrsav	;
		MOV	DI,ES:[BX].count;
		MOV	AX,ES:[BX].start;
		MOV	ES,AX		;
		XOR	CL,CL		;
getpr2:					;
		MOV	AL,ES:[DI]	;
		CMP	AL,'/'		;option switch?
		JNZ	getpr3		;
		INC	DI		;
		MOV	AL,ES:[DI]	;
		CMP	AL,'M'		;set system memory size?
		JNZ	getpr1		;
		INC	DI		;
		MOV	AL,ES:[DI]	;
		CMP	AL,':'		;
		JNZ	getpr3		;
		INC	DI		;
		CALL	ascbin1		;change data ascii -> binary.
		JB	getpr5		;
		MOV	sysmem,AX	;set system memory size data.
		JMP	getpr5		;next.
getpr1:					;
		CMP	AL,'P'		;set page frame address?
		JNZ	getpr3		;
		INC	DI		;
		MOV	AL,ES:[DI]	;
		CMP	AL,':'		;
		JNZ	getpr1		;
		INC	DI		;
		CALL	ascbin2		;change data ascii -> binary.
		JNB	getpr8		;error ?
		JMP	getpr5		;
getpr8:					;
		MOV	pageseg,AX	;
		MOV	page_frame_seg,AX;
		OR	CL,2		;set page frame address change flag.
		JMP	getpr5		;
getpr3:					;
		CMP	AL,'I'		;set EMS i/o port address?
		JNZ	getpr6		;
		INC	DI		;
		MOV	AL,ES:[DI]	;
		CMP	AL,':'		;
		JNZ	getpr1		;
		INC	DI		;
		CALL	ascbin2		;change data ascii -> binary.
		MOV	rqioadr,AX	;
		MOV	emsio,AX	;
		OR	CL,1		;set EMS i/o port address change flag.
		JMP	getpr5		;
getpr6:					;
		CMP	AL,CR		;
		JZ	getpr4		;
getpr5:					;
		INC	DI		;
		JMP	getpr2		;
getpr4:					;
		MOV	sysflg,CL	;set system option flag.
		POP	DS		;
		RET			;
getprm		ENDP

;--------------------------------------------------------------------
; Check EMS i/o port.
; output
;	cf = 0 : OK
;	cf = 1 : NG
;--------------------------------------------------------------------
ckemsio		PROC	NEAR
		MOV	DX,EMSIOA		;
		MOV	AL,CHKIOA		;
		OUT	DX,AL			;
		IN	AL,DX			;
		TEST	AL,80H			;check TRS flag
		JNZ	ckems7			;
		MOV	AL,CHKIOA		;
		OUT	DX,AL			;
		IN	AL,DX			;
		TEST	AL,80H			;check TRS flag
		JZ	ckems1			;
ckems7:						;
		MOV	CX,1000			;
ckems5:						;
		IN	AL,DX			;
		TEST	AL,80H			;check TRS flag
		JZ	ckems6			;
		LOOP	ckems5			;
		JMP	ckems1			;
ckems6:						;
		MOV	BL,CHKIOA		;
		AND	BL,7FH			;
		CMP	AL,BL			;
		JZ	ckems2			;
ckems1:						;
		MOV	DX,EMSIOB		;
		MOV	AL,CHKIOB		;
		OUT	DX,AL			;
		IN	AL,DX			;
		TEST	AL,80H			;check TRS flag
		JNZ	ckems8			;
		MOV	AL,CHKIOB		;
		OUT	DX,AL			;
		IN	AL,DX			;
		TEST	AL,80H			;check TRS flag
		JZ	ckems3			;
ckems8:						;
		MOV	CX,1000			;
ckems9:						;
		IN	AL,DX			;
		TEST	AL,80H			;check TRS flag
		JZ	ckemsa			;
		LOOP	ckems9			;
		JMP	ckems3			;
ckemsa:						;
		MOV	BL,CHKIOB		;
		AND	BL,7FH			;
		CMP	AL,BL			;
		JNZ	ckems3			;
ckems2:						;
		MOV	CS:emsio,DX		;set i/o port address.
		TEST	BYTE PTR CS:sysflg,1	;
		JZ	ckems4			;
		MOV	AX,CS:rqioadr		;
		MOV	BX,AX			;change EMS i/o port addess.
		MOV	DX,CS:emsio		;
		MOV	CL,3			;
		SHR	AX,CL			;
		OR	AL,80H			;
		CALL	emsout			;
		MOV	CS:emsio,BX		;
ckems4:						;
		CLC				;reset CF
		RET				;
ckems3:						;
		MOV	SI,OFFSET hard_w_err	;display wardware error messege.
		CALL	strdsp			;
		STC				;set CF
		RET				;
ckemsio		ENDP

;--------------------------------------------------------------------
; Check system memory size.
;--------------------------------------------------------------------
sysram		PROC	NEAR
		PUSH	CS			;
		POP	DS			;
		PUSH	ES			;
		XOR	AX,AX			;set system memory size.
		MOV	ES,AX			;
		MOV	AX,sysmem		;
		CMP	ES:WORD PTR MEMSIZE,AX	;memory size same ?
		JZ	sysram1			;
		MOV	ES:WORD PTR MEMSIZE,AX	;
		INT	19H			;reboot...
sysram1:					;
		POP	ES			;
		MOV	BX,40H			;
		MUL	BX			;
		MOV	DX,emsio		;
		ADD	DX,2			;
		MOV	AL,AH			;
		CALL	emsout			;output EMS i/o port data.
		SHR	AL,1			;
		SHR	AL,1			;
		MOV	pageofs,AL		;set page no. offset data
		MOV	DX,STATSEG 		;;;v1.01
		RET				;
sysram		ENDP

;--------------------------------------------------------------------
; Check expanded memory.
; output
;	cf = 0 : OK
;	cf = 1 : NG
;--------------------------------------------------------------------
ramchk		PROC	NEAR
		PUSH	AX			;
		PUSH	BX			;
		PUSH	CX			;
		PUSH	DX			;
		PUSH	BP			;
		PUSH	CS			;
		POP	DS			;
		MOV	SI,OFFSET port_addr	;set phys_page i/o port address
		MOV	DI,OFFSET map_table	;
		MOV	CX,PHYS_PAGES		;
		MOV	BX,emsio		;
		ADD	BX,4			;
ramch14:					;
		MOV	[SI],BX			;
		MOV	[DI].phys_page_port,BX	;
		MOV	[DI].log_page_data,0	;
		ADD	DI,SIZE phys_page_struct;
		MOV	DX,BX			;disable physical pages ---
		MOV	AL,DIS_EMS		;
		CALL	emsout			;--------------------------
		INC	SI			;
		INC	SI			;
		INC	BX			;
		LOOP	ramch14			;------------------------------
		CALL	SYSRAM    		;set system memory size
		XOR	SI,SI			;
ramch4:						;found 64KB free area...
		MOV	BP,DX			;
		XOR	BX,BX			;
ramch6:						;
		MOV	ES,DX			;
		MOV	WORD PTR ES:[SI],0000H	;
		CMP	WORD PTR ES:[SI],0AA55H	;
		JNZ	ckrom1			;
		XOR	AH,AH			;
		MOV	AL,ES:[SI+2]		;
		MOV	CL,5			;
		SHL	AX,CL			;
		ADD	DX,AX			;
		JMP	ramch1			;
ckrom1:
		OR	BX,BX			;
		JNZ	ckrom2			;
		MOV	AX,DX			;
		AND	AX,3FFH			;
		OR	AX,AX			;
		JZ	ckrom5			;
		AND	DX,0FC00H		;
		ADD	DX,400H			;
		JMP	ramch4			;
ckrom2:
		ADD	DX,80H			;
ckrom5:
		MOV	WORD PTR ES:[SI],55AAH	;
		CMP	WORD PTR ES:[SI],55AAH	;
		JZ	ramch1			;
		INC	BX			;
		CMP	BX,20H			;
		JNB	ramch2			;
		CMP	DX,ROMSEG		;
		JB	ramch6			;
		JMP	ramch3			;
ramch1:						;
		CMP	DX,ENDSEG		;
		JB	ramch4			;
ramch3:						;
		PUSH	CS			;
		POP	DS			;
		MOV	SI,OFFSET nomem		;
		CALL	strdsp			;
		STC				;
		JMP	ramch5			;........................
ramch2:						;
		PUSH	CS			;
		POP	DS			;
		MOV	AX,BP			;
		MOV	page_frame_seg,AX	;
		TEST	BYTE PTR sysflg,2	;
		JZ	ramch12			;
		MOV	AX,pageseg		;physical page segment set
		MOV	page_frame_seg,AX	;------------------------------
ramch12:					;
		MOV	AX,page_frame_seg	;segment start address set
		MOV	AL,AH			;
		MOV	DX,emsio		;
		ADD	DX,3			;
		CALL	emsout			;EMS i/o port data out
		MOV	DI,OFFSET map_table	;set physical page frame address
		MOV	CX,PHYS_PAGES		;
		MOV	AX,page_frame_seg	;+
ramch18:					;+
		MOV	[DI].phys_seg_addr,AX	;+
		ADD	DI,SIZE phys_page_struct;+
		ADD	AX,0400H		;+
		LOOP	ramch18			;------------------------------
		MOV	SI,OFFSET pagemsg	;display page test msg..
		CALL	strdsp			;
		IN	AL,I8042+1		;logical page test...
		OR	AL,4			;system memory parity disable
		OUT	I8042+1,AL		;
		MOV	SI,OFFSET port_addr	;
		MOV	DI,OFFSET log_page	;
		MOV	DX,[SI]			;
		CMP	DX,0FFFFH		;
		JZ	ramch7			;
		XOR	AH,AH			;
		MOV	AL,pageofs		;get EMS logical page start no.
		MOV	CX,PAGE_MAX		;
		XOR	BX,BX			;
ramch9:						;
		PUSH	CX			;
		CALL	emsout			;EMS i/o port data out
		CALL	imgchk			;
		JNB	ramch17			;
		POP	CX			;
		JMP	ramch16			;
ramch17:					;
		CALL	pagetst			;
		JB	ramch8			;
		MOV	[DI],NOT_USE		;
		INC	BX			;
		ADD	DI,LOG_SIZE		;
ramch8:						;
		POP	CX			;
		INC	AL			;
		LOOP	ramch9			;
ramch16:					;
		MOV	total_pages,BX		;
		MOV	un_alloc_pages,BX	;
		MOV	CX,PHYS_PAGES		;disable physical pages...
		MOV	DX,CS:emsio		;
		ADD	DX,4			;
ramch19:
		MOV	AL,DIS_EMS		;
		CALL	emsout			;
		INC	DX			;
		LOOP	ramch19			;
		IN	AL,I8042+1		;enable system memory parity..
		AND	AL,0FBH			;
		OUT	I8042+1,AL		;
		CMP	total_pages,0		;total page zero?
		JNZ	ramch7			;
		MOV	SI,OFFSET nopage_err	;error message display
		CALL	strdsp			;
		STC				;set CF
		JMP	ramch5			;
ramch7:						;
		CLC				;
ramch5:						;
		POP	BP			;
		POP	DX			;
		POP	CX			;
		POP	BX			;
		POP	AX			;
		RET				;
ramchk		ENDP

;--------------------------------------------------------------------
; Display EMM install opening message.
;--------------------------------------------------------------------
instmsg		PROC	NEAR
		PUSH	AX			;
		PUSH	BX			;
		PUSH	CX			;
		PUSH	DI			;
		PUSH	CS			;
		POP	ES			;
		MOV	SI,OFFSET openmsg	;
		CALL	strdsp			;
		MOV	AX,total_pages		;
		MOV	DI,OFFSET total_pg	;
		CALL	dbinasc			;
		MOV	SI,OFFSET install_msg	;
		CALL	strdsp			;
		MOV	AX,page_frame_seg	;
		MOV	DI,OFFSET segadr	;
		CALL	hbinasc			;
		MOV	SI,OFFSET page_msg	;
		CALL	strdsp			;
		MOV	AX,emsio		;
		MOV	DI,OFFSET pioadr	;
		CALL	hbinasc			;
		MOV	SI,OFFSET port_msg	;
		CALL	strdsp			;
		POP	DI			;
		POP	CX			;
		POP	BX			;
		POP	AX			;
		RET				;
instmsg		ENDP

;--------------------------------------------------------------------
; check memory size (1024 KByte)
;--------------------------------------------------------------------
imgchk		PROC	NEAR
		CLD				;
		PUSH	AX			;
		PUSH	CX			;
		PUSH	SI			;
		PUSH	DI			;
		PUSH	DS			;
		MOV	AX,page_frame_seg	;
		MOV	ES,AX			;
		PUSH	CX			;
		XOR	AX,AX			;
		MOV	DS,AX			;
		XOR	SI,SI			;
		XOR	DI,DI			;
		MOV	CX,2000H		;
		REPZ	CMPSW			;
		CMP	CX,0			;
		JNZ	imgch1			;
		POP	CX			;
		STC				;
		JMP	imgch3			;
imgch1:
		POP	CX			;
		CLC				;reset CF
imgch3:
		POP	DS			;
		POP	DI			;
		POP	SI			;
		POP	CX			;
		POP	AX			;
		RET				;
imgchk		ENDP

;--------------------------------------------------------------------
; check logical page memory.
; input
;	AX	: logical page no.
;--------------------------------------------------------------------
pagetst		PROC	NEAR
		CLD				;reset DF
		PUSH	AX			;push registers...
		PUSH	BX			;
		PUSH	CX			;
		PUSH	DX			;
		PUSH	SI			;
		PUSH	DI			;
		PUSH	DS			;
		PUSH	CS			;set ES <- CS..
		POP	ES			;
		SUB	AL,pageofs		;sub page no. - page offset.
		MOV	DI,OFFSET tstpage	;
		CALL	dbinasc			;change binary -> ascii.
		MOV	SI,OFFSET tstpage	;display message..
		CALL	strdsp			;
		MOV	AX,page_frame_seg	;set page frame address -> ES..
		MOV	ES,AX			;
		PUSH	CX			;
		XOR	AX,AX			;check 0:0 image data in page_
		MOV	DS,AX			;frame...
		XOR	SI,SI			;
		XOR	DI,DI			;
		MOV	CX,2000H		;
		REPZ	CMPSW			;
		CMP	CX,0			;check ok?
		JZ	pagets2			;
		PUSH	CS			;
		POP	DS			;
		MOV	BX,OFFSET chkchr	;fill pattan data...
		MOV	AX,CS:[BX]		;
		XOR	DI,DI			;
		MOV	CX,2000H		;
		REPZ	STOSW			;
		MOV	CX,2000H		;check pattan data...
		XOR	DI,DI			;
		REPZ	SCASW			;
		CMP	CX,0			;check ok?
		JZ	pagets1			;
pagets2:
		POP	CX			;pop CX
		STC				;set CF
		JMP	pagets3			;
pagets1:
		XOR	AX,AX			;clear expand memory...
		XOR	DI,DI			;
		MOV	CX,2000H		;
		REPZ	STOSW			;
		POP	CX			;pop CX
		CLC				;reset CF
pagets3:
		POP	DS			;pop registers...
		POP	DI			;
		POP	SI			;
		POP	DX			;
		POP	CX			;
		POP	BX			;
		POP	AX			;
		RET				;return.
pagetst		ENDP

;--------------------------------------------------------------------
; Change data BYNARY -> ASCII (DEC)
; input
;	AX	: binary data
; output
;	ES:DI	: ascii data (DEC)
;--------------------------------------------------------------------
dbinasc:
		PUSH	AX
		PUSH	BX
		PUSH	CX
		PUSH	DX
		PUSH	SI
		MOV	SI,DI
		MOV	CX,4
		MOV	BX,1000
		XOR	DX,DX
dbinas1:
		DIV	BX
		OR	AL,AL
		JNZ	dbinas2
		CMP	CL,4
		JZ	dbinas4
		CMP	BYTE PTR [SI],' '
		JNZ	dbinas2
dbinas4:
		MOV	AL,' '
		CMP	CL,1
		JNZ	dbinas3
		XOR	AL,AL
dbinas2:
		ADD	AL,'0'
dbinas3:
		MOV	SI,DI
		STOSB
		PUSH	DX
		XOR	DX,DX
		MOV	AX,BX
		MOV	BX,10
		DIV	BX
		MOV	BX,AX
		POP	AX
		LOOP	dbinas1
		POP	SI
		POP	DX
		POP	CX
		POP	BX
		POP	AX
		DEC	DI
		RET

;--------------------------------------------------------------------
; Change data BYNARY -> ASCII (HEX)
; input
;	AX	: binary data
; output
;	ES:DI	: ascii data (HEX)
;--------------------------------------------------------------------
hbinasc:
		PUSH	AX
		PUSH	BX
		PUSH	CX
		PUSH	DX
		PUSH	SI
		MOV	SI,DI
		MOV	CX,4
		MOV	BX,1000H
		XOR	DX,DX
hbinas1:
		DIV	BX
		CMP	AL,10
		JB	hbinas2
		ADD	AL,7
hbinas2:
		ADD	AL,'0'
hbinas3:
		MOV	SI,DI
		STOSB
		PUSH	DX
		XOR	DX,DX
		MOV	AX,BX
		MOV	BX,10H
		DIV	BX
		MOV	BX,AX
		POP	AX
		LOOP	hbinas1
		POP	SI
		POP	DX
		POP	CX
		POP	BX
		POP	AX
		DEC	DI
		RET

;--------------------------------------------------------------------
; Change data ASCII (DEC) -> BINARY
; input
;	ES:DI = ascii data address (DEC)
; output
;	AX = binary data
;--------------------------------------------------------------------
ascbin1:
		PUSH	BX
		PUSH	CX
		PUSH	DX
		XOR	DL,DL
		MOV	CX,4
		XOR	BX,BX
ascbin11:
		MOV	AL,ES:[DI]
		CMP	AL,' '
		JZ	ascbin13
		CMP	AL,TAB
		JNZ	ascbin14
ascbin13:
		OR	DL,DL
		JNZ	ascbin12
		INC	DI
		JMP	ascbin11
ascbin12:
		OR	DL,DL
		JNZ	ascbin16
		STC
		JMP	ascbin15
ascbin14:
		CMP	AL,'0'
		JB	ascbin12
		CMP	AL,':'
		JNB	ascbin12
		MOV	DL,1
		SUB	AL,'0'
		XOR	AH,AH
		XCHG	BX,AX
		PUSH	DX
		MOV	DX,10
		MUL	DX
		ADD	BX,AX
		POP	DX
		INC	DI
		LOOP	ascbin11
ascbin16:
		MOV	AX,BX
		CLC
ascbin15:
		POP	DX
		POP	CX
		POP	BX
		RET

;--------------------------------------------------------------------
; Change data ASCII (HEX) -> BINARY
; input
;	ES:DI = ascii data address (HEX)
; output
;	AX = binary data
;--------------------------------------------------------------------
ascbin2:
		PUSH	BX
		PUSH	CX
		PUSH	DX
		XOR	DL,DL
		MOV	CX,4
		XOR	BX,BX
ascbin21:
		MOV	AL,ES:[DI]
		CMP	AL,' '
		JZ	ascbin23
		CMP	AL,TAB
		JNZ	ascbin24
ascbin23:
		OR	DL,DL
		JNZ	ascbin22
		INC	DI
		JMP	ascbin21
ascbin22:
		OR	DL,DL
		JNZ	ascbin27
		STC
		JMP	ascbin25
ascbin24:
		CMP	AL,'0'
		JB	ascbin22
		CMP	AL,':'
		JB	ascbin26
		CMP	AL,'A'
		JB	ascbin22
		CMP	AL,'G'
		JNB	ascbin22
		SUB	AL,7
ascbin26:
		MOV	DL,1
		SUB	AL,'0'
		XOR	AH,AH
		XCHG	BX,AX
		PUSH	DX
		MOV	DX,10H
		MUL	DX
		ADD	BX,AX
		POP	DX
		INC	DI
		LOOP	ascbin21
ascbin27:
		MOV	AX,BX
		CLC
ascbin25:
		POP	DX
		POP	CX
		POP	BX
		RET

;--------------------------------------------------------------------
; STRINGS DISPLAY SUB
; input
;	DS:SI	: strings datas
;--------------------------------------------------------------------
strdsp:
		PUSH	AX			;
		PUSH	DX			;
		PUSH	ES			;
		PUSH	CS			;
		POP	ES			;
		MOV	DX,SI			;
		MOV	AH,9			;
		INT	21H			;bdos call
		POP	ES			;
		POP	DX			;
		POP	AX			;
		RET				;

;____________________________________________________________________

;--------------------------------------------------------------------
;	EMM driver initial routine work data area
;--------------------------------------------------------------------
openmsg		DB	CR
		DB	'SUNTAC-62 Chip Set EMS Driver Version 4.0',CR,LF
		DB	'SUN ELECTRONICS CORP. 1988    Release 1.0',CR,LF
		DB	'          -- ONLY EVALUATION --          ',CR,LF
		DB	'             SAMPLE PROGRAM              ',CR,LF
		DB	'$'
install_msg	DB	'EMM Total Pages  : '
total_pg	DB	'0000',CR,LF,'$'
page_msg	DB	'EMM Page Segment : '
segadr		DB	'0000H',CR,LF,'$'
port_msg	DB	'EMM Port Address : '
pioadr		DB	'0000H',CR,LF,LF,'$'
start_msg	DB	'SUNTAC-62 Chip Set EMS Driver Version 4.0 Release 1.0'
		DB	' -- ONLY EVALUATION --'
		DB	CR,LF,LF,'$'
hard_w_err	DB	'EMS HARDWARE NOT FOUND !',CR,LF,'$'
nopage_err	DB	'EMS LOGICAL PAGE NOT FOUND !',CR,LF,'$'
notinst		DB	'EMM DRIVER FAIL TO INSTALL ABORTED !',CR,LF,'$'
nomem		DB	'NO FREE MEMORY SEGMENT, EMM DRIVER CAN NOT INSTALL !'
		DB	CR,LF,'$'
pagemsg		DB	'0000 PAGES TESTING',CR,'$'
tstpage		DB	'0000',CR,'$'
pageseg		DW	0	;physical page segment
rqioadr		DW	0	;request EMS i/o port address
sysflg		DB	0	;system option flag
sysmem		DW	0	;system memory size
chkchr		DW	55AAH

code		ENDS
		END
