/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.hid;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.communication.SSLWrapper;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import com.ami.kvm.jviewer.hid.HIDCtrlReader;
import com.ami.kvm.jviewer.hid.KVMClient;
import com.ami.kvm.jviewer.hid.KVMReader;
import com.ami.kvm.jviewer.kvmpkts.IVTPPktHdr;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import javax.swing.JOptionPane;

public class HIDHeaderReader
implements KVMReader {
    private KVMClient m_client;
    private byte[] m_hdrBuf;
    private ByteBuffer m_hdrByteBuf;
    private IVTPPktHdr m_pktHdr;
    private int m_hdrIx;

    public HIDHeaderReader(KVMClient client) {
        this.m_client = client;
        this.m_hdrBuf = new byte[7];
        this.m_hdrByteBuf = ByteBuffer.wrap(this.m_hdrBuf);
        this.m_pktHdr = new IVTPPktHdr();
        this.m_hdrIx = 0;
    }

    @Override
    public void initialize() {
        this.m_hdrIx = 0;
        this.m_hdrByteBuf.clear();
    }

    @Override
    public int read(SocketChannel sockCh, SSLWrapper ssl_wrapper) {
        try {
            this.m_hdrIx = ssl_wrapper != null ? (this.m_hdrIx += ssl_wrapper.GetBytes(this.m_hdrByteBuf)) : (this.m_hdrIx += sockCh.read(this.m_hdrByteBuf));
            if (7 <= this.m_hdrIx) {
                this.m_pktHdr.set(this.m_hdrByteBuf);
                this.m_client.m_HIDpktHdr = this.m_pktHdr;
                if (this.m_pktHdr.pktSize > 0) {
                    HIDCtrlReader reader = this.m_client.getHIDCtrlReader();
                    reader.initialize();
                    this.m_client.setHIDState(reader);
                } else {
                    this.m_client.onHIDPacket();
                    HIDHeaderReader reader = this.m_client.getHIDHdrReader();
                    reader.initialize();
                    this.m_client.setHIDState(reader);
                }
            }
        }
        catch (Exception e) {
            Debug.out.println("HID_HDR_RDR " + e);
            JOptionPane.showMessageDialog(null, LocaleStrings.GetString("H_1_HR"), LocaleStrings.GetString("A_1_GLOBAL"), 0);
            return -1;
        }
        return 0;
    }
}

