/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;

public class AlertPolicyTable {
    private byte entryNumber;
    private byte policyNumber;
    private byte policy;
    private byte channel;
    private byte destination;
    private byte alertStringKey;
    private boolean isEnable;

    public byte[] toRaw() {
        byte[] raw = new byte[4];
        raw[0] = this.entryNumber;
        byte temp = (byte)(this.policyNumber << 4);
        temp = this.isEnable ? (byte)(temp | 8) : temp;
        raw[1] = temp = (byte)(temp | this.policy);
        temp = 0;
        temp = (byte)(this.channel << 4);
        raw[2] = temp = (byte)(temp | this.destination);
        raw[3] = this.alertStringKey;
        return raw;
    }

    public boolean fromRaw(byte[] raw) {
        if (raw.length != 4) {
            return false;
        }
        this.entryNumber = raw[0];
        this.policyNumber = (byte)((0xFF & raw[1]) >> 4);
        this.policy = (byte)(raw[1] & 7);
        this.isEnable = (raw[1] & 8) > 0;
        this.channel = (byte)((0xFF & raw[2]) >> 4);
        this.destination = (byte)(raw[2] & 0xF);
        this.alertStringKey = raw[3];
        System.out.println("Araw = " + ByteUtility.bytesToHex(raw));
        return true;
    }

    public void setPolicyNumber(byte policyNumber) {
        this.policyNumber = policyNumber;
    }

    public void setPolicy(byte policy) {
        this.policy = policy;
    }

    public void setChannel(byte channel) {
        this.channel = channel;
    }

    public void setDestination(byte destination) {
        this.destination = destination;
    }

    public void setAlertStringKey(byte alertStringKey) {
        this.alertStringKey = alertStringKey;
    }

    public void setEntryNumber(byte entryNumber) {
        this.entryNumber = entryNumber;
    }

    public void setIsEnable(boolean isEnable) {
        this.isEnable = isEnable;
    }

    public byte getPolicy() {
        return this.policy;
    }

    public byte getDestination() {
        return this.destination;
    }

    public byte getAlertStringKey() {
        return this.alertStringKey;
    }

    public byte getEntryNumber() {
        return this.entryNumber;
    }

    public byte getChannel() {
        return this.channel;
    }

    public byte getPolicyNumber() {
        return this.policyNumber;
    }

    public boolean isIsEnable() {
        return this.isEnable;
    }
}

