/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.DeviceInfo;
import com.supermicro.ipmi.IPMIGlobalCommand;
import com.supermicro.ipmi.IPMII2CPMBusCommand;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMIOEMCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class IPMIOEMSummary
extends SuperBladeCommand {
    @Override
    public void runCommand() throws Exception {
        byte numberFrom3021;
        String cpld;
        IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(null);
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(null);
        IPMIInterface ipmiInterface = this.ipmiCMMOEMCommand.getIPMIInterface();
        IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(ipmiInterface);
        byte[] guid = ipmiMessagingCommand.getSystemGUID();
        if (!IPMIMessagingCommand.isSupportedIPMISummary(guid)) {
            MOut.G(this).println("Not supported device for this command");
            this.statusCode = 153;
            return;
        }
        ipmiOEMCommand.setIPMIInterface(ipmiInterface);
        IPMIGlobalCommand ipmiGlobalCommand = new IPMIGlobalCommand(ipmiInterface);
        ipmiLanCommand.setIPMIInterface(ipmiInterface);
        IPMII2CPMBusCommand ipmii2cPMBusCommand = new IPMII2CPMBusCommand(null);
        ipmii2cPMBusCommand.setIPMIInterface(ipmiInterface);
        DeviceInfo deviceInfo = ipmiGlobalCommand.getDevice();
        MOut.G(this).println("Summary");
        MOut.G(this).println("-------------------------------------------");
        MOut.G(this).println("IP                     : " + ipmiLanCommand.getIP());
        MOut.G(this).println("BMC MAC Address        : " + ipmiLanCommand.getMAC());
        MOut.G(this).println("Firmware Revision      : " + deviceInfo.firmwareRevision1 + "." + ByteUtility.byteToHex(deviceInfo.firmwareRevision2));
        byte[] bytes = ipmiOEMCommand.getFirmwareBuild();
        String s = new String(bytes);
        char c = s.toCharArray()[0];
        if (bytes != null && c != '\u0000') {
            MOut.G(this).println("Firmware Build Time    : " + ByteUtility.transferDateFormat(s));
        }
        bytes = ipmiOEMCommand.getBiosVer();
        s = new String(bytes);
        c = s.toCharArray()[0];
        if (bytes != null && c != '\u0000') {
            MOut.G(this).println("BIOS Version           : " + s);
        }
        if ((bytes = ipmiOEMCommand.getBiosDate()) != null) {
            s = new String(bytes);
            c = s.toCharArray()[0];
        }
        if (bytes != null && c != '\u0000') {
            MOut.G(this).println("BIOS Build Time        : " + s);
        }
        if ((cpld = ipmii2cPMBusCommand.getCPLDversion()) != null) {
            MOut.G(this).println("CPLD Version           : " + cpld);
        }
        if ((numberFrom3021 = ipmiOEMCommand.getNumberOfMacBy3021()) == 0) {
            return;
        }
        bytes = ipmiOEMCommand.getSystemMACAddress();
        if (bytes != null) {
            MOut.G(this).println("System LAN1 MAC Address: " + ByteUtility.byteToHex(bytes[0]) + ":" + ByteUtility.byteToHex(bytes[1]) + ":" + ByteUtility.byteToHex(bytes[2]) + ":" + ByteUtility.byteToHex(bytes[3]) + ":" + ByteUtility.byteToHex(bytes[4]) + ":" + ByteUtility.byteToHex(bytes[5]));
        }
        if (numberFrom3021 > 1 && numberFrom3021 <= 4) {
            for (int i = 0; i < numberFrom3021 - 1; ++i) {
                MOut.G(this).println("System LAN" + (i + 2) + " MAC Address: " + ByteUtility.byteToHex(bytes[0]) + ":" + ByteUtility.byteToHex(bytes[1]) + ":" + ByteUtility.byteToHex(bytes[2]) + ":" + ByteUtility.byteToHex(bytes[3]) + ":" + ByteUtility.byteToHex(bytes[4]) + ":" + ByteUtility.byteToHex((byte)(bytes[5] + i + 1)));
            }
            this.statusCode = 0;
            return;
        }
        int number = ipmiOEMCommand.getOtherSystemMacNumber();
        if (number > 0) {
            bytes = ipmiOEMCommand.getOtherSystemMacAddress();
        }
        for (int i = 0; i < number; ++i) {
            MOut.G(this).println("System MAC Address " + (i + 2) + "   : " + ByteUtility.byteToHex(bytes[i * 6 + 0]) + ":" + ByteUtility.byteToHex(bytes[i * 6 + 1]) + ":" + ByteUtility.byteToHex(bytes[i * 6 + 2]) + ":" + ByteUtility.byteToHex(bytes[i * 6 + 3]) + ":" + ByteUtility.byteToHex(bytes[i * 6 + 4]) + ":" + ByteUtility.byteToHex(bytes[i * 6 + 5]));
        }
        this.statusCode = 0;
    }
}

