/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class UserPasswordCommand
extends SuperBladeCommand {
    byte userID;
    String password;

    @Override
    public boolean preValidate() {
        String usage = "Usage: user setpwd <user id> <password>";
        if (this.parameters == null || this.parameters.length != 2) {
            MOut.G(this).println(usage);
            return false;
        }
        try {
            this.userID = Byte.parseByte(this.parameters[0]);
        }
        catch (NumberFormatException ex) {
            MOut.G(this).println("user id should be number");
            MOut.G(this).println(usage);
            return false;
        }
        this.password = this.parameters[1];
        if (this.password.length() > 20) {
            MOut.G(this).println("password should less then 20 characters");
            MOut.G(this).println(usage);
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(null);
        ipmiMessagingCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        if (!ipmiMessagingCommand.setUserPasswordByID(this.userID, this.password)) {
            MOut.G(this).println("Set user password failed");
            this.statusCode = 149;
            return;
        }
        MOut.G(this).println("Done");
        this.statusCode = 0;
    }
}

