/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIGlobalCommand;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIOEMCommand;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.RMCPPlus;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.VirtualMediaInfo;
import com.supermicro.ipmi.text.MOut;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.StringTokenizer;

public class IPMIRaritanOEMCommand
extends IPMICommand {
    MOut mout = MOut.G();
    public static final int GET_FIRMWARE_INFO_ALL = 0;
    public static final int GET_FIRMWARE_INFO_VERSION = 1;
    public static final int GET_FIRMWARE_INFO_TAG = 2;

    public void setMOut(MOut mout) {
        this.mout = mout;
    }

    public IPMIRaritanOEMCommand(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
    }

    public IPMIMessage getFirmwareVersionCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)-16, (byte)32, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage startFirmwareUpgradeCommand(int firmwareSize) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[4];
        ByteUtility.intTo4Bytes(data, 0, firmwareSize);
        ipmiMessage.setCommandAndData((byte)-16, (byte)33, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage uploadFirmwareCommand(byte[] reservationID, byte[] currentChunk, byte[] chunk) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[6 + chunk.length];
        data[0] = reservationID[0];
        data[1] = reservationID[1];
        data[2] = currentChunk[0];
        data[3] = currentChunk[1];
        data[4] = currentChunk[2];
        data[5] = currentChunk[3];
        System.arraycopy(chunk, 0, data, 6, chunk.length);
        ipmiMessage.setCommandAndData((byte)-16, (byte)34, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage flashFirmwareCommand(byte[] reservationID, byte flag) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{reservationID[0], reservationID[1], flag};
        ipmiMessage.setCommandAndData((byte)-16, (byte)35, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage cancelFirmwareUpgradeCommand(byte[] reservationID) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{reservationID[0], reservationID[1]};
        ipmiMessage.setCommandAndData((byte)-16, (byte)36, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage finalizeFirmwareUpgradeCommand(byte[] reservationID) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{reservationID[0], reservationID[1]};
        ipmiMessage.setCommandAndData((byte)-16, (byte)37, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage resetToFactoryDefaultsCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)-16, (byte)64, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getSerialNumberCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)-16, (byte)65, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setSerialNumberCommand(byte[] serialNumber) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = serialNumber;
        ipmiMessage.setCommandAndData((byte)-16, (byte)66, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getVirtualMediaStatusCommand(byte deviceID) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{deviceID};
        ipmiMessage.setCommandAndData((byte)-16, (byte)80, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage closeVirtualMediaSession(byte deviceID) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{deviceID};
        ipmiMessage.setCommandAndData((byte)-16, (byte)81, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage startFloppyImageUploadCommand(byte deviceID, int firmwareSize, byte[] firmwareFilename) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[5 + firmwareFilename.length];
        data[0] = deviceID;
        byte[] length = new byte[4];
        ByteUtility.intTo4Bytes(length, 0, firmwareSize);
        data[1] = length[0];
        data[2] = length[1];
        data[3] = length[2];
        data[4] = length[3];
        System.arraycopy(firmwareFilename, 0, data, 5, firmwareFilename.length);
        ipmiMessage.setCommandAndData((byte)-16, (byte)82, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage uploadFloppyImageCommand(byte deviceID, byte[] reservationID, byte[] currentChunk, byte[] chunk) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[7 + chunk.length];
        data[0] = deviceID;
        data[1] = reservationID[0];
        data[2] = reservationID[1];
        data[3] = currentChunk[0];
        data[4] = currentChunk[1];
        data[5] = currentChunk[2];
        data[6] = currentChunk[3];
        System.arraycopy(chunk, 0, data, 7, chunk.length);
        ipmiMessage.setCommandAndData((byte)-16, (byte)83, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage finalizeFloppyImageUploadCommand(byte deviceID, byte[] reservationID, byte operation) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{deviceID, reservationID[0], reservationID[1], operation};
        ipmiMessage.setCommandAndData((byte)-16, (byte)84, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage startSMBImageMountCommand(byte deviceID) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{deviceID};
        ipmiMessage.setCommandAndData((byte)-16, (byte)85, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setSMBImageParameterCommand(byte deviceID, byte[] reservationID, byte parameter, byte[] value) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[4 + value.length];
        data[0] = deviceID;
        data[1] = reservationID[0];
        data[2] = reservationID[1];
        data[3] = parameter;
        System.arraycopy(value, 0, data, 4, value.length);
        ipmiMessage.setCommandAndData((byte)-16, (byte)86, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage finalizeSMBImageMountCommand(byte deviceID, byte[] reservationID, byte operation) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{deviceID, reservationID[0], reservationID[1], operation};
        ipmiMessage.setCommandAndData((byte)-16, (byte)87, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public static boolean checkFirmwareFile(String firmwareFilename) throws Exception {
        File firmware = new File(firmwareFilename);
        RandomAccessFile raf = new RandomAccessFile(firmware, "r");
        byte[] chunk = new byte[1000];
        boolean result = false;
        int count = raf.read(chunk, 0, chunk.length);
        if (count != 1000) {
            throw new Exception("File read error");
        }
        byte[] peppercon = new byte[9];
        System.arraycopy(chunk, 111, peppercon, 0, 9);
        if (new String(peppercon).equals("peppercon")) {
            result = true;
        }
        raf.close();
        return result;
    }

    public String getFirmwareVersionFromIPMI(int part) {
        IPMIMessage ipmiMessage = this.getFirmwareVersionCommand();
        if (ipmiMessage == null || ipmiMessage.completionCode != 0) {
            return null;
        }
        byte[] majorVersion = new byte[4];
        byte[] minorVersion = new byte[4];
        byte[] subMinorVersion = new byte[4];
        byte[] buildNumber = new byte[4];
        byte[] tagAndOem = new byte[ipmiMessage.data.length - 17];
        int index = 0;
        System.arraycopy(ipmiMessage.data, index, majorVersion, 0, 4);
        System.arraycopy(ipmiMessage.data, index += 4, minorVersion, 0, 4);
        System.arraycopy(ipmiMessage.data, index += 4, subMinorVersion, 0, 4);
        System.arraycopy(ipmiMessage.data, index += 4, buildNumber, 0, 4);
        byte hardwareID = ipmiMessage.data[index += 4];
        System.arraycopy(ipmiMessage.data, ++index, tagAndOem, 0, tagAndOem.length);
        String versionString = ByteUtility.fourBytesToLongByLSBFirst(majorVersion) + "." + ByteUtility.fourBytesToLongByLSBFirst(minorVersion) + "." + ByteUtility.fourBytesToLongByLSBFirst(subMinorVersion) + "  build " + ByteUtility.fourBytesToLongByLSBFirst(buildNumber);
        String hardwareIDString = "0x" + ByteUtility.byteToHex(hardwareID);
        StringTokenizer st = new StringTokenizer(new String(tagAndOem), new String(new byte[]{0}));
        String tagString = st.nextToken();
        String oemString = st.nextToken();
        if (tagString != null) {
            tagString.trim();
        }
        if (oemString != null) {
            oemString.trim();
        }
        String frimwareInfo = null;
        if (part == 0) {
            frimwareInfo = "Firmware Version: " + versionString + "\n" + "Firmware Tag: " + tagString;
        } else if (part == 1) {
            frimwareInfo = versionString;
        } else if (part == 2) {
            frimwareInfo = tagString;
        }
        return frimwareInfo;
    }

    public String getFirmwareVersionFromIPMI() {
        IPMIMessage ipmiMessage = this.getFirmwareVersionCommand();
        if (ipmiMessage == null || ipmiMessage.completionCode != 0) {
            return null;
        }
        byte[] majorVersion = new byte[4];
        byte[] minorVersion = new byte[4];
        byte[] subMinorVersion = new byte[4];
        byte[] buildNumber = new byte[4];
        byte[] tagAndOem = new byte[ipmiMessage.data.length - 17];
        int index = 0;
        System.arraycopy(ipmiMessage.data, index, majorVersion, 0, 4);
        System.arraycopy(ipmiMessage.data, index += 4, minorVersion, 0, 4);
        System.arraycopy(ipmiMessage.data, index += 4, subMinorVersion, 0, 4);
        System.arraycopy(ipmiMessage.data, index += 4, buildNumber, 0, 4);
        byte hardwareID = ipmiMessage.data[index += 4];
        System.arraycopy(ipmiMessage.data, ++index, tagAndOem, 0, tagAndOem.length);
        String versionString = ByteUtility.fourBytesToLongByLSBFirst(majorVersion) + "." + ByteUtility.fourBytesToLongByLSBFirst(minorVersion) + "." + ByteUtility.fourBytesToLongByLSBFirst(subMinorVersion) + "  build " + ByteUtility.fourBytesToLongByLSBFirst(buildNumber);
        String hardwareIDString = "0x" + ByteUtility.byteToHex(hardwareID);
        StringTokenizer st = new StringTokenizer(new String(tagAndOem), new String(new byte[]{0}));
        String tagString = st.nextToken();
        String oemString = st.nextToken();
        if (tagString != null) {
            tagString.trim();
        }
        if (oemString != null) {
            oemString.trim();
        }
        String frimwareInfo = " Firmware Version: " + versionString + "\n" + " Firmware Tag    : " + tagString + "\n";
        return frimwareInfo;
    }

    public static String getFirmwareVersionFromFile(String firmwareFilename) throws Exception {
        File firmware = new File(firmwareFilename);
        RandomAccessFile raf = new RandomAccessFile(firmware, "r");
        byte[] chunk = new byte[1000];
        boolean result = false;
        int count = raf.read(chunk, 0, chunk.length);
        if (count != 1000) {
            throw new Exception("File read error");
        }
        byte[] majorVersion = new byte[2];
        byte[] minorVersion = new byte[2];
        byte[] subMinorVersion = new byte[2];
        byte[] buildNumber = new byte[2];
        byte[] tag = new byte[50];
        majorVersion[0] = chunk[31];
        majorVersion[1] = chunk[32];
        minorVersion[0] = chunk[33];
        minorVersion[1] = chunk[34];
        subMinorVersion[0] = chunk[35];
        subMinorVersion[1] = chunk[36];
        buildNumber[0] = chunk[45];
        buildNumber[1] = chunk[46];
        System.arraycopy(chunk, 47, tag, 0, tag.length);
        String versionString = Integer.parseInt(new String(majorVersion)) + "." + Integer.parseInt(new String(minorVersion)) + "." + Integer.parseInt(new String(subMinorVersion)) + "  build " + ByteUtility.twoBytesToIntMSB(buildNumber);
        String tagString = new String(tag).trim();
        String frimwareInfo = " Firmware Version: " + versionString + "\n" + " Firmware Tag    : " + tagString + "\n" + " Firmware Size   : " + firmware.length() + " bytes" + "\n" + " Firmware Path   : " + firmware.getAbsolutePath();
        raf.close();
        return frimwareInfo;
    }

    public boolean flashFirmwareWithMessage(String firmwareFilename) throws Exception {
        File firmware = new File(firmwareFilename);
        int chunkSize = 0;
        byte[] reservationID = new byte[2];
        int totalRead = 0;
        int readCount = 0;
        boolean checkFile = IPMIRaritanOEMCommand.checkFirmwareFile(firmwareFilename);
        if (!checkFile) {
            throw new Exception("File error");
        }
        this.mout.println("BMC firmware version:");
        this.mout.println(this.getFirmwareVersionFromIPMI());
        this.mout.println("File firmware version:");
        this.mout.println(IPMIRaritanOEMCommand.getFirmwareVersionFromFile(firmwareFilename));
        long fileSize = firmware.length();
        IPMIMessage ipmiMessage = this.startFirmwareUpgradeCommand((int)fileSize);
        if (ipmiMessage.completionCode != 0) {
            this.mout.println(ByteUtility.byteToHex(ipmiMessage.completionCode));
            this.cancelFirmwareUpgradeCommand(reservationID);
            throw new Exception("Calling start firmware upgrade error");
        }
        reservationID[0] = ipmiMessage.data[0];
        reservationID[1] = ipmiMessage.data[1];
        byte[] bytes = new byte[4];
        System.arraycopy(ipmiMessage.data, 2, bytes, 0, 4);
        chunkSize = (int)ByteUtility.fourBytesToLongByLSBFirst(bytes);
        chunkSize = 900;
        byte[] chunk = new byte[chunkSize];
        IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(this.ipmiInterface);
        byte[] data = ipmiOEMCommand.getSIMxxLanDriver();
        if (data != null) {
            byte lanType = data[0];
            byte lanDrvier = data[1];
            if (lanType == 1 && lanDrvier == 5) {
                chunkSize = 80;
                chunk = new byte[chunkSize];
            }
        }
        RandomAccessFile raf = new RandomAccessFile(firmware, "r");
        this.mout.print("Uploading firmware ...");
        int currentProgress = 0;
        int lastProgress = 0;
        while ((readCount = raf.read(chunk, 0, chunk.length)) != -1) {
            byte[] currentChunk = new byte[4];
            ByteUtility.intTo4Bytes(currentChunk, 0, totalRead);
            if (readCount != chunkSize) {
                byte[] lastChunk = new byte[readCount];
                System.arraycopy(chunk, 0, lastChunk, 0, readCount);
                chunk = lastChunk;
            }
            ipmiMessage = this.uploadFirmwareCommand(reservationID, currentChunk, chunk);
            if (ipmiMessage.completionCode != 0) {
                this.mout.println(ByteUtility.byteToHex(ipmiMessage.completionCode));
                this.cancelFirmwareUpgradeCommand(reservationID);
                throw new Exception("Upload firmware error. location = " + totalRead + " (" + ByteUtility.byteToHex(ipmiMessage.completionCode) + "h) Please retry");
            }
            totalRead += readCount;
            if (chunkSize == 80) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
            if ((currentProgress = (int)((long)(totalRead * 100) / firmware.length())) <= lastProgress) continue;
            this.mout.print(".");
            lastProgress = currentProgress;
        }
        this.mout.println("Done");
        byte flashFlag = 0;
        ipmiMessage = this.flashFirmwareCommand(reservationID, flashFlag);
        if (ipmiMessage.completionCode != 0) {
            String errorMessage = "";
            switch (ipmiMessage.completionCode) {
                case -128: {
                    errorMessage = "upload incomplete";
                }
                case -127: {
                    errorMessage = "bad CRC";
                }
                case -126: {
                    errorMessage = "firmware invalid";
                }
                case -125: {
                    errorMessage = "upgrade failed";
                }
            }
            this.cancelFirmwareUpgradeCommand(reservationID);
            throw new Exception(errorMessage);
        }
        this.mout.println("Executing Flash Firmware, please wait (2 minutes)...");
        IPMIGlobalCommand ipmiGlobalCommand = new IPMIGlobalCommand(this.ipmiInterface);
        ipmiGlobalCommand.getDeviceIDCommand();
        Thread.currentThread();
        Thread.sleep(10000L);
        ipmiGlobalCommand.getDeviceIDCommand();
        Thread.currentThread();
        Thread.sleep(10000L);
        ipmiGlobalCommand.getDeviceIDCommand();
        Thread.currentThread();
        Thread.sleep(10000L);
        ipmiGlobalCommand.getDeviceIDCommand();
        Thread.currentThread();
        Thread.sleep(10000L);
        ipmiGlobalCommand.getDeviceIDCommand();
        Thread.currentThread();
        Thread.sleep(10000L);
        ipmiGlobalCommand.getDeviceIDCommand();
        Thread.currentThread();
        Thread.sleep(10000L);
        ipmiGlobalCommand.getDeviceIDCommand();
        Thread.currentThread();
        Thread.sleep(10000L);
        ipmiGlobalCommand.getDeviceIDCommand();
        Thread.currentThread();
        Thread.sleep(10000L);
        ipmiGlobalCommand.getDeviceIDCommand();
        Thread.currentThread();
        Thread.sleep(10000L);
        int retryCount = 5;
        this.mout.print("Checking FW update status and reboot device (1 minutes)...");
        ipmiMessage = this.finalizeFirmwareUpgradeCommand(reservationID);
        try {
            Thread.sleep(60000L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        do {
            IPMIMessage newIPMIMessage;
            if ((newIPMIMessage = this.createNewSessionForFinalizeFirmwareUpgrade(reservationID)) != null) {
                switch (newIPMIMessage.completionCode) {
                    case -59: {
                        this.mout.println("Flash Done (CMM reboot already)");
                        return true;
                    }
                    case 0: {
                        break;
                    }
                    case -125: {
                        this.mout.print(".");
                        break;
                    }
                }
            }
            Thread.currentThread();
            Thread.sleep(5000L);
        } while (retryCount-- > 0);
        return false;
    }

    public IPMIMessage createNewSessionForFinalizeFirmwareUpgrade(byte[] reservationID) throws Exception {
        if (this.getIPMIInterface() instanceof RMCPPlus) {
            RMCPPlus plus = (RMCPPlus)this.getIPMIInterface();
            IPMIRaritanOEMCommand ipmiRaritanOEMCommand = new IPMIRaritanOEMCommand(null);
            ISessionController sessionController = SessionControllerFactory.createSessionController(plus.config, ipmiRaritanOEMCommand);
            if (sessionController == null) {
                return null;
            }
            IPMIMessage ipmiMessage = ipmiRaritanOEMCommand.finalizeFirmwareUpgradeCommand(reservationID);
            sessionController.closeSession();
            return ipmiMessage;
        }
        return null;
    }

    public boolean flashFirmware(String firmwareFilename) throws Exception {
        File firmware = new File(firmwareFilename);
        int chunkSize = 0;
        byte[] reservationID = new byte[2];
        int totalRead = 0;
        int readCount = 0;
        boolean checkFile = IPMIRaritanOEMCommand.checkFirmwareFile(firmwareFilename);
        if (!checkFile) {
            throw new Exception("File error");
        }
        long fileSize = firmware.length();
        IPMIMessage ipmiMessage = this.startFirmwareUpgradeCommand((int)fileSize);
        if (ipmiMessage.completionCode != 0) {
            this.mout.println(ByteUtility.byteToHex(ipmiMessage.completionCode));
            this.cancelFirmwareUpgradeCommand(reservationID);
            throw new Exception("Calling start firmware upgrade error");
        }
        reservationID[0] = ipmiMessage.data[0];
        reservationID[1] = ipmiMessage.data[1];
        byte[] bytes = new byte[4];
        System.arraycopy(ipmiMessage.data, 2, bytes, 0, 4);
        chunkSize = (int)ByteUtility.fourBytesToLongByLSBFirst(bytes);
        chunkSize = 900;
        byte[] chunk = new byte[chunkSize];
        IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(this.ipmiInterface);
        byte[] data = ipmiOEMCommand.getSIMxxLanDriver();
        if (data != null) {
            byte lanType = data[0];
            byte lanDrvier = data[1];
            if (lanType == 1 && lanDrvier == 5) {
                chunkSize = 80;
                chunk = new byte[chunkSize];
            }
        }
        RandomAccessFile raf = new RandomAccessFile(firmware, "r");
        while ((readCount = raf.read(chunk, 0, chunk.length)) != -1) {
            byte[] currentChunk = new byte[4];
            ByteUtility.intTo4Bytes(currentChunk, 0, totalRead);
            if (readCount != chunkSize) {
                byte[] lastChunk = new byte[readCount];
                System.arraycopy(chunk, 0, lastChunk, 0, readCount);
                chunk = lastChunk;
            }
            ipmiMessage = this.uploadFirmwareCommand(reservationID, currentChunk, chunk);
            if (ipmiMessage.completionCode != 0) {
                this.mout.println(ByteUtility.byteToHex(ipmiMessage.completionCode));
                this.cancelFirmwareUpgradeCommand(reservationID);
                throw new Exception("Upload firmware error. location = " + totalRead);
            }
            totalRead += readCount;
        }
        byte flashFlag = 0;
        ipmiMessage = this.flashFirmwareCommand(reservationID, flashFlag);
        if (ipmiMessage.completionCode != 0) {
            String errorMessage = "";
            switch (ipmiMessage.completionCode) {
                case -128: {
                    errorMessage = "upload incomplete";
                }
                case -127: {
                    errorMessage = "bad CRC";
                }
                case -126: {
                    errorMessage = "firmware invalid";
                }
                case -125: {
                    errorMessage = "upgrade failed";
                }
            }
            this.cancelFirmwareUpgradeCommand(reservationID);
            throw new Exception(errorMessage);
        }
        IPMIGlobalCommand ipmiGlobalCommand = new IPMIGlobalCommand(this.ipmiInterface);
        ipmiGlobalCommand.getDeviceIDCommand();
        Thread.currentThread();
        Thread.sleep(10000L);
        ipmiGlobalCommand.getDeviceIDCommand();
        Thread.currentThread();
        Thread.sleep(10000L);
        ipmiGlobalCommand.getDeviceIDCommand();
        Thread.currentThread();
        Thread.sleep(10000L);
        ipmiGlobalCommand.getDeviceIDCommand();
        Thread.currentThread();
        Thread.sleep(10000L);
        ipmiGlobalCommand.getDeviceIDCommand();
        Thread.currentThread();
        Thread.sleep(10000L);
        ipmiGlobalCommand.getDeviceIDCommand();
        Thread.currentThread();
        Thread.sleep(10000L);
        ipmiMessage = this.finalizeFirmwareUpgradeCommand(reservationID);
        switch (ipmiMessage.completionCode) {
            case 0: {
                return true;
            }
            case -128: {
                return false;
            }
        }
        return false;
    }

    public boolean mountImage(byte deviceID, String host, String share, String path, String username, String password) throws Exception {
        byte[] reserveationID = new byte[2];
        IPMIMessage ipmiMessage = this.startSMBImageMountCommand(deviceID);
        if (ipmiMessage.completionCode != 0) {
            if (ipmiMessage.completionCode == -128) {
                throw new Exception("No empty device");
            }
            throw new Exception("Start SMB image error");
        }
        reserveationID[0] = ipmiMessage.data[1];
        reserveationID[1] = ipmiMessage.data[2];
        ipmiMessage = this.setSMBImageParameterCommand(deviceID, reserveationID, (byte)0, host.getBytes());
        if (ipmiMessage.completionCode != 0) {
            this.finalizeSMBImageMountCommand(deviceID, reserveationID, (byte)0);
            throw new Exception("Set host error");
        }
        ipmiMessage = this.setSMBImageParameterCommand(deviceID, reserveationID, (byte)1, share.getBytes());
        if (ipmiMessage.completionCode != 0) {
            this.finalizeSMBImageMountCommand(deviceID, reserveationID, (byte)0);
            throw new Exception("Set share error");
        }
        ipmiMessage = this.setSMBImageParameterCommand(deviceID, reserveationID, (byte)2, path.getBytes());
        if (ipmiMessage.completionCode != 0) {
            this.finalizeSMBImageMountCommand(deviceID, reserveationID, (byte)0);
            throw new Exception("Set path error");
        }
        if (username != null) {
            ipmiMessage = this.setSMBImageParameterCommand(deviceID, reserveationID, (byte)3, username.getBytes());
            if (ipmiMessage.completionCode != 0) {
                this.finalizeSMBImageMountCommand(deviceID, reserveationID, (byte)0);
                throw new Exception("Set username error");
            }
        }
        if (password != null) {
            ipmiMessage = this.setSMBImageParameterCommand(deviceID, reserveationID, (byte)4, password.getBytes());
            if (ipmiMessage.completionCode != 0) {
                this.finalizeSMBImageMountCommand(deviceID, reserveationID, (byte)0);
                throw new Exception("Set password error");
            }
        }
        ipmiMessage = this.finalizeSMBImageMountCommand(deviceID, reserveationID, (byte)1);
        if (ipmiMessage.completionCode != 0) {
            this.finalizeSMBImageMountCommand(deviceID, reserveationID, (byte)0);
            switch (ipmiMessage.completionCode) {
                case -126: {
                    throw new Exception("SMB image mount in progress");
                }
                case -124: {
                    throw new Exception("Image access failed");
                }
            }
            throw new Exception("Finalize SMB image error");
        }
        return true;
    }

    public boolean mountISOImageForTextMode(byte deviceID, String host, String share, String path, String username, String password) throws Exception {
        byte[] reserveationID = new byte[2];
        IPMIMessage ipmiMessage = this.startSMBImageMountCommand(deviceID);
        if (ipmiMessage.completionCode != 0) {
            if (ipmiMessage.completionCode == -128) {
                this.mout.println("No empty device");
                return false;
            }
            this.mout.println("Start SMB image error");
            return false;
        }
        reserveationID[0] = ipmiMessage.data[1];
        reserveationID[1] = ipmiMessage.data[2];
        ipmiMessage = this.setSMBImageParameterCommand(deviceID, reserveationID, (byte)0, host.getBytes());
        if (ipmiMessage.completionCode != 0) {
            this.finalizeSMBImageMountCommand(deviceID, reserveationID, (byte)0);
            this.mout.println("Set share host error");
            return false;
        }
        ipmiMessage = this.setSMBImageParameterCommand(deviceID, reserveationID, (byte)1, share.getBytes());
        if (ipmiMessage.completionCode != 0) {
            this.finalizeSMBImageMountCommand(deviceID, reserveationID, (byte)0);
            this.mout.println("Set share name error");
            return false;
        }
        ipmiMessage = this.setSMBImageParameterCommand(deviceID, reserveationID, (byte)2, path.getBytes());
        if (ipmiMessage.completionCode != 0) {
            this.finalizeSMBImageMountCommand(deviceID, reserveationID, (byte)0);
            this.mout.println("Set path to image error");
            return false;
        }
        if (username != null) {
            ipmiMessage = this.setSMBImageParameterCommand(deviceID, reserveationID, (byte)3, username.getBytes());
            if (ipmiMessage.completionCode != 0) {
                this.finalizeSMBImageMountCommand(deviceID, reserveationID, (byte)0);
                this.mout.println("Set username error");
                return false;
            }
        }
        if (password != null) {
            ipmiMessage = this.setSMBImageParameterCommand(deviceID, reserveationID, (byte)4, password.getBytes());
            if (ipmiMessage.completionCode != 0) {
                this.finalizeSMBImageMountCommand(deviceID, reserveationID, (byte)0);
                this.mout.println("Set password error");
                return false;
            }
        }
        ipmiMessage = this.finalizeSMBImageMountCommand(deviceID, reserveationID, (byte)1);
        if (ipmiMessage.completionCode != 0) {
            this.finalizeSMBImageMountCommand(deviceID, reserveationID, (byte)0);
            switch (ipmiMessage.completionCode) {
                case -126: {
                    this.mout.println("SMB image mount in progress");
                    return false;
                }
                case -124: {
                    this.mout.println("Image access failed");
                    return false;
                }
            }
            this.mout.println("Finalize SMB image error");
            return false;
        }
        boolean mountingFlag = true;
        int limit = 20;
        for (int i = 0; i < limit; ++i) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            ipmiMessage = this.finalizeSMBImageMountCommand(deviceID, reserveationID, (byte)2);
            if (ipmiMessage.completionCode == 0) break;
            if (i != limit - 1) continue;
            this.finalizeSMBImageMountCommand(deviceID, reserveationID, (byte)0);
            mountingFlag = false;
            switch (ipmiMessage.completionCode) {
                case -126: {
                    this.mout.println("SMB image mount in progress");
                    return false;
                }
                case -124: {
                    this.mout.println("Image access failed");
                    return false;
                }
            }
            this.mout.println("Finalize SMB image error");
            return false;
        }
        mountingFlag = false;
        return true;
    }

    public static void main(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("192.168.10.244");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMIRaritanOEMCommand ipmiRaritanOEMCommand = new IPMIRaritanOEMCommand(null);
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            MessageCenter.getInstance().put("Network error");
            return;
        }
        MessageCenter.getInstance().put("RMCP Login successfully");
        ipmiRaritanOEMCommand.setIPMIInterface(rmcp);
        try {
            VirtualMediaInfo vm = ipmiRaritanOEMCommand.getVirtualMediaStatus((byte)1);
            System.out.println(vm.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public VirtualMediaInfo getVirtualMediaStatus(byte deviceID) {
        IPMIMessage ipmiMessage = this.getVirtualMediaStatusCommand(deviceID);
        if (ipmiMessage != null) {
            if (ipmiMessage.completionCode == 0) {
                VirtualMediaInfo virtualMediaInfo = VirtualMediaInfo.fromRaw(deviceID, ipmiMessage.data);
                return virtualMediaInfo;
            }
            return null;
        }
        return null;
    }

    public static boolean checkFloppyImage(String floppyImageFilename) throws Exception {
        File floppyImage = new File(floppyImageFilename);
        if (floppyImage.length() % 512L > 0L) {
            throw new Exception("The image file size must be a multiple of 512 bytes");
        }
        if (floppyImage.length() > 1474560L) {
            throw new Exception("File Size > 1.44 M (1474560 bytes)");
        }
        return true;
    }

    public boolean uploadFloppyImageForTextMode(byte deviceID, String floppyImageFilename) throws Exception {
        File floppy = new File(floppyImageFilename);
        int chunkSize = 0;
        byte[] reservationID = new byte[2];
        int totalRead = 0;
        int readCount = 0;
        boolean checkFile = IPMIRaritanOEMCommand.checkFloppyImage(floppyImageFilename);
        if (!checkFile) {
            throw new Exception("File error");
        }
        IPMIMessage ipmiMessage = this.startFloppyImageUploadCommand(deviceID, (int)floppy.length(), floppy.getName().getBytes());
        if (ipmiMessage.completionCode != 0) {
            this.mout.println("startFloppyImageUploadCommand error :" + ByteUtility.byteToHex(ipmiMessage.completionCode));
            switch (ipmiMessage.completionCode) {
                case -128: {
                    throw new Exception("No empty device");
                }
                case -127: {
                    throw new Exception("Invalid file size");
                }
                case -126: {
                    throw new Exception("SMB mount in progress");
                }
            }
            throw new Exception("Start floppy image upload failed");
        }
        byte virtualDeviceID = ipmiMessage.data[0];
        reservationID[0] = ipmiMessage.data[1];
        reservationID[1] = ipmiMessage.data[2];
        byte[] bytes = new byte[4];
        System.arraycopy(ipmiMessage.data, 3, bytes, 0, 4);
        chunkSize = (int)ByteUtility.fourBytesToLongByLSBFirst(bytes);
        chunkSize = 900;
        byte[] chunk = new byte[chunkSize];
        IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(this.ipmiInterface);
        byte[] data = ipmiOEMCommand.getSIMxxLanDriver();
        if (data != null) {
            byte lanType = data[0];
            byte lanDrvier = data[1];
            if (lanType == 1 && lanDrvier == 5) {
                chunkSize = 80;
                chunk = new byte[chunkSize];
            }
        }
        RandomAccessFile raf = new RandomAccessFile(floppy, "r");
        this.mout.println("Uploading floppy ");
        int percentageBak = 0;
        while ((readCount = raf.read(chunk, 0, chunk.length)) != -1) {
            byte[] currentChunk = new byte[4];
            ByteUtility.intTo4Bytes(currentChunk, 0, totalRead);
            if (readCount != chunkSize) {
                byte[] lastChunk = new byte[readCount];
                System.arraycopy(chunk, 0, lastChunk, 0, readCount);
                chunk = lastChunk;
            }
            ipmiMessage = this.uploadFloppyImageCommand(deviceID, reservationID, currentChunk, chunk);
            if (ipmiMessage.completionCode != 0) {
                this.mout.println("uploadFloppyImageCommand error :" + ByteUtility.byteToHex(ipmiMessage.completionCode));
                this.finalizeFloppyImageUploadCommand(deviceID, reservationID, (byte)0);
                throw new Exception("Upload floppy error. location = " + totalRead);
            }
            int percentage = (int)((long)((totalRead += readCount) * 100) / floppy.length());
            if (percentage <= percentageBak) continue;
            this.mout.print(".");
            percentageBak = percentage;
        }
        this.mout.println("");
        byte operation = 1;
        ipmiMessage = this.finalizeFloppyImageUploadCommand(deviceID, reservationID, operation);
        if (ipmiMessage.completionCode != 0) {
            this.mout.println("finalizeFloppyImageUploadCommand error :" + ByteUtility.byteToHex(ipmiMessage.completionCode));
            this.finalizeFloppyImageUploadCommand(deviceID, reservationID, (byte)0);
            switch (ipmiMessage.completionCode) {
                case -126: {
                    throw new Exception("SMB image mount in progress");
                }
                case -125: {
                    throw new Exception("incomplete upload");
                }
            }
            throw new Exception("finalize Floppy Image Upload error");
        }
        return true;
    }

    public boolean uploadFloppyImage(byte deviceID, String floppyImageFilename) throws Exception {
        File floppy = new File(floppyImageFilename);
        int chunkSize = 0;
        byte[] reservationID = new byte[2];
        int totalRead = 0;
        int readCount = 0;
        boolean checkFile = IPMIRaritanOEMCommand.checkFloppyImage(floppyImageFilename);
        if (!checkFile) {
            throw new Exception("File error");
        }
        IPMIMessage ipmiMessage = this.startFloppyImageUploadCommand(deviceID, (int)floppy.length(), floppy.getName().getBytes());
        this.mout.println(ByteUtility.bytesToHex(ipmiMessage.data));
        if (ipmiMessage.completionCode != 0) {
            this.mout.println("startFloppyImageUploadCommand error :" + ByteUtility.byteToHex(ipmiMessage.completionCode));
            switch (ipmiMessage.completionCode) {
                case -128: {
                    throw new Exception("No empty device");
                }
                case -127: {
                    throw new Exception("Invalid file size");
                }
                case -126: {
                    throw new Exception("SMB mount in progress");
                }
            }
            throw new Exception("Start floppy image upload failed");
        }
        byte virtualDeviceID = ipmiMessage.data[0];
        reservationID[0] = ipmiMessage.data[1];
        reservationID[1] = ipmiMessage.data[2];
        this.mout.println(ByteUtility.byteToHex(virtualDeviceID));
        this.mout.println(ByteUtility.bytesToHex(reservationID));
        byte[] bytes = new byte[4];
        System.arraycopy(ipmiMessage.data, 3, bytes, 0, 4);
        chunkSize = (int)ByteUtility.fourBytesToLongByLSBFirst(bytes);
        chunkSize = 900;
        byte[] chunk = new byte[chunkSize];
        RandomAccessFile raf = new RandomAccessFile(floppy, "r");
        while ((readCount = raf.read(chunk, 0, chunk.length)) != -1) {
            byte[] currentChunk = new byte[4];
            ByteUtility.intTo4Bytes(currentChunk, 0, totalRead);
            if (readCount != chunkSize) {
                byte[] lastChunk = new byte[readCount];
                System.arraycopy(chunk, 0, lastChunk, 0, readCount);
                chunk = lastChunk;
            }
            ipmiMessage = this.uploadFloppyImageCommand(deviceID, reservationID, currentChunk, chunk);
            if (ipmiMessage.completionCode != 0) {
                this.mout.println("uploadFloppyImageCommand error :" + ByteUtility.byteToHex(ipmiMessage.completionCode));
                this.finalizeFloppyImageUploadCommand(deviceID, reservationID, (byte)0);
                throw new Exception("Upload floppy error. location = " + totalRead);
            }
            totalRead += readCount;
        }
        byte operation = 1;
        ipmiMessage = this.finalizeFloppyImageUploadCommand(deviceID, reservationID, operation);
        if (ipmiMessage.completionCode != 0) {
            this.mout.println("finalizeFloppyImageUploadCommand error :" + ByteUtility.byteToHex(ipmiMessage.completionCode));
            this.finalizeFloppyImageUploadCommand(deviceID, reservationID, (byte)0);
            switch (ipmiMessage.completionCode) {
                case -126: {
                    throw new Exception("SMB image mount in progress");
                }
                case -125: {
                    throw new Exception("incomplete upload");
                }
            }
            throw new Exception("finalize Floppy Image Upload error");
        }
        return true;
    }

    public boolean isVersionBefore2588() {
        IPMIMessage ipmiMessage = this.getFirmwareVersionCommand();
        byte[] majorVersion = new byte[4];
        byte[] minorVersion = new byte[4];
        byte[] subMinorVersion = new byte[4];
        int index = 0;
        System.arraycopy(ipmiMessage.data, index, majorVersion, 0, 4);
        System.arraycopy(ipmiMessage.data, index += 4, minorVersion, 0, 4);
        System.arraycopy(ipmiMessage.data, index += 4, subMinorVersion, 0, 4);
        index += 4;
        long major = ByteUtility.fourBytesToLongByLSBFirst(majorVersion);
        long minor = ByteUtility.fourBytesToLongByLSBFirst(minorVersion);
        long subMinor = ByteUtility.fourBytesToLongByLSBFirst(subMinorVersion);
        return major <= 2L && minor <= 5L && subMinor <= 88L;
    }

    public static void main____(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("192.168.10.241");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMIRaritanOEMCommand ipmiRaritanOEMCommand = new IPMIRaritanOEMCommand(null);
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            MessageCenter.getInstance().put("Network error");
            return;
        }
        MessageCenter.getInstance().put("RMCP Login successfully");
        ipmiRaritanOEMCommand.setIPMIInterface(rmcp);
        VirtualMediaInfo virtualMediaInfo = ipmiRaritanOEMCommand.getVirtualMediaStatus((byte)1);
        if (virtualMediaInfo != null) {
            System.out.println(virtualMediaInfo.toString());
        }
        if ((virtualMediaInfo = ipmiRaritanOEMCommand.getVirtualMediaStatus((byte)2)) != null) {
            System.out.println(virtualMediaInfo.toString());
        }
        boolean result = sessionController.closeSession();
        System.out.println("close session :" + result);
    }

    public static void main__(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("192.168.1.192");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMIRaritanOEMCommand ipmiRaritanOEMCommand = new IPMIRaritanOEMCommand(null);
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            MessageCenter.getInstance().put("Network error");
            return;
        }
        MessageCenter.getInstance().put("RMCP Login successfully");
        ipmiRaritanOEMCommand.setIPMIInterface(rmcp);
        VirtualMediaInfo virtualMediaInfo = ipmiRaritanOEMCommand.getVirtualMediaStatus((byte)1);
        if (virtualMediaInfo != null) {
            System.out.println(virtualMediaInfo.toString());
        }
        if ((virtualMediaInfo = ipmiRaritanOEMCommand.getVirtualMediaStatus((byte)2)) != null) {
            System.out.println(virtualMediaInfo.toString());
        }
        System.out.println("close virutal media of device 1 and 2");
        ipmiRaritanOEMCommand.closeVirtualMediaSession((byte)1);
        ipmiRaritanOEMCommand.closeVirtualMediaSession((byte)2);
        virtualMediaInfo = ipmiRaritanOEMCommand.getVirtualMediaStatus((byte)1);
        if (virtualMediaInfo != null) {
            System.out.println(virtualMediaInfo.toString());
        }
        if ((virtualMediaInfo = ipmiRaritanOEMCommand.getVirtualMediaStatus((byte)2)) != null) {
            System.out.println(virtualMediaInfo.toString());
        }
        boolean result = sessionController.closeSession();
    }
}

