/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.blade;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.blade.BladeSystemEntity;
import java.util.Observable;

public class IBFDREntity
extends Observable {
    private boolean powerOn;
    private boolean powerReset;
    private byte present;
    private byte p3v3;
    private byte p1v25;
    private byte switchTemp;
    private byte boardTemp;
    private byte i2cError;
    private byte busNumber;
    private byte channel;
    private byte initialized;
    private byte pollCount;
    private byte flag;
    private byte reserve2;
    private byte type;
    private byte i2cResetCount;
    private byte trlsb;
    private byte reserve6;
    private byte reserve7;
    private byte reserve8;
    private byte p0v9;
    private byte pvlsb;
    private byte[] raw;
    private int moduleIndex;
    private byte[] modelName;
    public boolean showModelName = false;

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\npowerOn =" + this.powerOn);
        sb.append("\npowerReset =" + this.powerReset);
        sb.append("\npresent =" + this.present);
        sb.append("\np3v3 =" + this.p3v3);
        sb.append("\np1v25 =" + this.p1v25);
        sb.append("\nvswitchTemp =" + this.switchTemp);
        sb.append("\nvboardTemp =" + this.boardTemp);
        sb.append("\ni2cError =" + this.i2cError);
        sb.append("\nbusNumber =" + this.busNumber);
        sb.append("\nchannel =" + this.channel);
        sb.append("\ninitialized =" + this.initialized);
        sb.append("\npollCount =" + this.pollCount);
        sb.append("\nflag =" + this.flag);
        sb.append("\nreserve2 =" + this.reserve2);
        sb.append("\ntype* =" + this.type);
        sb.append("\ni2cResetCount =" + this.i2cResetCount);
        sb.append("\trlsb =" + this.trlsb);
        sb.append("\nreserve6 =" + this.reserve6);
        sb.append("\nreserve7 =" + this.reserve7);
        sb.append("\nreserve8 =" + this.reserve8);
        sb.append("\np0v9 =" + this.p0v9);
        sb.append("\npvlsb =" + this.pvlsb);
        sb.append("\nRAW =" + ByteUtility.bytesToHex(this.raw));
        sb.append("\n3.3V = " + this.getP3v3Formula());
        sb.append("\n1.25V = " + this.getP1v25Formula());
        return sb.toString();
    }

    public boolean fromRaw(byte[] raw) {
        if (raw.length != BladeSystemEntity.INFINI_BAND_MODULE_DATA_SIZE && raw.length != BladeSystemEntity.INFINI_BAND_MODULE_DATA_SIZE2) {
            return false;
        }
        this.showModelName = raw.length == BladeSystemEntity.INFINI_BAND_MODULE_DATA_SIZE2;
        try {
            this.powerOn = (raw[0] & 0x20) == 32;
            this.powerReset = (raw[0] & 0x10) == 16;
            this.present = raw[2];
            this.p3v3 = raw[3];
            this.p1v25 = raw[4];
            this.switchTemp = raw[5];
            this.boardTemp = raw[6];
            this.p0v9 = raw[7];
            this.pvlsb = raw[8];
            this.i2cError = raw[9];
            this.busNumber = raw[10];
            this.channel = raw[11];
            this.initialized = raw[12];
            this.pollCount = raw[13];
            this.flag = raw[14];
            this.reserve2 = raw[15];
            this.type = raw[16];
            this.i2cResetCount = raw[17];
            this.trlsb = raw[18];
            this.reserve6 = raw[19];
            this.reserve7 = raw[20];
            this.reserve8 = raw[21];
            this.modelName = new byte[21];
            if (this.showModelName) {
                for (int i = 0; i < 21; ++i) {
                    this.modelName[i] = raw[22 + i];
                }
            }
            this.raw = raw;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return false;
        }
        return true;
    }

    public double getP3v3Formula() {
        double v = (double)((this.p3v3 & 0xFF) * 4 + (this.pvlsb & 0xC0) / 64) * 0.004;
        return v;
    }

    public double getP1v25Formula() {
        double v = (double)((this.p1v25 & 0xFF) * 4 + (this.pvlsb & 0xC0) / 64) * 0.002;
        return v;
    }

    public double getP0v9Formula() {
        double v = (double)((this.p0v9 & 0xFF) * 4 + (this.pvlsb & 0xC0) / 64) * 0.002;
        return v;
    }

    public byte getBusNumber() {
        return this.busNumber;
    }

    public byte getChannel() {
        return this.channel;
    }

    public byte getFlag() {
        return this.flag;
    }

    public byte getI2cError() {
        return this.i2cError;
    }

    public byte getInitialized() {
        return this.initialized;
    }

    public int getModuleIndex() {
        return this.moduleIndex;
    }

    public byte getPollCount() {
        return this.pollCount;
    }

    public boolean isPowerOn() {
        return this.powerOn;
    }

    public boolean isPowerReset() {
        return this.powerReset;
    }

    public byte getPresent() {
        return this.present;
    }

    public byte[] getRaw() {
        return this.raw;
    }

    public byte getReserve2() {
        return this.reserve2;
    }

    public byte getReserve6() {
        return this.reserve6;
    }

    public byte getReserve7() {
        return this.reserve7;
    }

    public byte getSwitchTemp() {
        return this.switchTemp;
    }

    public byte getType() {
        return this.type;
    }

    public byte getBoardTemp() {
        return this.boardTemp;
    }

    public int getSwitchTempFormula() {
        double c = (double)this.switchTemp + (double)this.trlsb * 0.125;
        return (int)c;
    }

    public int getBoardTempFormula() {
        double c = (double)this.boardTemp + (double)this.trlsb * 0.125;
        return (int)c;
    }

    public byte getP1v25() {
        return this.p1v25;
    }

    public byte getP3v3() {
        return this.p3v3;
    }

    public byte getReserve8() {
        return this.reserve8;
    }

    public String getModelName() {
        if (this.modelName.length == 0) {
            return "";
        }
        return new String(this.modelName).trim();
    }

    public void setBusNumber(byte busNumber) {
        this.busNumber = busNumber;
    }

    public void setChannel(byte channel) {
        this.channel = channel;
    }

    public void setFlag(byte flag) {
        this.flag = flag;
    }

    public void setI2cError(byte i2cError) {
        this.i2cError = i2cError;
    }

    public void setModuleIndex(int moduleIndex) {
        this.moduleIndex = moduleIndex;
    }

    public void setInitialized(byte initialized) {
        this.initialized = initialized;
    }

    public void setPollCount(byte pollCount) {
        this.pollCount = pollCount;
    }

    public void setPowerOn(boolean powerOn) {
        this.powerOn = powerOn;
    }

    public void setPowerReset(boolean powerReset) {
        this.powerReset = powerReset;
    }

    public void setPresent(byte present) {
        this.present = present;
    }

    public void setRaw(byte[] raw) {
        this.raw = raw;
    }

    public void setReserve2(byte reserve2) {
        this.reserve2 = reserve2;
    }

    public void setReserve6(byte reserve6) {
        this.reserve6 = reserve6;
    }

    public void setReserve7(byte reserve7) {
        this.reserve7 = reserve7;
    }

    public void setReserve8(byte reserve8) {
        this.reserve8 = reserve8;
    }

    public void setSwitchTemp(byte switchTemp) {
        this.switchTemp = switchTemp;
    }

    public void setBoardTemp(byte boardTemp) {
        this.boardTemp = boardTemp;
    }

    public void setType(byte type) {
        this.type = type;
    }

    public void setP1v25(byte p1v25) {
        this.p1v25 = p1v25;
    }

    public void setP3v3(byte p3v3) {
        this.p3v3 = p3v3;
    }

    public String toFormatedHeader() {
        String formatTemplate = " %-7s | %-5s | %13s | %13s | %6s | %6s | %6s\n";
        StringBuffer header = new StringBuffer();
        header.append(String.format(formatTemplate, "IBFDR", "Power", "Temp. Switch", "Temp. Board", "3.3V", "1.25V", "0.9V"));
        header.append(String.format(formatTemplate, "-----", "-----", "------------", "-----------", "----", "-----", "----"));
        return header.toString();
    }

    public String toFormatedHeaderLine2() {
        if (!this.showModelName) {
            return "";
        }
        String formatTemplate = " %-7s | %-25s\n";
        StringBuffer header = new StringBuffer();
        header.append(String.format(formatTemplate, "", "Model Name"));
        header.append(String.format(formatTemplate, "-----", "-------------------------"));
        return header.toString();
    }

    public String toFormatedString() {
        if (this.getPresent() == 0) {
            return "";
        }
        if (this.getInitialized() != 1) {
            return "";
        }
        String formatTemplate = " %-7s | %-5s | %13s | %13s | %6s | %6s | %6s\n";
        StringBuffer formatedString = new StringBuffer();
        String index = "IBFDR " + this.moduleIndex;
        String power = this.isPowerOn() ? "On" : "Off";
        String switchTemp = "" + this.showCandF(this.getSwitchTempFormula());
        String boardTemp = "" + this.showCandF(this.getBoardTempFormula());
        String v33 = this.d2StrV(this.getP3v3Formula());
        String v12 = this.d2StrV(this.getP1v25Formula());
        String v09 = this.d2StrV(this.getP0v9Formula());
        formatedString.append(String.format(formatTemplate, index, power, switchTemp, boardTemp, v33, v12, v09));
        return formatedString.toString();
    }

    public String toFormatedStringLine2() {
        if (this.getPresent() == 0) {
            return "";
        }
        if (this.getInitialized() != 1) {
            return "";
        }
        if (!this.showModelName) {
            return "";
        }
        String formatTemplate = " %-7s | %-25s";
        StringBuffer formatedString = new StringBuffer();
        String index = "IBFDR " + this.moduleIndex;
        formatedString.append(String.format(formatTemplate, index, this.getModelName()));
        return formatedString.toString();
    }

    protected String showCandF(int c) {
        if (c == -127) {
            return "N/A";
        }
        long f = Math.round(1.8 * (double)c + 32.0);
        return c + "C/" + f + "F";
    }

    public String d2StrV(double value) {
        int temp = (int)(value * 100.0);
        double d = (double)temp / 100.0;
        return "" + d + "V";
    }

    public boolean isIBFDR() {
        if (this.type != 0) {
            return false;
        }
        boolean isIBFDR = (this.getFlag() & 8) == 8;
        return isIBFDR;
    }
}

