/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.blade;

import com.supermicro.ipmi.blade.BladeEntity;
import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.blade.FailureEntity;
import com.supermicro.ipmi.blade.MB_B7DBE_SensorEntity;
import com.supermicro.ipmi.blade.TemperatureData;
import java.util.ArrayList;

public class MB_B8DTT_ACER_SensorEntity
extends MB_B7DBE_SensorEntity {
    public static final String SYSTEM_TEMP1 = "System Temp";
    public static final String CPU1_DIMM_VOLTAGE = "CPU1 DIMM";
    public static final String CPU2_DIMM_VOLTAGE = "CPU2 DIMM";
    public static final String V3VSB = "3.3VSB";
    public static final String CPU1_TEMP = "CPU1 Temp";
    public static final String CPU2_TEMP = "CPU2 Temp";
    private byte cpu1DIMMVoltage;
    private byte cpu2DIMMVoltage;
    private byte v3vsb;

    @Override
    public boolean fromRaw(byte[] raw) {
        if (raw.length != BladeSystemEntity.MOTHER_BOARD_SENSORS_DATA_SIZE) {
            return false;
        }
        this.pollCount = raw[0];
        this.flag = raw[1];
        this.remoteCPU1Temp = raw[2];
        this.remoteCPU2Temp = raw[3];
        this.systemTemp = raw[4];
        this.cpu1CoreVoltage = raw[5];
        this.cpu2CoreVoltage = raw[6];
        this.cpu1DIMMVoltage = raw[7];
        this.cpu2DIMMVoltage = raw[8];
        this.v1p5 = raw[9];
        this.v3p3 = raw[10];
        this.v3vsb = raw[11];
        this.v5 = raw[12];
        this.v12 = raw[13];
        this.batteryVoltage = raw[14];
        this.cpuTempHighLimit = raw[27];
        this.systemTempHighLimit = raw[28];
        this.raw = raw;
        return true;
    }

    @Override
    public ArrayList generateFailureReport(BladeEntity bladeEntity, int moduleIndex) {
        ArrayList<FailureEntity> failures = new ArrayList<FailureEntity>();
        if (this.getFlag() != 1) {
            return failures;
        }
        if (this.checkRemoteCPU1Temp() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, CPU1_TEMP));
        }
        if (this.checkRemoteCPU2Temp() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, CPU2_TEMP));
        }
        if (this.checkSystemTemp() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, SYSTEM_TEMP1));
        }
        if (this.checkCpu1CoreVoltage() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "CPU1 Vcore"));
        }
        if (this.checkCpu2CoreVoltage() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "CPU2 Vcore"));
        }
        if (this.checkCpu1DIMMVoltage() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, CPU1_DIMM_VOLTAGE));
        }
        if (this.checkCpu2DIMMVoltage() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, CPU2_DIMM_VOLTAGE));
        }
        if (this.checkV1p5() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "1.5V"));
        }
        if (this.checkV3p3() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "3.3V"));
        }
        if (this.checkV3vsb() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "3.3V"));
        }
        if (this.checkV5() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "5V"));
        }
        if (this.checkBatteryVoltage() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "VBAT"));
        }
        return failures;
    }

    @Override
    public String toFormatedString() {
        this.formatedString = new StringBuffer();
        this.formatedString.append(String.format(this.formatTemplate, "Status", "Sensor", "Reading", "Low Limit", "High Limit"));
        this.formatedString.append(String.format(this.formatTemplate, "------", "------", "-------", "---------", "----------"));
        this.addRaw(this.checkRemoteCPU1Temp(), CPU1_TEMP, this.showCandF(this.getRemoteCPU1Temp()), "N/A", "" + this.showCandF(this.getRemoteCPU1TempHighLimit()));
        this.addRaw(this.checkRemoteCPU2Temp(), CPU2_TEMP, this.showCandF(this.getRemoteCPU2Temp()), "N/A", "" + this.showCandF(this.getRemoteCPU2TempHighLimit()));
        this.addRaw(this.checkSystemTemp(), SYSTEM_TEMP1, this.showCandF(this.getSystemTemp()), "N/A", "" + this.showCandF(this.getSystemTempHighLimit()));
        if (this.getRemoteCPU1Temp() == 7) {
            this.setCpu1CoreVoltage((byte)0);
        }
        if (this.getRemoteCPU2Temp() == 7) {
            this.setCpu2CoreVoltage((byte)0);
        }
        this.addRaw(this.checkCpu1CoreVoltage(), "CPU1 Vcore", this.d2StrV(this.getCpu1CoreVoltageFormula()), this.d2StrV(this.getCpu1CoreVoltageLowLimit()), this.d2StrV(this.getCpu1CoreVoltageHighLimit()));
        this.addRaw(this.checkCpu2CoreVoltage(), "CPU2 Vcore", this.d2StrV(this.getCpu2CoreVoltageFormula()), this.d2StrV(this.getCpu2CoreVoltageLowLimit()), this.d2StrV(this.getCpu2CoreVoltageHighLimit()));
        this.addRaw(this.checkCpu1DIMMVoltage(), CPU1_DIMM_VOLTAGE, this.d2StrV(this.getCpu1DIMMVoltageFormula()), this.d2StrV(this.getCpu1DIMMVoltageLowLimit()), this.d2StrV(this.getCpu1DIMMVoltageHighLimit()));
        this.addRaw(this.checkCpu2DIMMVoltage(), CPU2_DIMM_VOLTAGE, this.d2StrV(this.getCpu2DIMMVoltageFormula()), this.d2StrV(this.getCpu2DIMMVoltageLowLimit()), this.d2StrV(this.getCpu2DIMMVoltageHighLimit()));
        this.addRaw(this.checkV1p5(), "1.5V", this.d2StrV(this.getV1p5Formula()), this.d2StrV(this.getV1p5LowLimit()), this.d2StrV(this.getV1p5HighLimit()));
        this.addRaw(this.checkV3p3(), "3.3V", this.d2StrV(this.getV3p3Formula()), this.d2StrV(this.getV3p3LowLimit()), this.d2StrV(this.getV3p3HighLimit()));
        this.addRaw(this.checkV3vsb(), V3VSB, this.d2StrV(this.getV3vsbFormula()), this.d2StrV(this.getV3vsbLowLimit()), this.d2StrV(this.getV3vsbHighLimit()));
        this.addRaw(this.checkV5(), "5V", this.d2StrV(this.getV5Formula()), this.d2StrV(this.getV5LowLimit()), this.d2StrV(this.getV5HighLimit()));
        this.addRaw(this.checkV12(), "12V", this.d2StrV(this.getV12Formula()), this.d2StrV(this.getV12LowLimit()), this.d2StrV(this.getV12HighLimit()));
        this.addRaw(this.checkBatteryVoltage(), "VBAT", this.d2StrV(this.getBatteryVoltageFormula()), this.d2StrV(this.getBatteryVoltageLowLimit()), this.d2StrV(this.getBatteryVoltageHighLimit()));
        return this.formatedString.toString();
    }

    @Override
    public ArrayList<TemperatureData> getTemperatures() {
        ArrayList<TemperatureData> list = new ArrayList<TemperatureData>();
        list.add(this.createTemperatureData(this.checkRemoteCPU1Temp(), CPU1_TEMP, this.showCPUTempString(this.getRemoteCPU1Temp()), "N/A", "N/A"));
        list.add(this.createTemperatureData(this.checkRemoteCPU2Temp(), CPU2_TEMP, this.showCPUTempString(this.getRemoteCPU2Temp()), "N/A", "N/A"));
        list.add(this.createTemperatureData(this.checkSystemTemp(), SYSTEM_TEMP1, this.showCandF(this.getSystemTemp()), "N/A", "" + this.showCandF(this.getSystemTempHighLimit())));
        return list;
    }

    @Override
    public double getCpu1CoreVoltageLowLimit() {
        return 0.6;
    }

    @Override
    public double getCpu2CoreVoltageLowLimit() {
        return 0.6;
    }

    public double getCpu1DIMMVoltageLowLimit() {
        return 1.2;
    }

    public double getCpu1DIMMVoltageHighLimit() {
        return 1.65;
    }

    public double getCpu2DIMMVoltageLowLimit() {
        return 1.2;
    }

    public double getCpu2DIMMVoltageHighLimit() {
        return 1.65;
    }

    public double getV3vsbLowLimit() {
        return 2.96;
    }

    public double getV3vsbHighLimit() {
        return 3.63;
    }

    public double getCpu1DIMMVoltageFormula() {
        return (double)(this.cpu1DIMMVoltage & 0xFF) * 0.008;
    }

    public double getCpu2DIMMVoltageFormula() {
        return (double)(this.cpu2DIMMVoltage & 0xFF) * 0.008;
    }

    public double getV3vsbFormula() {
        return (double)(this.v3vsb & 0xFF) * 0.024;
    }

    @Override
    public double getV1p5Formula() {
        return (double)(this.v1p5 & 0xFF) * 0.008;
    }

    @Override
    public double getV3p3Formula() {
        return (double)(this.v3p3 & 0xFF) * 0.024;
    }

    @Override
    public double getV5Formula() {
        return (double)(this.v5 & 0xFF) * 0.008 * 5.02;
    }

    @Override
    public double getBatteryVoltageFormula() {
        return (double)(this.batteryVoltage & 0xFF) * 0.024;
    }

    @Override
    public int checkCpu1CoreVoltage() {
        if (this.getRemoteCPU1Temp() == 7) {
            return 2;
        }
        if (this.getCpu1CoreVoltageFormula() == 0.0) {
            return 2;
        }
        if (this.getCpu1CoreVoltageFormula() <= this.getCpu1CoreVoltageLowLimit() || this.getCpu1CoreVoltageFormula() >= this.getCpu1CoreVoltageHighLimit()) {
            return 1;
        }
        return 0;
    }

    @Override
    public int checkCpu2CoreVoltage() {
        if (this.getRemoteCPU2Temp() == 7) {
            return 2;
        }
        if (this.getCpu2CoreVoltageFormula() == 0.0) {
            return 2;
        }
        if (this.getCpu2CoreVoltageFormula() <= this.getCpu2CoreVoltageLowLimit() || this.getCpu2CoreVoltageFormula() >= this.getCpu2CoreVoltageHighLimit()) {
            return 1;
        }
        return 0;
    }

    public int checkCpu1DIMMVoltage() {
        if (this.getCpu1DIMMVoltageFormula() == 0.0) {
            return 2;
        }
        if (this.getCpu1DIMMVoltageFormula() <= this.getCpu1DIMMVoltageLowLimit() || this.getCpu1DIMMVoltageFormula() >= this.getCpu1DIMMVoltageHighLimit()) {
            return 1;
        }
        return 0;
    }

    public int checkCpu2DIMMVoltage() {
        if (this.getCpu2DIMMVoltageFormula() == 0.0) {
            return 2;
        }
        if (this.getCpu2DIMMVoltageFormula() <= this.getCpu2DIMMVoltageLowLimit() || this.getCpu2DIMMVoltageFormula() >= this.getCpu2DIMMVoltageHighLimit()) {
            return 1;
        }
        return 0;
    }

    public int checkV3vsb() {
        if (this.getV3vsbFormula() == 0.0) {
            return 2;
        }
        if (this.getV3vsbFormula() <= this.getV3vsbLowLimit() || this.getV3vsbFormula() >= this.getV3vsbHighLimit()) {
            return 1;
        }
        return 0;
    }

    public void setCpu1DIMMVoltage(byte cpu1DIMMVoltage) {
        this.cpu1DIMMVoltage = cpu1DIMMVoltage;
    }

    public void setCpu2DIMMVoltage(byte cpu2DIMMVoltage) {
        this.cpu2DIMMVoltage = cpu2DIMMVoltage;
    }

    public void setV3vsb(byte v3vsb) {
        this.v3vsb = v3vsb;
    }

    public byte getCpu1DIMMVoltage() {
        return this.cpu1DIMMVoltage;
    }

    public byte getCpu2DIMMVoltage() {
        return this.cpu2DIMMVoltage;
    }

    public byte getV3vsb() {
        return this.v3vsb;
    }
}

