/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.microblade;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.microblade.AbstractModuleInfo;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.DecimalFormat;

public class PowerSupplyInfo
extends AbstractModuleInfo {
    public static final String CELSIUS_UNIT = "\u00b0C";
    public byte present;
    public byte psType;
    public byte temp;
    public byte tempHLimit;
    public byte[] fan1Speed;
    public byte[] fan1SpeedLLimit;
    public byte[] fan2Speed;
    public byte[] fan2SpeedLLimit;
    public byte powerStatus;
    public byte[] acRMSCur;
    public byte dcOutputCur;
    public byte firmwareVer;
    public byte fruVer;
    public byte acCurLimit;
    public byte dcCurLimit;
    public byte[] psWatt;
    public byte[] fanSpeed;
    public byte i2CError;
    public byte initialized;
    public byte pollCount;
    public byte psStatusCnt;
    public byte selReportError;
    public byte error;
    public byte lastPwrOnState;
    public byte numOfFans;
    public byte pollFanCount;
    public byte i2CResetCount;
    public byte acInputVolt;
    public byte[] modelName;
    public byte[] CurPowerConsumption;

    @Override
    public void fromRaw(byte[] raw) {
        super.fromRaw(raw);
        int index = 0;
        this.present = raw[index++];
        this.psType = raw[index++];
        this.temp = raw[index++];
        this.tempHLimit = raw[index++];
        this.fan1Speed = ByteUtility.getBytes(raw, index, 4);
        this.fan1SpeedLLimit = ByteUtility.getBytes(raw, index += 4, 4);
        this.fan2Speed = ByteUtility.getBytes(raw, index += 4, 4);
        this.fan2SpeedLLimit = ByteUtility.getBytes(raw, index += 4, 4);
        this.acRMSCur = ByteUtility.getBytes(raw, index += 4, 4);
        index += 4;
        this.powerStatus = raw[index++];
        this.dcOutputCur = raw[index++];
        this.firmwareVer = raw[index++];
        this.fruVer = raw[index++];
        this.acCurLimit = raw[index++];
        this.dcCurLimit = raw[index++];
        this.psWatt = ByteUtility.getBytes(raw, index += 2, 4);
        this.fanSpeed = ByteUtility.getBytes(raw, index += 4, 4);
        index += 4;
        this.i2CError = raw[index++];
        this.initialized = raw[index++];
        this.pollCount = raw[index++];
        this.psStatusCnt = raw[index++];
        this.selReportError = raw[index++];
        ++index;
        ++index;
        int n = ++index;
        this.error = raw[n];
        int n2 = ++index;
        this.lastPwrOnState = raw[n2];
        int n3 = ++index;
        this.numOfFans = raw[n3];
        int n4 = ++index;
        this.pollFanCount = raw[n4];
        int n5 = ++index;
        this.i2CResetCount = raw[n5];
        int n6 = ++index;
        this.acInputVolt = raw[n6];
        this.modelName = ByteUtility.getBytes(raw, ++index, 17);
        this.CurPowerConsumption = ByteUtility.getBytes(raw, index += 17, 4);
        index += 4;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("present =" + this.present);
        sb.append("\npresent =" + this.isPresent());
        sb.append("\npsType =" + this.psType);
        sb.append("\ntemp =" + this.temp);
        sb.append("\ntempHLimit =" + this.tempHLimit);
        sb.append("\nfan1Speed =" + this.getFan1Speed());
        sb.append("\nfan1SpeedLimit =" + this.getFan1SpeedLimit());
        sb.append("\nfan2Speed =" + this.getFan2Speed());
        sb.append("\nfan2SpeedLimit =" + this.getFan2SpeedLimit());
        sb.append("\npowerStatus =" + this.powerStatus);
        sb.append("\nacRMSCur =" + this.getACRMSCur());
        sb.append("\ndcOutputCur =" + this.dcOutputCur);
        sb.append("\nfirmwareVer =" + this.firmwareVer);
        sb.append("\nfirmwareVer =" + this.getfirmwareVer());
        sb.append("\nfruVer =" + this.fruVer);
        sb.append("\nacCurLimit =" + this.acCurLimit);
        sb.append("\ndcCurLimit =" + this.dcCurLimit);
        sb.append("\npsWatt =" + this.getPSWatt());
        sb.append("\nfanSpeed =" + this.getFanSpeed());
        sb.append("\ni2CError =" + this.i2CError);
        sb.append("\ninitialized =" + this.initialized);
        sb.append("\npollCount =" + this.pollCount);
        sb.append("\npsStatusCnt =" + this.psStatusCnt);
        sb.append("\nselReportError =" + this.selReportError);
        sb.append("\nerror =" + this.error);
        sb.append("\nlastPwrOnState =" + this.lastPwrOnState);
        sb.append("\nnumOfFans =" + this.numOfFans);
        sb.append("\npollFanCount =" + this.pollFanCount);
        sb.append("\ni2CResetCount =" + this.i2CResetCount);
        sb.append("\nacInputVolt =" + this.getAcInputVolt());
        sb.append("\nmodelName =" + this.getModelName());
        sb.append("\nPowerConsumption =" + this.getCurPowerConsumption());
        return sb.toString();
    }

    public boolean isPresent() {
        return (byte)(this.present & 1) == 1;
    }

    public String getfirmwareVer() {
        String ver = ByteUtility.byteToHex(this.firmwareVer);
        return ver.substring(0, 1) + "." + ver.substring(1, 2);
    }

    public int getFan1Speed() {
        return ByteUtility.fourBytesToIntByLSBFirst(this.fan1Speed);
    }

    public int getFan1SpeedLimit() {
        return ByteUtility.fourBytesToIntByLSBFirst(this.fan1SpeedLLimit);
    }

    public int getFan2Speed() {
        return ByteUtility.fourBytesToIntByLSBFirst(this.fan2Speed);
    }

    public int getFan2SpeedLimit() {
        return ByteUtility.fourBytesToIntByLSBFirst(this.fan2SpeedLLimit);
    }

    public float getACRMSCur() {
        return ByteBuffer.wrap(this.acRMSCur).order(ByteOrder.LITTLE_ENDIAN).getFloat();
    }

    public int getPSWatt() {
        return ByteUtility.fourBytesToIntByLSBFirst(this.psWatt);
    }

    public int getFanSpeed() {
        return ByteUtility.fourBytesToIntByLSBFirst(this.fanSpeed);
    }

    public int getAcInputVolt() {
        return this.acInputVolt & 0xFF;
    }

    public String getModelName() {
        return new String(this.modelName).trim();
    }

    public int getCurPowerConsumption() {
        return ByteUtility.fourBytesToIntByLSBFirst(this.CurPowerConsumption);
    }

    public static final int getIndex(String index) {
        int alternateIndex = -1;
        if (index.equalsIgnoreCase("A1")) {
            alternateIndex = 0;
        } else if (index.equalsIgnoreCase("A2")) {
            alternateIndex = 1;
        } else if (index.equalsIgnoreCase("A3")) {
            alternateIndex = 2;
        } else if (index.equalsIgnoreCase("A4")) {
            alternateIndex = 3;
        } else if (index.equalsIgnoreCase("B1")) {
            alternateIndex = 4;
        } else if (index.equalsIgnoreCase("B2")) {
            alternateIndex = 5;
        } else if (index.equalsIgnoreCase("B3")) {
            alternateIndex = 6;
        } else if (index.equalsIgnoreCase("B4")) {
            alternateIndex = 7;
        }
        return alternateIndex;
    }

    public static final String getIndex(int index) {
        String alternateIndex = null;
        switch (index) {
            case 0: {
                alternateIndex = "A1";
                break;
            }
            case 1: {
                alternateIndex = "A2";
                break;
            }
            case 2: {
                alternateIndex = "A3";
                break;
            }
            case 3: {
                alternateIndex = "A4";
                break;
            }
            case 4: {
                alternateIndex = "B1";
                break;
            }
            case 5: {
                alternateIndex = "B2";
                break;
            }
            case 6: {
                alternateIndex = "B3";
                break;
            }
            case 7: {
                alternateIndex = "B4";
            }
        }
        return alternateIndex;
    }

    public String toFormatedHeader() {
        String formatTemplate = " %-30s | %20s \n";
        StringBuffer header = new StringBuffer();
        header.append(String.format(formatTemplate, "Item", "Value"));
        header.append(String.format(formatTemplate, "----", "-----"));
        return header.toString();
    }

    public String toFormatedString() {
        if (!this.isPresent()) {
            return "";
        }
        String f = " %-30s | %20s \n";
        StringBuffer stringBuffer = new StringBuffer();
        String index = "Power Supply " + PowerSupplyInfo.getIndex(this.getIndex());
        DecimalFormat decimalFormat = new DecimalFormat("#.##");
        stringBuffer.append(String.format(f, "Power Supply", index));
        stringBuffer.append(String.format(f, "Model Name", this.getModelName()));
        stringBuffer.append(String.format(f, "Power Status", this.powerStatus == 1 ? "On" : "Off"));
        stringBuffer.append(String.format(f, "Temperature", this.temp > 0 ? this.temp + CELSIUS_UNIT : "N/A"));
        stringBuffer.append(String.format(f, "Fan Speed (RPM)", this.getFan1Speed()));
        stringBuffer.append(String.format(f, "AC Input Voltage", this.getAcInputVolt() > 0 ? this.getAcInputVolt() + " V" : "N/A"));
        stringBuffer.append(String.format(f, "Max Watt", this.getPSWatt() > 0 ? this.getPSWatt() + " W" : "N/A"));
        stringBuffer.append(String.format(f, "AC Input Current", this.getACRMSCur() > 0.0f ? decimalFormat.format(this.getACRMSCur()) + " A" : "N/A"));
        stringBuffer.append(String.format(f, "DC Output Current", this.dcOutputCur > 0 ? this.dcOutputCur + " A" : "N/A"));
        stringBuffer.append(String.format(f, "Current Power Usage", this.dcOutputCur > 0 ? decimalFormat.format((float)(100 * this.dcOutputCur * 12) / (float)this.getPSWatt()) + "%" : "N/A"));
        stringBuffer.append(String.format(f, "FW Version", this.getfirmwareVer()));
        stringBuffer.append(String.format(f, "FRU Version", this.fruVer));
        stringBuffer.append(String.format(f, "Error", this.error == 0 ? "Normal" : Byte.valueOf(this.error)));
        return stringBuffer.toString();
    }
}

