/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.IPMIX9BIOSOEMCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.text.BIOSAbstractCommand;
import com.supermicro.ipmi.text.MOut;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BIOSSetKeysCommand
extends BIOSAbstractCommand {
    public void usage() {
        MOut.G(this).println("This command is used to activate Node product key via a file");
        MOut.G(this).println("It is used for Node product keys activation on multiple BMCs");
    }

    @Override
    public boolean preValidate() {
        if (this.parameters == null) {
            MOut.G(this).println("Node product key file is required");
            MOut.G(this).println("");
            this.usage();
            this.statusCode = 149;
            return false;
        }
        File file = new File(this.parameters[0]);
        if (!file.isFile()) {
            MOut.G(this).println("Cannot find file : " + this.parameters[0]);
            this.statusCode = 149;
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        String line;
        String filename = this.parameters[0];
        BufferedReader in = new BufferedReader(new FileReader(filename));
        boolean isProcessAny = false;
        while ((line = in.readLine()) != null) {
            String key;
            String ip;
            String mac;
            block13: {
                if (line.length() == 0) continue;
                if (line.startsWith("#")) {
                    this.writeLog(filename + ".act", line);
                    continue;
                }
                try {
                    StringTokenizer st = new StringTokenizer(line, ";");
                    mac = st.nextToken();
                    ip = st.nextToken();
                    key = st.nextToken();
                    if (!(IPMILanCommand.isMacAddressNoColon(mac) && IPMILanCommand.isIPAddress(ip) && BIOSSetKeysCommand.validateKeyFormat(key))) {
                        this.writeLog(filename + ".act", line);
                    }
                    break block13;
                }
                catch (NoSuchElementException ex1) {
                    this.writeLog(filename + ".act", line);
                }
                continue;
            }
            MOut.G(this).print("Activating Node product key at " + ip + "... ");
            int result = this.activateProductKey(ip, mac, key);
            String resultStr = "";
            switch (result) {
                case 0: {
                    resultStr = "Done";
                    break;
                }
                case 1: {
                    resultStr = "Error: Cannot connect to IP";
                    break;
                }
                case 2: {
                    resultStr = "Error: MAC does not match";
                    break;
                }
                case 3: {
                    resultStr = "Error: Node product Key invalid";
                    break;
                }
                default: {
                    resultStr = "Error: unknown";
                }
            }
            MOut.G(this).println(resultStr);
            this.statusCode = resultStr.equals("Done") ? 0 : 149;
            this.writeLog(filename + ".act", mac + ";" + ip + ";" + resultStr);
            isProcessAny = true;
        }
        if (isProcessAny) {
            System.out.println("file " + filename + ".act is created");
            System.out.println("Please check this file for the result of Node product keys activation");
        } else {
            System.out.println("None of valid data to process Node product key");
        }
    }

    public int activateProductKey(String ip, String mac, String key) {
        IPMIInterfaceConfig ipmiConfig = new IPMIInterfaceConfig();
        ipmiConfig.setIp(ip);
        ipmiConfig.setUserName(this.config.getUserName());
        ipmiConfig.setPassword(this.config.getPassword());
        this.config.setPrivilege((byte)4);
        IPMIX9BIOSOEMCommand ipmiX9BIOSOEMCommand = new IPMIX9BIOSOEMCommand(null);
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(ipmiConfig, ipmiX9BIOSOEMCommand);
        if (sessionController == null) {
            return 1;
        }
        ipmiLanCommand.setIPMIInterface(ipmiX9BIOSOEMCommand.getIPMIInterface());
        try {
            String bmcMAC = ipmiLanCommand.getMAC2Ex();
            if (!mac.equalsIgnoreCase(bmcMAC)) {
                sessionController.closeSession();
                return 2;
            }
            byte[] productKey = ByteUtility.fromFormatKey(key);
            boolean result = ipmiX9BIOSOEMCommand.biosSetProductKey(productKey);
            if (result) {
                sessionController.closeSession();
                return 0;
            }
            sessionController.closeSession();
            return 3;
        }
        catch (Exception ex) {
            sessionController.closeSession();
            return 99;
        }
    }

    public static boolean validateKeyFormat(String value) {
        Pattern macPattern = Pattern.compile("[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}");
        Matcher m = macPattern.matcher(value);
        return m.matches();
    }

    public void writeLog(String filename, String msg) {
        try {
            FileWriter outs = new FileWriter(filename, true);
            outs.write(msg + "\n");
            outs.close();
        }
        catch (IOException ex) {
            System.out.println("--- error to write log[" + filename + "]! ---");
        }
    }
}

