/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ACPIInfo;
import com.supermicro.ipmi.IPMIGlobalCommand;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMIX9BIOSOEMCommand;
import com.supermicro.ipmi.lic.SWKeyExpiredException;
import com.supermicro.ipmi.lic.SWLicenseAdapter;
import com.supermicro.ipmi.text.BIOSAbstractCommand;
import com.supermicro.ipmi.text.MOut;

public class BIOSVerCommand
extends BIOSAbstractCommand {
    @Override
    public void runCommand() throws Exception {
        this.closeSessionIfExist();
        boolean isPassSWKey = false;
        try {
            if (SWLicenseAdapter.isSWFRUSupported(this.config) && SWLicenseAdapter.check_SFT_SUM_LIC_ProductKey(this.config)) {
                isPassSWKey = true;
            }
        }
        catch (SWKeyExpiredException e) {
            MOut.G(this).println("Node product key is expired");
            this.statusCode = 155;
            return;
        }
        this.createSession();
        if (!isPassSWKey && !this.checkIfSupportBIOSUpdate()) {
            MOut.G(this).println("This device doesn't support BIOS commands");
            MOut.G(this).println("BIOS commands only support X9 series montherboards");
            this.statusCode = 153;
            return;
        }
        IPMIGlobalCommand ipmiGlobalCommand = new IPMIGlobalCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        ACPIInfo acpiInfo = ipmiGlobalCommand.getACPI();
        byte[] guid = ipmiMessagingCommand.getSystemGUID();
        if (acpiInfo.getSystemState() == 0 || acpiInfo.getSystemState() == 1 || acpiInfo.getSystemState() == 2 || acpiInfo.getSystemState() == 3) {
            if (IPMIMessagingCommand.isAMIX9GUID(guid)) {
                this.ipmiX9BIOSOEMCommand = new IPMIX9BIOSOEMCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
                try {
                    String amiBIOSVerString = this.ipmiX9BIOSOEMCommand.getBIOSVersionForAMIX9AndSystemIsOn();
                    MOut.G(this).println(amiBIOSVerString);
                    this.statusCode = 0;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.statusCode = 149;
                    MOut.G(this).println("Get BIOS Info failed");
                }
                return;
            }
        }
        if (!isPassSWKey && this.checkIfSWProductKeyNotActivated()) {
            MOut.G(this).println("The Node product key needs to be activated for this device");
            this.statusCode = 153;
            return;
        }
        if (!this.getBIOSInfo()) {
            MOut.G(this).println("Get BIOS Info failed");
            this.statusCode = 153;
            return;
        }
        MOut.G(this).println(this.biosInfo.toStringFromBMC());
        this.statusCode = 0;
    }
}

