/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.IPMIOEMWebSettingCommand;
import com.supermicro.ipmi.text.IPMIX10OEMWebSettingAbstractCommand;
import com.supermicro.ipmi.text.MOut;

public class IPMIOEMDNSStateCommand
extends IPMIX10OEMWebSettingAbstractCommand {
    public static final byte DNS_IPV4 = 0;
    public static final byte DNS_ADD = 0;
    public static final byte DNS_DEL = 1;

    @Override
    public void runCommand() throws Exception {
        if (!this.isX10CFGSupported()) {
            MOut.G(this).println("This command supports X10 platform only");
            this.statusCode = 153;
            return;
        }
        if (this.checkIfSWProductKeyNotActivated()) {
            return;
        }
        IPMIOEMWebSettingCommand ipmiOEMWebSettingCommand = new IPMIOEMWebSettingCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        if (this.getParameters() == null) {
            String DNSIP = ipmiOEMWebSettingCommand.getDNS((byte)0);
            MOut.G(this).println(new String(DNSIP));
            this.statusCode = 0;
        } else if (this.getParameters().length == 1) {
            String newDNSIP = this.getParameters()[0];
            if (!IPMILanCommand.isIPAddress(newDNSIP)) {
                MOut.G(this).println("IP format error!");
                this.statusCode = 147;
                return;
            }
            if (newDNSIP.equals("0.0.0.0")) {
                MOut.G(this).println("IP cannot be 0.0.0.0!");
                this.statusCode = 147;
                return;
            }
            boolean result = ipmiOEMWebSettingCommand.setDNS((byte)0, newDNSIP, (byte)0);
            if (result) {
                this.statusCode = 0;
                MOut.G(this).println("Done");
            } else {
                this.statusCode = 149;
            }
        } else {
            this.printUsage();
        }
    }

    public void printUsage() {
        MOut.G(this).println("Usage: ipmi oem x10cfg dns [dns_IP] ");
    }
}

