/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.blade.AbstractMBSensorEntity;
import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.blade.GigabitSwitchEntity;
import com.supermicro.ipmi.blade.IBFDREntity;
import com.supermicro.ipmi.blade.IBQDREntity;
import com.supermicro.ipmi.blade.InfiniBandEntity;
import com.supermicro.ipmi.blade.PowerSupplyEntity;
import com.supermicro.ipmi.blade.TemperatureData;
import com.supermicro.ipmi.blade.TenGSwitchEntity;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import java.util.ArrayList;

public class ListSystemTemperatureCommand
extends SuperBladeCommand {
    StringBuffer formatedString;
    String formatTemplate = "  %-6s | %-12s | %-20s | %10s | %10s |\n";

    @Override
    public void runCommand() throws Exception {
        int i;
        if (!this.isMaster) {
            this.printSlaveCMMUnavailableMessage();
            this.statusCode = 150;
            return;
        }
        BladeSystemEntity bladeSystemEntity = this.getBladeSystemEntity();
        if (bladeSystemEntity == null) {
            this.statusCode = 149;
            return;
        }
        this.formatedString = new StringBuffer();
        this.formatedString.append(String.format(this.formatTemplate, "Status", "Module", "Sensor", "Reading", "High Limit"));
        this.formatedString.append(String.format(this.formatTemplate, "------", "------", "------", "-------", "----------"));
        for (i = 0; i < bladeSystemEntity.getBlades().length; ++i) {
            AbstractMBSensorEntity mbSensorEntity = bladeSystemEntity.getMbSensors()[i];
            this.addBladeTemp(mbSensorEntity, i + 1);
        }
        for (i = 0; i < bladeSystemEntity.getPowerSupplies().length; ++i) {
            PowerSupplyEntity powerSupplyEntity = bladeSystemEntity.getPowerSupplies()[i];
            this.addPowerTemp(powerSupplyEntity, i + 1);
        }
        for (i = 0; i < bladeSystemEntity.getGigabitSwitchs().length; ++i) {
            GigabitSwitchEntity gigabitSwitchEntity = bladeSystemEntity.getGigabitSwitchs()[i];
            this.addGBTemp(gigabitSwitchEntity, i + 1);
        }
        for (i = 0; i < bladeSystemEntity.getTenGSwitches().length; ++i) {
            TenGSwitchEntity tenG = bladeSystemEntity.getTenGSwitches()[i];
            this.addTenGTemp(tenG, i + 1);
        }
        for (i = 0; i < bladeSystemEntity.getInfiniBands().length; ++i) {
            this.addIBTemp(bladeSystemEntity, i + 1);
        }
        MOut.G(this).println(this.formatedString.toString());
        this.statusCode = 0;
    }

    private void addBladeTemp(AbstractMBSensorEntity mbSensorEntity, int index) {
        if (mbSensorEntity.getFlag() == 0) {
            return;
        }
        ArrayList<TemperatureData> list = mbSensorEntity.getTemperatures();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                TemperatureData t = list.get(i);
                this.addRaw(t.getStatus(), "Blade " + index, t.getSensor(), t.getReading(), t.getHiLimit());
            }
        }
    }

    private void addPowerTemp(PowerSupplyEntity powerSupplyEntity, int index) {
        if (powerSupplyEntity.getPresent() == 0) {
            return;
        }
        String result = "";
        result = powerSupplyEntity.getTemperature() < powerSupplyEntity.getTemperatureHighLimit() ? "OK" : "Fail";
        this.addRaw(result, "Power " + index, "Temp.", this.showCandF(powerSupplyEntity.getTemperature()), this.showCandF(powerSupplyEntity.getTemperatureHighLimit()));
    }

    private void addGBTemp(GigabitSwitchEntity gigabitSwitchEntity, int index) {
        if (gigabitSwitchEntity.getPresent() <= 0 || gigabitSwitchEntity.getInitialized() != 1) {
            return;
        }
        String result = "";
        result = gigabitSwitchEntity.getSwitchTemperature() < 80 ? "OK" : "Fail";
        this.addRaw(result, "GBSW " + index, "Switch", "" + this.showCandF(gigabitSwitchEntity.getSwitchTemperature()), this.showCandF((byte)80));
    }

    private void addTenGTemp(TenGSwitchEntity tenG, int index) {
        if (tenG.getPresent() <= 0 || !tenG.is10GSwitch()) {
            return;
        }
        String result = "";
        result = tenG.getSwitchTemperature() < 80 ? "OK" : "Fail";
        this.addRaw(result, "10G SW " + (index += 2), "Switch", "" + this.showCandF(tenG.getSwitchTemperature()), this.showCandF((byte)80));
    }

    private void addIBTemp(BladeSystemEntity bladeSystem, int index) {
        InfiniBandEntity ib = bladeSystem.getInfiniBands()[index - 1];
        TenGSwitchEntity tenG = bladeSystem.getTenGSwitches()[index - 1];
        IBQDREntity ibQDR = bladeSystem.getIBQDRs()[index - 1];
        IBFDREntity ibFDR = bladeSystem.getIBFDRs()[index - 1];
        if (ib.getPresent() == 0) {
            return;
        }
        if (ib.getPresent() > 0 && ib.getReserve3() == 0 && (ib.getFlag() & 0xFE) == 0 && !tenG.is10GSwitch() && ib.getInitialized() == 1) {
            String result = "";
            result = ib.getTemperature() < 80 ? "OK" : "Fail";
            this.addRaw(result, "InfiniBand " + index, "Temp.", this.showCandF(ib.getTemperature()), this.showCandF((byte)80));
        } else if (ibQDR.getPresent() > 0 && (ibQDR.isIBQDR() || ibQDR.isIBQDRPassThru())) {
            String result = "";
            result = ibQDR.getSwitchTemp() < 80 ? "OK" : "Fail";
            this.addRaw(result, "IBQDR " + index, "Temp.", this.showCandF(ibQDR.getSwitchTemp()), this.showCandF((byte)80));
        } else if (ibFDR.getPresent() > 0 && ibFDR.isIBFDR()) {
            String result = "";
            result = ibFDR.getSwitchTempFormula() < 80 ? "OK" : "Fail";
            this.addRaw(result, "IBFDR " + index, "Temp.", this.showCandF((byte)ibFDR.getSwitchTempFormula()), this.showCandF((byte)80));
        }
    }

    protected void addRaw(String checkedResult, String module, String name, String value, String high) {
        this.formatedString.append(String.format(this.formatTemplate, checkedResult, module, name, value, high));
    }

    protected String showCandF(byte c) {
        if (c == -127) {
            return "N/A";
        }
        long f = Math.round(1.8 * (double)c + 32.0);
        return c + "C/" + (f < 100L ? " " : "") + f + "F";
    }

    public String getBar(byte c) {
        return null;
    }
}

