/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ConfigAccessor;
import com.supermicro.ipmi.text.Argument;
import com.supermicro.ipmi.text.CommandPlugIn;
import java.io.File;
import java.io.FileFilter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class PlugInJarClassLoader
implements FileFilter {
    File[] jarFiles;
    File[] PropertiesFiles;
    String searchExtname = "jar";
    ClassLoader classLoader;

    public String getExtname(String filename) {
        int index = filename.lastIndexOf(".");
        if (index == -1) {
            return null;
        }
        String extname = filename.substring(index + 1, filename.length());
        return extname;
    }

    public String getFilenameWithoutExt(String filename) {
        int index = filename.lastIndexOf(".");
        if (index == -1) {
            return null;
        }
        String extname = filename.substring(0, index);
        return extname;
    }

    @Override
    public boolean accept(File pathname) {
        String filename = pathname.getName();
        String extname = this.getExtname(filename);
        return this.searchExtname.equalsIgnoreCase(extname);
    }

    public File[] findJarFiles() {
        File f = new File(".");
        this.searchExtname = "jar";
        return f.listFiles(this);
    }

    public ArrayList<String> findPlugInFiles() {
        ArrayList<String> found = new ArrayList<String>();
        File[] jarFiles = this.findJarFiles();
        for (int i = 0; i < jarFiles.length; ++i) {
            File testFile;
            String fNoExt = this.getFilenameWithoutExt(jarFiles[i].getName());
            if (fNoExt == null || !(testFile = new File(fNoExt + ".properties")).isFile()) continue;
            found.add(fNoExt);
        }
        return found;
    }

    public void loadJarFile(String filename) {
        try {
            URL[] urlList = new URL[]{new File(filename).toURL()};
            this.classLoader = new URLClassLoader(urlList, ClassLoader.getSystemClassLoader());
            JarFile jf = new JarFile(new File(filename));
            Enumeration<JarEntry> e = jf.entries();
            while (e.hasMoreElements()) {
                String jarEntry = ((Object)e.nextElement()).toString();
                if (!jarEntry.endsWith(".class") || jarEntry.indexOf("nn/pp/rc/JSSE") != -1) continue;
                jarEntry = jarEntry.replace('/', '.');
                jarEntry = jarEntry.substring(0, jarEntry.length() - 6);
                Class<?> c = this.classLoader.loadClass(jarEntry);
            }
        }
        catch (Exception e) {
            System.out.println("Got the exception: " + e.toString());
        }
    }

    public ArrayList<Argument> load() {
        ArrayList<Argument> listArgument = new ArrayList<Argument>();
        ArrayList<String> list = this.findPlugInFiles();
        for (int i = 0; i < list.size(); ++i) {
            if ("SMCIPMITool".equalsIgnoreCase(list.get(i))) continue;
            this.loadJarFile(list.get(i) + ".jar");
            ConfigAccessor ca = new ConfigAccessor(".", list.get(i) + ".properties");
            String classname = ca.getProperty("class");
            if (classname == null || classname.length() == 0) continue;
            try {
                Class<?> classObject = this.classLoader.loadClass(classname);
                Object o = classObject.newInstance();
                CommandPlugIn commandPlugIn = (CommandPlugIn)o;
                Argument argument = new Argument(commandPlugIn.getName(), commandPlugIn.getValue(), commandPlugIn.getComment(), commandPlugIn);
                if (commandPlugIn.getAlternateValue() != null) {
                    argument.addAlternateValue(commandPlugIn.getAlternateValue());
                }
                listArgument.add(argument);
                continue;
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
                continue;
            }
            catch (InstantiationException ex) {
                ex.printStackTrace();
                continue;
            }
            catch (ClassNotFoundException ex) {
                ex.printStackTrace();
            }
        }
        return listArgument;
    }

    public static void main(String[] args) {
        PlugInJarClassLoader c = new PlugInJarClassLoader();
        ArrayList<Argument> arguments = c.load();
        System.out.println(arguments.size());
    }

    public static void main_method_invoke_test(String[] args) {
        PlugInJarClassLoader c = new PlugInJarClassLoader();
        ArrayList<String> found = c.findPlugInFiles();
        System.out.println(found.size());
        c.loadJarFile("IPMIUDPProxy.jar");
        try {
            Class<?> c1 = Class.forName("com.supermicro.ipmi.IPMIInterfaceConfig");
            Object o = c1.newInstance();
            Method m = c1.getMethod("setIp", "".getClass());
            m.invoke(o, "123123123");
            m = c1.getMethod("getIp", new Class[0]);
            Object r = m.invoke(o, new Object[0]);
            System.out.println("return =" + r);
            System.out.println(o.getClass().getName());
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        }
        catch (SecurityException ex) {
            ex.printStackTrace();
        }
        catch (NoSuchMethodException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
    }
}

