/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.drvredir;

import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.blade.CMMModuleEntity;
import com.supermicro.ipmi.text.CommandPlugIn;
import com.supermicro.ipmi.text.MOut;
import java.io.IOException;
import nn.pp.drvredir.ConnectionHandlerLiteDrive;
import nn.pp.drvredir.ConnectionHandlerLiteIso;
import nn.pp.drvredir.Drive;
import nn.pp.drvredir.DrvRedirNative;
import nn.pp.rc.RFBProfile;

public class DrvRedirPlugIn
extends CommandPlugIn {
    public DrvRedirPlugIn() {
        this.isSupportBackgroundModeForTaskRunCommand = false;
    }

    @Override
    public String[] getSubCommandsForTabCompletion() {
        return new String[]{"list", "iso", "drv"};
    }

    @Override
    public void execute() throws Exception {
        if (!this.isVirutalMediaSupported()) {
            this.printSlaveCMMUnavailableMessage();
            return;
        }
        if (this.parameters == null || this.parameters.length == 0) {
            this.usage();
            return;
        }
        String subCommand = this.parameters[0];
        if (subCommand.equalsIgnoreCase("list")) {
            if (System.getProperty("os.name").toLowerCase().indexOf("win") == -1) {
                MOut.G().println("Drive list doesn't support on this OS(" + System.getProperty("os.name") + ").\nOnly Windows platform supported");
                return;
            }
            this.listAvailableDrive();
        } else if (subCommand.equalsIgnoreCase("iso")) {
            if (this.parameters.length < 3) {
                this.isoUsage();
                return;
            }
            String driveID = this.parameters[1];
            String filename = this.parameters[2];
            if (!driveID.equals("1") && !driveID.equals("2")) {
                MOut.G().print("Drive ID should 1 or 2");
                return;
            }
            this.setISORedir(Integer.parseInt(driveID), filename);
        } else if (subCommand.equalsIgnoreCase("drv")) {
            if (System.getProperty("os.name").toLowerCase().indexOf("win") == -1) {
                MOut.G().println("Drive redirection doesn't support on this OS(" + System.getProperty("os.name") + ").\nOnly Windows platform supported");
                return;
            }
            if (this.parameters.length < 3) {
                this.drvUsage();
                return;
            }
            String driveID = this.parameters[1];
            String driveLetter = this.parameters[2];
            boolean isWriteSupport = false;
            if (!driveID.equals("1") && !driveID.equals("2")) {
                MOut.G().print("Drive ID should 1 or 2");
                return;
            }
            if (this.parameters.length >= 4 && this.parameters[3].equalsIgnoreCase("enable")) {
                isWriteSupport = true;
            }
            this.setDRVRedir(Integer.parseInt(driveID), driveLetter, isWriteSupport);
        } else {
            this.usage();
            return;
        }
    }

    public boolean isVirutalMediaSupported() {
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (guid == null) {
            return false;
        }
        if (IPMIMessagingCommand.isCMMGUID(guid)) {
            return this.isCurrentCMMMaster();
        }
        if (IPMIMessagingCommand.isPepperconGUID(guid)) {
            return true;
        }
        if (IPMIMessagingCommand.isPepperconNoneKVMGUID(guid)) {
            return true;
        }
        if (IPMIMessagingCommand.isSIMBL(guid)) {
            return true;
        }
        if (IPMIMessagingCommand.isOSAGUID(guid)) {
            return false;
        }
        return false;
    }

    public boolean isCurrentCMMMaster() {
        BladeSystemEntity bladeSystem = new BladeSystemEntity(this.config, 10, 2, 2, 2, 4);
        bladeSystem.setEnableAllQuery(false);
        bladeSystem.setIsQueryCMMModuleEntity(true);
        bladeSystem.getData();
        for (int i = 0; i < 2; ++i) {
            CMMModuleEntity cmm = bladeSystem.getCmmModules()[i];
            if (!cmm.isConnected() || cmm.getMasterSlave() != 0) continue;
            return true;
        }
        return false;
    }

    public void printSlaveCMMUnavailableMessage() {
        MOut.G().println("This function is unavailable for this device or slave CMM.");
    }

    public void usage() {
        MOut.G().printf("Available commands:\n", new Object[0]);
        MOut.G().printf("%-25s \t %-20s \n", "dr list", "List available local drive");
        MOut.G().printf("%-48s\t %-20s \n", "dr iso <drive ID> <path to iso file>", "Set ISO redirection");
        MOut.G().printf("%-48s\t %-20s \n", "dr drv <drive ID> <drive Letter> [write ? enable]", "Set drive redirection");
    }

    public void isoUsage() {
        MOut.G().printf("Available command:\n", new Object[0]);
        MOut.G().printf("%-48s\t %-20s \n", "dr iso <drive ID> <path to iso file>", "Set ISO redirection");
        MOut.G().printf("example: dr iso c:\\cd.iso\n", new Object[0]);
        MOut.G().printf("This will extablish a ISO redirecion with you cd.iso\n", new Object[0]);
        MOut.G().printf("Note: If your path include space, please place double quote\n", new Object[0]);
        MOut.G().printf("      at begin and end of <path to iso file>\n", new Object[0]);
    }

    public void drvUsage() {
        MOut.G().printf("Available command:\n", new Object[0]);
        MOut.G().printf("%-48s\t %-20s \n", "dr drv <drive ID> <drive Letter> [write ? enable]", "Set drive redirection");
        MOut.G().printf("Example 1: dr drv 1 d\n", new Object[0]);
        MOut.G().printf("This will establish a drive redirecion with your local d drive.\n", new Object[0]);
        MOut.G().printf("The write support is disabled\n", new Object[0]);
        MOut.G().printf("\n", new Object[0]);
        MOut.G().printf("Example 2: dr drv 1 e enable\n", new Object[0]);
        MOut.G().printf("This will establish a drive redirecion with your local e drive.\n", new Object[0]);
        MOut.G().printf("The write support is enabled\n", new Object[0]);
        MOut.G().printf("\nPlease use the \"dr list\" command to see available drives\n", new Object[0]);
    }

    public void listAvailableDrive() {
        try {
            DrvRedirNative drvn = new DrvRedirNative(null);
            Drive[] drives = drvn.getAvailableDrives();
            for (int i = 0; i < drives.length; ++i) {
                System.out.println(drives[i].getNameAndDescription());
            }
        }
        catch (Exception ex) {
            MOut.G().println(ex.getMessage());
        }
    }

    public void setISORedir(int driveID, String filename) {
        RFBProfile rfbProfile = new RFBProfile();
        rfbProfile.remoteHost = this.config.getIp();
        rfbProfile.username = this.config.getUserName();
        rfbProfile.password = this.config.getPassword();
        rfbProfile.driveRedirectionNoDrives = 2;
        rfbProfile.driveRedirection = true;
        ConnectionHandlerLiteIso iso = new ConnectionHandlerLiteIso(rfbProfile, System.out, driveID - 1);
        try {
            iso.chooseIsoFile(filename);
            iso.connect();
            MOut.G().println("Done");
            MOut.G().println("Note: The ISO redirection will stop once you quit shell mode");
        }
        catch (IOException ex1) {
            MOut.G().println(ex1.getMessage());
        }
        catch (Exception ex1) {
            MOut.G().println(ex1.getMessage());
        }
    }

    public void setDRVRedir(int driveID, String driveLetter, boolean isWriteSupport) {
        RFBProfile rfbProfile = new RFBProfile();
        rfbProfile.remoteHost = this.config.getIp();
        rfbProfile.username = this.config.getUserName();
        rfbProfile.password = this.config.getPassword();
        rfbProfile.driveRedirectionNoDrives = 2;
        rfbProfile.driveRedirection = true;
        try {
            ConnectionHandlerLiteDrive drive = new ConnectionHandlerLiteDrive(rfbProfile, System.out, driveID - 1);
            drive.chooseDrive(driveLetter, isWriteSupport);
            drive.connect();
            MOut.G().println("Done");
            MOut.G().println("Note: The drive redirection will stop once you quit shell mode");
        }
        catch (IOException ex1) {
            MOut.G().println(ex1.getMessage());
        }
        catch (Exception ex1) {
            MOut.G().println(ex1.getMessage());
        }
    }

    @Override
    public String getAlternateValue() {
        return null;
    }

    @Override
    public String getComment() {
        return "Drive redirection";
    }

    @Override
    public String getName() {
        return "dr";
    }

    @Override
    public String getValue() {
        return "dr";
    }

    @Override
    public boolean isSupportCLIMode() {
        return false;
    }

    @Override
    public boolean isSupportShellMode() {
        return true;
    }

    public static void main(String[] args) {
    }
}

