/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.rc;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import nn.pp.rc.CursorType;
import nn.pp.rc.JVMVersionInfo;
import nn.pp.rc.T;

public class CustomCursor {
    private boolean bSupportsCustom;
    private Dimension cursorSize;
    private Integer dMaxColors;
    private Hashtable cursorHash;
    private int systemCursors;
    private Vector cursors;
    private CursorType currentCursor;
    String c1 = T._("Pixel");
    String c2 = T._("Transparent");
    String c3 = T._("Big");
    String c4 = T._("Default");
    String c5 = T._("Crosshair");

    public CustomCursor(String localcursor) {
        this.cursorHash = new Hashtable();
        this.dMaxColors = new Integer(0);
        this.fillSystemCursors();
        if (JVMVersionInfo.getJVMVersionInfo().isJava12()) {
            this.fillCustomCursors();
        }
        this.currentCursor = this.getCursor(localcursor);
        if (this.currentCursor == null) {
            this.currentCursor = this.getCursor("Default");
        }
    }

    public Object[] getCursors() {
        this.cursors = new Vector();
        Enumeration e = this.cursorHash.elements();
        while (e.hasMoreElements()) {
            this.cursors.addElement(e.nextElement());
        }
        return this.toArray(this.cursors);
    }

    public CursorType getCursor(String name) {
        if (name == null) {
            return null;
        }
        return (CursorType)this.cursorHash.get(name);
    }

    public CursorType getCurrentCursor() {
        return this.currentCursor;
    }

    public void setCurrentCursor(CursorType cursor) {
        this.currentCursor = cursor;
    }

    private void fillSystemCursors() {
        Cursor sysCursor = new Cursor(0);
        CursorType cursorType = new CursorType("Default", sysCursor);
        cursorType.cursor = sysCursor;
        this.cursorHash.put(T.N_("Default"), cursorType);
        sysCursor = new Cursor(1);
        cursorType = new CursorType("Crosshair", sysCursor);
        cursorType.cursor = sysCursor;
        this.cursorHash.put(T.N_("Crosshair"), cursorType);
    }

    private void fillCustomCursors() {
        BufferedReader reader;
        Class<?> clToolkit;
        String line = null;
        Method me = null;
        Toolkit kit = Toolkit.getDefaultToolkit();
        try {
            clToolkit = Class.forName("java.awt.Toolkit");
            me = clToolkit.getMethod("getMaximumCursorColors", null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.dMaxColors = (Integer)me.invoke((Object)kit, null);
            if (this.dMaxColors == new Integer(0)) {
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        Class[] params = new Class[3];
        Object[] arglist = new Object[3];
        params[0] = Image.class;
        params[1] = Point.class;
        params[2] = String.class;
        try {
            clToolkit = Class.forName("java.awt.Toolkit");
            me = clToolkit.getMethod("createCustomCursor", params);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        try {
            InputStream istream = this.getClass().getClassLoader().getResourceAsStream("nn/pp/rc/cursors.txt");
            reader = new BufferedReader(new InputStreamReader(istream));
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        try {
            while ((line = reader.readLine()) != null) {
                StringTokenizer tokenizer = new StringTokenizer(line, " ");
                if (tokenizer.countTokens() != 4) continue;
                String cursorName = tokenizer.nextToken();
                String fileName = tokenizer.nextToken();
                Integer hotX = new Integer(tokenizer.nextToken());
                Integer hotY = new Integer(tokenizer.nextToken());
                Image cursorImage = kit.getImage(this.getClass().getClassLoader().getResource("nn/pp/rc/" + fileName));
                arglist[0] = cursorImage;
                arglist[1] = new Point(hotX, hotY);
                arglist[2] = cursorName;
                Cursor cursor = (Cursor)me.invoke((Object)kit, arglist);
                CursorType cursorType = new CursorType(cursorName, cursor);
                cursorType.cursor = cursor;
                this.cursorHash.put(cursorName, cursorType);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Object[] toArray(Vector v) {
        Object[] os = new Object[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            os[i] = v.elementAt(i);
        }
        return os;
    }

    private static void swap(Vector aVector, int left, int right) {
        Object save = aVector.elementAt(left);
        aVector.setElementAt(aVector.elementAt(right), left);
        aVector.setElementAt(save, right);
    }
}

