/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.rc;

import java.io.IOException;
import java.io.PrintStream;
import java.net.Socket;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import nn.pp.rc.JVMVersionInfo;
import nn.pp.rc.RFBProfile;
import nn.pp.rc.SSLConnector;
import nn.pp.rc.T;
import nn.pp.rc.TunnelSocket;

public class ErlaConnector {
    public RFBProfile profile;
    boolean isSecure = false;
    String secDesc = "";
    protected String sockerr = "";
    PrintStream logger;
    private String protocol;

    public ErlaConnector(RFBProfile profile, PrintStream logger, String protocol) {
        this.profile = profile;
        this.logger = logger;
        this.protocol = protocol;
    }

    public Socket connect(String host, int port) {
        String hp = "" + host + ':' + port;
        this.logger.println(this.protocol + ": " + MessageFormat.format(T._("trying connection to {0}"), hp));
        Socket s = null;
        try {
            s = new Socket(host, port);
            this.logger.println(this.protocol + ": " + MessageFormat.format(T._("connected successfully to {0}"), hp));
            this.isSecure = false;
            this.secDesc = T._("Norm");
        }
        catch (Exception e) {
            this.logger.println(this.protocol + ": " + T._("connect:") + " " + e);
            this.logger.println(this.protocol + ": " + MessageFormat.format(T._("connection FAILED to {0}"), hp));
            this.sockerr = e.getMessage();
        }
        return s;
    }

    public Socket connectProxy(String proxyHost, int proxyPort, String host, int port) {
        String hp = "" + host + ':' + port;
        String php = "" + proxyHost + ':' + proxyPort;
        this.logger.println(this.protocol + ": " + MessageFormat.format(T._("trying to TUNNEL over proxy {0} to {1}"), php, hp));
        TunnelSocket s = null;
        try {
            s = new TunnelSocket(proxyHost, proxyPort, host, port);
            this.logger.println(this.protocol + ": " + MessageFormat.format(T._("tunneled successfully to {0}"), hp));
            this.isSecure = true;
            this.secDesc = T._("tunneld SSL");
        }
        catch (Exception e) {
            this.logger.println(this.protocol + ": " + T._("TUNNEL connect:") + " " + e);
            this.logger.println(this.protocol + ": " + MessageFormat.format(T._("TUNNEL connection FAILED to {0}"), hp));
        }
        return s;
    }

    public Socket connectSSL(String host, int port) {
        SSLConnector con = null;
        String sslimplid = null;
        JVMVersionInfo verInfo = JVMVersionInfo.getJVMVersionInfo();
        if (verInfo.isJava15()) {
            sslimplid = "JSSE15";
        } else if (verInfo.isJava14()) {
            sslimplid = "JSSE14";
        } else if (verInfo.isJava13()) {
            sslimplid = "JSSE10";
        } else if (verInfo.isNSJava()) {
            sslimplid = "NS";
        }
        if (sslimplid != null) {
            con = SSLConnector.getConnector(sslimplid, this.logger, this.protocol);
        }
        if (null == con) {
            this.sockerr = T._("no SSL implementation available");
            this.logger.println(this.protocol + ": " + T._("SSL: WARNING:") + " " + this.sockerr);
            return null;
        }
        this.isSecure = true;
        this.secDesc = T._("SSL");
        Socket s = con.connect(host, port);
        this.sockerr = con.error;
        return s;
    }

    protected String binToHex(byte[] bin) {
        String hex = "";
        for (int i = 0; i < bin.length; ++i) {
            int b = bin[i] & 0xFF;
            if (b <= 15) {
                hex = hex + "0";
            }
            hex = hex + Integer.toHexString(b).toUpperCase();
        }
        return hex;
    }

    protected void getChallengeResponse(byte[] challenge, byte[] response, int pos) throws IOException {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("Could not find MD5 algorithm.");
        }
        digest.update(challenge);
        digest.update(this.profile.connectId.getBytes("ISO-8859-1"), 0, this.profile.connectId.length());
        byte[] hash = digest.digest();
        String hashString = this.binToHex(hash);
        System.arraycopy(hashString.getBytes("ISO-8859-1"), 0, response, pos, hashString.length());
    }
}

