/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.rc;

import java.awt.Color;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import javax.swing.JFrame;

public class FullFrame
extends JFrame {
    public static final int EXCLUSIVE = 0;
    public static final int FULL = 1;
    public static final int DECORATED = 2;
    private GraphicsDevice device = null;
    private int mode = 0;

    public FullFrame() {
        this("");
    }

    public FullFrame(String title) {
        this(title, 0);
    }

    public FullFrame(String title, int mode) {
        this(title, mode, Color.black);
    }

    public FullFrame(String title, int mode, Color backColor) {
        super(title);
        this.setDefaultCloseOperation(3);
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.device = env.getDefaultScreenDevice();
        this.getContentPane().setBackground(backColor);
        this.setBackground(backColor);
        this.setMode(mode);
    }

    public void setMode(int mode) {
        boolean isDisp = this.isDisplayable();
        if (isDisp) {
            this.dispose();
        }
        this.mode = mode;
        switch (mode) {
            case 0: {
                if (this.device.isFullScreenSupported()) {
                    this.setUndecorated(true);
                    this.setResizable(false);
                    this.device.setFullScreenWindow(this);
                    break;
                }
            }
            case 1: {
                this.setUndecorated(true);
                this.setResizable(false);
                this.setLocation(0, 0);
                this.setSize(Toolkit.getDefaultToolkit().getScreenSize());
                this.mode = 1;
                break;
            }
            case 2: {
                this.device.setFullScreenWindow(null);
                this.setUndecorated(false);
                this.setResizable(true);
            }
        }
        if (isDisp) {
            this.show();
        }
    }

    public int getMode() {
        return this.mode;
    }
}

