/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.rc;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.ImageObserver;
import java.awt.image.MemoryImageSource;
import java.awt.image.VolatileImage;
import java.io.IOException;
import nn.pp.rc.GenericTimer;
import nn.pp.rc.MonitoringDataInputStream;
import nn.pp.rc.RCRenderer;
import nn.pp.rc.RFBproto;
import nn.pp.rc.TimerQueue;
import smc.ext.OSDMessage;
import smc.ext.OSDMessageManager;

public abstract class RFBRenderer
implements RCRenderer,
ActionListener,
ImageObserver {
    protected RFBproto rfb;
    protected Component comp;
    protected Dimension mysize;
    protected Image vimg;
    protected Graphics gvimg;
    OSDMessage osdMessage = new OSDMessage("default", 25, 10, 20);
    public OSDMessageManager osdManager = new OSDMessageManager();
    private int bufsize = 65536;
    private byte[] buf = new byte[this.bufsize];
    private int count = 0;
    private int pos = 0;
    private final int osd_height = 20;
    private GenericTimer osd_timer = null;
    private Color osd_bgcolor = new Color(32, 32, 128);
    private Color osd_fgcolor = new Color(96, 96, 240);
    private Font osd_font;
    private FontMetrics osd_metrics;
    private String osd_message;
    private boolean osd_blank = false;
    private boolean screen_blank = false;
    private Image osd_image = null;
    private boolean osd_show = false;
    int xcount = 0;
    Rectangle jpegRect;
    protected MemoryImageSource jimgsrc;

    @Override
    public OSDMessageManager getOSDManager() {
        return this.osdManager;
    }

    protected final int readBufferedByte(MonitoringDataInputStream is) throws IOException {
        if (this.count - this.pos <= 0) {
            this.count = is.read(this.buf);
            this.pos = 0;
        }
        return this.buf[this.pos++] & 0xFF;
    }

    protected final void finishBufferedReading(MonitoringDataInputStream is) {
        is.stall(this.buf, this.pos, this.count - this.pos);
        this.count = 0;
        this.pos = 0;
    }

    abstract void sendPixelMsg() throws IOException;

    abstract void sendUpdateMsg() throws IOException;

    abstract void drawRawRect(int var1, int var2, int var3, int var4, boolean var5) throws IOException;

    abstract void drawRawVSCRect(int var1, int var2, int var3, int var4, boolean var5) throws IOException;

    abstract void drawHextileRect(int var1, int var2, int var3, int var4, boolean var5) throws IOException;

    abstract void drawTightRect(int var1, int var2, int var3, int var4) throws IOException;

    abstract void drawTightCachedRect(int var1, int var2, int var3, int var4) throws IOException;

    abstract void drawCopyRect(int var1, int var2, int var3, int var4, int var5, int var6) throws IOException;

    abstract void drawLRLERect(long var1, int var3, int var4, int var5, int var6) throws IOException;

    abstract void setNewTightCacheSize();

    abstract void enableTightCache(boolean var1);

    @Override
    public abstract void repaint();

    @Override
    public abstract void setInterpol(boolean var1);

    @Override
    public abstract void dispose();

    public RFBRenderer(Component comp) {
        this.comp = comp;
        this.osd_font = new Font("Monospaced", 1, 20);
        this.osd_metrics = Toolkit.getDefaultToolkit().getFontMetrics(this.osd_font);
    }

    public void setRFBProto(RFBproto rfb) {
        this.rfb = rfb;
    }

    @Override
    public void setRenderSize(Dimension d) {
        this.mysize = d;
        this.generateOSDImage();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.osd_show = false;
        this.repaint();
    }

    public void setOSDState(boolean blank, String message, int timeout_ms) {
        if (message != null && message.length() != 0 && !message.equals(this.osdMessage.message)) {
            this.osdMessage.timeout = 5;
            this.osdMessage.message = message;
            if (this.osdManager.isContainOSDMessage(this.osdMessage)) {
                this.osdManager.removeOSDMessage(this.osdMessage);
            }
            this.osdManager.addOSDMessage(this.osdMessage);
        }
        this.osd_blank = blank;
        this.osd_message = message;
        this.generateOSDImage();
        if (this.osd_timer != null) {
            this.osd_timer.stop();
        }
        if (timeout_ms > 0 && this.osd_show) {
            this.osd_timer = new GenericTimer(timeout_ms, this);
            this.osd_timer.start();
        }
        this.repaint();
    }

    void setBlank(boolean blank) {
        this.screen_blank = blank;
        this.repaint();
    }

    private void generateOSDImage() {
        if (this.osd_message != null && this.osd_message.length() > 0) {
            this.osd_image = this.comp.createImage(this.mysize.width, 20);
            Graphics osd_g = this.osd_image.getGraphics();
            osd_g.setColor(this.osd_bgcolor);
            osd_g.fillRect(0, 0, this.mysize.width, 20);
            osd_g.setColor(this.osd_fgcolor);
            osd_g.setFont(this.osd_font);
            int text_width = this.osd_metrics.stringWidth(this.osd_message);
            int text_height = this.osd_metrics.getMaxDescent() + this.osd_metrics.getMaxAscent();
            osd_g.drawString(this.osd_message, (this.mysize.width - text_width) / 2, 20 - (20 - text_height) / 2 - this.osd_metrics.getMaxDescent());
            this.osd_show = true;
        } else {
            this.osd_show = false;
        }
    }

    protected void paintContent(Graphics g, boolean scale, Dimension scalesize) {
        Dimension size = scale ? scalesize : this.mysize;
        int osd_height_draw = scalesize.height * 20 / this.mysize.height;
        if (((VolatileImage)this.vimg).contentsLost()) {
            System.out.println("Content is lost ");
            return;
        }
        this.osdManager.processOSDMessage(this.vimg);
        Image vimgPlus = this.osdManager.getReplacedImage();
        g.setClip(0, 0, size.width, size.height);
        if (this.osd_blank || this.screen_blank) {
            g.setColor(Color.black);
            g.fillRect(0, 0, size.width, size.height);
            this.osdManager.drawOSDMessageDirectlyByGraphics(g);
        } else {
            g.drawImage(vimgPlus, 0, 0, size.width, size.height, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean imageUpdate(Image img, int infoflags, int _x, int _y, int _w, int _h) {
        if ((infoflags & 0xA0) == 0) {
            return true;
        }
        if ((infoflags & 0x20) != 0 && this.jpegRect != null) {
            Rectangle rectangle = this.jpegRect;
            synchronized (rectangle) {
                int x = this.jpegRect.x;
                int y = this.jpegRect.y;
                int w = this.jpegRect.width;
                int h = this.jpegRect.height;
                this.jimgsrc.newPixels(x, y, w, h);
                this.gvimg.setClip(x, y, w, h);
                this.gvimg.drawImage(img, x, y, null);
                this.jpegRect.notify();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawJpegRect(int x, int y, int w, int h) throws IOException {
        int size = (int)this.rfb.is.readUnsignedInt();
        byte[] jpegData = new byte[size];
        this.rfb.is.readFully(jpegData);
        Image jpegImage = Toolkit.getDefaultToolkit().createImage(jpegData);
        Rectangle rectangle = this.jpegRect = new Rectangle(x, y, w, h);
        synchronized (rectangle) {
            Toolkit.getDefaultToolkit().prepareImage(jpegImage, -1, -1, this);
            try {
                this.jpegRect.wait(3000L);
            }
            catch (InterruptedException e) {
                throw new IOException("Interrupted while decoding JPEG image");
            }
        }
        this.jpegRect = null;
    }

    public void removeOSDTimer() {
        if (this.osd_timer != null) {
            TimerQueue.sharedInstance().removeTimer(this.osd_timer);
            this.osd_timer.actionListener = null;
            this.osd_timer = null;
        }
    }
}

