/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.View;
import com.sun.javafx.tk.quantum.EmbeddedStage;
import com.sun.javafx.tk.quantum.GlassScene;
import com.sun.javafx.tk.quantum.GlassStage;
import com.sun.javafx.tk.quantum.PaintRenderJob;
import com.sun.javafx.tk.quantum.QuantumRenderer;
import com.sun.javafx.tk.quantum.QuantumToolkit;
import com.sun.javafx.tk.quantum.ViewPainter;
import com.sun.javafx.tk.quantum.ViewScene;
import com.sun.prism.render.CompletionListener;
import com.sun.prism.render.RenderJob;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicBoolean;

public class PaintCollector {
    private static final boolean verbose = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            return Boolean.getBoolean("quantum.verbose");
        }
    });
    private static final boolean pulseDebug = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            return Boolean.getBoolean("quantum.pulse");
        }
    });
    private final CyclicBarrier pulseBarrier = new CyclicBarrier(2);
    private final List<GlassScene> uploadScenes = new ArrayList<GlassScene>();
    private final List<GlassScene> syncScenes = new ArrayList<GlassScene>();
    private final List<GlassScene> dirtyScenes = new ArrayList<GlassScene>();
    private final List<GlassScene> dirtyMarker = new ArrayList<GlassScene>();
    private final List<GlassScene> dirtyWork = new ArrayList<GlassScene>();
    private final AtomicBoolean hasDirty = new AtomicBoolean(false);
    private final AtomicBoolean released = new AtomicBoolean(false);
    private final QuantumToolkit toolkit;
    private final QuantumRenderer renderer;
    private ViewPainter viewPainter;
    private boolean needsHint;
    private static PaintCollector collector;
    private final CompletionListener rendered = new CompletionListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void done(RenderJob renderJob) {
            PaintCollector.this.checkThreads();
            PaintRenderJob paintRenderJob = (PaintRenderJob)renderJob;
            GlassScene glassScene = paintRenderJob.getScene();
            if (pulseDebug) {
                System.err.println("PC: rendered: now: " + System.nanoTime() + PaintCollector.sceneSize(glassScene));
            }
            Object object = PaintCollector.this;
            synchronized (object) {
                PaintCollector.this.dirtyMarker.remove(glassScene);
                glassScene.clearDirty();
                glassScene.frameRendered();
            }
            if (pulseDebug) {
                System.err.println("PC: rendered: remain: " + PaintCollector.this.dirtyMarker.size());
                for (GlassScene glassScene2 : PaintCollector.this.dirtyMarker) {
                    System.err.println("REMAIN: " + PaintCollector.sceneSize(glassScene2));
                }
            }
            object = PaintCollector.this;
            synchronized (object) {
                if (PaintCollector.this.dirtyMarker.isEmpty()) {
                    PaintCollector.this.toolkit.endPulseRunning();
                    if (PaintCollector.this.needsHint) {
                        PaintCollector.this.toolkit.vsyncHint();
                    }
                    if (!PaintCollector.this.released.get()) {
                        PaintCollector.this.releaseBarrier();
                    }
                    if (pulseDebug) {
                        System.err.println("PC: rendered: renderAll: " + System.nanoTime());
                    }
                }
            }
        }
    };
    private final CompletionListener viewRepainted = new CompletionListener(){

        @Override
        public void done(RenderJob renderJob) {
            ((PaintCollector)PaintCollector.this).viewPainter.liveRepaint.set(false);
            if (verbose) {
                System.err.println("LR.end: " + System.nanoTime());
            }
        }
    };

    private PaintCollector(QuantumToolkit quantumToolkit, QuantumRenderer quantumRenderer) {
        this.toolkit = quantumToolkit;
        this.renderer = quantumRenderer;
    }

    protected static PaintCollector createInstance(QuantumToolkit quantumToolkit) {
        collector = new PaintCollector(quantumToolkit, QuantumRenderer.getInstance());
        return collector;
    }

    public static PaintCollector getInstance() {
        return collector;
    }

    public AtomicBoolean hasDirty() {
        return this.hasDirty;
    }

    public boolean isReleased() {
        return this.released.get();
    }

    protected QuantumToolkit toolkit() {
        return this.toolkit;
    }

    protected static String sceneSize(GlassScene glassScene) {
        if (glassScene instanceof ViewScene) {
            View view = ((ViewScene)glassScene).getPlatformView();
            return " scene: " + glassScene.hashCode() + " @ (" + view.getWidth() + "," + view.getHeight() + ")";
        }
        GlassStage glassStage = glassScene.glassStage;
        EmbeddedStage embeddedStage = (EmbeddedStage)glassStage;
        return " scene: " + glassScene.hashCode() + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDirtyScene(GlassScene glassScene) {
        if (verbose) {
            System.err.println("PC.addDirtyScene: " + System.nanoTime() + PaintCollector.sceneSize(glassScene));
        }
        PaintCollector paintCollector = this;
        synchronized (paintCollector) {
            if (!this.dirtyScenes.contains(glassScene)) {
                this.dirtyScenes.add(glassScene);
            }
            this.hasDirty.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeDirtyScene(GlassScene glassScene) {
        if (verbose) {
            System.err.println("PC.removeDirtyScene: " + PaintCollector.sceneSize(glassScene));
        }
        PaintCollector paintCollector = this;
        synchronized (paintCollector) {
            this.dirtyScenes.remove(glassScene);
            this.hasDirty.set(!this.dirtyScenes.isEmpty());
        }
    }

    void checkThreads() {
        if (!$assertionsDisabled) {
            PaintCollector paintCollector = this;
            if (Thread.currentThread().equals(paintCollector.toolkit.getFxUserThread())) {
                throw new AssertionError();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseScene(GlassScene glassScene) {
        PaintCollector paintCollector = this;
        synchronized (paintCollector) {
            if (this.dirtyMarker.remove(glassScene) && this.dirtyMarker.isEmpty()) {
                this.releaseBarrier();
                this.released.set(true);
            }
        }
    }

    void releaseBarrier() {
        try {
            this.pulseBarrier.await();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (BrokenBarrierException brokenBarrierException) {
            brokenBarrierException.printStackTrace();
        }
    }

    protected CompletionListener getRendered() {
        return this.rendered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void liveRepaintRenderJob(GlassScene glassScene) {
        if (glassScene instanceof ViewScene) {
            ViewScene viewScene = (ViewScene)glassScene;
            PaintCollector paintCollector = this;
            synchronized (paintCollector) {
                this.viewPainter = viewScene.getPen().getPainter();
                if (!this.viewPainter.liveRepaint.getAndSet(true)) {
                    this.renderer.submit(new RenderJob((Runnable)((Object)this.viewPainter), this.viewRepainted));
                    if (verbose) {
                        System.err.println("LR.start: " + System.nanoTime() + PaintCollector.sceneSize(glassScene));
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void renderAll() {
        int n;
        int n2;
        if (pulseDebug) {
            System.err.println("PC.renderAll(" + this.dirtyScenes.size() + "): " + System.nanoTime());
        }
        if (!this.hasDirty.get()) {
            this.toolkit.endPulseRunning();
            return;
        }
        GlassScene glassScene = null;
        PaintCollector paintCollector = this;
        synchronized (paintCollector) {
            this.pulseBarrier.reset();
            this.released.set(false);
            int n3 = this.dirtyScenes.size();
            for (n2 = 0; n2 < n3; ++n2) {
                glassScene = this.dirtyScenes.get(n2);
                this.dirtyMarker.add(glassScene);
                this.dirtyWork.add(glassScene);
            }
            this.dirtyScenes.clear();
            this.uploadScenes.clear();
            this.syncScenes.clear();
            n3 = this.dirtyWork.size();
            for (n2 = 0; n2 < n3; ++n2) {
                glassScene = this.dirtyWork.get(n2);
                if (glassScene.isSynchronous()) {
                    this.syncScenes.add(glassScene);
                    continue;
                }
                this.uploadScenes.add(glassScene);
            }
        }
        if (this.uploadScenes.isEmpty() && this.syncScenes.isEmpty()) {
            this.toolkit.endPulseRunning();
            return;
        }
        this.needsHint = !this.syncScenes.isEmpty();
        n2 = this.uploadScenes.size();
        for (n = 0; n < n2; ++n) {
            glassScene = this.uploadScenes.get(n);
            try {
                glassScene.repaint();
                continue;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        n2 = this.syncScenes.size();
        for (n = 0; n < n2; ++n) {
            glassScene = this.syncScenes.get(n);
            try {
                glassScene.repaint();
                continue;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        try {
            this.releaseBarrier();
        }
        finally {
            PaintCollector paintCollector2 = this;
            synchronized (paintCollector2) {
                this.dirtyWork.clear();
                this.syncScenes.clear();
                this.uploadScenes.clear();
                assert (this.dirtyMarker.isEmpty());
                this.hasDirty.set(false);
            }
        }
    }
}

