/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.impl;

import com.sun.prism.paint.Color;
import java.util.Arrays;

public class VertexBuffer {
    protected static final int VERTS_PER_QUAD = 4;
    protected static final int FLOATS_PER_TC = 2;
    protected static final int FLOATS_PER_VC = 3;
    protected static final int FLOATS_PER_VERT = 7;
    protected static final int BYTES_PER_VERT = 4;
    protected int capacity;
    protected int index;
    protected byte r;
    protected byte g;
    protected byte b;
    protected byte a;
    protected byte[] colorArray;
    protected float[] coordArray;

    public VertexBuffer(int n) {
        this.capacity = n * 4;
        this.index = 0;
        this.colorArray = new byte[this.capacity * 4];
        this.coordArray = new float[this.capacity * 7];
    }

    protected void drawQuads(int n) {
        throw new Error("flush not implemented for lightweight");
    }

    protected void drawTriangles(int n, float[] fArray, byte[] byArray) {
        throw new Error("flush not implemented for lightweight");
    }

    public final void setPerVertexColor(Color color, float f) {
        float f2 = color.getAlpha() * f;
        this.r = (byte)(color.getRed() * f2 * 255.0f);
        this.g = (byte)(color.getGreen() * f2 * 255.0f);
        this.b = (byte)(color.getBlue() * f2 * 255.0f);
        this.a = (byte)(f2 * 255.0f);
    }

    public final void setPerVertexColor(float f) {
        this.b = this.a = (byte)(f * 255.0f);
        this.g = this.a;
        this.r = this.a;
    }

    public final void updateVertexColors(int n) {
        for (int i = 0; i != n; ++i) {
            this.putColor(i);
        }
    }

    private void putColor(int n) {
        int n2 = n * 4;
        this.colorArray[n2 + 0] = this.r;
        this.colorArray[n2 + 1] = this.g;
        this.colorArray[n2 + 2] = this.b;
        this.colorArray[n2 + 3] = this.a;
    }

    public final void flush() {
        if (this.index > 0) {
            this.drawQuads(this.index);
            this.index = 0;
        }
    }

    public final void rewind() {
        this.index = 0;
    }

    private void grow() {
        this.capacity *= 2;
        this.colorArray = Arrays.copyOf(this.colorArray, this.capacity * 4);
        this.coordArray = Arrays.copyOf(this.coordArray, this.capacity * 7);
    }

    public final void addVert(float f, float f2) {
        if (this.index == this.capacity) {
            this.grow();
        }
        int n = 7 * this.index;
        this.coordArray[n + 0] = f;
        this.coordArray[n + 1] = f2;
        this.coordArray[n + 2] = 0.0f;
        this.putColor(this.index);
        ++this.index;
    }

    public final void addVert(float f, float f2, float f3, float f4) {
        if (this.index == this.capacity) {
            this.grow();
        }
        int n = 7 * this.index;
        this.coordArray[n + 0] = f;
        this.coordArray[n + 1] = f2;
        this.coordArray[n + 2] = 0.0f;
        this.coordArray[n + 3] = f3;
        this.coordArray[n + 4] = f4;
        this.putColor(this.index);
        ++this.index;
    }

    public final void addVert(float f, float f2, float f3, float f4, float f5, float f6) {
        if (this.index == this.capacity) {
            this.grow();
        }
        int n = 7 * this.index;
        this.coordArray[n + 0] = f;
        this.coordArray[n + 1] = f2;
        this.coordArray[n + 2] = 0.0f;
        this.coordArray[n + 3] = f3;
        this.coordArray[n + 4] = f4;
        this.coordArray[n + 5] = f5;
        this.coordArray[n + 6] = f6;
        this.putColor(this.index);
        ++this.index;
    }

    private void addVertNoCheck(float f, float f2) {
        int n = 7 * this.index;
        this.coordArray[n + 0] = f;
        this.coordArray[n + 1] = f2;
        this.coordArray[n + 2] = 0.0f;
        this.putColor(this.index);
        ++this.index;
    }

    private void addVertNoCheck(float f, float f2, float f3, float f4) {
        int n = 7 * this.index;
        this.coordArray[n + 0] = f;
        this.coordArray[n + 1] = f2;
        this.coordArray[n + 2] = 0.0f;
        this.coordArray[n + 3] = f3;
        this.coordArray[n + 4] = f4;
        this.putColor(this.index);
        ++this.index;
    }

    private void addVertNoCheck(float f, float f2, float f3, float f4, float f5, float f6) {
        int n = 7 * this.index;
        this.coordArray[n + 0] = f;
        this.coordArray[n + 1] = f2;
        this.coordArray[n + 2] = 0.0f;
        this.coordArray[n + 3] = f3;
        this.coordArray[n + 4] = f4;
        this.coordArray[n + 5] = f5;
        this.coordArray[n + 6] = f6;
        this.putColor(this.index);
        ++this.index;
    }

    public final void addVerts(VertexBuffer vertexBuffer, int n) {
        this.flush();
        this.drawTriangles(n / 3, vertexBuffer.coordArray, vertexBuffer.colorArray);
    }

    private void ensureCapacityForQuad() {
        if (this.index + 4 > this.capacity) {
            this.drawQuads(this.index);
            this.index = 0;
        }
    }

    public final void addQuad(float f, float f2, float f3, float f4) {
        this.ensureCapacityForQuad();
        this.addVertNoCheck(f, f2);
        this.addVertNoCheck(f, f4);
        this.addVertNoCheck(f3, f2);
        this.addVertNoCheck(f3, f4);
    }

    public final void addQuad(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        this.ensureCapacityForQuad();
        this.addVertNoCheck(f, f2, f5, f6, f9, f10);
        this.addVertNoCheck(f, f4, f5, f8, f9, f12);
        this.addVertNoCheck(f3, f2, f7, f6, f11, f10);
        this.addVertNoCheck(f3, f4, f7, f8, f11, f12);
    }

    public final void addMappedQuad(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        this.ensureCapacityForQuad();
        this.addVertNoCheck(f, f2, f5, f6);
        this.addVertNoCheck(f, f4, f9, f10);
        this.addVertNoCheck(f3, f2, f7, f8);
        this.addVertNoCheck(f3, f4, f11, f12);
    }

    public final void addMappedQuad(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16, float f17, float f18, float f19, float f20) {
        this.ensureCapacityForQuad();
        this.addVertNoCheck(f, f2, f5, f6, f13, f14);
        this.addVertNoCheck(f, f4, f9, f10, f17, f18);
        this.addVertNoCheck(f3, f2, f7, f8, f15, f16);
        this.addVertNoCheck(f3, f4, f11, f12, f19, f20);
    }

    public final void addQuad(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        int n = this.index;
        if (n + 4 > this.capacity) {
            this.drawQuads(n);
            this.index = 0;
            n = 0;
        }
        int n2 = 7 * n;
        float[] fArray = this.coordArray;
        fArray[n2] = f;
        fArray[++n2] = f2;
        fArray[++n2] = 0.0f;
        fArray[++n2] = f5;
        fArray[++n2] = f6;
        fArray[n2 += 3] = f;
        fArray[++n2] = f4;
        fArray[++n2] = 0.0f;
        fArray[++n2] = f5;
        fArray[++n2] = f8;
        fArray[n2 += 3] = f3;
        fArray[++n2] = f2;
        fArray[++n2] = 0.0f;
        fArray[++n2] = f7;
        fArray[++n2] = f6;
        fArray[n2 += 3] = f3;
        fArray[++n2] = f4;
        fArray[++n2] = 0.0f;
        fArray[++n2] = f7;
        fArray[++n2] = f8;
        byte[] byArray = this.colorArray;
        byte by = this.r;
        byte by2 = this.g;
        byte by3 = this.b;
        byte by4 = this.a;
        int n3 = 4 * n;
        byArray[n3] = by;
        byArray[++n3] = by2;
        byArray[++n3] = by3;
        byArray[++n3] = by4;
        byArray[++n3] = by;
        byArray[++n3] = by2;
        byArray[++n3] = by3;
        byArray[++n3] = by4;
        byArray[++n3] = by;
        byArray[++n3] = by2;
        byArray[++n3] = by3;
        byArray[++n3] = by4;
        byArray[++n3] = by;
        byArray[++n3] = by2;
        byArray[++n3] = by3;
        byArray[++n3] = by4;
        this.index = n + 4;
    }

    public final void addQuadVO(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
        int n = this.index;
        if (n + 4 > this.capacity) {
            this.drawQuads(n);
            this.index = 0;
            n = 0;
        }
        int n2 = 7 * n;
        float[] fArray = this.coordArray;
        fArray[n2] = f3;
        fArray[++n2] = f4;
        fArray[++n2] = 0.0f;
        fArray[++n2] = f7;
        fArray[++n2] = f8;
        fArray[n2 += 3] = f3;
        fArray[++n2] = f6;
        fArray[++n2] = 0.0f;
        fArray[++n2] = f7;
        fArray[++n2] = f10;
        fArray[n2 += 3] = f5;
        fArray[++n2] = f4;
        fArray[++n2] = 0.0f;
        fArray[++n2] = f9;
        fArray[++n2] = f8;
        fArray[n2 += 3] = f5;
        fArray[++n2] = f6;
        fArray[++n2] = 0.0f;
        fArray[++n2] = f9;
        fArray[++n2] = f10;
        byte[] byArray = this.colorArray;
        int n3 = 4 * n;
        byte by = (byte)(f * 255.0f);
        byte by2 = (byte)(f2 * 255.0f);
        byArray[n3] = by;
        byArray[++n3] = by;
        byArray[++n3] = by;
        byArray[++n3] = by;
        byArray[++n3] = by2;
        byArray[++n3] = by2;
        byArray[++n3] = by2;
        byArray[++n3] = by2;
        byArray[++n3] = by;
        byArray[++n3] = by;
        byArray[++n3] = by;
        byArray[++n3] = by;
        byArray[++n3] = by2;
        byArray[++n3] = by2;
        byArray[++n3] = by2;
        byArray[++n3] = by2;
        this.index = n + 4;
    }

    public final void addMappedPgram(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16, float f17, float f18) {
        int n = this.index;
        if (n + 4 > this.capacity) {
            this.drawQuads(n);
            this.index = 0;
            n = 0;
        }
        int n2 = 7 * n;
        float[] fArray = this.coordArray;
        fArray[n2] = f;
        fArray[++n2] = f2;
        fArray[++n2] = 0.0f;
        fArray[++n2] = f9;
        fArray[++n2] = f10;
        fArray[++n2] = f17;
        fArray[++n2] = f18;
        fArray[++n2] = f5;
        fArray[++n2] = f6;
        fArray[++n2] = 0.0f;
        fArray[++n2] = f13;
        fArray[++n2] = f14;
        fArray[++n2] = f17;
        fArray[++n2] = f18;
        fArray[++n2] = f3;
        fArray[++n2] = f4;
        fArray[++n2] = 0.0f;
        fArray[++n2] = f11;
        fArray[++n2] = f12;
        fArray[++n2] = f17;
        fArray[++n2] = f18;
        fArray[++n2] = f7;
        fArray[++n2] = f8;
        fArray[++n2] = 0.0f;
        fArray[++n2] = f15;
        fArray[++n2] = f16;
        fArray[++n2] = f17;
        fArray[++n2] = f18;
        byte[] byArray = this.colorArray;
        byte by = this.r;
        byte by2 = this.g;
        byte by3 = this.b;
        byte by4 = this.a;
        int n3 = 4 * n;
        byArray[n3] = by;
        byArray[++n3] = by2;
        byArray[++n3] = by3;
        byArray[++n3] = by4;
        byArray[++n3] = by;
        byArray[++n3] = by2;
        byArray[++n3] = by3;
        byArray[++n3] = by4;
        byArray[++n3] = by;
        byArray[++n3] = by2;
        byArray[++n3] = by3;
        byArray[++n3] = by4;
        byArray[++n3] = by;
        byArray[++n3] = by2;
        byArray[++n3] = by3;
        byArray[++n3] = by4;
        this.index = n + 4;
    }
}

