/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.stream.writers;

import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.Comment;
import javax.xml.stream.events.DTD;
import javax.xml.stream.events.EntityReference;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.ProcessingInstruction;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class XMLEventWriterImpl
implements XMLEventWriter {
    private XMLStreamWriter fStreamWriter;
    private static final boolean DEBUG = false;

    public XMLEventWriterImpl(XMLStreamWriter xMLStreamWriter) {
        this.fStreamWriter = xMLStreamWriter;
    }

    @Override
    public void add(XMLEventReader xMLEventReader) throws XMLStreamException {
        if (xMLEventReader == null) {
            throw new XMLStreamException("Event reader shouldn't be null");
        }
        while (xMLEventReader.hasNext()) {
            this.add(xMLEventReader.nextEvent());
        }
    }

    @Override
    public void add(XMLEvent xMLEvent) throws XMLStreamException {
        int n = xMLEvent.getEventType();
        switch (n) {
            case 11: {
                DTD dTD = (DTD)xMLEvent;
                this.fStreamWriter.writeDTD(dTD.getDocumentTypeDeclaration());
                break;
            }
            case 7: {
                StartDocument startDocument = (StartDocument)xMLEvent;
                try {
                    this.fStreamWriter.writeStartDocument(startDocument.getCharacterEncodingScheme(), startDocument.getVersion());
                }
                catch (XMLStreamException xMLStreamException) {
                    this.fStreamWriter.writeStartDocument(startDocument.getVersion());
                }
                break;
            }
            case 1: {
                Object object;
                StartElement startElement = xMLEvent.asStartElement();
                QName qName = startElement.getName();
                this.fStreamWriter.writeStartElement(qName.getPrefix(), qName.getLocalPart(), qName.getNamespaceURI());
                Iterator iterator = startElement.getNamespaces();
                while (iterator.hasNext()) {
                    object = (Namespace)iterator.next();
                    this.fStreamWriter.writeNamespace(object.getPrefix(), object.getNamespaceURI());
                }
                object = startElement.getAttributes();
                while (object.hasNext()) {
                    Attribute attribute = (Attribute)object.next();
                    QName qName2 = attribute.getName();
                    this.fStreamWriter.writeAttribute(qName2.getPrefix(), qName2.getNamespaceURI(), qName2.getLocalPart(), attribute.getValue());
                }
                break;
            }
            case 13: {
                Namespace namespace = (Namespace)xMLEvent;
                this.fStreamWriter.writeNamespace(namespace.getPrefix(), namespace.getNamespaceURI());
                break;
            }
            case 5: {
                Comment comment = (Comment)xMLEvent;
                this.fStreamWriter.writeComment(comment.getText());
                break;
            }
            case 3: {
                ProcessingInstruction processingInstruction = (ProcessingInstruction)xMLEvent;
                this.fStreamWriter.writeProcessingInstruction(processingInstruction.getTarget(), processingInstruction.getData());
                break;
            }
            case 4: {
                Characters characters = xMLEvent.asCharacters();
                if (characters.isCData()) {
                    this.fStreamWriter.writeCData(characters.getData());
                    break;
                }
                this.fStreamWriter.writeCharacters(characters.getData());
                break;
            }
            case 9: {
                EntityReference entityReference = (EntityReference)xMLEvent;
                this.fStreamWriter.writeEntityRef(entityReference.getName());
                break;
            }
            case 10: {
                Attribute attribute = (Attribute)xMLEvent;
                QName qName = attribute.getName();
                this.fStreamWriter.writeAttribute(qName.getPrefix(), qName.getNamespaceURI(), qName.getLocalPart(), attribute.getValue());
                break;
            }
            case 12: {
                Characters characters = (Characters)xMLEvent;
                if (!characters.isCData()) break;
                this.fStreamWriter.writeCData(characters.getData());
                break;
            }
            case 2: {
                this.fStreamWriter.writeEndElement();
                break;
            }
            case 8: {
                this.fStreamWriter.writeEndDocument();
            }
        }
    }

    @Override
    public void close() throws XMLStreamException {
        this.fStreamWriter.close();
    }

    @Override
    public void flush() throws XMLStreamException {
        this.fStreamWriter.flush();
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.fStreamWriter.getNamespaceContext();
    }

    @Override
    public String getPrefix(String string) throws XMLStreamException {
        return this.fStreamWriter.getPrefix(string);
    }

    @Override
    public void setDefaultNamespace(String string) throws XMLStreamException {
        this.fStreamWriter.setDefaultNamespace(string);
    }

    @Override
    public void setNamespaceContext(NamespaceContext namespaceContext) throws XMLStreamException {
        this.fStreamWriter.setNamespaceContext(namespaceContext);
    }

    @Override
    public void setPrefix(String string, String string2) throws XMLStreamException {
        this.fStreamWriter.setPrefix(string, string2);
    }
}

