package org.apache.log4j.appender;

import junit.framework.Assert;
import junit.framework.TestCase;

public class TestBackupSuffixHelper extends TestCase {

  public void testDefaultSuffix() {
    BackupSuffixHelper helper = new BackupSuffixHelper();
    Assert.assertEquals("1", helper.defaultSuffix());
    Assert.assertEquals("1", helper.next(""));
    Assert.assertEquals("1", helper.next(" "));
    Assert.assertEquals("1", helper.next("app.log"));
    Assert.assertEquals("1", helper.next("app.log.0"));
    Assert.assertEquals("1", helper.next("app.log.bak"));
  }

  public void testNextWithBackupCount() {
    BackupSuffixHelper helper = new BackupSuffixHelper();
    Assert.assertEquals("2", helper.next("app.log.1"));
    Assert.assertEquals("3", helper.next("app.log.2"));
    Assert.assertEquals("11", helper.next("app.log.10"));
    Assert.assertEquals("101", helper.next("app.log.100"));
  }
  
  public void testNextWithBackupCountAndZip() {
    BackupSuffixHelper helper = new BackupSuffixHelper();
    Assert.assertEquals("2", helper.next("app.log.1.zip"));
    Assert.assertEquals("3", helper.next("app.log.2.zip"));
    Assert.assertEquals("11", helper.next("app.log.10.zip"));
    Assert.assertEquals("101", helper.next("app.log.100.zip"));
  }
}
