/*$Author:   DCODY  $*/
/*$Date:   24 Sep 1992 08:49:42  $*/
/*$Header:   X:/sccs/misc/inithw.c_v   1.4   24 Sep 1992 08:49:42   DCODY  $*/
/*$Log:   X:/sccs/misc/inithw.c_v  $
 * 
 *    Rev 1.4   24 Sep 1992 08:49:42   DCODY
 * changed MVGetHardware to mvGetHardware
 * 
 *    Rev 1.3   20 Jul 1992 11:45:58   DCODY
 * changed mvGetHWVersion call to request relocatable I/O detection.
 * 
 *    Rev 1.2   17 Jul 1992 14:10:32   DCODY
 * major re-write for new Pro Audio cards
 * 
 *    Rev 1.1   23 Jun 1992 16:33:12   DCODY
 * PAS2 update
 * 
 *    Rev 1.0   15 Jun 1992 09:39:54   BCRANE
 * Initial revision.
*/
/*$Logfile:   X:/sccs/misc/inithw.c_v  $*/
/*$Modtimes$*/

	/*\
	|*|----====< INITHW.C >====----
	|*|
	|*| This module initializes the Pro Audio Spectrum from a cold boot
	|*|
	|*| Copyright (c) 1991, Media Vision, Inc. All rights reserved.
    |*|
    \*/

#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>

#include "state.h"
#include "mixers.h"
#include "binary.h"
#include "common.h"
#include "target.h"


	/* initial volume control states										*/

	static unsigned char volumes[6][2] = {
		  0,  BI_VOLLOUD,			/*	 0% - switch off					*/
		  0,  BI_VOLENHANCE,		/*	 0% - switch off					*/
		 50,  BI_VOLBASS,			/*	50% - sliding scale 				*/
		 50,  BI_VOLTREBLE, 		/*	50% - sliding scale 				*/
		 45,  BI_VOLLEFT,			/*	45% - sliding scale 				*/
		 45,  BI_VOLRIGHT			/*	45% - sliding scale 				*/
	};

	static unsigned char mixersetting[16][3] = {
		 88,  BI_INPUTMIXER, BI_L_FM,		/* 88% of the sliding scale 	*/
		 88,  BI_INPUTMIXER, BI_R_FM,		/* 88% of the sliding scale 	*/

		 55,  BI_OUTPUTMIXER, BI_L_IMIXER,	/* 55% of the sliding scale 	*/
		 55,  BI_OUTPUTMIXER, BI_R_IMIXER,	/* 55% of the sliding scale 	*/

		 88,  BI_INPUTMIXER, BI_L_EXT,		/* 88% of the sliding scale 	*/
		 88,  BI_INPUTMIXER, BI_R_EXT,		/* 88% of the sliding scale 	*/

		 88,  BI_INPUTMIXER, BI_L_INT,		/* 88% of the sliding scale 	*/
		 88,  BI_INPUTMIXER, BI_R_INT,		/* 88% of the sliding scale 	*/

		 40,  BI_INPUTMIXER, BI_L_MIC,		/* 40% of the sliding scale 	*/
		 40,  BI_INPUTMIXER, BI_R_MIC,		/* 40% of the sliding scale 	*/

		 88,  BI_INPUTMIXER, BI_L_PCM,		/* 88% of the sliding scale 	*/
		 88,  BI_INPUTMIXER, BI_R_PCM,		/* 88% of the sliding scale 	*/

		 88,  BI_INPUTMIXER, BI_L_SPEAKER,	/* 88% of the sliding scale 	*/
		 88,  BI_INPUTMIXER, BI_R_SPEAKER,	/* 88% of the sliding scale 	*/

		 88,  BI_INPUTMIXER, BI_L_SBDAC,	/* 88% of the sliding scale 	*/
		 88,  BI_INPUTMIXER, BI_R_SBDAC 	/* 88% of the sliding scale 	*/

	};


	/*\
	|*|----====< int InitMVHardware( ) >====----
	|*|
	|*| This code initializes the ProAudio Spectrum mixer, volume,
	|*| MIDI, FM, and PCM hardware to default states.
    |*|
	|*| Entry Conditions:
	|*| 	None
    |*|
	|*| Exit Conditions:
	|*| 	returns the hardware version of the card (currently 0)
    |*|
	\*/
int InitMVHardware()
{
int n,i,x,hv,hvbits;
int mvGetHWVersion(int);

	/* determine the feature set of this board								*/

		_asm {
			mov 	ax,USE_ACTIVE_ADDR
			push	ax
			call	mvGetHWVersion
			add 	sp,2

			mov 	hv,ax
			mov 	hvbits,cx
		}

    /* blow off the interrupts                                              */

		MVOut (INTRCTLR, 0xFF,0x00);

	/* take the board out of reset by writing a value to the filter 		*/

		MVOut(AUDIOFILT,0xFF,0x00);

	/* set the cross channel to LEFT-TO-LEFT, RIGHT-TO-RIGHT & kill PCM 	*/

		MVOut (CROSSCHANNEL,0xFF, bCCl2l+bCCr2r);

	/* initialize access to the mixers										*/

		MVInitMixerCode(0);

	/* initialize the volume device 										*/

		for (n=0;n<6;n++)
			cMVSetVolumeFunction(volumes[n][0], volumes[n][1]);

	/* initialize the input mixer for all channels							*/

		for (n=0;n<16;n++)
			cMVSetMixerFunction
			  (
				mixersetting[n][0],
				mixersetting[n][1],
				mixersetting[n][2]
			  );

	/* turn off the realsound switch										*/

		cMVRealSoundSwitch (0,1);

	/* set the FM into mono access mode, then flush them... 				*/

		cMVFMSplitSwitch   (100,1);

		for (n=0;n<256;n++) {

			outp (0x388,n);

			for(x=i=0;i<3;i++)
				x += inp(0x388);

			outp (0x389,0);

			for(x=i=0;i<33;i++)
				x += inp(0x388);
		}

	/* flush the MIDI interface 											*/

		if (hvbits & bMV101) {

			MVOut(MIDIPRESCALE, 0xFF,0x00);
			MVOut(MIDICONTROL,	0xFF,bMCRrstfifoi+bMCRrstfifoi);
            MVOut(MIDICONTROL,  0xFF,0x00);

		}
        else {

			MVOut(MDSYSCTLR,0xFF,0x80); 	// send a reset to the Yamaha

            for(x=i=0;i<33;i++)             // wait 80 microseconds
				x += inp(0x388);

            MVOut(MDSYSCTLR,0xFF,0x80);     // clear the reset

        }

    /* take the board out of reset by writing a value to the filter         */

		cMVSetFilterFunction(100);		/* set for no limiting				*/

	/* return the hardware version #										*/

		return (hv);
}

	/*\
	|*| end of INITHW.C
	\*/

