1000 REM      -=[ ACD_DEMO ]=-
1010 REM SAVE "B:\BAS\ADC_DEMO.BAS",A
1020 REM
1030 REM   Uses the parallel printer port to input analog data converted to
1040 REM   8 bit binary by an ADC-0804 Analog / Digital, ( A/D ), converter IC.
1042 REM
1046 REM   Print raw value, RD, and voltage, VOLTS.  
1050 REM
1060 LPT2  = 632: REM base address of IBM's 3ed parallel port
1062 REM              ues 888 for Graphic Card's printer port
1064 REM              use 956 for Monochrome Card's printer port              
1068 INTER = 8 : WR = 1
1070 NEWVALUE = 0 : OLDVALUE = 1
1080 CLS
1090 GOSUB 1170 : REM start conversion
1095 REM
1100 GOSUB 1220 : REM read data
1110 GOSUB 1170 : REM start conversion
1120 GOSUB 1290 : REM digest data
1130 IF NEWVALUE <> OLDVALUE THEN GOSUB 1370 : REM print results
1140 IF INKEY$ = "" THEN 1100 : REM REPEAT UNTIL KEYPRESSED
1150 END
1160 REM
1170 REM   -=[ START CONVERSION ]=-
1180 REM
1190 OUT LPT2, WR : OUT LPT2, 0 : OUT LPT2, WR
1200 RETURN
1210 REM
1220 REM   -=[ READ DATA ]=-
1230 REM
1240 OUT LPT2 + 2, 4
1250 LONIBBLE = INP(LPT2 + 2)
1260 HINIBBLE = INP(LPT2 + 1)
1270 RETURN
1280 REM
1290 REM   -=[ DIGEST DATA ]=-
1300 REM
1310 LONIBBLE = LONIBBLE AND 15
1320 HINIBBLE = HINIBBLE AND &HF0
1330 RD = HINIBBLE OR LONIBBLE
1340 NEWVALUE = RD
1350 RETURN
1360 REM
1370 REM   -=[ PRINT RESULTS ]=-
1380 REM
1390 LOCATE 10,10
1400 VOLTS = RD * 5 / 255
1410 PRINT "Raw Data = ";RD;
1420 PRINT TAB(30);
1430 PRINT USING "& ###.##"; "Volts = ", VOLTS;
1440 OLDVALUE = NEWVALUE
1450 RETURN
