
1   REM  FILE: MOT_CLK.BAS,  WRITTEN IN QBASIC
2   REM
3   REM Bipolar stepping motor control from printer port using CLOCK pulses
7   REM
100  CW = 1: REM printer port D0, pin 2, provides clockwise rotation pulses
110 CCW = 2: REM printer port D1, pin 3, provides CounterClockWise pulses
135  T = 300
137 REM
138 REM   %%%%%%%%%%%%%%%%%%% -=[ METHOD ONE ]=- %%%%%%%%%%%%%%%%%%%%%%%%%%
140 REM
142 REM  Semicolens at end of LPRINT statement tells BASIC to not add
145 REM  carrage return and line feed to transmitted data.
146 REM  This method only works with LPT1.
147 REM
150 FOR e = 1 TO 40: REM  step motor 40 steps in clockwise direction
160 LPRINT CHR$(CW); : GOSUB 500
170 LPRINT CHR$(0); : GOSUB 500
200 NEXT e
210 FOR e = 1 TO 40: REM step motor 40 steps in counter-clockwise direction
220 LPRINT CHR$(CCW); : GOSUB 500
230 LPRINT CHR$(0); : GOSUB 500
260 NEXT e
270 REM
280 REM  %%%%%%%%%%%%%%%%%%%%%%%%  -=[ METHOD TWO ]=- %%%%%%%%%%%%%%%%%%%%%%
282 REM
283 REM   This method permits sending control signals to LPT1, LPT2, and LPT3
290 REM
300 GOSUB 600: REM   get port's base address
310 FOR e = 1 TO 40: REM  step motor clockwise through 40 steps
320 OUT LptPortAddress, CW: GOSUB 500
340 OUT LptPortAddress, 0: GOSUB 500
370 NEXT e
380 FOR e = 1 TO 40: REM step motor counterclockwise through 40 steps
390 OUT LptPortAddress, CCW: GOSUB 500
400 OUT LptPortAddress, 0: GOSUB 500
430 NEXT e
499 END
500 REM  -=[ delay ]=-
510 FOR V = 1 TO T: NEXT V
520 RETURN
600 REM
605 PRINT
610 PRINT " Which printer port do you want to use? "
620 PRINT "             1) LPT1"
630 PRINT "             2) LPT1"
640 PRINT "             3) LPT3"
650 n = VAL(INPUT$(1))
670 IF (n < 1) OR (n > 3) THEN GOTO 605
675 DEF SEG = 0
680 OffSet = (n * 2) + 6: Address = 1024 + OffSet
690 LptPortAddress = PEEK(Address) + (PEEK(Address + 1) * 256)
700 RETURN







