/*                         PROGRAM Adc_Demo
		    Code conversion by Eugene Klein

  Utilize the parallel printer port to input analog data converted to
  8 bit binary by an ADC-0804 analog / digital converter IC
  Display readings in large letters
*/

#include <dos.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <bios.h>
#include "My_TPU.h"




struct TABLE {
 char Table[255][8];
 } *a;


const int  WR = 0x01;               // D0, Base = Write line
unsigned int LPTx;
unsigned char Lo_Nibble, Hi_Nibble, Temp, Lpt_Num;
int Code, N, E, Whole, Remainder, Old_Value, New_Value;
char A[80], B[80], St[80], Char_Desig[8], String80[80];
div_t answ;

void Lg_Char(int Col, int Row, int To_Print, int Fill_Char)
// display large characters
{
 int X, Y, E, I;
 unsigned char pattern[8];
 for(X=1;X<=8;X++)
  pattern[X] = a->Table[To_Print][X];
 for(X=1; X<=8; X++)
 {
  for(Y=1; Y<=8; Y++)
  {
   gotoxy((Col-1) + 8 - Y, ( Row - 1) + X);
   answ=div(pattern[X] >> Y,2);
   if(answ.rem!=0)
    printf("%c",Fill_Char);

  }
 }
}

void Print_Large_Letters(char St[80])
/* Create large letters by reading each pixel in character table and make it
   a character, 5 by 8 pixels.
   Turbo Pascal Toolbox, 2nd Edition, Sybex Pub. by Frank Dutton, Page 253.
*/
{

 int Ord_Ch, n, E, i, Col, Row, code;
 char ch;
 char temp[80];
// print large letters
 Col = 10; Row = 4;
 for(i=1;i<=6;i++)
 {
  if(St[i] >='0' && St[i] <= '9' && St[i] =='.')
   Ord_Ch = (St[i]);
  else
   Ord_Ch = 32;
  Lg_Char(Col, Row, Ord_Ch , Ord_Ch);
  Col = Col + 8;
 }
}


void main()
{

 a= (struct TABLE *)0xF000FA6E;
 Lpt_Num = Select_Printer_Port();
 LPTx = Init_Printer_Port(Lpt_Num);
 clrscr(); Cursor_Off(); Old_Value = 0;
    //intiilize A/D chip 
 outport(LPTx,WR);
 outport(LPTx, 0);
 outport(LPTx, WR);
 delay(10);   // stay within A/D chip timing parameters

 do
 {
  /* Read data.
     Pull-up all Base + 2, open collector, pins BEFORE a read instruction.
  */
  outport(LPTx + 2,0x04); // 00000100, allow for inverted pins
  Lo_Nibble = inport(LPTx + 2);  // get D0 - D3  bits
  Hi_Nibble = inport(LPTx + 1);  // get D4 - D7  bits
  // strobe ADC-0804 to start new conversion
  outport(LPTx,WR); // while software digest the current data
  outport(LPTx,0);  // Strobe 0804 WR line to start new conversion
  outport(LPTx,WR); // while software digestS the current data
  // digest data
  Lo_Nibble = Lo_Nibble & 0x0F; // extract the meaningful bits, 0 - 3
  Hi_Nibble = Hi_Nibble & 0xF0; // extract the meaningful bits, 4 - 7
  X = (Hi_Nibble | Lo_Nibble);    // put all high bits in one byte               }
  // print results
  New_Value = ( X * 5 ) / 255;   // convert byte to a voltage between O and 5   }
  if( New_Value != Old_Value)     // only update if value has changed            }
  {
   gotoxy(1,15);
   printf("High Nibble = %3i;    Low Nibble =  %3i;\n",Hi_Nibble,Lo_Nibble);
   printf("\n    D7    D6    D5    D4    D3    D2    D1    D0\n");
   N = 128;
   for(E = 1;E<=8;E++)
   {
    printf("%6i",X & N);
    N = N/2;
   }
   printf("\n\nThe A/D binary value is %4i",X);
   answ =div(X*5,255);
   itoa(answ.quot,A,10);
   itoa(answ.rem,B,10);
   stpcpy(St,A);
   strcat(St,".");
   strcat(St,B);
   printf(";     Voltage = %s volts\n",St);
   for(E = 1;E<=8;E++)
   {
    gotoxy(1, 3 + E);
    printf("                                                                  ");
   }
   Print_Large_Letters(St);
   Old_Value = New_Value;
  }
 }while(!kbhit());
}

