/*                        PROGRAM Adc_0809
			Code conversion by Eugene Klein

    Operate a multiplexed eight channel A/D converter from a standard
    Centronic Parallel Printer Port.
*/

#include <dos.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <bios.h>
#include "My_TPU.h"


const unsigned char ESC = 0x1B;       //Escape

  // input lines, BASE + 2
const int   D0 = 1;    // STROBE , base + 2, pin 1 on Cen. Par. Con. = D0
const int   D1 = 2;    // AUTO-FEED line, base + 2, pin 14 on Cen. Par. Con. = D1
const int   D2 = 4;    // INITIALIZE line, base + 2, pin 31 on Cen. Par. Con. = D2
const int   D3 = 8;    // SELECT-INPUT line, base + 2, pin 36 on Cen. Par. Con. = D3
  // input lines, BASE + 1
const int   D4 = 16;   // SELECT line, base + 1, pin 13, on Cen. Par. Con. = D4
const int   D5 = 32;   // PAPER-END line, base + 1, pin 12 on Cen. Par. Con. = D5
const int   D6 = 64;   // ACK line, base + 1, pin 10 on Cen. Par. Con. = D6
const int   D7 = 64;   // BUSY line, base + 1, pin 11 on Cen. Par. Con. = D7

const int   OE = 32;   // D5, base address,  pin 7 on Cen. Par. Connector
  // NOTE: pin numbers are for 36 pin Centronics Parallel Connector
const int Max_Channels = 7; // max number of channels used on ADC-0809

int    E;
char   Ch;
unsigned int LPTx;
unsigned char Data, Lpt_Num;
union REGS Regs;

void Start_Conversion(int E, unsigned int LPTx)
   // Pulse Start Conversion line, of selected channel E.
{
 const int    Strobe = 8; // Data bit D3 is used to send 'start conversion' pulse.
 unsigned char Pulse;
 if (E > Max_Channels)
   E = 0;
 Pulse = E | Strobe;
 outport(LPTx,E);     // Select channel.
 outport(LPTx,Pulse); // Strobe start line HIGH.
 outport(LPTx,E);     // Strobe start line LOW.
}

void Read_ADC0809(int E, unsigned int LPTx)
{
 unsigned char Temp1, Temp2, Carry;
 unsigned char High_Nibble, Low_Nibble;
 //Read A/D data.
 outport(LPTx,(E | OE)); // Turn on tri-state output.
 // Set all pins HIGH so you can read from base + 2.
 outport(LPTx + 2,inport((LPTx + 2) | 0x04));
 delay(50);  // Allow ADC-0809 time to digest instruction.
 Low_Nibble =  inport(LPTx + 2);
 High_Nibble =inport(LPTx + 1);
 outport(LPTx,E); // Turn off tri-state output.
 Start_Conversion(E+1,LPTx); // Give A/D time for next conversion.
 // digest raw data
 High_Nibble = High_Nibble & 0xF0;      // HEX F0 = 11110000
 Low_Nibble = Low_Nibble & 0x0F;        // HEX 0F = 00001111
 Data = High_Nibble | Low_Nibble;
}

void Display_Value(int E, unsigned char Data)
{
 int L, S, T, U;
 U = 1; S = 1; L = 3;
 gotoxy(1,(E*3) + L);
 printf("CHANNEL # %i:     D7    D6    D5    D4    D3    D2    D1    D0",E);
 do
 {
  if ((Data & S) == S)
    T = S;
   else
    T = 0;
   gotoxy(64 - (U * 6),E * 3 + L + 1); printf("%3i",T);
   S = S + S; U = U + 1;
  }while(U<=8);
  gotoxy(1,E*3 + L + 1); printf("%3i dec      =",Data);
}

void main()
{
 Lpt_Num = Select_Printer_Port();
 LPTx = Init_Printer_Port(Lpt_Num);
 Cursor_Off(); clrscr();
 printf("           -=[ ADC-0809 MULTIPLEXED A/D CONVERTER ]=-              \n");
 do
 {
  Start_Conversion(0,LPTx);
  for(E = 0;E <= Max_Channels;E++)
  {
   Read_ADC0809(E, LPTx);
   Display_Value(E,Data);
   if(kbhit())
     Ch = getch();          // Check for request to exit.
  }
 }while(Ch != ESC);         // Pressing ESC exits program.
 clrscr();
}


