/*                              PROGRAM GrayCode
		      Code conversion by Eugene Klein
	 control a bipolar stepping motor via GRAY CODE logic
*/


#include <dos.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <bios.h>
#include "My_TPU.h"

const int t = 300;
int   E;
unsigned int Lpt_Port_Address, Lpt_Num;
void main()
{
 /*   * %%%%%%%%%%%%%%%%%%%%%%%%  -=[ METHOD ONE ]=-  %%%%%%%%%%%%%%%%% *

   Basic 4-wire, bipolar, stepping motor control.  Uses Pascal's WRITE
   command to transmit data through computer's LPT1 printer port.  The
   WRITE commands sends data WITHOUT generating printer Line Feed, or
   Carriage Return instructions.

   NOTE the sequence of the transmitted numbers.  Bipolar stepping motors
   require Gray Code.
 */
 for(E=1;E<=10;E++)              // step motor clockwise through 40 steps
 {
  putc(0,stdprn); delay(t);
  putc(1,stdprn); delay(t);
  putc(3,stdprn); delay(t);
  putc(2,stdprn); delay(t);
 }
 for(E=1;E<=10;E++)              // step motor counter-clockwise through 40 steps }
 {
  putc(2,stdprn); delay(t);
  putc(3,stdprn); delay(t);
  putc(1,stdprn); delay(t);
  putc(0,stdprn); delay(t);
 }

 /*  * %%%%%%%%%%%%%%%%%%%%%%%%  -=[ METHOD TWO ]=-  %%%%%%%%%%%%%%%%% *

   4-wire stepping motor control.  Data is sent to printer port
   LPT1, LPT2, or LPT3.  From users keyboard input of the number 1, 2, or 3,
   port's address is computed, and used to route data.

   Since the printer port latches data sent to it, data sent to a printer
   port will remain on the output pins until new data replaces it.  That
   means stepping motors, directly driven by printer port logic, will hold
   there position between transmitted instructions.

   NOTE the sequence of the transmitted numbers.  Bipolar stepping motors
   require Gray Code.
 */

 Lpt_Num = Select_Printer_Port();
 Lpt_Port_Address = Init_Printer_Port(Lpt_Num);

 for(E=1;E<=10;E++)              // step motor clockwise through 40 steps
 {
  outport(Lpt_Port_Address,0); delay(t);
  outport(Lpt_Port_Address,1); delay(t);
  outport(Lpt_Port_Address,3); delay(t);
  outport(Lpt_Port_Address,2); delay(t);
 }
 for(E=1;E<=10;E++)              // step motor counter-clockwise through 40 steps }
 {
  outport(Lpt_Port_Address,2); delay(t);
  outport(Lpt_Port_Address,3); delay(t);
  outport(Lpt_Port_Address,1); delay(t);
  outport(Lpt_Port_Address,0); delay(t);
 }
}