/*                          PROGRAM Mot_1042
		       Code  conversion by Eugene Klein
  Bidirectional stepping motor control from parallel printer port using
  CLOCK & DIRECTION control logic.
*/

#include <dos.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <bios.h>
#include "My_TPU.h"

const int  CLK = 1;                      // clock data bit, D0
const int  DIR = 2;                      // direction data bit, D1
const int  t   = 100; // time delay dependent on your computer's clock speed
int E;
unsigned int  Lpt_Num, Lpt_Port_Address;

void main()
{
   /* %%%%%%%%%%%%%%%%%%%%%%% -=[ METHOD ONE ]=- %%%%%%%%%%%%%%%%%%%% *


   Advance stepper motor shaft 40 steps in clockwise direction.
   With Dir, bit D1, held low, strobe the clock line, D0, 40 times.
   This method only works with LPT1.
*/

 putc(0,stdprn);             // intitilize to clockwise direction, data = 0
 for(E=1;E<=40;E++)
 {
  putc(CLK,stdprn);         //00000001
  delay(t);
  putc(0,stdprn);            // 00000000
  delay(t);
 }
/*
   Advance stepper motor shaft 40 steps in counter-clockwise direction.
   With Dir, bit D1, held high, strobe the clock line, D0, 40 times.
*/
 for(E=1;E<=40;E++)
 {
  putc((CLK + DIR),stdprn);   // 00000011
  delay(t);
  putc(DIR,stdprn);           // 00000010
  delay(t);
 }
  // (* %%%%%%%%%%%%%%%%%%%%%%% -=[ METHOD TWO ]=- %%%%%%%%%%%%%%%%%%%% *)

 Lpt_Num = Select_Printer_Port();
 Lpt_Port_Address = Init_Printer_Port(Lpt_Num);
 clrscr();

/*
   Advance stepper motor shaft 40 steps in clockwise direction.
   With Dir, bit D1, held low, strobe the clock line, D0, 40 times.
   This method permits selection of LPT1, LPT2 or LPT3.
*/

 for(E=1;E<=40;E++)
 {
  outport(Lpt_Port_Address,CLK);  // 00000001
  delay(t);
  outport(Lpt_Port_Address,0);    // 00000000
  delay(t);
 }
/*
   Advance stepper motor shaft 40 steps in counter-clockwise direction.
   With Dir, bit D1, held high, strobe the clock line, D0, 40 times.
*/
 for(E=1;E<=40;E++)
 {
 outport(Lpt_Port_Address,CLK+DIR);  // 00000011
  delay(t);
  outport(Lpt_Port_Address,DIR);    // 00000010
  delay(t);
 }
}