 /*                         PROGRAM OSC_825
		     Code conversion by Eugene Klein
		 Produce a square wave on Intel's 8253
 */


#include <dos.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <bios.h>
#include "My_TPU.h"

const int A0 = 1; // D0, Bit 1, = Strobe at Base-Address + 2
const int A1 = 2; // D1, Bit 2, = Auto-Feed at Base-Address + 2
const int WR = 4; // D2, Bit 3, = Initialize at Base-Address + 2
const int CS = 8; // D3, Bit 4, = Select-Input at Base-Address + 2
unsigned char Control_Word, Data, Control_Lines;
unsigned int LPTx, Lpt_Num, Data_Word;
int Num, E;
char Ch;

void Send_Control_Word(void)
{
	// set up Counter 0 to Mode 3, Square Wave Generator
	//                              D7  D6  D5  D4    D3  D2  D1  D0
	//                             Sc1 Sc0 RL1 RL0    M2  M1  M0 BCD
	//          select counter       0   0
	//       Load LSB then MSB               1   1
	//           Select Mode 3                         0   1   1
	// No Binary Coded Decimal                                     0
	//                           -----------------------------------
 Control_Word = 0x36; //                  0   0   1   1     0   1   1   0       }
 outport(LPTx,Control_Word); //place control word on printer port's data lines

		      //              INTEL 8253 PINS:  CS   WR   A1   A0
		      //                                 __        __   __
		      //             PRINTER PORT PINS:  D3   D2   D1   D0
 outport(LPTx + 2,0x4); // Set ALL  control lines HIGH;     0    1    0    0     }
 outport(LPTx + 2,0xC); // set CS line to active LOW        1    1    0    0     }
 outport(LPTx + 2,0x8); // set WR line to active LOW        1    0    0    0     }
 outport(LPTx + 2,0xC); // set WR line to inactive HIGH     1    1    0    0     }
 outport(LPTx + 2,0x4); // set CS line to inactive HIGH     0    1    0    0     }
}

void Send_Data(int Data)
{
 outport(LPTx,Data);
		      //                INTEL 8253 PINS:  CS   WR   A1   A0
		      //                                  __        __   __
		      //              PRINTER PORT PINS:  D3   D2   D1   D0
 outport(LPTx + 2,0x4); // turn ALL lines to inactive HIGHs  0    1    0    0
 outport(LPTx + 2,0x7); // Set A0 and A1 to LOW              0    1    1    1
 outport(LPTx + 2,0xF); // set CS line to active LOW         1    1    1    1
 outport(LPTx + 2,0xB); // set WR line to active LOW         1    0    1    1
 outport(LPTx + 2,0xF); // set WR line to inactive HIGH      1    1    1    1
 outport(LPTx + 2,0x7); // set CS line to inactive HIGH      0    1    1    1
}

void main()
{
 int x;
 clrscr(); Num = 2;
 Lpt_Num = Select_Printer_Port();
 LPTx = Init_Printer_Port(Lpt_Num);
 clrscr();
   // Initialize the control lines
 outport(LPTx + 2,0x04); // 0000 0100
 Data_Word = 0x7FFF;     // set initial frequency a about the middle of range
 do
 {
  do
  {
   Ch = getch();
   if(Ch==0)
    Ch=getch();
  }while(Ch!=73 & Ch!=81 & Ch!=27 & Ch!=57 & Ch!=51);
  switch(Ch)
  {
   case 73:
    if(Data_Word < 0xE000)
     Data_Word = Data_Word + 0x0FFF;
    break;

   case 57:
    if(Data_Word < 0xE000)
     Data_Word = Data_Word + 0x0FFF;
    break;
   case 51:
    if(Data_Word > 0x100F)
     Data_Word = Data_Word - 0x0FFF;
    break;
   case 81:
    if(Data_Word > 0x100F)
     Data_Word = Data_Word - 0x0FFF;
    break;
   case 27:
    exit(0);      //pressing ESC key exits program
  }
  printf(" DATA WORD = %u\n",Data_Word);
  Send_Control_Word();
  Send_Data(Data_Word & 0xff);
  Send_Data(Data_Word>>8);
 }while(Ch !='\'');    //pressing ESC key exits program
}
