/*                      PROGRAM RS232
		   Code conversion by Eugene Klein

 Input / output data from IBM Serial Port, COM1 or COM2
 REF: Understanding Serial Communications, Peter W Gofton, Sybex Pub., Ch 15
 Programmer's PC Sourcebook, by Tom Hogan, Microsoft Press 1991, 4-54..4-58
 Turbo Pascal 6, by Stephen O'Brien, McGraw Hill Pub. Page 394..400
 Programed by Paul Bergsman for use by Trenton State College to interface
  their electric car's Killowatt Meter to an IBM serial port.  5/18/1993
 Written using Borland's Turbo Pascal 6.  Paul Bergsman (215) 667-2449
*/

#include <dos.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <bios.h>
#include "My_TPU.h"



       struct Modem_Set_Type
       {
	 int Comm_Port_Num;
	 int  BPS;
	 int  Data_Bits;
	 int  Stop_Bits;
	 char  Parity;
	};

struct Modem_Set_Type Modem_Set;

char Data_String[80];

const unsigned int ESC = 0x1B;
const unsigned int Max_Buffer_Length =  1024;
char Buffer[1024];
unsigned char  Main_Dseg= 0;
const unsigned char  Line_Offset = 5;
const unsigned char  CR = 0x0D;


const unsigned char  ENBLRDY = 0x01;     // Initial value for Port[IRR]
const unsigned char  MDMMOD = 0x0B;      // Initial value for Port[MCR]
const unsigned char  MDMCD = 0x80;       // Initial value for Port[MDMMSR]
const unsigned char  INTCTLR = 0x21;     // 8259 Interrupt Controller Port


union REGS Regs;
char Orig;


unsigned char Init_Num;
unsigned int Chars_In_Buffer, Circ_Out, Circ_In;
unsigned int IER, LCR, MCR, LSR, MDMMSR, Data_Port;

void interrupt Async_Int(void)
{
 __emit__(0xFB);   // STI = set interrupt enable
 if(Chars_In_Buffer < Max_Buffer_Length)
 {
  Buffer[Circ_In] = inport(Data_Port);
  if( Circ_In < Max_Buffer_Length)
   Circ_In++;
  else
   Circ_In = 1;
  Chars_In_Buffer++;
 }
 __emit__(0xFA);    // CLI = clear interrupt enable
 outport(0x20,0x20);
}



char Get_Char_In_Buffer(void)
{
 char bufchar;
 // if a character is in the buffer, process it
 if(Chars_In_Buffer > 0)
 {
  bufchar = Buffer[Circ_Out];
  if(Circ_Out) // < Max_Buffer_Length)
   Circ_Out++;
  else
   Circ_Out = 1;
  Chars_In_Buffer--;
 }
  return(bufchar);
}

void Select_Modem_Setup(void)
{
 // user interface for serial port paramiter selection
 char Ch;
 int Loop=0;

 clrscr(); gotoxy(1,5);
 // default settings match Solar Car's KiloWatt Meter Serial interface
 printf("Default settings are: COM1, 9600 baud, 8 data bits, 1 stop bit, No Parity\n");
 printf(" Y / N: "); Ch=getch();
 if(Ch == 'Y'|| Ch == 'y')
 {
  Modem_Set.Comm_Port_Num = 1; Modem_Set.BPS = 9600; Modem_Set.Data_Bits = 8; Modem_Set.Stop_Bits = 1; Modem_Set.Parity = 'N';
 }
 else
 {
  do   // getting user's parameters
  {
   clrscr(); printf("\n");
   Loop = 0;
   do
   {
    printf("\nSelect COMM PORT: 1 / 2: "); scanf("%i",&Modem_Set.Comm_Port_Num);
    if(Modem_Set.Comm_Port_Num ==1 || Modem_Set.Comm_Port_Num ==2)
     Loop = 1;
    else
     printf("You selected COMM PORT %i.  Try again",Modem_Set.Comm_Port_Num);
   }while(Loop == 0);
   Loop = 0;
   do
   {
    printf("\nSelect BAUD; 300, 600, 1200, 2400, 4800, 9600: ");
    scanf("%i",&Modem_Set.BPS);
    if(Modem_Set.BPS==300 || Modem_Set.BPS==600 || Modem_Set.BPS==1200 || Modem_Set.BPS==2400 || Modem_Set.BPS==4800 || Modem_Set.BPS==9600)
     Loop = 1;
    else printf("You have selected %i Bits Per Second. Try again",Modem_Set.BPS);
   }while(Loop==0);
   Loop=0;
   do
   {
    printf("\nSelect Data Bits; 5, 6, 7, or 8: "); scanf("%i",&Modem_Set.Data_Bits);
    if(Modem_Set.Data_Bits>=5 && Modem_Set.Data_Bits <=8)
     Loop=1;
    else printf("You have selected %i Bits Per Second. Try again",Modem_Set.Data_Bits);
   }while(Loop==0);
   Loop=0;
   do
   {
    printf("\nSelect Stop Bits; 1 / 2: "); scanf("%i",&Modem_Set.Stop_Bits);
    if(Modem_Set.Stop_Bits>=1 && Modem_Set.Stop_Bits <=2)
     Loop=1;
    else printf("You have selected %i Stop Bits. Try again",Modem_Set.Stop_Bits);
   }while(Loop==0);
   Loop=0;
   do
   {
    printf("\nSelect Parity; (N)one, (O)dd, (E)ven: ");
    scanf("%c",&Modem_Set.Parity);
    if(Modem_Set.Parity==10)
     scanf("%c",&Modem_Set.Parity);
    strupr(&Modem_Set.Parity);
    if(Modem_Set.Parity=='N' || Modem_Set.Parity=='O'|| Modem_Set.Parity=='E')
     Loop=1;
    else
     printf("You have selected %c parity. Try again",Modem_Set.Parity);
   }while(Loop==0);

   printf("\nSELECTED PARAMETERS ARE: \n\nCOM %i,", Modem_Set.Comm_Port_Num);
   printf(" %i Baud, %i Data Bits, %i Stop Bits. ",Modem_Set.BPS,Modem_Set.Data_Bits,Modem_Set.Stop_Bits);
   switch(Modem_Set.Parity)
   {
    case 'N':
     printf("NO Parity.\n");
     break;
    case 'O':
     printf("ODD Parity.\n");
     break;
    case 'E':
     printf("EVEN Parity.\n");
     break;
   }
   printf("\nAre these parameters correct Y/N: ");
   Ch=getch();
  }while(Ch != 'Y' && Ch != 'y');
 }
 printf("\n");
}

void Clear_Buffer(void)
{
 Circ_In = 1;
 Circ_Out = 1;
 Chars_In_Buffer = 0;
 memset(Buffer,Max_Buffer_Length,NULL);
}

void Enable_Ports(void)
{
 struct SREGS Sregs;
 void interrupt *oldfunc;

 segread(&Sregs);
 Main_Dseg = Sregs.ds;
 Clear_Buffer();
 //oldfunc = getvect(Init_Num);
 setvect(Init_Num, Async_Int);
 outport(INTCTLR,inport(INTCTLR) & 0x0EF);
 outport(LCR,inport(LCR) & 0x7F);
 outport(IER,ENBLRDY);
 outport(MCR,0x08 | MDMMOD);
 outport(MDMMSR,MDMCD);
 outport(0x20,0x20);
}

void Set_Serial_Port(void)
{
 // Procedure Select_Modem_Setup parameters installed via interrupt 14H
 // identify ISN8250 UART Register locations.

 unsigned char Regs_AL;
 if(Modem_Set.Comm_Port_Num == 1)
 {
  Data_Port = 0x03F8; Init_Num = 0x0C;
 }
 else
 {
  Data_Port = 0x02F8; Init_Num = 0x0B;
 }
 IER = Data_Port + 1;    // Interrupt Enable Register,
			 //    Enables Serial Port when set to 1
 LCR = Data_Port + 3;    // Line Control Register,
			 //    Sets communications parameters
 MCR = Data_Port + 4;    // Modem Control Register
			 //    Bits 1, 2, and 4 set HIGH to ready modem
 LSR = Data_Port + 5;    // Line Status Register
			 //    It's safe to send data when bit 6 is HIGH
 MDMMSR = Data_Port + 6; // When starting, initialize to 80h
 switch(Modem_Set.BPS)
 {
  case  100:
   Modem_Set.BPS = 0;
   break;
  case  150:
   Modem_Set.BPS = 1;
   break;
  case  300:
   Modem_Set.BPS = 2;
   break;
  case  600:
   Modem_Set.BPS = 3;
   break;
  case 1200:
   Modem_Set.BPS = 4;
   break;
  case 2400:
   Modem_Set.BPS = 5;
   break;
  case 4800:
   Modem_Set.BPS = 6;
   break;
  case 9600:
   Modem_Set.BPS = 7;
   break;
 }
 Modem_Set.Stop_Bits = Modem_Set.Stop_Bits - 1;
 switch(Modem_Set.Data_Bits)
 {
  case 5:
   Modem_Set.Data_Bits = 0;
   break;
  case 6:
   Modem_Set.Data_Bits = 1;
   break;
  case 7:
   Modem_Set.Data_Bits = 2;
   break;
  case 8:
   Modem_Set.Data_Bits = 3;
   break;
 }
 Regs_AL = (Modem_Set.BPS << 5) + (Modem_Set.Stop_Bits << 2) + Modem_Set.Data_Bits;
 switch(Modem_Set.Parity)
 {
  case 'N':
   Regs_AL = Regs_AL + 0;   // or 16
   break;
  case 'E':
   Regs_AL = Regs_AL + 24;
   break;
  case 'O':
   Regs_AL = Regs_AL + 8;
   break;
 }
 Regs.x.dx = Modem_Set.Comm_Port_Num - 1;
 Regs.h.ah = 0;
 Regs.h.al = Regs_AL;
 Regs.x.flags = 0;
 int86(0x14,&Regs,&Regs);
 Enable_Ports();
}

void Send_Char(char Out_Char)
{
 // send character out serial port
 while((inport(LSR) & 0x20) != 0x20)
 {
  outport(Data_Port,Out_Char);
 }
}

void Set_Up_Display_Screen(void)
{
 gotoxy(1,1);     printf("TRENTON STATE, POTENTIAL DIFFERENCE");
 gotoxy(1,Line_Offset);     printf("TIME (sec): ");
 gotoxy(1,Line_Offset + 2); printf("      AMPS: ");
 gotoxy(1,Line_Offset + 4); printf("     VOLTS: ");
 gotoxy(1,Line_Offset + 6); printf("    KW Hrs: ");
}

void Display_Data(void)
{
 // display electric car's wattmeter info on laptop's display
 // (* separate data string into Time, Watts, Amps, and Volts *)
 // (* elements are separated by commas                       *)

 char *Volts, *Amps, *Watts, *Time;

 gotoxy(1,1);     printf("TRENTON STATE, POTENTIAL DIFFERENCE");
 Time = strtok(Data_String,",");
 gotoxy(13,Line_Offset);     printf("TIME (sec): %7c",Time);
 Amps = strtok(NULL,",");
 gotoxy(13,Line_Offset + 2); printf("      AMPS: %7c",Amps);
 Volts = strtok(NULL,",");
 gotoxy(13,Line_Offset + 4); printf("     VOLTS: %7c",Volts);
 Watts = strtok(NULL,",");
 gotoxy(13,Line_Offset + 6); printf("    KW Hrs: %7c",Watts);
}

void Start_Communicating(void)
{
 // transmit characters you type, and display characters received by UART

 unsigned char Out_Char, In_Char;

 strset(Data_String,NULL);
 do
 {
  if(Chars_In_Buffer > 0)
  {
   In_Char = Get_Char_In_Buffer();
   if(In_Char >= 32 && In_Char <= 128)
   {
    strcat(Data_String,&In_Char);
   }
   else
   {
    if(In_Char == CR )
    {
     Display_Data();
     strset(Data_String,NULL);
    }
   }
  }
  if(kbhit())
  {
   Out_Char = getch();
   if(Out_Char != 27)
   {
    Send_Char(Out_Char);
    if(Out_Char == CR)
     printf("\n");
    else
     printf("%i",Out_Char);
   }
  }
 }while(Out_Char != ESC);
}

void Disable_Ports(void)
{
 // before exiting program, leave the port as you found it
 // install original interrupts in Interrupt Vector Table and Reset UART

 // turn off COMx communication interrupt
 outport(INTCTLR,inport(INTCTLR) || 0x10);

 // disable 8250 Data Ready Interrupt
 outport(LCR,inport(LCR) & 0x7F);
 outport(IER,0x0);

 // DISABLE OUT2 on 8250
 outport(MCR,0x0);
 outport(0x20,0x20);
 setvect(Init_Num, Async_Int);
}

void main()
{
 /* TextMode(BW40);   current donated lap top is an LCD display XT  */
 Select_Modem_Setup();
 Set_Serial_Port();
 clrscr();
 Set_Up_Display_Screen();
 Start_Communicating(); // exit when ESC Key is pressed
 printf("Ending program.  Disabling Ports\n");
 printf("Press RETURN to continue: "); getch();
 Disable_Ports();
 textmode(LASTMODE & 0x0f);
}




