PROGRAM Adc_Demo;
{ Utilize the parallel printer port to input analog data converted to        }
{ 8 bit binary by an ADC-0804 analog / digital converter IC                  }
{ Display readings in large letters                                          }

USES DOS, CRT, My_TPU;

TYPE Char_Design = Array[1..8] of BYTE;
     String80    = String[80];

CONST   Wr = $01;               { D0, Base = Write line              }

VAR Lo_Nibble, Hi_Nibble, Temp, X : BYTE;
        Lpt_Num, Lpt_Port_Address : WORD;
     Code, N, E, Whole, Remainder : INTEGER;
             Old_Value, New_Value : REAL;
                          A,B, St : String80;

PROCEDURE Print_Large_Letters(St : String80);
{ Create large letters by reading each pixel in character table and make it }
{  a character, 5 by 8 pixels                                               }
{ Turbo Pascal ToolBoox, 2ed Edition, Sybex Pub. by Frank Dutton, Pagbe 253 }
VAR Table   : ARRAY[0..255] OF Char_Design ABSOLUTE $F000:$FA6E;
  Ord_Ch, n, E, I, Col, Row, code : integer;
                               ch : CHAR;
                             temp : String[80];

PROCEDURE Lg_Char(Col, Row, To_Print, Fill_Char : INTEGER);
 { display large characters }
VAR  X, Y, E, I : INTEGER;
     Pattern    : Char_Design;
BEGIN
Pattern := Table[To_Print];
For X := 1 to 8 DO
  For Y := 1 to 8 DO
     BEGIN
     GoToXY((Col-1) + 8 - Y, ( Row - 1) + X);
     If ( Odd( Pattern[X] Shr Y)) THEN Write(Chr(Fill_Char));
     END; { for y }
END;  { large character }

BEGIN { print large letters }
Col := 10; Row := 4;
FOR I := 1 to  6  DO
   BEGIN
   IF St[i] IN ['0'..'9','.'] THEN Ord_Ch := ORD(st[i]) ELSE Ord_Ch := 32;
   lg_Char(Col, Row, Ord_Ch , Ord_Ch);
   Col := Col + 8;
   END; { for i }
END; { print large letters }

BEGIN { main,  adc demo }
Select_Printer_Port(Lpt_Num, Lpt_Port_Address);
Init_Printer_Port(Lpt_Num, Lpt_Port_Address);
ClrScr; Cursor_Off; Old_Value := 0;
    { initialize A/D chip }
Port[Lpt_Port_Address] := WR;
Port[Lpt_Port_Address] := 0;
Port[Lpt_Port_Address] := WR;
DELAY(10);   { stay within A/D chip timing parameters }

REPEAT
{ read data }
{ pull-up all Base + 2, open collector, pins BEFORE a read instruction        }
  PORT[Lpt_Port_Address + 2] := $04; { 00000100, allow for inverted logic     }
  Lo_Nibble := PORT[Lpt_Port_Address + 2];  { get D0 - D3  bits               }
  Hi_Nibble := PORT[Lpt_Port_Address + 1];  { get D4 - D7  bits               }
{ strobe ADC-0804 to start new conversion }
  Port[Lpt_Port_Address] := WR; { while software digest the current data      }
  Port[Lpt_Port_Address] := 0;  { Strobe 0804 WR line to start new conversion }
  Port[Lpt_Port_Address] := WR; { while software digests the current data     }
{ digest data }
  Lo_Nibble := Lo_Nibble AND $0F; { extract the meaningful bits, 0 - 3        }
  Hi_Nibble := Hi_Nibble AND $F0; { extract the meaningful bits, 4 - 7        }
  X := Hi_Nibble OR Lo_Nibble;  { put all high bits in one byte               }
{ print results }
New_Value := ( X * 5 ) / 255;   { convert byte to a voltage between O and 5   }
IF New_Value <> Old_Value THEN  { only update if value has changed            }
  BEGIN
  gotoxy(1,15);
  Writeln('High Nibble = ',Hi_Nibble:3, ';       Low Nibble = ',Lo_Nibble:3);
  writeln;
  writeln('    D7    D6    D5    D4    D3    D2    D1    D0');
  N := 128;
  FOR E := 1 to 8 DO
    BEGIN
    WRITE((X AND N):6);
    N := N DIV 2;
    END; { for }
  WRITELN; WRITELN;
  WRITE('The A/D binary value is ',X:4);
  Whole := X * 5 DIV 255;
  Remainder := X * 5 MOD 255;
  Str(Whole:3,A);
  Str(Remainder:2,B);
  St := A + '.' + B;
  WRITELN(';     Voltage = ', St, ' volts');
  FOR E := 1 to 8 DO
    BEGIN
    GoToXY(1, 3 + E);
    WRITE('                                                                  ');
    END; { for E }
  Print_Large_Letters(St);
  Old_Value := New_Value;
  END; { if }
UNTIL KEYPRESSED;
END. { main, adc demo }

