PROGRAM Bi_PRN;
 {
   Test program for Universal Adapter which converts a standard IBM parallel
   printer port into a true I/O  device with 8 bi-directional data bits and 4
   control bits.
 }
 USES CRT, My_tpu;
 CONST T = 130;
 VAR                           _Num : INTEGER;
                               A, E : BYTE;
    Lpt_Num, Lpt_Port_Address, LPTx : WORD;
                                 Ch : CHAR;

PROCEDURE Send_Data( E : Byte);
CONST  Write_Bit = $00;         { D3, the Read / Write bit, is set LOW         }
VAR Lo_Nibble, Hi_Nibble : BYTE;

BEGIN { send data }
Port[LPTx] := Write_Bit;  { Write_Bit on 74LS241 is set HIGH       }
Lo_Nibble := E AND $0F;         { low nibble of byte  goes to BASE + 2 address }
Lo_Nibble := Lo_Nibble XOR $0B; { invert inverted pins, 0000 1011 = $0B hex    }
(* Hi_Nibble := (E AND $F0); *) { hi nibble of byte goes to BASE address       }
Hi_Nibble := (E AND $0F) * 16;  { just to watch  display in hex                }
                    { put high nibble on data lines,  keep write bit active    }
Port[LPTx] := Hi_Nibble OR Write_Bit;
                                { put lo-nibble data on D4 to D7 data lines    }
PORT[LPTX + 2 ] := Lo_Nibble;
delay(T);                       { slow process down so I can observe LEDs      }
                                { connected to driver outputs                  }
END;  { send data }

PROCEDURE Input_Data;
VAR Lo_Nibble, Hi_Nibble, Temp, Data_Byte : BYTE;

BEGIN  { input data }
Ch := ' ';
  REPEAT
  Port[lptx] := $08;       { set R/W line for READ                     }
  PORT[LPTx + 2] := $04;   { 0000 0100,   init all pull-up resistors   }
{ -=[ input data byte ]=- }
  Lo_Nibble := PORT[LPTx + 2];    { read low nibble                    }
  Temp := Port[LPtx + 1];         { read high nibble                   }
{ -=[ process HI nibble ]=- }
  Hi_Nibble := Temp AND $80;      { extract D7                         }
  Temp := Temp AND $38;           { extract remaining three bits       }
  Temp := Temp * 2;               { shift these bits to left one place }
  Hi_Nibble := Temp OR Hi_Nibble; { recombine bits of nibble           }
  Hi_Nibble := Hi_Nibble XOR $70; { invert inverted logic bits         }
{ -=[ process LO nibble ]=- }
  Lo_Nibble := Lo_Nibble AND $0F; { extract data bits                  }
  Lo_Nibble := Lo_Nibble xor $04; { invert inverted printer port logic }
{ -=[ display data ]=- }
  GoToXY(10,8);
  WRITE('Hi_Nibble = ', Hi_Nibble:3, ';      Lo Nibble = ', Lo_Nibble:2);
  Data_Byte := Hi_Nibble OR Lo_Nibble;  { combined hi and lo nibbles   }
  gotoxy(10,15); write('Input byte = ',Data_Byte:3);
  IF KEYPRESSED THEN CH := READKEY; { press any key to exit            }
  UNTIL ORD(Ch) = 27;
END;   { input data }

BEGIN  { Bi Printer Port Adapter }
Select_Printer_Port( Lpt_Num, Lpt_Port_Address );
LPTx := Lpt_Port_Address;
Ch := ' ';
  REPEAT
  { set eight data bits high in binary order                            }
  FOR E := 0 to 32 DO Send_Data(E);
  {  set control bits high in binary sequence, ten times                }
  FOR  A := 1 TO 10 DO
    BEGIN { for a }
    E := 1;
      REPEAT
      PORT[LPTx] := E AND $0F;
      delay(T) ;
      E := E + E;
      UNTIL (E > 8);
  END; { for a }
IF Keypressed THEN Ch := ReadKey;
UNTIL ORD(Ch) = 27;
Input_Data;
END.   { Bi Printer Port Adaptor }
