PROGRAM GrayCode;
{
  control a bipolar stepping motor using GRAY CODE logic
}
USES CRT, PRINTER, My_Tpu;
CONST T = 300;
VAR                         E : INTEGER;
    Lpt_Num, Lpt_Port_Address : WORD;

BEGIN
   (* %%%%%%%%%%%%%%%%%%%%%%%%  -=[ METHOD ONE ]=-  %%%%%%%%%%%%%%%%% *)
 {
   Basic 4-wire, bipolar, stepping motor control.  Uses Pascal's WRITE
   command to transmit data through computer's LPT1 printer port.  The
   WRITE commands sends data WITHOUT generating printer Line Feed, or
   Carriage Return instructions.

   NOTE the sequence of the transmitted numbers.  Bipolar stepping motors
   require Gray Code.
 }
FOR E := 1 TO 10 DO  { step motor clockwise through 40 steps }
    BEGIN
    WRITE(LST, CHAR(0)); DELAY(t);
    WRITE(LST, CHAR(1)); DELAY(t);
    WRITE(LST, CHAR(3)); DELAY(t);
    WRITE(LST, CHAR(2)); DELAY(t);
    END;
  FOR E := 1 TO 10 DO  { step motor counter-clockwise through 40 steps }
    BEGIN
    WRITE(LST, CHAR(2)); DELAY(t);
    WRITE(LST, CHAR(3)); DELAY(t);
    WRITE(LST, CHAR(1)); DELAY(t);
    WRITE(LST, CHAR(0)); DELAY(t);
    END;

   (* %%%%%%%%%%%%%%%%%%%%%%%%  -=[ METHOD TWO ]=-  %%%%%%%%%%%%%%%%% *)
 {
   4-wire, bipolar, stepping motor control.  Data is sent to printer port
   LPT1, LPT2, or LPT3.  From users keyboard input of the number 1, 2, or 3,
   port's address is computed, and used to route data.

   Since the printer port latches data sent to it, data sent to a printer
   port will remain on the output pins until new data replaces it.  That
   means stepping motors, directly driven by printer port logic, will hold
   there position between transmitted instructions.

   NOTE the sequence of the transmitted numbers.  Bipolar stepping motors
   require Gray Code.
 }
Select_Printer_Port(Lpt_Num, Lpt_Port_Address);
FOR E := 1 TO 10 DO    { step motor clockwise through 40 steps }
    BEGIN
    PORT[Lpt_Port_Address] := 0; DELAY(t);
    PORT[Lpt_Port_Address] := 1; DELAY(t);
    PORT[Lpt_Port_Address] := 3; DELAY(t);
    PORT[Lpt_Port_Address] := 2; DELAY(t);
    END;
  FOR E := 1 TO 10 DO  { step motor counter-clockwise through 40 steps }
    BEGIN
    PORT[Lpt_Port_Address] := 2; DELAY(t);
    PORT[Lpt_Port_Address] := 3; DELAY(t);
    PORT[Lpt_Port_Address] := 1; DELAY(t);
    PORT[Lpt_Port_Address] := 0; DELAY(t);
    END;
END.
